/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.matching.MatchTarget;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSListenerSetException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.MessageQueue;
import com.ibm.mq.jms.SessionConfig;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public class MessageConsumerImpl
extends MatchTarget
implements MessageConsumer,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MessageConsumerImpl.java, jms, j521, j521-L020622 02/06/21 18:22:35 @(#) 1.11.1.5";
    private static final DebugObject debug = new DebugObject("MessageConsumerImpl");
    private boolean active = true;
    private MessageQueue receiveQueue;
    private String messageSelector;
    private SessionImpl parentSession;
    private MessageQueue sessionDispatchQueue;
    private MessageListener listener;
    private MessageListener sessionListener;
    private MessageListener activeListener;
    private int readers = 0;
    private int upreaders = 0;
    private Thread readThread = null;

    public MessageConsumerImpl(String string, String string2, SessionImpl sessionImpl) {
        super(4, string);
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MessageConsumerImpl", string, string2, sessionImpl);
        }
        this.messageSelector = string2;
        this.receiveQueue = new MessageQueue(SessionConfig.MAX_MESSAGE_QUEUE_SIZE);
        this.parentSession = sessionImpl;
        this.sessionDispatchQueue = this.parentSession.getDispatchQueue();
        this.activeListener = this.sessionListener = this.parentSession.getMessageListener();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MessageConsumerImpl");
        }
    }

    public String getMessageSelector() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMessageSelector");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMessageSelector", this.messageSelector);
        }
        return this.messageSelector;
    }

    public MessageListener getMessageListener() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMessageListener");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMessageListener", this.listener);
        }
        return this.listener;
    }

    public synchronized void setMessageListener(MessageListener messageListener) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setMessageListener", messageListener);
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        this.listener = messageListener;
        if (this.sessionListener == null) {
            this.setActiveListener(messageListener);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setMessageListener");
        }
    }

    synchronized void setSessionMessageListener(MessageListener messageListener) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setSessionMessageListener", messageListener);
        }
        MessageListener messageListener2 = this.sessionListener;
        this.sessionListener = messageListener;
        if (messageListener2 != messageListener) {
            if (messageListener != null) {
                this.setActiveListener(messageListener);
            } else {
                this.setActiveListener(this.listener);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setSessionMessageListener");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private synchronized void setActiveListener(MessageListener messageListener) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setActiveListener", messageListener);
        }
        SessionImpl sessionImpl = this.parentSession;
        // MONITORENTER : sessionImpl
        boolean bl = this.parentSession.isStopped();
        if (!bl) {
            this.parentSession.stop();
        }
        this.acquireWriteLock();
        try {
            MessageListener messageListener2 = this.activeListener;
            this.activeListener = messageListener;
            if (messageListener == null && messageListener2 == null) {
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "setActiveListener");
                }
                Object var6_5 = null;
                this.releaseWriteLock();
                if (!bl) {
                    this.parentSession.start();
                }
                // MONITOREXIT : sessionImpl
                return;
            }
            if (messageListener != null && messageListener2 != null) {
                if (debug.debugIt(64)) {
                    debug.debug(-175921860444054L, "setActiveListener");
                }
                Object var6_6 = null;
                this.releaseWriteLock();
                if (!bl) {
                    this.parentSession.start();
                }
                // MONITOREXIT : sessionImpl
                return;
            }
            if (messageListener != null && messageListener2 == null) {
                this.receiveQueue.moveTo(this.sessionDispatchQueue);
            }
            if (messageListener == null && messageListener2 != null) {
                this.sessionDispatchQueue.moveMessagesFor(this, this.receiveQueue);
            }
            Object var6_7 = null;
            this.releaseWriteLock();
            if (!bl) {
                this.parentSession.start();
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.releaseWriteLock();
            if (bl) throw throwable;
            this.parentSession.start();
            throw throwable;
        }
        if (!debug.debugIt(64)) return;
        debug.debug(-175921860444054L, "setActiveListener");
    }

    public Message receive() throws JMSListenerSetException, IllegalStateException, JMSWrappedException {
        Trace.checkForTurnTracingOn();
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "receive");
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        if (this.activeListener != null) {
            throw new JMSListenerSetException(ExceptionBuilder.buildReasonString(1090, null));
        }
        try {
            MessageImpl messageImpl = this.receiveQueue.dequeue();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "receive", messageImpl);
            }
            return messageImpl;
        }
        catch (Exception exception) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1093, new Object[]{exception}), exception);
        }
    }

    public Message receive(long l) throws JMSException, IllegalStateException {
        Trace.checkForTurnTracingOn();
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "receive", new Long(l));
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        if (l == 0L) {
            Message message = this.receive();
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "receive", message);
            }
            return message;
        }
        if (this.activeListener != null) {
            throw new JMSListenerSetException(ExceptionBuilder.buildReasonString(1090, null));
        }
        try {
            MessageImpl messageImpl = this.receiveQueue.dequeueWait(l);
            if (debug.debugIt(64)) {
                debug.debug(-175921860444054L, "receive", messageImpl);
            }
            return messageImpl;
        }
        catch (InterruptedException interruptedException) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1093, new Object[]{interruptedException}), interruptedException);
        }
    }

    public Message receiveNoWait() throws JMSException {
        Trace.checkForTurnTracingOn();
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "receiveNoWait");
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new IllegalStateException(string2, string);
        }
        if (this.activeListener != null) {
            throw new JMSListenerSetException(ExceptionBuilder.buildReasonString(1090, null));
        }
        MessageImpl messageImpl = this.receiveQueue.dequeueNoWait();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "receiveNoWait", messageImpl);
        }
        return messageImpl;
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.close(null, true);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    public void close(Exception exception, boolean bl) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close", exception, new Boolean(bl));
        }
        if (this.active) {
            this.active = false;
            this.receiveQueue.close(exception, bl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isActive", new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isClosed", new Boolean(!this.active));
        }
        return !this.active;
    }

    public void newMessage(MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "newMessage", messageImpl);
        }
        if (messageImpl.getConsumer() != null) {
            messageImpl = messageImpl.duplicate();
        }
        messageImpl.setConsumer(this);
        this.acquireReadLock();
        try {
            if (this.activeListener != null) {
                this.sessionDispatchQueue.enqueue(messageImpl);
            } else {
                this.receiveQueue.enqueue(messageImpl);
            }
            Object var3_2 = null;
            this.releaseReadLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseReadLock();
            throw throwable;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "newMessage");
        }
    }

    void dispatch(MessageImpl messageImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dispatch", messageImpl);
        }
        this.acquireUpReadLock();
        try {
            this.activeListener.onMessage((Message)messageImpl);
            Object var3_2 = null;
            this.releaseUpReadLock();
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.releaseUpReadLock();
            throw throwable;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dispatch");
        }
    }

    SessionImpl getSession() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getSession");
        }
        SessionImpl sessionImpl = null;
        if (this.active) {
            sessionImpl = this.parentSession;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getSession", sessionImpl);
        }
        return sessionImpl;
    }

    MessageQueue getReceiveQueue() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getReceiveQueue");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getReceiveQueue", this.receiveQueue);
        }
        return this.receiveQueue;
    }

    void acquireWriteLock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acquireWriteLock");
        }
        Thread thread = Thread.currentThread();
        while (this.readers > 0 || this.upreaders > 0 && thread != this.readThread) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acquireWriteLock");
        }
    }

    void releaseWriteLock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "releaseWriteLock");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "releaseWriteLock");
        }
    }

    synchronized void acquireReadLock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acquireReadLock");
        }
        ++this.readers;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acquireReadLock");
        }
    }

    synchronized void releaseReadLock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "releaseReadLock");
        }
        --this.readers;
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "releaseReadLock");
        }
    }

    synchronized void acquireUpReadLock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "acquireUpReadLock");
        }
        ++this.upreaders;
        this.readThread = Thread.currentThread();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "acquireUpReadLock");
        }
    }

    synchronized void releaseUpReadLock() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "releaseUpReadLock");
        }
        --this.upreaders;
        if (this.upreaders == 0) {
            this.readThread = null;
        }
        this.notifyAll();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "releaseUpReadLock");
        }
    }

    void stop() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "stop");
        }
        this.receiveQueue.stop();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "stop");
        }
    }

    void start() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "start");
        }
        this.receiveQueue.start();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "start");
        }
    }
}

