/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.Envelop;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotWriteableException;

public class MapMessageImpl
extends MessageImpl
implements MapMessage,
Envelop.payload.normal.body.jms,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MapMessageImpl.java, jms, j521, j521-L020126 02/01/25 15:18:38 @(#) 1.10.1.1";
    private static final DebugObject debug = new DebugObject("MapMessageImpl");
    Dictionary fields;

    public MapMessageImpl(SchemaCursor schemaCursor, TupleCursor tupleCursor, TupleCursor tupleCursor2) {
        super(schemaCursor, tupleCursor, tupleCursor2);
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MapMessageImpl", schemaCursor, tupleCursor, tupleCursor2);
        }
        this.messageClass = "jms_map";
        this.fields = this.getNamedFields();
        this.readOnly = true;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MapMessageImpl");
        }
    }

    public MapMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "MapMessageImpl");
        }
        this.messageClass = "jms_map";
        this.fields = new Hashtable();
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "MapMessageImpl");
        }
    }

    public boolean getBoolean(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getBoolean", string);
        }
        Object v = this.fields.get(string);
        Boolean bl = null;
        if (v == null) {
            bl = new Boolean(false);
        } else if (v instanceof Boolean) {
            bl = (Boolean)v;
        } else if (v instanceof String) {
            bl = Boolean.valueOf((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getBoolean", bl);
        }
        return bl;
    }

    public byte getByte(String string) throws JMSException {
        byte by;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getByte", string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Byte) {
            by = (Byte)v;
        } else if (v instanceof String) {
            by = Byte.parseByte((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getByte", new Byte(by));
        }
        return by;
    }

    public short getShort(String string) throws JMSException {
        short s;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getShort", string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Short || v instanceof Byte) {
            s = ((Number)v).shortValue();
        } else if (v instanceof String) {
            s = Short.parseShort((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getShort", new Short(s));
        }
        return s;
    }

    public char getChar(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getChar", string);
        }
        Object v = this.fields.get(string);
        char c = '\u0000';
        if (v == null) {
            throw new NullPointerException();
        }
        if (!(v instanceof Character)) {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        c = ((Character)v).charValue();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getChar", new Character(c));
        }
        return c;
    }

    public int getInt(String string) throws JMSException {
        int n;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getInt", string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Integer || v instanceof Short || v instanceof Byte) {
            n = ((Number)v).intValue();
        } else if (v instanceof String) {
            n = Integer.parseInt((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getInt", new Integer(n));
        }
        return n;
    }

    public long getLong(String string) throws JMSException {
        long l;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getLong", string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NumberFormatException();
        }
        if (v instanceof Long || v instanceof Integer || v instanceof Short || v instanceof Byte) {
            l = ((Number)v).longValue();
        } else if (v instanceof String) {
            l = Long.parseLong((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getLong", new Long(l));
        }
        return l;
    }

    public float getFloat(String string) throws JMSException {
        Float f;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getFloat", string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NullPointerException();
        }
        if (v instanceof Float) {
            f = (Float)v;
        } else if (v instanceof String) {
            f = Float.valueOf((String)v);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getFloat", f);
        }
        return f.floatValue();
    }

    public double getDouble(String string) throws JMSException {
        Double d;
        Object v;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getDouble", string);
        }
        if ((v = this.fields.get(string)) == null) {
            throw new NullPointerException();
        }
        if (v instanceof Double) {
            d = (Double)v;
        } else if (v instanceof String) {
            d = Double.valueOf((String)v);
        } else if (v instanceof Float) {
            d = new Double(((Float)v).doubleValue());
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getDouble", d);
        }
        return d;
    }

    public String getString(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getString", string);
        }
        Object v = this.fields.get(string);
        String string2 = null;
        if (v != null) {
            if (v instanceof byte[]) {
                String string3 = "MQJMS0006";
                String string4 = ConfigEnvironment.getErrorMessage(string3);
                throw new MessageFormatException(string4, string3);
            }
            string2 = v.toString();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getString", string2);
        }
        return string2;
    }

    public byte[] getBytes(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getBytes", string);
        }
        Object v = this.fields.get(string);
        byte[] byArray = null;
        if (v != null) {
            if (v instanceof byte[]) {
                byArray = (byte[])v;
            } else {
                String string2 = "MQJMS0006";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                throw new MessageFormatException(string3, string2);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getBytes", byArray);
        }
        return byArray;
    }

    public Object getObject(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getObject", string);
        }
        Object v = this.fields.get(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getObject", v);
        }
        return v;
    }

    public Enumeration getMapNames() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMapNames");
        }
        Enumeration enumeration = this.fields.keys();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMapNames", enumeration);
        }
        return enumeration;
    }

    public void setBoolean(String string, boolean bl) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setBoolean", string, new Boolean(bl));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Boolean(bl));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setBoolean");
        }
    }

    public void setByte(String string, byte by) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setByte", string, new Byte(by));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Byte(by));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setByte");
        }
    }

    public void setShort(String string, short s) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setShort", string, new Short(s));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Short(s));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setShort");
        }
    }

    public void setChar(String string, char c) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setChar", string, new Character(c));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Character(c));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setChar");
        }
    }

    public void setInt(String string, int n) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setInt", string, new Integer(n));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Integer(n));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setInt");
        }
    }

    public void setLong(String string, long l) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setLong", string, new Long(l));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Long(l));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setLong");
        }
    }

    public void setFloat(String string, float f) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setFloat", string, new Float(f));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Float(f));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setFloat");
        }
    }

    public void setDouble(String string, double d) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setDouble", string, new Double(d));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        this.fields.put(string, new Double(d));
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setDouble");
        }
    }

    public void setString(String string, String string2) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setString", string, new String(string2));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        if (string2 != null) {
            this.fields.put(string, string2);
        } else {
            this.fields.remove(string);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setString");
        }
    }

    public void setBytes(String string, byte[] byArray) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setBytes", string, byArray);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        if (byArray != null) {
            this.fields.put(string, byArray);
        } else {
            this.fields.remove(string);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setBytes");
        }
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setBytes", string, byArray, new Integer(n), new Integer(n2));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.fields.put(string, byArray2);
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setBytes");
        }
    }

    public void setObject(String string, Object object) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setObject", string, object);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        if (object instanceof String || object instanceof Integer || object instanceof Boolean || object instanceof Short || object instanceof Long || object instanceof byte[] || object instanceof Byte || object instanceof Character || object instanceof Double || object instanceof Float) {
            this.fields.put(string, object);
        } else if (object == null) {
            this.fields.remove(string);
        } else {
            String string2 = "MQJMS0006";
            String string3 = ConfigEnvironment.getErrorMessage(string2);
            throw new MessageFormatException(string3, string2);
        }
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setObject");
        }
    }

    public boolean itemExists(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "itemExists", string);
        }
        boolean bl = ((Hashtable)this.fields).containsKey(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "itemExists", new Boolean(bl));
        }
        return bl;
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearBody");
        }
        this.readOnly = false;
        this.fields = new Hashtable();
        this.setNamedFields(this.fields);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearBody");
        }
    }
}

