/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.TopicSession;
import javax.jms.XATopicSession;

public class MQXATopicSession
extends MQXASession
implements XATopicSession {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQXATopicSession.java, jms, j521, j521-L020126 02/01/25 15:25:10 @(#) 1.9.1.1";
    private MQTopicSession session = null;

    public MQXATopicSession(MQConnection mQConnection, MQTopicSession mQTopicSession, MQXAResource mQXAResource) throws JMSException {
        super(mQConnection, mQXAResource);
        this.session = mQTopicSession;
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
    }

    public TopicSession getTopicSession() throws JMSException {
        return this.session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            try {
                super.close();
                this.session.close();
                this.session.discQM();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception: " + exception);
                throw jMSException;
            }
            Object var4_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    public void _acknowledge() throws JMSException {
        throw ConfigEnvironment.newException("MQJMS1016", "MQXATopicSession._acknowledge");
    }
}

