/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;
import javax.jms.XASession;
import javax.transaction.xa.XAException;
import javax.transaction.xa.XAResource;

public abstract class MQXASession
extends MQSession
implements XASession {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQXASession.java, jms, j521, j521-L020126 02/01/25 15:24:44 @(#) 1.8.1.1";
    XAResource resource;

    public MQXASession(MQConnection mQConnection, MQXAResource mQXAResource) throws JMSException {
        super(mQConnection, true, 0);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.resource = mQXAResource;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public XAResource getXAResource() {
        return this.resource;
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            try {
                ((MQXAResource)this.resource).close();
            }
            catch (XAException xAException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2012");
                jMSException.setLinkedException((Exception)xAException);
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception: " + xAException);
                throw jMSException;
            }
            Object var4_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    void acknowledge() throws JMSException {
        throw ConfigEnvironment.newException("MQJMS1016", "MQXASession.acknowledge");
    }

    public void commit() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new TransactionInProgressException(string);
    }

    public void rollback() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new TransactionInProgressException(string);
    }

    public void recover() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new IllegalStateException(string);
    }
}

