/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQXAResource;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.QueueSession;
import javax.jms.XAQueueSession;

public class MQXAQueueSession
extends MQXASession
implements XAQueueSession {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQXAQueueSession.java, jms, j521, j521-L020126 02/01/25 15:25:36 @(#) 1.10.1.1";
    private MQQueueSession session = null;

    public MQXAQueueSession(MQConnection mQConnection, MQQueueSession mQQueueSession, MQXAResource mQXAResource) throws JMSException {
        super(mQConnection, mQXAResource);
        this.session = mQQueueSession;
    }

    public QueueSession getQueueSession() throws JMSException {
        return this.session;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            try {
                super.close();
                this.session.close();
                this.session.discQM();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception: " + exception);
                throw jMSException;
            }
            Object var4_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    public void _acknowledge() throws JMSException {
        throw ConfigEnvironment.newException("MQJMS1016", "MQXAQueueSession._acknowledge");
    }
}

