/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.RFH;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.util.NoSuchElementException;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import javax.jms.TopicSubscriber;

public class MQTopicSubscriber
extends MQMessageConsumer
implements TopicSubscriber {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTopicSubscriber.java, jms, j521, j521-L020126 02/01/25 15:22:39 @(#) 1.74.1.1";
    public static final int DEFAULT_MAX_ASYNC_ATTEMPTS = 5;
    private MQTopic topicSpec;
    private MQGetMessageOptions gmo;
    private MQJMSMessage baseMessage;
    private int acknowledgeMode;
    private MQTopicSession session;
    private MessageListener listener;
    private boolean noLocal;
    private boolean selectorSet;
    private MQQueue queue;
    private int maxAsyncAttempts;
    private String backoutRetryQueue;
    private boolean durable;
    private String name;
    private byte[] subscriberId;
    private byte[] statusMgrId;
    private boolean shared_queue;
    MQSubscription subscription;
    private static final int SYNCPOINT = 1;
    private static final int SPIP = 2;
    private static final int NO_SYNCPOINT = 3;
    private int syncPoint;

    MQTopicSubscriber(MQTopic mQTopic, MQTopicSession mQTopicSession, MQSubscription mQSubscription, boolean bl, int n) throws JMSException {
        block23: {
            this.topicSpec = null;
            this.session = null;
            this.listener = null;
            this.noLocal = false;
            this.selectorSet = false;
            this.queue = null;
            this.maxAsyncAttempts = 5;
            this.backoutRetryQueue = null;
            this.name = null;
            this.subscriberId = null;
            this.statusMgrId = null;
            this.shared_queue = false;
            this.subscription = null;
            this.syncPoint = 1;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
                Trace.trace(this, sccsid);
            }
            this.topicSpec = mQTopic;
            this.queue = mQSubscription.getSubscriberQueue();
            this.session = mQTopicSession;
            this.noLocal = mQSubscription.getNoLocal();
            this.name = mQSubscription.getQueueName();
            this.subscriberId = mQSubscription.getCorrelationId();
            if (mQSubscription instanceof MQQueueSubscription) {
                this.statusMgrId = ((MQQueueSubscription)mQSubscription).getStatusMgrId();
            }
            this.shared_queue = mQSubscription.isSharedQueue();
            String string = mQSubscription.getSelector();
            this.subscription = mQSubscription;
            this.acknowledgeMode = n;
            if (Trace.isOn) {
                Trace.trace(this, "Queue name = " + this.name);
            }
            if (this.name.startsWith("SYSTEM.JMS.D.")) {
                if (Trace.isOn) {
                    Trace.trace(this, "durable set to TRUE");
                }
                this.durable = true;
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "durable set to FALSE");
                }
                this.durable = false;
            }
            try {
                this.setMessageSelector(string);
            }
            catch (JMSException jMSException) {
                this.session = null;
                this.topicSpec = null;
                this.queue = null;
                if (Trace.isOn) {
                    Trace.trace(this, "constructor: setMessageSelector() threw " + (Object)((Object)jMSException));
                    Trace.exit(this, "constructor");
                }
                throw jMSException;
            }
            this.selectorSet = string != null && !string.equals("");
            try {
                int[] nArray = new int[]{22};
                int[] nArray2 = new int[1];
                this.queue.inquire(nArray, nArray2, null);
                String string2 = this.queue.getAttributeString(2019, 48).trim();
                int n2 = nArray2[0];
                if (Trace.isOn) {
                    Trace.trace(this, "returned from inquire, threshold = " + n2 + ", borq = '" + string2 + "'");
                }
                if (n2 != 0) {
                    this.maxAsyncAttempts = n2;
                }
                this.backoutRetryQueue = !string2.equals("") ? string2 : mQTopicSession.getDLQName();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block23;
                Trace.trace(this, "constructor: queue.inquire threw " + exception);
            }
        }
        this.gmo = new MQGetMessageOptions(true);
        this.gmo.matchOptions = this.shared_queue ? 2 : 0;
        boolean bl2 = mQTopicSession.getSyncpointAllGets();
        if (bl || bl2 || n == 2 || mQTopicSession.getDistTransactionMode() == 2) {
            this.syncPoint = 1;
            this.gmo.options |= 2;
            this.gmo.options &= 0xFFFFFFFB;
            this.gmo.options &= 0xFFFFEFFF;
            if (Trace.isOn) {
                Trace.trace(this, "syncpoint enabled");
            }
        } else if (this.durable) {
            this.syncPoint = 2;
            this.gmo.options |= 0x1000;
            this.gmo.options &= 0xFFFFFFFB;
            this.gmo.options &= 0xFFFFFFFD;
            if (Trace.isOn) {
                Trace.trace(this, "using syncpoint if persistent");
            }
        } else {
            this.syncPoint = 3;
            this.gmo.options |= 4;
            this.gmo.options &= 0xFFFFFFFD;
            this.gmo.options &= 0xFFFFEFFF;
            if (Trace.isOn) {
                Trace.trace(this, "syncpoint disabled");
            }
        }
        this.baseMessage = new MQJMSMessage();
        if (mQTopic instanceof MQTemporaryTopic) {
            ((MQTemporaryTopic)mQTopic).usageUp();
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void finalize() throws Throwable {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            try {
                this.close();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) break block4;
                Trace.trace(this, "calling close from finalize failed: " + (Object)((Object)jMSException));
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        boolean bl = true;
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            try {
                if (this.session != null) {
                    this.session.setPlayNice(true);
                }
                MQTopicSubscriber mQTopicSubscriber = this;
                synchronized (mQTopicSubscriber) {
                    block27: {
                        if (this.listener != null) {
                            if (this.session != null) {
                                this.session.removeAsync(this);
                            }
                            this.listener = null;
                        }
                        this.closed = true;
                        if (!this.isDurable()) {
                            try {
                                this.subscription.close();
                                this.queue = null;
                            }
                            catch (JMSException jMSException) {
                                Exception exception = jMSException.getLinkedException();
                                if (exception instanceof MQException && ((MQException)((Object)exception)).reasonCode == 2055) {
                                    bl = false;
                                    if (Trace.isOn) {
                                        Trace.trace(this, "close ignoring MQException 2055");
                                    }
                                    break block27;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "close() ignoring exception " + (Object)((Object)jMSException));
                                    if (exception != null) {
                                        Trace.trace(this, "linked exception " + exception);
                                    }
                                }
                                this.queue = null;
                            }
                        } else if (this.queue != null) {
                            try {
                                this.subscription.close();
                                this.queue.close();
                                this.queue = null;
                            }
                            catch (MQException mQException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", this.subscription.getQueueName());
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                throw jMSException;
                            }
                        }
                    }
                    if (this.session != null && bl) {
                        this.session.removeConsumer(this);
                    }
                    if (this.session != null) {
                        this.session.setPlayNice(false);
                    }
                    this.session = null;
                    if (this.topicSpec instanceof MQTemporaryTopic) {
                        ((MQTemporaryTopic)this.topicSpec).usageDown();
                        this.topicSpec = null;
                    }
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var7_9 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    public MessageListener getMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getMessageListener");
        }
        this.checkConsumerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getMessageListener");
        }
        return this.listener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMessageListener");
        }
        this.checkConsumerOpen();
        try {
            try {
                if (this.isClosed() || this.session == null) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS3034");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                if (messageListener != null && this.session.hasMessageListener()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                this.listener = messageListener;
                if (messageListener == null) {
                    this.session.removeAsync(this);
                }
                this.session.addAsync(this);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setMessageListener");
            throw throwable;
        }
        Trace.exit(this, "setMessageListener");
    }

    public boolean getNoLocal() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getNoLocal");
        }
        this.checkConsumerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getNoLocal");
        }
        return this.noLocal;
    }

    public Topic getTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getTopic");
        }
        this.checkConsumerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getTopic");
        }
        return this.topicSpec;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message receive() throws JMSException {
        Message message = null;
        Trace.checkForTurnTracingOn();
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "receive");
                }
                while (message == null) {
                    message = this.receiveInternal(-1L);
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var5_2 = null;
            if (!Trace.isOn) return message;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "receive");
            throw throwable;
        }
        Trace.exit(this, "receive");
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long l) throws JMSException {
        Message message;
        Trace.checkForTurnTracingOn();
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "receive(t)");
                }
                if (l == 0L) {
                    message = this.receive();
                }
                message = this.receiveInternal(l);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var7_3 = null;
            if (!Trace.isOn) return message;
        }
        catch (Throwable throwable) {
            Object var7_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "receive(t)");
            throw throwable;
        }
        Trace.exit(this, "receive(t)");
        return message;
    }

    public Message receiveNoWait() throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "receiveNoWait");
        }
        Message message = this.receiveInternal(0L);
        if (Trace.isOn) {
            Trace.exit(this, "receiveNoWait()");
        }
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized boolean receiveAsync(long l) throws NoMsgListenerException, JMSException {
        boolean bl;
        block30: {
            boolean bl2;
            block29: {
                bl = false;
                try {
                    try {
                        if (Trace.isOn) {
                            Trace.entry(this, "receiveAsync");
                        }
                        if (this.isClosed()) {
                            String string = ConfigEnvironment.getErrorMessage("MQJMS3034");
                            IllegalStateException illegalStateException = new IllegalStateException(string);
                            throw illegalStateException;
                        }
                        if (this.listener == null) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1012");
                            throw jMSException;
                        }
                        if (this.queue == null) {
                            throw ConfigEnvironment.newException("MQJMS2001");
                        }
                        boolean bl3 = this.session.getTransacted();
                        Object object = this.session.getTransactionLock();
                        synchronized (object) {
                            if (!this.session.isStarted()) {
                                bl2 = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 28] lbl20 : MonitorExitStatement: MONITOREXIT : var5_8
                                Object var15_11 = null;
                                if (!Trace.isOn) return bl2;
                                break block29;
                            }
                            JMSMessage jMSMessage = this.getMessage(l);
                            if (jMSMessage != null) {
                                if (!bl3 && this.acknowledgeMode == 2) {
                                    jMSMessage._setSession(this.session);
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiveAsync - entering delivery block");
                                }
                                if (this.listener == null) throw new NoMsgListenerException("no message listener registered");
                                boolean bl4 = true;
                                int n = 0;
                                while (true) {
                                    if (!bl4) {
                                        this.acknowledgeOrSet(jMSMessage);
                                        bl = true;
                                        break;
                                    }
                                    try {
                                        bl4 = false;
                                        ++n;
                                        this.listener.onMessage((Message)jMSMessage);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            Logger.log(new LogMessage(2, "MQJMS1034", throwable.toString()));
                                        }
                                        catch (LogException logException) {
                                            System.err.println("failed to log error because of " + logException);
                                        }
                                        if (Trace.isOn) {
                                            Trace.trace(this, "onMessage threw " + throwable);
                                        }
                                        if (!(bl3 || this.acknowledgeMode != 1 && this.acknowledgeMode != 3 || n >= this.maxAsyncAttempts)) {
                                            bl4 = true;
                                            jMSMessage.setJMSRedelivered(true);
                                            continue;
                                        }
                                        try {
                                            if (this.backoutRetryQueue == null) {
                                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                                                if (!Trace.isOn) throw jMSException;
                                                Trace.trace(this, "receiveAsync() no backout queue defined.");
                                                throw jMSException;
                                            }
                                            this.session.redirectMessage(this.backoutRetryQueue, this.baseMessage);
                                            if (this.syncPoint != 2 || this.baseMessage.getPersistence() == 1) continue;
                                            this.session._acknowledge();
                                        }
                                        catch (JMSException jMSException) {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "failed to redirect message. Closing receiver");
                                            }
                                            try {
                                                Logger.log(new LogMessage(2, "MQJMS1022"));
                                            }
                                            catch (LogException logException) {
                                                System.err.println("failed to log error because of " + logException);
                                            }
                                            this.close();
                                            if (!Trace.isOn) throw jMSException;
                                            Trace.exception(this, "receiveAsync", throwable);
                                            Trace.exit(this, "receiveAsync");
                                            throw jMSException;
                                        }
                                    }
                                }
                            }
                            break block30;
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception == null) throw jMSException;
                        Trace.trace(this, "linked exception " + exception);
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_13 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "receiveAsync");
                    throw throwable;
                }
            }
            Trace.exit(this, "receiveAsync");
            return bl2;
        }
        Object var15_12 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "receiveAsync");
        return bl;
    }

    boolean isDurable() {
        return this.durable;
    }

    private JMSMessage getMessage(long l) throws JMSException {
        boolean bl;
        JMSMessage jMSMessage = null;
        RFH rFH = null;
        if (Trace.isOn) {
            Trace.entry(this, "getMessage");
        }
        if (l == 0L) {
            if (Trace.isOn) {
                Trace.trace(this, "getMessage setting no wait");
            }
            this.gmo.options |= 0;
            this.gmo.options &= 0xFFFFFFFE;
        } else {
            if (Trace.isOn) {
                Trace.trace(this, "getMessage setting waitInterval");
            }
            this.gmo.options |= 1;
            this.gmo.options &= 0xFFFFFFFF;
            this.gmo.waitInterval = (int)l;
            if (Trace.isOn) {
                Trace.trace(this, "getMessage setting waitInterval to " + l);
            }
        }
        int n = 0;
        do {
            bl = false;
            try {
                Object object;
                if (Trace.isOn) {
                    Trace.trace(this, "getMessage MQGET started");
                    Trace.trace(this, "retry #" + n++);
                }
                this.baseMessage.setMessageId(MQC.MQMI_NONE);
                if (this.shared_queue) {
                    this.baseMessage.setCorrelationId(this.subscriberId);
                } else {
                    this.baseMessage.setCorrelationId(MQC.MQCI_NONE);
                }
                if (this.durable || this.syncPoint != 3) {
                    this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo);
                } else {
                    ((MQSPIQueue)this.queue).spiBatchedGet((MQMsg2)this.baseMessage, this.gmo);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "getMessage MQGET done");
                }
                if (this.noLocal) {
                    long l2;
                    if (Trace.isOn) {
                        Trace.trace(this, "Entering noLocal checks");
                    }
                    try {
                        l2 = this.baseMessage.getFormatAsLong();
                    }
                    catch (Exception exception) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                        if (Trace.isOn) {
                            Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                            Trace.exit(this, "getMessage (via Exception)");
                        }
                        throw jMSException;
                    }
                    object = null;
                    if (l2 == 5571313732235042848L || l2 == -3109514705039769536L) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Received message has RFH1 header");
                        }
                        try {
                            rFH = new RFH(this.baseMessage);
                            if (rFH != null) {
                                object = rFH.getValue("UNIQUE_CONNECTION_ID");
                            }
                        }
                        catch (JMSException jMSException) {
                            if (Trace.isOn) {
                                Trace.trace(this, "couldn't create an RFH from the incoming message");
                            }
                        }
                        catch (NoSuchElementException noSuchElementException) {}
                    } else if (l2 == 5571313732236222496L || l2 == -3109514705028104128L) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Received message has RFH2 header");
                        }
                        try {
                            String string;
                            int n2 = 0;
                            int n3 = 0;
                            int n4 = 0;
                            int n5 = 0;
                            n2 = this.baseMessage.getEncoding();
                            this.baseMessage.skipReadingBytes(8);
                            n3 = this.baseMessage.readInt(n2);
                            this.baseMessage.skipReadingBytes(20);
                            n4 = this.baseMessage.readInt(n2);
                            this.baseMessage.skipReadingBytes(4);
                            n5 = n3 - 40;
                            byte[] byArray = new byte[n5];
                            this.baseMessage.read(byArray);
                            if (n4 == 1208) {
                                string = new String(byArray);
                            } else {
                                String string2 = MQJMSMessage.getCharacterSetString(n4, n2);
                                string = new String(byArray, string2);
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "nameValueString is " + string);
                            }
                            object = string.substring(string.indexOf("<UNIQUE_CONNECTION_ID>") + 22, string.indexOf("</UNIQUE_CONNECTION_ID>"));
                        }
                        catch (Exception exception) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                            if (Trace.isOn) {
                                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                                Trace.exit(this, "getMessage (via Exception)");
                            }
                            throw jMSException;
                        }
                    } else {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1087");
                        if (Trace.isOn) {
                            Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                            Trace.exit(this, "getMessage (via Exception)");
                        }
                        throw jMSException;
                    }
                    if (object == null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "No UNIQUE_CONNECTION_ID in message");
                        }
                    } else if (((String)object).equals(this.session.getConnectionID())) {
                        if (Trace.isOn) {
                            Trace.trace(this, "IDs match (" + (String)object + ")" + ", therefore " + "the message is local, and needs to be " + "discarded. Setting retry=true");
                        }
                        bl = true;
                    } else if (Trace.isOn) {
                        Trace.trace(this, "IDs don't match. Incoming=" + (String)object + ", Connection=" + this.session.getConnectionID() + ". Message is non-local, therefore valid");
                    }
                    this.baseMessage.resetReadPosition();
                }
                try {
                    jMSMessage = this.baseMessage.createJMSMessage(this.session);
                }
                catch (JMSException jMSException) {
                    throw jMSException;
                }
                catch (Exception exception) {
                    object = ConfigEnvironment.newException("MQJMS1000");
                    object.setLinkedException(exception);
                    throw object;
                }
                if (!this.messageSelector.isSelected(jMSMessage, this.baseMessage)) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Msg failed selector. retry=true");
                    }
                    bl = true;
                }
                if (!bl) continue;
                if (Trace.isOn) {
                    Trace.trace(this, "getMessage calling acknowledgeOrSet to commit a discarded message");
                }
                this.acknowledgeOrSet(jMSMessage);
            }
            catch (MQException mQException) {
                if (mQException.reasonCode == 2033) {
                    if (Trace.isOn) {
                        Trace.trace(this, "No more messages!");
                    }
                    jMSMessage = null;
                    continue;
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
        } while (bl);
        if (Trace.isOn) {
            Trace.exit(this, "getMessage");
        }
        return jMSMessage;
    }

    private void acknowledgeOrSet(JMSMessage jMSMessage) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "acknowledgeOrSet");
        }
        if (!this.session.getTransacted()) {
            if (Trace.isOn) {
                Trace.trace(this, "acknowledgeOrSet - checking ack mode");
            }
            switch (this.acknowledgeMode) {
                case 2: {
                    jMSMessage._setSession(this.session);
                    break;
                }
                case 1: 
                case 3: {
                    if (this.syncPoint == 2) {
                        if (this.baseMessage.getPersistence() != 1) break;
                        this.session._acknowledge();
                        break;
                    }
                    if (this.syncPoint != 1) break;
                    this.session._acknowledge();
                    break;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1001", new Integer(this.acknowledgeMode));
                    if (Trace.isOn) {
                        Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                        Trace.exit(this, "acknowledgeOrSet");
                    }
                    throw jMSException;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "acknowledgeOrSet");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message receiveInternal(long l) throws NoMsgListenerException, JMSException {
        JMSMessage jMSMessage;
        block23: {
            Message message;
            block22: {
                Message message2;
                block21: {
                    Message message3;
                    block20: {
                        jMSMessage = null;
                        try {
                            try {
                                long l2;
                                if (Trace.isOn) {
                                    Trace.entry(this, "receiveInternal");
                                }
                                if (this.isClosed()) {
                                    String string = ConfigEnvironment.getErrorMessage("MQJMS3034");
                                    IllegalStateException illegalStateException = new IllegalStateException(string);
                                    throw illegalStateException;
                                }
                                if (this.session.usingAsyncMode() || this.session.hasMessageListener()) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                                    throw jMSException;
                                }
                                if (this.queue == null) {
                                    throw ConfigEnvironment.newException("MQJMS2001");
                                }
                                if (l != -1L && (l > Integer.MAX_VALUE || l < 0L)) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1067");
                                    throw jMSException;
                                }
                                if (l == 0L && this.session.isStopped()) {
                                    message3 = null;
                                    Object var12_10 = null;
                                    if (!Trace.isOn) return message3;
                                    break block20;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiveInternal - waiting for session start");
                                }
                                if (l == -1L) {
                                    this.session.waitForStart();
                                    l2 = -1L;
                                } else {
                                    l2 = this.session.waitForStart(l);
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiveInternal - session started");
                                }
                                if (l > 0L && l2 == 0L) {
                                    message2 = null;
                                    break block21;
                                }
                                Object object = this.session.getTransactionLock();
                                synchronized (object) {
                                    if (!this.session.isStarted()) {
                                        message = null;
                                        // MONITOREXIT @DISABLED, blocks:[0, 17, 1, 3] lbl41 : MonitorExitStatement: MONITOREXIT : var8_16
                                        break block22;
                                    }
                                    jMSMessage = this.getMessage(l2);
                                    if (jMSMessage != null) {
                                        this.acknowledgeOrSet(jMSMessage);
                                    }
                                    break block23;
                                }
                            }
                            catch (JMSException jMSException) {
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "receiveInternal throwing " + (Object)((Object)jMSException));
                                throw jMSException;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_14 = null;
                            if (!Trace.isOn) throw throwable;
                            Trace.exit(this, "receiveInternal");
                            throw throwable;
                        }
                    }
                    Trace.exit(this, "receiveInternal");
                    return message3;
                }
                Object var12_11 = null;
                if (!Trace.isOn) return message2;
                Trace.exit(this, "receiveInternal");
                return message2;
            }
            Object var12_12 = null;
            if (!Trace.isOn) return message;
            Trace.exit(this, "receiveInternal");
            return message;
        }
        Object var12_13 = null;
        if (!Trace.isOn) return jMSMessage;
        Trace.exit(this, "receiveInternal");
        return jMSMessage;
    }
}

