/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQMigrateSubscriptionEngine;
import com.ibm.mq.jms.MQQueueSubscriptionEngine;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicPublisher;
import com.ibm.mq.jms.MQTopicSubscriber;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import javax.jms.TransactionRolledBackException;

public class MQTopicSession
extends MQSession
implements TopicSession {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTopicSession.java, jms, j521, j521-L020523 02/05/22 10:57:52 @(#) 1.101.1.4";
    private static final int DEFAULT_BROKER_TIMEOUT = 120000;
    static final int REGISTER_PUBLISHER = 0;
    static final int DEREGISTER_PUBLISHER = 1;
    static final int REGISTER_SUBSCRIBER = 2;
    static final int DEREGISTER_SUBSCRIBER = 3;
    static final int REGISTER_SHAREDQ_SUBSCRIBER = 4;
    static final int DEREGISTER_SHAREDQ_SUBSCRIBER = 5;
    private static final String REGPUB_CMD_PREFIX = "MQPSCommand RegPub MQPSTopic ";
    private static final String DEREGPUB_CMD_PREFIX = "MQPSCommand DeregPub MQPSTopic ";
    private static final String REGSUB_CMD_PREFIX = "MQPSCommand RegSub MQPSTopic ";
    private static final String DEREGSUB_CMD_PREFIX = "MQPSCommand DeregSub MQPSTopic ";
    private static final String REGSUB_CORREL_CMD_PREFIX = "MQPSCommand RegSub MQPSRegOpts CorrelAsId MQPSTopic ";
    private static final String DEREGSUB_CORREL_CMD_PREFIX = "MQPSCommand DeregSub MQPSRegOpts CorrelAsId MQPSTopic ";
    private static final String MQPS_STREAM_NAME_B = " MQPSStreamName ";
    private static final String MQPS_Q_NAME_B = " MQPSQName ";
    private static final String MQPS_REGISTRATION_OPTIONS_B = " MQPSRegOpts ";
    private static final String MQPS_NON_PERSISTENT = "NonPers";
    private static final String MQPS_DUPLICATES_OK = "DupsOK";
    static final String PUBLISH_CMD_PREFIX = "MQPSCommand Publish MQPSTopic ";
    private boolean wait_for_reply = true;
    private int brokerTimeout = 120000;
    private BrokerConnectionInfo brk = new BrokerConnectionInfo(null, null, null);
    private MQTopicConnection connection = null;
    private String deadLetterQueue = null;
    private String resolvedQmName = null;
    private String nondur_subscribeQ;
    public String SUBSCRIBE_CMD_POSTFIX;
    private byte[] statusMgrId;
    private MQQueue replyQ = null;
    MQGetMessageOptions brokerReponseGmo;
    private byte[] responseCorrelId = new byte[24];
    private boolean responseScheduled = false;
    private int brkOptLevel;
    private byte[] sessionName;

    MQTopicSession(MQTopicConnection mQTopicConnection, MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        super(mQTopicConnection, bl, n);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.qm = mQQueueManager;
        this.connection = mQTopicConnection;
        MQSubscriptionEngine mQSubscriptionEngine = this.connection.getSubscriptionEngine();
        this.statusMgrId = null;
        this.sessionName = null;
        if (mQSubscriptionEngine instanceof MQBrokerSubscriptionEngine) {
            this.sessionName = ((MQBrokerSubscriptionEngine)mQSubscriptionEngine).createSessionName(this);
        } else if (mQSubscriptionEngine instanceof MQQueueSubscriptionEngine) {
            this.statusMgrId = ((MQQueueSubscriptionEngine)mQSubscriptionEngine).getStatusMgrId();
        } else if (mQSubscriptionEngine instanceof MQMigrateSubscriptionEngine) {
            this.statusMgrId = ((MQMigrateSubscriptionEngine)mQSubscriptionEngine).getStatusMgrId();
            this.sessionName = ((MQMigrateSubscriptionEngine)mQSubscriptionEngine).createSessionName(this);
        }
        this.brk.controlQ = this.connection.getBrkControlQueue();
        this.brk.streamQ = this.connection.getBrkPubQueue();
        this.brk.qmName = this.connection.getBrkQueueManager();
        this.brkOptLevel = this.connection.getBrkOptLevel();
        this.nondur_subscribeQ = this.connection.getBrkSubQueue();
        this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
        try {
            int n2 = 1;
            this.replyQ = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", n2);
            this.brokerReponseGmo = new MQGetMessageOptions();
            this.brokerReponseGmo.options = 1;
            this.brokerReponseGmo.waitInterval = this.brokerTimeout;
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("failed to setup response queue");
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    MQTopicSession(MQQueueManager mQQueueManager, String string, String string2) throws JMSException {
        super(null, false, 1);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.qm = mQQueueManager;
        this.brk.controlQ = string;
        this.brk.streamQ = string2;
        this.SUBSCRIBE_CMD_POSTFIX = new String(MQPS_STREAM_NAME_B + this.brk.streamQ + MQPS_Q_NAME_B);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void setBrokerTimeout(int n) {
        if (Trace.isOn) {
            Trace.trace(this, "setBrokerTimeout to " + n);
        }
        this.brokerTimeout = n;
        this.wait_for_reply = this.brokerTimeout > 0;
    }

    public int getBrokerTimeout() {
        return this.brokerTimeout;
    }

    public byte[] getSessionName() {
        return this.sessionName;
    }

    public Topic createTopic(String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopic");
        }
        this.checkSessionOpen();
        if (Trace.isOn) {
            Trace.exit(this, "createTopic");
        }
        return new MQTopic(string);
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "createSubscriber");
        }
        if (Trace.isOn) {
            Trace.exit(this, "createSubscriber");
        }
        return this.createSubscriber(topic, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TopicSubscriber createSubscriber(Topic topic, String string, boolean bl) throws JMSException {
        int n = 33;
        Object var5_5 = null;
        Object var6_6 = null;
        MQTopicSubscriber mQTopicSubscriber = null;
        Object var8_8 = null;
        MQSubscription mQSubscription = null;
        boolean bl2 = true;
        boolean bl3 = this.wait_for_reply;
        boolean bl4 = false;
        try {
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "createSubscriber(t,s,n)");
            }
            if (this.isClosed()) {
                String string2 = "MQJMS1024";
                String string3 = ConfigEnvironment.getErrorMessage(string2);
                IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                throw illegalStateException;
            }
            if (this.qm == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                throw jMSException;
            }
            if (!(topic instanceof MQTopic)) {
                String string4 = "MQJMS0003";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                throw invalidDestinationException;
            }
            MQTopic mQTopic = (MQTopic)topic;
            if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() != this.connection.getBrkVersion()) {
                if (Trace.isOn) {
                    Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                    Trace.exit(this, "createSubscriber");
                }
                String string6 = "MQJMS0003";
                String string7 = ConfigEnvironment.getErrorMessage(string6);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string6);
                throw invalidDestinationException;
            }
            if (topic instanceof MQTemporaryTopic) {
                MQTemporaryTopic mQTemporaryTopic = (MQTemporaryTopic)topic;
                if (mQTemporaryTopic.isDeleted()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3019");
                    throw jMSException;
                }
                if (!this.connection.getConnectionID().equals(mQTemporaryTopic.getConnID())) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3020");
                    throw jMSException;
                }
            }
            if (this.nondur_subscribeQ.trim().equals("")) {
                this.nondur_subscribeQ = "SYSTEM.JMS.ND.*";
            } else if (!this.nondur_subscribeQ.startsWith("SYSTEM.JMS.ND.")) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", this.nondur_subscribeQ);
                throw jMSException;
            }
            if (this.nondur_subscribeQ.endsWith("*")) {
                bl2 = false;
                if (Trace.isOn) {
                    Trace.trace(this, "Using multi-queue approach.");
                }
            } else {
                bl2 = true;
            }
            if (Trace.isOn) {
                Trace.trace(this, "Prefix: SYSTEM.JMS.ND.");
                Trace.trace(this, "QName:  " + this.nondur_subscribeQ);
            }
            mQSubscription = this.connection.getSubscriptionEngine().openSubscription(this, mQTopic, string, bl, bl2, this.nondur_subscribeQ);
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.exit(this, "createSubscriber(t,s,n)");
            throw jMSException;
        }
        try {
            mQTopicSubscriber = new MQTopicSubscriber((MQTopic)topic, this, mQSubscription, this.transacted, this.acknowledgeMode);
            super.addConsumer(mQTopicSubscriber);
            Object var19_30 = null;
            if (!Trace.isOn) return mQTopicSubscriber;
        }
        catch (Throwable throwable) {
            Object var19_31 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createSubscriber(t,s,n)");
            throw throwable;
        }
        Trace.exit(this, "createSubscriber(t,s,n)");
        return mQTopicSubscriber;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDurableSubscriber");
        }
        if (Trace.isOn) {
            Trace.exit(this, "createDurableSubscriber");
        }
        return this.createDurableSubscriber(topic, string, null, false);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TopicSubscriber createDurableSubscriber(Topic topic, String string, String string2, boolean bl) throws JMSException {
        MQSubscription mQSubscription = null;
        MQTopicSubscriber mQTopicSubscriber = null;
        String string3 = null;
        boolean bl2 = true;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createDurableSubscriber(t,n,s,n)");
                }
                if (this.isClosed()) {
                    String string4 = "MQJMS1024";
                    String string5 = ConfigEnvironment.getErrorMessage(string4);
                    IllegalStateException illegalStateException = new IllegalStateException(string5, string4);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                if (!(topic instanceof MQTopic)) {
                    String string6 = "MQJMS0003";
                    String string7 = ConfigEnvironment.getErrorMessage(string6);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string6);
                    throw invalidDestinationException;
                }
                MQTopic mQTopic = (MQTopic)topic;
                if (mQTopic.containsAnyWildcard() && mQTopic.getBrokerVersion() != this.connection.getBrkVersion()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Invalid wildcard - InvalidDestinationException");
                        Trace.exit(this, "createSubscriber");
                    }
                    String string8 = "MQJMS0003";
                    String string9 = ConfigEnvironment.getErrorMessage(string8);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                    throw invalidDestinationException;
                }
                if (topic instanceof MQTemporaryTopic) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS0003");
                    throw jMSException;
                }
                string3 = ((MQTopic)topic).getBrokerDurSubQueue();
                if (string3.trim().equals("")) {
                    string3 = "SYSTEM.JMS.D.*";
                } else if (!string3.startsWith("SYSTEM.JMS.D.")) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string3);
                    throw jMSException;
                }
                if (string3.endsWith("*")) {
                    bl2 = false;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Topic name = " + ((MQTopic)topic).getBaseTopicName());
                    Trace.trace(this, "Sub Q name = " + string3);
                    Trace.trace(this, "Name       = " + string);
                    Trace.trace(this, "Selector   = " + string2);
                    Trace.trace(this, "noLocal    = " + bl);
                }
                mQSubscription = this.connection.getSubscriptionEngine().openDurableSubscription(this, mQTopic, string2, bl, bl2, string3, string);
                mQTopicSubscriber = new MQTopicSubscriber(mQTopic, this, mQSubscription, this.transacted, this.acknowledgeMode);
                super.addConsumer(mQTopicSubscriber);
                Object var14_25 = null;
                if (!Trace.isOn) return mQTopicSubscriber;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var14_26 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createDurableSubscriber(t,n,s,n)");
            throw throwable;
        }
        Trace.exit(this, "createDurableSubscriber(t,n,s,n)");
        return mQTopicSubscriber;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TopicPublisher createPublisher(Topic topic) throws JMSException {
        MQTopicPublisher mQTopicPublisher;
        int n = 16;
        MQQueue mQQueue = null;
        String string = null;
        try {
            try {
                MQTemporaryTopic mQTemporaryTopic;
                if (Trace.isOn) {
                    Trace.entry(this, "createPublisher");
                }
                string = this.connection.getBrkPubQueue();
                if (this.isClosed()) {
                    String string2 = "MQJMS1024";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    throw new IllegalStateException(string3, string2);
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                if (topic instanceof MQTemporaryTopic && (mQTemporaryTopic = (MQTemporaryTopic)topic).isDeleted()) {
                    JMSException jMSException = new JMSException("TemporaryTopic already deleted");
                    throw jMSException;
                }
                try {
                    mQQueue = this.qm.accessQueue(string, n, this.brk.qmName, null, null);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "createPublisher failed to access publish queue because of " + (Object)((Object)mQException));
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                mQTopicPublisher = new MQTopicPublisher((MQTopic)topic, mQQueue, this.qm, this.connection, this);
                super.addProducer(mQTopicPublisher);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var9_15 = null;
            if (!Trace.isOn) return mQTopicPublisher;
        }
        catch (Throwable throwable) {
            Object var9_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createPublisher");
            throw throwable;
        }
        Trace.exit(this, "createPublisher");
        return mQTopicPublisher;
    }

    public TemporaryTopic createTemporaryTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTemporaryTopic");
        }
        this.checkSessionOpen();
        if (Trace.isOn) {
            Trace.exit(this, "createTemporaryTopic");
        }
        return new MQTemporaryTopic(this.connection, this.connection.getAndIncrementTempTopicCount());
    }

    public void commit() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "commit");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (!this.transacted) {
                    String string = "MQJMS1019";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    Object object = this.getTransactionLock();
                    synchronized (object) {
                        this.qm.commit();
                        if (this.responseScheduled) {
                            try {
                                try {
                                    MQMsg2 mQMsg2 = new MQMsg2();
                                    mQMsg2.setCorrelationId(this.responseCorrelId);
                                    this.getBrokerResponse(mQMsg2);
                                }
                                catch (JMSException jMSException) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "caught " + (Object)((Object)jMSException));
                                        Exception exception = jMSException.getLinkedException();
                                        if (exception != null) {
                                            Trace.trace(this, "linked exception " + exception);
                                        }
                                    }
                                    throw jMSException;
                                }
                                Object var5_17 = null;
                                this.unscheduleResponse();
                            }
                            catch (Throwable throwable) {
                                Object var5_18 = null;
                                this.unscheduleResponse();
                                throw throwable;
                            }
                        }
                    }
                }
                catch (MQException mQException) {
                    int n = mQException.completionCode;
                    int n2 = mQException.reasonCode;
                    JMSException jMSException = n == 1 && n2 == 2003 ? new TransactionRolledBackException(ConfigEnvironment.getMessage("MQJMS0011")) : ConfigEnvironment.newException("MQJMS2009");
                    if (this.responseScheduled) {
                        this.unscheduleResponse();
                    }
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var8_22 = null;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "linked exception " + exception);
                    }
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_23 = null;
            Trace.exit(this, "commit");
            throw throwable;
        }
        Trace.exit(this, "commit");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "rollback");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (!this.transacted) {
                    String string = "MQJMS1019";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    Object object = this.getTransactionLock();
                    synchronized (object) {
                        this.qm.backout();
                        if (this.responseScheduled) {
                            this.unscheduleResponse();
                        }
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1023");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var6_14 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "rollback");
            throw throwable;
        }
        Trace.exit(this, "rollback");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recover() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "recover");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (this.transacted) {
                    String string = "MQJMS1024";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    Object object = this.getTransactionLock();
                    synchronized (object) {
                        if (this.qm.isConnected()) {
                            try {
                                this.qm.backout();
                            }
                            catch (NullPointerException nullPointerException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                                jMSException.setLinkedException((Exception)nullPointerException);
                                throw jMSException;
                            }
                        } else if (Trace.isOn) {
                            Trace.trace(this, "qm not connected - race condition?");
                        }
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var6_16 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "recover throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "recover");
            throw throwable;
        }
        Trace.exit(this, "recover");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(String string) throws JMSException {
        this.checkSessionOpen();
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "unsubscribe");
                    Trace.trace(this, "public unsubscribe call, name='" + string + "'");
                }
                this.connection.getSubscriptionEngine().durableUnsubscribe(this, string);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception = " + exception);
                throw jMSException;
            }
            Object var5_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "unsubscribe");
            throw throwable;
        }
        Trace.exit(this, "unsubscribe");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        try {
            try {
                Throwable throwable;
                block11: {
                    if (Trace.isOn) {
                        Trace.entry(this, "close");
                    }
                    if (this.isStarted() && this.usingAsyncMode()) {
                        try {
                            this.stop();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) break block11;
                            Trace.trace(this, "implicit stop failed with " + (Object)((Object)jMSException));
                            throwable = jMSException.getLinkedException();
                            if (throwable == null) break block11;
                            Trace.trace(this, "linked exception " + throwable);
                        }
                    }
                }
                if (this.replyQ != null) {
                    try {
                        this.replyQ.close();
                        this.replyQ = null;
                    }
                    catch (MQException mQException) {
                        throwable = ConfigEnvironment.newException("MQJMS2000");
                        throwable.setLinkedException((Exception)((Object)mQException));
                        throw throwable;
                    }
                }
                super.close();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var4_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    void sendCommand(String string, int n, String string2, byte[] byArray) throws JMSException {
        this.sendCommand(string, n, string2, byArray, this.wait_for_reply, false);
    }

    void sendCommand(String string, int n, String string2, byte[] byArray, boolean bl) throws JMSException {
        this.sendCommand(string, n, string2, byArray, bl, false);
    }

    /*
     * Exception decompiling
     */
    void sendCommand(String var1_1, int var2_2, String var3_3, byte[] var4_4, boolean var5_5, boolean var6_6) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [23[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    String getConnectionID() {
        return this.connection.getConnectionID();
    }

    int getConnectionBrokerVersion() {
        return this.connection.getBrkVersion();
    }

    String getDLQName() {
        return this.deadLetterQueue;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void redirectMessage(String string, MQMsg2 mQMsg2) throws JMSException {
        MQQueue mQQueue = null;
        try {
            block22: {
                block20: {
                    if (Trace.isOn) {
                        Trace.entry(this, "redirectMessage");
                        Trace.trace(this, "sending message to '" + string + "'");
                    }
                    if (this.isClosed()) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                        throw jMSException;
                    }
                    if (this.qm == null) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                        throw jMSException;
                    }
                    try {
                        int n = 16;
                        mQQueue = this.qm.accessQueue(string, n);
                        MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                        mQPutMessageOptions.options |= 2;
                        mQPutMessageOptions.options &= 0xFFFFFFFB;
                        mQQueue.putMsg2(mQMsg2, mQPutMessageOptions);
                        Object var7_12 = null;
                        if (!Trace.isOn) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var7_13 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "redirectMessage finally block");
                        }
                        if (mQQueue == null) throw throwable;
                        try {
                            mQQueue.close();
                            throw throwable;
                        }
                        catch (MQException mQException) {
                            try {
                                Logger.log(new LogMessage(2, "MQJMS2000"));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                            if (!Trace.isOn) throw throwable;
                            Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                        }
                        throw throwable;
                    }
                    Trace.trace(this, "redirectMessage finally block");
                }
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS2000"));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        if (Trace.isOn) {
                            Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                        }
                        break block22;
                    }
                }
                break block22;
                {
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            Object var11_19 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "redirectMessage");
            throw throwable;
        }
        Trace.exit(this, "redirectMessage");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing exception: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removePublisher(MQTopicPublisher mQTopicPublisher) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removePublisher");
            }
            super.removeProducer(mQTopicPublisher);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "removePublisher");
            throw throwable;
        }
        Trace.exit(this, "removePublisher");
    }

    MQQueueManager getQM() {
        return this.qm;
    }

    BrokerConnectionInfo getBrk() {
        return this.brk;
    }

    MQQueue getResponseQueue() {
        return this.replyQ;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getBrokerResponse(MQMsg2 mQMsg2) throws NoBrokerResponseException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "getBrokerResponse");
                }
                this.replyQ.getMsg2(mQMsg2, this.brokerReponseGmo);
            }
            catch (MQException mQException) {
                String string = "MQJMS5053";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                throw noBrokerResponseException;
            }
            Object var7_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getBrokerResponse");
            throw throwable;
        }
        Trace.exit(this, "getBrokerResponse");
    }

    public boolean scheduleResponse() {
        if (!this.responseScheduled) {
            if (Trace.isOn) {
                Trace.entry(this, "scheduleResponse");
            }
            this.responseScheduled = true;
            if (Trace.isOn) {
                Trace.exit(this, "scheduleResponse");
            }
            return true;
        }
        return false;
    }

    public void unscheduleResponse() {
        this.responseScheduled = false;
    }

    public void recordResponseId(byte[] byArray) {
        System.arraycopy(byArray, 0, this.responseCorrelId, 0, byArray.length);
        int n = byArray.length;
        while (n < this.responseCorrelId.length) {
            this.responseCorrelId[n] = 0;
            ++n;
        }
    }
}

