/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageProducer;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import javax.jms.TopicPublisher;

public class MQTopicPublisher
extends MQMessageProducer
implements TopicPublisher {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTopicPublisher.java, jms, j521, j521-L020202 02/02/01 11:10:15 @(#) 1.74.1.2";
    private MQPutMessageOptions pmo;
    private MQTopic TopicSpec = null;
    private MQQueue mqPubQ = null;
    private MQQueueManager qm = null;
    private MQTopicConnection connection;
    private MQJMSMessage baseMessage = new MQJMSMessage();
    private MQTopicSession session = null;
    private String publishQ;
    private String streamQ;
    private int msgsSinceLastAck = 0;
    private int msgAckInterval = 0;
    private boolean firstMsg = true;
    private byte[] cachedRFHData = null;
    private String cachedBaseTopic = null;
    private int cachedEncoding = 0;

    MQTopicPublisher(MQTopic mQTopic, MQQueue mQQueue, MQQueueManager mQQueueManager, MQTopicConnection mQTopicConnection, MQTopicSession mQTopicSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.TopicSpec = mQTopic;
        this.mqPubQ = mQQueue;
        this.qm = mQQueueManager;
        this.connection = mQTopicConnection;
        this.session = mQTopicSession;
        this.streamQ = this.publishQ = this.connection.getBrkPubQueue();
        this.msgsSinceLastAck = this.msgAckInterval = mQTopicConnection.getPubAckInterval();
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void finalize() throws Throwable {
        block4: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            try {
                this.close();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) break block4;
                Trace.trace(this, "calling close from finalize failed: " + (Object)((Object)jMSException));
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    public Topic getTopic() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getTopic");
        }
        this.checkProducerOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getTopic");
        }
        return this.TopicSpec;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(Message message, int n, int n2, long l) throws JMSException {
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            block30: {
                try {
                    Trace.checkForTurnTracingOn();
                    if (Trace.isOn) {
                        Trace.entry(this, "publish(m,d,p,t)");
                    }
                    if (this.closed) {
                        String string = ConfigEnvironment.getErrorMessage("MQJMS3028");
                        throw new IllegalStateException(string);
                    }
                    this.validateParms(this.TopicSpec, message, n, n2, l);
                    if (this.mqPubQ == null) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2001");
                        throw jMSException;
                    }
                    if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                        if (Trace.isOn) {
                            Trace.trace(this, "can't publish because session is actively using async delivery");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                        throw jMSException;
                    }
                    boolean bl3 = this.session.getTransacted();
                    if (bl3) {
                        this.pmo.options |= 2;
                        this.pmo.options &= 0xFFFFFFFB;
                    } else {
                        this.pmo.options |= 4;
                        this.pmo.options &= 0xFFFFFFFD;
                    }
                    this.buildBaseMessage(this.TopicSpec, message, n, n2, l);
                    if (this.baseMessage.getReport() == 0 && this.msgAckInterval != 0 && ++this.msgsSinceLastAck >= this.msgAckInterval) {
                        if (!bl3) {
                            bl = true;
                        } else {
                            Object object = this.session.getTransactionLock();
                            synchronized (object) {
                                if (this.session.scheduleResponse()) {
                                    bl = true;
                                    n3 = this.baseMessage.getMessageType();
                                    this.baseMessage.setReport(3);
                                    this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                                    this.baseMessage.setReplyToQueueManagerName("");
                                    try {
                                        this.mqPubQ.putMsg2((MQMsg2)this.baseMessage, this.pmo);
                                        this.session.recordResponseId(this.baseMessage.getMessageId());
                                        bl2 = true;
                                    }
                                    catch (MQException mQException) {
                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                                        jMSException.setLinkedException((Exception)((Object)mQException));
                                        this.session.unscheduleResponse();
                                        throw jMSException;
                                    }
                                }
                            }
                        }
                    }
                    if (!bl2) {
                        if (bl) {
                            n3 = this.baseMessage.getMessageType();
                            this.baseMessage.setReport(3);
                            this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                            this.baseMessage.setReplyToQueueManagerName("");
                        } else if (this.baseMessage.getReport() == 0) {
                            this.baseMessage.setMessageType(8);
                        }
                        try {
                            this.mqPubQ.putMsg2((MQMsg2)this.baseMessage, this.pmo);
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                    }
                    if (bl) {
                        this.baseMessage.setMessageType(n3);
                        this.baseMessage.setReport(0);
                        this.baseMessage.setReplyToQueueName("");
                        this.baseMessage.setReplyToQueueManagerName("");
                    }
                    this.baseMessage.setHeaderFromMQMD(message);
                    if (!bl) break block30;
                    if (!bl3) {
                        this.checkBrokerResponse();
                        if (this.firstMsg) {
                            SubscriptionHelper.checkResponse(this.baseMessage);
                            this.firstMsg = false;
                        }
                    }
                    this.msgsSinceLastAck = 0;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    }
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    throw jMSException;
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var15_20 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "publish(m,d,p,t)");
            return;
        }
        catch (Throwable throwable) {
            Object var15_21 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "publish(m,d,p,t)");
            throw throwable;
        }
    }

    public void publish(Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "publish(m)");
        }
        this.publish(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (Trace.isOn) {
            Trace.exit(this, "publish(m)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void publish(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        int n3 = -1;
        boolean bl = false;
        boolean bl2 = false;
        try {
            block32: {
                try {
                    Trace.checkForTurnTracingOn();
                    if (Trace.isOn) {
                        Trace.entry(this, "publish(t,m,d,p,t)");
                    }
                    if (this.closed) {
                        String string = ConfigEnvironment.getErrorMessage("MQJMS3028");
                        throw new IllegalStateException(string);
                    }
                    this.validateParms(topic, message, n, n2, l);
                    if (this.mqPubQ == null) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2001");
                        throw jMSException;
                    }
                    if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                        if (Trace.isOn) {
                            Trace.trace(this, "can't publish because session is actively using async delivery");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                        throw jMSException;
                    }
                    boolean bl3 = this.session.getTransacted();
                    if (bl3) {
                        this.pmo.options |= 2;
                        this.pmo.options &= 0xFFFFFFFB;
                    } else {
                        this.pmo.options |= 4;
                        this.pmo.options &= 0xFFFFFFFD;
                    }
                    this.buildBaseMessage((MQTopic)topic, message, n, n2, l);
                    if (this.baseMessage.getReport() == 0 && this.msgAckInterval != 0 && ++this.msgsSinceLastAck >= this.msgAckInterval) {
                        if (!bl3) {
                            bl = true;
                        } else {
                            Object object = this.session.getTransactionLock();
                            synchronized (object) {
                                if (this.session.scheduleResponse()) {
                                    bl = true;
                                    n3 = this.baseMessage.getMessageType();
                                    this.baseMessage.setReport(3);
                                    this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                                    this.baseMessage.setReplyToQueueManagerName("");
                                    try {
                                        this.mqPubQ.putMsg2((MQMsg2)this.baseMessage, this.pmo);
                                        this.session.recordResponseId(this.baseMessage.getMessageId());
                                        bl2 = true;
                                    }
                                    catch (MQException mQException) {
                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                                        jMSException.setLinkedException((Exception)((Object)mQException));
                                        this.session.unscheduleResponse();
                                        throw jMSException;
                                    }
                                }
                            }
                        }
                    }
                    if (!bl2) {
                        if (bl) {
                            n3 = this.baseMessage.getMessageType();
                            this.baseMessage.setReport(3);
                            this.baseMessage.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                            this.baseMessage.setReplyToQueueManagerName("");
                        } else if (this.baseMessage.getReport() == 0) {
                            this.baseMessage.setMessageType(8);
                        }
                        try {
                            this.mqPubQ.putMsg2((MQMsg2)this.baseMessage, this.pmo);
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                    }
                    if (bl) {
                        this.baseMessage.setMessageType(n3);
                        this.baseMessage.setReport(0);
                        this.baseMessage.setReplyToQueueName("");
                        this.baseMessage.setReplyToQueueManagerName("");
                    }
                    this.baseMessage.setHeaderFromMQMD(message);
                    if (!bl) break block32;
                    if (!bl3) {
                        this.checkBrokerResponse();
                        if (this.firstMsg) {
                            SubscriptionHelper.checkResponse(this.baseMessage);
                            this.firstMsg = false;
                        }
                    }
                    this.msgsSinceLastAck = 0;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3011");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Create Exception " + (Object)((Object)jMSException));
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    }
                    if (Trace.isOn) {
                        Trace.exception(this, "publish(t,n,d,p,t)", (Throwable)jMSException);
                    }
                    Object var16_22 = null;
                    if (!Trace.isOn) return;
                    Trace.exit(this, "publish(t,m,d,p,t)");
                    return;
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var16_21 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "publish(t,m,d,p,t)");
            return;
        }
        catch (Throwable throwable) {
            Object var16_23 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "publish(t,m,d,p,t)");
            throw throwable;
        }
    }

    public void publish(Topic topic, Message message) throws JMSException {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "publish(t,m)");
        }
        this.publish(topic, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (Trace.isOn) {
            Trace.exit(this, "publish(t,m)");
        }
    }

    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        this.closed = true;
        if (this.TopicSpec != null) {
            try {
                try {
                    this.TopicSpec = null;
                    this.mqPubQ.close();
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException(exception);
                    if (Trace.isOn) {
                        Trace.trace(this, "create and thrown " + (Object)((Object)jMSException));
                        Trace.trace(this, "Linked Exception " + exception);
                        Trace.exit(this, "close");
                    }
                    throw jMSException;
                }
                Object var4_1 = null;
                this.mqPubQ = null;
            }
            catch (Throwable throwable) {
                Object var4_2 = null;
                this.mqPubQ = null;
                throw throwable;
            }
            this.session.removePublisher(this);
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void validateParms(Topic topic, Message message, int n, int n2, long l) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "validateParms");
                }
                if (topic == null) {
                    String string = "MQJMS3006";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new InvalidDestinationException(string2, string);
                }
                if (topic instanceof MQTemporaryTopic && ((MQTemporaryTopic)topic).isDeleted()) {
                    String string = "MQJMS3019";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    throw new InvalidDestinationException(string3, string);
                }
                if (message == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "message", "null");
                    throw jMSException;
                }
                if (n != 2 && n != 1 && n != -1) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Delivery Mode", String.valueOf(n));
                    throw jMSException;
                }
                if (n2 != -1 && (n2 < 0 || n2 > 9)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Priority", String.valueOf(n2));
                    throw jMSException;
                }
                if (l != -1L && l < 0L) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "Time to Live", String.valueOf(l));
                    throw jMSException;
                }
                Object var11_15 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "validateParms");
            throw throwable;
        }
        Trace.exit(this, "validateParms");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildBaseMessage(MQTopic mQTopic, Message message, int n, int n2, long l) throws JMSException {
        try {
            block49: {
                try {
                    int n3;
                    int n4;
                    long l2;
                    JMSMessage jMSMessage;
                    block48: {
                        if (Trace.isOn) {
                            Trace.entry(this, "buildBaseMessage");
                        }
                        if (message instanceof JMSMessage) {
                            jMSMessage = (JMSMessage)message;
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "buildBaseMessage publishing alien message");
                            }
                            jMSMessage = JMSMessage._copyFromMessage(this.session, message);
                        }
                        l2 = System.currentTimeMillis();
                        this.baseMessage.clearMessageData();
                        this.baseMessage.setEncoding(mQTopic.getEncoding());
                        this.baseMessage.setCharacterSet(this.qm._getConnectionCCSID());
                        jMSMessage.setJMSDestination(mQTopic);
                        jMSMessage.setJMSTimestamp(l2);
                        this.baseMessage.setPersistenceFromMD(this.session.getPersistenceFromMD());
                        long l3 = mQTopic.getExpiry();
                        if (l3 == -2L) {
                            if (l == -1L) {
                                jMSMessage._setTimeToLive(l2, this.getTimeToLive());
                            } else {
                                jMSMessage._setTimeToLive(l2, l);
                            }
                        } else {
                            jMSMessage._setTimeToLive(l2, l3);
                        }
                        n4 = mQTopic.getPriority();
                        if (n4 == -2) {
                            if (n2 == -1) {
                                jMSMessage.setJMSPriority(this.getPriority());
                            } else {
                                jMSMessage.setJMSPriority(n2);
                            }
                        } else if (n4 == -1) {
                            jMSMessage.setJMSPriority(4);
                        } else {
                            jMSMessage.setJMSPriority(n4);
                        }
                        n3 = mQTopic.getPersistence();
                        if (n3 == -2) {
                            if (n == -1) {
                                jMSMessage.setJMSDeliveryMode(this.getDeliveryMode());
                            } else {
                                jMSMessage.setJMSDeliveryMode(n);
                            }
                        } else if (n3 == -1) {
                            jMSMessage.setJMSDeliveryMode(-2);
                        } else {
                            jMSMessage.setJMSDeliveryMode(n3);
                        }
                        String string = "";
                        string = "UNIQUE_CONNECTION_ID " + this.session.getConnectionID() + " " + "MQPSCommand Publish MQPSTopic " + mQTopic.getBaseTopicName() + " MQPSPubOpts NoReg";
                        try {
                            int n5;
                            String string2;
                            jMSMessage.setJMSDestination(mQTopic);
                            Integer n6 = (Integer)jMSMessage.getObjectProperty("JMS_IBM_Encoding");
                            if (n6 != null) {
                                this.baseMessage.setEncoding(n6);
                            }
                            if ((string2 = jMSMessage.getStringProperty("JMS_IBM_Character_Set")) == null) {
                                n5 = mQTopic.getCCSID();
                            } else {
                                n5 = MQJMSMessage.getCCSID(string2);
                                if (n5 == 0) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "JMS_IBM_Character_Set", string2);
                                    throw jMSException;
                                }
                            }
                            if (this.session.getConnectionBrokerVersion() == 1) {
                                jMSMessage.setPSCTopic(mQTopic.getBaseTopicName());
                                jMSMessage.setPSCConnID(this.session.getConnectionID());
                                this.baseMessage.write(jMSMessage, true, n5);
                                break block48;
                            }
                            switch (mQTopic.getTargetClient()) {
                                case 1: {
                                    this.baseMessage.writeRFH(string, jMSMessage, false, n5);
                                    break;
                                }
                                case 0: {
                                    this.buildBaseMessageWithCachedRFHAndRFH2(string, jMSMessage, n5);
                                    break;
                                }
                                default: {
                                    try {
                                        Logger.log(new LogMessage(2, "MQJMS1015", String.valueOf(mQTopic.getTargetClient())));
                                    }
                                    catch (LogException logException) {
                                        System.err.println("failed to log error because of " + logException);
                                    }
                                    String string3 = "MQJMS1015";
                                    String string4 = ConfigEnvironment.getErrorMessage(string3, String.valueOf(mQTopic.getTargetClient()));
                                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string3);
                                    throw invalidDestinationException;
                                }
                            }
                        }
                        catch (JMSException jMSException) {
                            throw jMSException;
                        }
                        catch (Exception exception) {
                            jMSException = ConfigEnvironment.newException("MQJMS3010");
                            jMSException.setLinkedException(exception);
                            throw jMSException;
                        }
                    }
                    if (n4 == -1) {
                        if (Trace.isOn) {
                            Trace.trace(this, "buildBaseMessage: MQMD priority set as QDEF");
                        }
                        this.baseMessage.setPriority(-1);
                    }
                    if (n3 == -1) {
                        if (Trace.isOn) {
                            Trace.trace(this, "buildBaseMessage: MQMD persistence set as QDEF");
                        }
                        this.baseMessage.setPersistence(2);
                    }
                    if (this.session.getConnectionBrokerVersion() == 1) {
                        this.baseMessage.setFormat("MQHRF2  ");
                    } else {
                        this.baseMessage.setFormat("MQHRF   ");
                    }
                    this.baseMessage.setGroupId(MQC.MQGI_NONE);
                    this.baseMessage.setMessageSequenceNumber(1);
                    this.baseMessage.setMessageFlags(this.baseMessage.getMessageFlags() & 0xFFFFFFF7);
                    if (jMSMessage == message) break block49;
                    message.setJMSDestination((Destination)mQTopic);
                    message.setJMSDeliveryMode(n);
                    message.setJMSTimestamp(l2);
                    message.setJMSExpiration(jMSMessage.getJMSExpiration());
                }
                catch (MQException mQException) {
                    JMSException jMSException = new JMSException("MQJMS1000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    throw jMSException;
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var23_24 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "buildBaseMessage");
            return;
        }
        catch (Throwable throwable) {
            Object var23_25 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "buildBaseMessage");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void buildBaseMessageWithCachedRFHAndRFH2(String string, JMSMessage jMSMessage, int n) throws JMSException {
        if (Trace.isOn()) {
            Trace.entry(this, "buildBaseMessageWithCachedRFHAndRFH2");
        }
        try {
            try {
                if (this.TopicSpec != null) {
                    if (this.cachedRFHData == null || !this.cachedBaseTopic.equals(this.TopicSpec.getBaseTopicName()) || this.cachedEncoding != this.baseMessage.getEncoding()) {
                        this.cachedRFHData = this.baseMessage.buildCacheableRFH(string, n, this.baseMessage.getEncoding());
                        this.cachedBaseTopic = this.TopicSpec.getBaseTopicName();
                        this.cachedEncoding = this.baseMessage.getEncoding();
                    }
                    this.baseMessage.appendByteArray(this.cachedRFHData);
                    this.baseMessage.write(jMSMessage, true, n);
                }
                this.baseMessage.writeRFH(string, jMSMessage, true, n);
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)iOException);
                Trace.trace(this, "buildBaseMessageWithCachedRFHAndRFH2 throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + iOException);
                throw jMSException;
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                Trace.trace(this, "buildBaseMessageWithCachedRFHAndRFH2 throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception " + (Object)((Object)mQException));
                throw jMSException;
            }
            Object var8_4 = null;
        }
        catch (Throwable throwable) {
            Object var8_5 = null;
            if (!Trace.isOn()) throw throwable;
            Trace.exit(this, "buildBaseMessageWithCachedRFHAndRFH2");
            throw throwable;
        }
        if (!Trace.isOn()) return;
        Trace.exit(this, "buildBaseMessageWithCachedRFHAndRFH2");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void checkBrokerResponse() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "checkBrokerResponse");
                }
                this.baseMessage.setCorrelationId(this.baseMessage.getMessageId());
                this.baseMessage.setMessageId(MQC.MQMI_NONE);
                this.session.getBrokerResponse(this.baseMessage);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var4_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "checkBrokerResponse");
            throw throwable;
        }
        Trace.exit(this, "checkBrokerResponse");
    }
}

