/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.BaseConfig;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.JMSParameterIsNullException;
import com.ibm.mq.jms.JMSWrappedException;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.SessionConfig;
import com.ibm.mq.jms.TopicConnectionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.Serializable;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQTopicConnectionFactory
extends MQConnectionFactory
implements TopicConnectionFactory,
Referenceable,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTopicConnectionFactory.java, jms, j521, j521-L020202 02/02/01 11:10:23 @(#) 1.50.1.1";
    static final long serialVersionUID = 4166164173764320001L;
    private static final int defaultCCSID = 819;
    private static final String defaultHostName = "localhost";
    private static final String defaultQueueManager = "";
    public static final String KEY_BROKER_CONTROL_QUEUE = "BCON";
    public static final String KEY_BROKER_PUB_QUEUE = "BPUB";
    public static final String KEY_BROKER_SUB_QUEUE = "BSUB";
    public static final String KEY_BROKER_CCSUB_QUEUE = "CCSUB";
    public static final String KEY_BROKER_QUEUE_MANAGER = "BQM";
    public static final String KEY_BROKER_VERSION = "BVER";
    public static final String KEY_MESSAGE_SELECTION = "MSEL";
    public static final String KEY_PUB_ACK_INTERVAL = "PAI";
    public static final String KEY_STATUS_REFRESH_INTERVAL = "SRI";
    public static final String KEY_SUBSCRIPTION_STORE = "SUBST";
    public static final String KEY_CLEANUP_LEVEL = "CL";
    public static final String KEY_CLEANUP_INTERVAL = "CLINT";
    public static final String KEY_CLONE_SUPPORT = "CLS";
    private String brokerControlQueue = "SYSTEM.BROKER.CONTROL.QUEUE";
    private String brokerPubQueue = "SYSTEM.BROKER.DEFAULT.STREAM";
    private String brokerQueueManager = "";
    private int brokerVersion = 0;
    private boolean bverSet = false;
    private int messageSelection = 0;
    private String brokerSubQueue = "SYSTEM.JMS.ND.SUBSCRIBER.QUEUE";
    private String brokerCCSubQueue = "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE";
    private int pubAckInterval = 25;
    private int statusRefreshInterval = 60000;
    private int subscriptionStore = 2;
    private int cleanupLevel = 1;
    private long cleanupInterval = 3600000L;
    private int cloneSupport = 0;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopicConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory;

    public TopicConnection createTopicConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopicConnection");
        }
        TopicConnection topicConnection = null;
        int n = this.getTransportType();
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                topicConnection = this.createMQTopicConnection();
                break;
            }
            case 2: {
                topicConnection = this.createDirectTopicConnection();
                break;
            }
            default: {
                topicConnection = this.createMQTopicConnection();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "createTopicConnection");
        }
        return topicConnection;
    }

    public TopicConnection createTopicConnection(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createTopicConnection");
        }
        TopicConnection topicConnection = null;
        int n = this.getTransportType();
        switch (n) {
            case 0: 
            case 1: 
            case 3: {
                topicConnection = this.createMQTopicConnection(string, string2);
                break;
            }
            case 2: {
                topicConnection = this.createDirectTopicConnection(string, string2);
                break;
            }
            default: {
                topicConnection = this.createMQTopicConnection(string, string2);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "createTopicConnection");
        }
        return topicConnection;
    }

    private TopicConnection createMQTopicConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createMQTopicConnection");
        }
        if (this.brokerVersion != 1 && this.messageSelection == 1) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3036");
            if (Trace.isOn) {
                Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "createMQTopicConnection");
            }
            throw jMSException;
        }
        MQTopicConnection mQTopicConnection = new MQTopicConnection(this);
        if (Trace.isOn) {
            Trace.exit(this, "createMQTopicConnection");
        }
        return mQTopicConnection;
    }

    private TopicConnection createMQTopicConnection(String string, String string2) throws JMSException {
        int n;
        if (Trace.isOn) {
            Trace.entry(this, "createMQTopicConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password non-null");
            }
        }
        if ((n = this.getTransportType()) == 0) {
            String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty("user.name");
                }
            });
            if (!string3.equals(string)) {
                String string4 = "MQJMS2013";
                String string5 = ConfigEnvironment.getErrorMessage(string4);
                JMSSecurityException jMSSecurityException = new JMSSecurityException(string5, string4);
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + jMSSecurityException);
                    Trace.exit(this, "createMQTopicConnection");
                }
                throw jMSSecurityException;
            }
            MQTopicConnection mQTopicConnection = new MQTopicConnection(this);
            if (Trace.isOn) {
                Trace.exit(this, "createMQTopicConnection");
            }
            return mQTopicConnection;
        }
        if (this.brokerVersion != 1 && this.messageSelection == 1) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3036");
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.exit(this, "createMQTopicConnection");
            }
            throw jMSException;
        }
        MQTopicConnection mQTopicConnection = new MQTopicConnection(this, string, string2);
        if (Trace.isOn) {
            Trace.exit(this, "createMQTopicConnection");
        }
        return mQTopicConnection;
    }

    private TopicConnection createDirectTopicConnection() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createDirectTopicConnection");
        }
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("user.name");
                }
                catch (AccessControlException accessControlException) {
                    return "anonymous";
                }
            }
        });
        TopicConnection topicConnection = this.createDirectTopicConnection(string, null);
        if (Trace.isOn) {
            Trace.exit(this, "createDirectTopicConnection");
        }
        return topicConnection;
    }

    private TopicConnection createDirectTopicConnection(String string, String string2) throws JMSException {
        TopicConnectionImpl topicConnectionImpl;
        if (Trace.isOn) {
            Trace.entry(this, "createDirectTopicConnection");
            Trace.trace(this, "userName=" + string);
            if (string2 != null) {
                Trace.trace(this, "password non-null");
            }
        }
        if (string == null || string.equals(defaultQueueManager)) {
            String string3 = ConfigEnvironment.getErrorMessage("MQJMS4124", "userName");
            throw new JMSParameterIsNullException(string3);
        }
        SessionConfig.initialize();
        BaseConfig.noMoreChanges = true;
        try {
            String string4 = "tcp";
            String string5 = this.getHostName();
            int n = this.getPort();
            topicConnectionImpl = new TopicConnectionImpl(string4, string5, n, string, string2);
            String string6 = this.getClientId();
            if (string6 != null && !string6.equals(defaultQueueManager)) {
                topicConnectionImpl.setClientID(string6);
            }
        }
        catch (IOException iOException) {
            throw new JMSWrappedException(ExceptionBuilder.buildReasonString(1115, new Object[]{iOException}), iOException);
        }
        if (Trace.isOn) {
            Trace.exit(this, "createDirectTopicConnection");
        }
        return topicConnectionImpl;
    }

    public void setBrokerControlQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerControlQueue", string2);
            throw jMSException;
        }
        this.brokerControlQueue = string;
    }

    public String getBrokerControlQueue() {
        return this.brokerControlQueue;
    }

    public void setBrokerQueueManager(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerQueueManager", string2);
            throw jMSException;
        }
        this.brokerQueueManager = string;
    }

    public String getBrokerQueueManager() {
        return this.brokerQueueManager;
    }

    public void setBrokerPubQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerPubQueue", string2);
            throw jMSException;
        }
        this.brokerPubQueue = string;
    }

    public String getBrokerPubQueue() {
        return this.brokerPubQueue;
    }

    public String getBrokerSubQueue() {
        return this.brokerSubQueue;
    }

    public void setBrokerSubQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerSubQueue", string2);
            throw jMSException;
        }
        this.brokerSubQueue = string;
    }

    public String getBrokerCCSubQueue() {
        return this.brokerCCSubQueue;
    }

    public void setBrokerCCSubQueue(String string) throws JMSException {
        if (string == null || string.length() > 48) {
            String string2 = string;
            if (string2 == null) {
                string2 = "<null>";
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerCCSubQueue", string2);
            throw jMSException;
        }
        this.brokerCCSubQueue = string;
    }

    public int getBrokerVersion() {
        return this.brokerVersion;
    }

    public void setBrokerVersion(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.brokerVersion = n;
                this.bverSet = true;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerVersion", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public void setBrokerVersionDefault(int n) {
        if (!this.bverSet) {
            this.brokerVersion = n;
        }
    }

    public int getMessageSelection() {
        return this.messageSelection;
    }

    public void setMessageSelection(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.messageSelection = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "messageSelection", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getPubAckInterval() {
        return this.pubAckInterval;
    }

    public void setPubAckInterval(int n) {
        this.pubAckInterval = n;
    }

    public int getStatusRefreshInterval() {
        return this.statusRefreshInterval;
    }

    public void setStatusRefreshInterval(int n) {
        this.statusRefreshInterval = n;
    }

    public void setSubscriptionStore(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: 
            case 2: {
                this.subscriptionStore = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "subscriptionStore", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getSubscriptionStore() {
        return this.subscriptionStore;
    }

    public void setCleanupLevel(int n) throws JMSException {
        switch (n) {
            case -1: 
            case 0: 
            case 1: 
            case 2: {
                this.cleanupLevel = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupLevel", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getCleanupLevel() {
        return this.cleanupLevel;
    }

    public void setCleanupInterval(long l) throws JMSException {
        if (l < 0L) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupInterval", String.valueOf(l));
            throw jMSException;
        }
        this.cleanupInterval = l;
    }

    public long getCleanupInterval() {
        return this.cleanupInterval;
    }

    public void setCloneSupport(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.cloneSupport = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cloneSupport", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public int getCloneSupport() {
        return this.cloneSupport;
    }

    public Reference getReference() throws NamingException {
        Reference reference = new Reference((class$com$ibm$mq$jms$MQTopicConnectionFactory == null ? (class$com$ibm$mq$jms$MQTopicConnectionFactory = MQTopicConnectionFactory.class$("com.ibm.mq.jms.MQTopicConnectionFactory")) : class$com$ibm$mq$jms$MQTopicConnectionFactory).getName(), (class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory = MQTopicConnectionFactory.class$("com.ibm.mq.jms.MQTopicConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQTopicConnectionFactoryFactory).getName(), null);
        this.populateReference(reference);
        return reference;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "equals");
        }
        if (object == null) {
            bl = false;
        } else if (this == object) {
            bl = true;
        } else if (object instanceof MQTopicConnectionFactory) {
            MQTopicConnectionFactory mQTopicConnectionFactory = (MQTopicConnectionFactory)object;
            bl = super.equals(object) && MQConnectionFactory.twoStringsEqual(this.brokerControlQueue, mQTopicConnectionFactory.brokerControlQueue) && MQConnectionFactory.twoStringsEqual(this.brokerPubQueue, mQTopicConnectionFactory.brokerPubQueue) && MQConnectionFactory.twoStringsEqual(this.brokerQueueManager, mQTopicConnectionFactory.brokerQueueManager) && MQConnectionFactory.twoStringsEqual(this.brokerSubQueue, mQTopicConnectionFactory.brokerSubQueue) && MQConnectionFactory.twoStringsEqual(this.brokerCCSubQueue, mQTopicConnectionFactory.brokerCCSubQueue) && this.pubAckInterval == mQTopicConnectionFactory.pubAckInterval && this.statusRefreshInterval == mQTopicConnectionFactory.statusRefreshInterval && this.messageSelection == mQTopicConnectionFactory.messageSelection && this.brokerVersion == mQTopicConnectionFactory.brokerVersion && this.subscriptionStore == mQTopicConnectionFactory.subscriptionStore && this.cleanupLevel == mQTopicConnectionFactory.cleanupLevel && this.cleanupInterval == mQTopicConnectionFactory.cleanupInterval;
        } else {
            bl = false;
        }
        if (Trace.isOn) {
            Trace.trace(this, "equals - result is " + bl);
            Trace.exit(this, "equals");
        }
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode() ^ this.brokerVersion;
        if (this.brokerControlQueue != null) {
            n ^= this.brokerControlQueue.hashCode();
        }
        if (this.brokerPubQueue != null) {
            n ^= this.brokerPubQueue.hashCode();
        }
        if (this.brokerQueueManager != null) {
            n ^= this.brokerQueueManager.hashCode();
        }
        if (this.brokerSubQueue != null) {
            n ^= this.brokerSubQueue.hashCode();
        }
        if (this.brokerCCSubQueue != null) {
            n ^= this.brokerCCSubQueue.hashCode();
        }
        n ^= this.messageSelection;
        n ^= this.pubAckInterval << 3;
        n ^= this.statusRefreshInterval;
        n ^= this.subscriptionStore;
        n ^= this.cleanupLevel;
        n ^= (int)this.cleanupInterval;
        return n ^= this.cloneSupport;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void populateReference(Reference reference) {
        String string = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "populateReference");
            }
            super.updateReference(reference);
            string = this.getBrokerControlQueue();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_BROKER_CONTROL_QUEUE, string));
            }
            if ((string = this.getBrokerPubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_PUB_QUEUE, string));
            }
            if ((string = this.getBrokerSubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_SUB_QUEUE, string));
            }
            if ((string = this.getBrokerCCSubQueue()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_CCSUB_QUEUE, string));
            }
            if ((string = this.getBrokerQueueManager()) != null) {
                reference.add(new StringRefAddr(KEY_BROKER_QUEUE_MANAGER, string));
            }
            reference.add(new StringRefAddr(KEY_BROKER_VERSION, String.valueOf(this.getBrokerVersion())));
            reference.add(new StringRefAddr(KEY_MESSAGE_SELECTION, String.valueOf(this.getMessageSelection())));
            reference.add(new StringRefAddr(KEY_PUB_ACK_INTERVAL, String.valueOf(this.getPubAckInterval())));
            reference.add(new StringRefAddr(KEY_STATUS_REFRESH_INTERVAL, String.valueOf(this.getStatusRefreshInterval())));
            reference.add(new StringRefAddr(KEY_SUBSCRIPTION_STORE, String.valueOf(this.getSubscriptionStore())));
            reference.add(new StringRefAddr(KEY_CLEANUP_LEVEL, String.valueOf(this.getCleanupLevel())));
            reference.add(new StringRefAddr(KEY_CLEANUP_INTERVAL, String.valueOf(this.getCleanupInterval())));
            reference.add(new StringRefAddr(KEY_CLONE_SUPPORT, String.valueOf(this.getCloneSupport())));
            Object var4_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "populateReference");
            throw throwable;
        }
        Trace.exit(this, "populateReference");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setFromReference(Reference reference) throws JMSException {
        try {
            block18: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "setFromReference");
                    }
                    super.setFromReference(reference);
                    RefAddr refAddr = reference.get(KEY_BROKER_CONTROL_QUEUE);
                    if (refAddr != null) {
                        this.setBrokerControlQueue((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_BROKER_PUB_QUEUE)) != null) {
                        this.setBrokerPubQueue((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_BROKER_SUB_QUEUE)) != null) {
                        this.setBrokerSubQueue((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_BROKER_CCSUB_QUEUE)) != null) {
                        this.setBrokerCCSubQueue((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_BROKER_QUEUE_MANAGER)) != null) {
                        String string = (String)refAddr.getContent();
                        if (string == null) {
                            string = defaultQueueManager;
                        }
                        this.setBrokerQueueManager(string);
                    }
                    if ((refAddr = reference.get(KEY_BROKER_VERSION)) != null) {
                        this.setBrokerVersion(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_MESSAGE_SELECTION)) != null) {
                        this.setMessageSelection(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_PUB_ACK_INTERVAL)) != null) {
                        this.setPubAckInterval(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_STATUS_REFRESH_INTERVAL)) != null) {
                        this.setStatusRefreshInterval(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_SUBSCRIPTION_STORE)) != null) {
                        this.setSubscriptionStore(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_CLEANUP_LEVEL)) != null) {
                        this.setCleanupLevel(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_CLEANUP_INTERVAL)) != null) {
                        this.setCleanupInterval(Long.parseLong((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_CLONE_SUPPORT)) == null) break block18;
                    this.setCloneSupport(Integer.parseInt((String)refAddr.getContent()));
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception " + exception);
                    throw jMSException;
                }
            }
            Object var6_5 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "setFromReference");
            return;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setFromReference");
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        try {
            Class.forName("com.ibm.mq.jms.services.ConfigEnvironment");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ERROR: couldn't load ConfigEnvironment class");
        }
    }
}

