/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQRRSQueueManager;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionConsumer;
import com.ibm.mq.jms.MQMigrateSubscriptionEngine;
import com.ibm.mq.jms.MQQueueSubscriptionEngine;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.lang.reflect.Constructor;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.ServerSessionPool;
import javax.jms.Topic;
import javax.jms.TopicConnection;
import javax.jms.TopicSession;

public class MQTopicConnection
extends MQConnection
implements TopicConnection {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTopicConnection.java, jms, j521, j521-L020621 02/06/20 13:50:54 @(#) 1.63.1.8";
    private String connectionID = null;
    private int tempTopicCount = 0;
    private final int tmpQOpenOptions = 32;
    private String brkControlQueue;
    private String brkQueueManager;
    private String brkPubQueue;
    private String brkSubQueue;
    private String brkCCSubQueue;
    private int brkVersion;
    private int brkOptLevel = 1;
    private int pubAckInterval;
    private int statusRefreshInterval;
    private MQSubscriptionEngine subscriptionEngine;
    private MQTopicSession ccBrokerSession = null;
    private Object ccBrokerSessionLock = new Object();

    MQTopicConnection(MQTopicConnectionFactory mQTopicConnectionFactory) throws JMSException {
        this(mQTopicConnectionFactory, null, null);
    }

    MQTopicConnection(MQTopicConnectionFactory mQTopicConnectionFactory, String string, String string2) throws JMSException {
        super(mQTopicConnectionFactory);
        MQQueueManager mQQueueManager;
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.qmgrName = mQTopicConnectionFactory.getQueueManager();
        this.brkControlQueue = mQTopicConnectionFactory.getBrokerControlQueue();
        this.brkQueueManager = mQTopicConnectionFactory.getBrokerQueueManager();
        this.brkPubQueue = mQTopicConnectionFactory.getBrokerPubQueue();
        this.brkSubQueue = mQTopicConnectionFactory.getBrokerSubQueue();
        this.brkCCSubQueue = mQTopicConnectionFactory.getBrokerCCSubQueue();
        this.brkVersion = mQTopicConnectionFactory.getBrokerVersion();
        this.pubAckInterval = mQTopicConnectionFactory.getPubAckInterval();
        this.statusRefreshInterval = mQTopicConnectionFactory.getStatusRefreshInterval();
        String string3 = mQTopicConnectionFactory.getClientId();
        if (string3 != null) {
            this.setClientID(string3);
        }
        switch (mQTopicConnectionFactory.getTransportType()) {
            case 0: {
                this.mqProperties.put("transport", "MQSeries Bindings");
                break;
            }
            case 3: {
                this.mqProperties.put("transport", "MQJD");
                break;
            }
            case 1: {
                this.mqProperties.put("transport", "MQSeries");
                this.mqProperties.put("CCSID", new Integer(mQTopicConnectionFactory.getCCSID()));
                this.mqProperties.put("channel", mQTopicConnectionFactory.getChannel());
                this.mqProperties.put("hostname", mQTopicConnectionFactory.getHostName());
                this.mqProperties.put("port", new Integer(mQTopicConnectionFactory.getPort()));
                if (string != null) {
                    this.mqProperties.put("userID", string);
                }
                if (string2 != null) {
                    this.mqProperties.put("password", string2);
                }
                String string4 = "<unset>";
                try {
                    String string5;
                    string4 = mQTopicConnectionFactory.getReceiveExit();
                    if (string4 != null) {
                        string5 = mQTopicConnectionFactory.getReceiveExitInit();
                        mQQueueManager = (MQReceiveExit)this.newExitInstance(string4, string5);
                        this.mqProperties.put("receiveExit", mQQueueManager);
                    }
                    if ((string4 = mQTopicConnectionFactory.getSecurityExit()) != null) {
                        string5 = mQTopicConnectionFactory.getSecurityExitInit();
                        mQQueueManager = (MQSecurityExit)this.newExitInstance(string4, string5);
                        this.mqProperties.put("securityExit", mQQueueManager);
                    }
                    if ((string4 = mQTopicConnectionFactory.getSendExit()) == null) break;
                    string5 = mQTopicConnectionFactory.getSendExitInit();
                    mQQueueManager = (MQSendExit)this.newExitInstance(string4, string5);
                    this.mqProperties.put("sendExit", mQQueueManager);
                    break;
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string4);
                    jMSException.setLinkedException(exception);
                    if (Trace.isOn) {
                        Trace.exception(this, "constructor", (Throwable)jMSException);
                        Trace.exit(this, "constructor");
                    }
                    throw jMSException;
                }
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(mQTopicConnectionFactory.getTransportType()));
                if (Trace.isOn) {
                    Trace.exception(this, "constructor", (Throwable)jMSException);
                    Trace.exit(this, "constructor");
                }
                throw jMSException;
            }
        }
        mQQueueManager = this.createQMNonXA();
        this.connectionID = this.createUniqueID(mQQueueManager);
        String string6 = mQQueueManager.name == null || mQQueueManager.name.trim().equals("") ? Utils.inquireString((MQManagedObject)mQQueueManager, 2015) : mQQueueManager.name;
        string6 = string6 == null ? "" : string6.trim();
        switch (mQTopicConnectionFactory.getSubscriptionStore()) {
            case 0: {
                if (mQTopicConnectionFactory.getCloneSupport() == 1) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                    throw jMSException;
                }
                this.subscriptionEngine = new MQQueueSubscriptionEngine(this, mQQueueManager);
                break;
            }
            case 1: {
                try {
                    mQQueueManager.disconnect();
                    mQQueueManager = null;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
                this.subscriptionEngine = new MQBrokerSubscriptionEngine(this, mQTopicConnectionFactory, string6);
                break;
            }
            case 2: {
                this.subscriptionEngine = new MQMigrateSubscriptionEngine(this, mQTopicConnectionFactory, mQQueueManager, string6);
                break;
            }
            default: {
                JMSException jMSException = new JMSException(ConfigEnvironment.getMessage("MQJMS1016"));
                throw jMSException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public synchronized TopicSession createTopicSession(boolean bl, int n) throws JMSException {
        return this.createTopicSession(bl, n, 0);
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "close");
                }
                super.close();
                this.subscriptionEngine.close();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "close", (Throwable)jMSException);
                throw jMSException;
            }
            Object var3_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized TopicSession createTopicSession(boolean bl, int n, int n2) throws JMSException {
        MQQueueManager mQQueueManager = null;
        MQTopicSession mQTopicSession = null;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createTopicSession");
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "distributed transactional mode " + n2);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Bad distributed transactional mode " + n2);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
                if (this.isClosed()) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                this.setClientIDFixed();
                switch (n2) {
                    case 0: {
                        mQQueueManager = this.createQMNonXA();
                        break;
                    }
                    case 1: {
                        mQQueueManager = this.createQMXA();
                        break;
                    }
                    case 2: {
                        mQQueueManager = this.createQMNonXA();
                        MQRRSQueueManager mQRRSQueueManager = new MQRRSQueueManager(mQQueueManager);
                        try {
                            mQRRSQueueManager.honourRRS();
                            break;
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            try {
                                mQQueueManager.disconnect();
                            }
                            catch (MQException mQException2) {
                                // empty catch block
                            }
                            mQQueueManager = null;
                            throw jMSException;
                        }
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Distibuted transactional mode unexpectedly changed! Now " + n2);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
                mQTopicSession = new MQTopicSession(this, mQQueueManager, bl, n);
                mQTopicSession.setDistTransactionMode(n2);
                this.addSession(mQTopicSession);
                if (this.isStarted()) {
                    try {
                        mQTopicSession.start();
                    }
                    catch (JMSException jMSException) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1033", jMSException.toString()));
                        }
                        catch (LogException logException) {
                            System.err.println(ConfigEnvironment.getMessage("MQJMS1038") + logException);
                        }
                    }
                }
                Object var12_18 = null;
                if (!Trace.isOn) return mQTopicSession;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTopicSession");
            throw throwable;
        }
        Trace.exit(this, "createTopicSession");
        return mQTopicSession;
    }

    String getBrkControlQueue() {
        return this.brkControlQueue;
    }

    String getBrkQueueManager() {
        return this.brkQueueManager;
    }

    String getBrkPubQueue() {
        return this.brkPubQueue;
    }

    String getBrkSubQueue() {
        return this.brkSubQueue;
    }

    String getBrkCCSubQueue() {
        return this.brkCCSubQueue;
    }

    int getBrkVersion() {
        return this.brkVersion;
    }

    int getAndIncrementTempTopicCount() {
        return ++this.tempTopicCount;
    }

    int getPubAckInterval() {
        return this.pubAckInterval;
    }

    int getBrkOptLevel() {
        return this.brkOptLevel;
    }

    void setBrkOptLevel(int n) {
        this.brkOptLevel = n;
    }

    int getStatusRefreshInterval() {
        return this.statusRefreshInterval;
    }

    MQSubscriptionEngine getSubscriptionEngine() {
        return this.subscriptionEngine;
    }

    private Object newExitInstance(String string, String string2) throws JMSException {
        Object t;
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "newExitInstance");
            object = string2 != null ? string2 : "<null>";
            Trace.trace(this, "classname = " + string + ", initString = " + (String)object);
        }
        try {
            Constructor constructor;
            Object[] objectArray;
            object = Class.forName(string);
            Class<?> clazz = Class.forName("java.lang.String");
            try {
                objectArray = new Class[]{clazz};
                constructor = ((Class)object).getConstructor((Class<?>[])objectArray);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1009");
                jMSException.setLinkedException((Exception)noSuchMethodException);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + noSuchMethodException);
                    Trace.exit(this, "newExitInstance");
                }
                throw jMSException;
            }
            objectArray = new Object[]{string2};
            t = constructor.newInstance(objectArray);
        }
        catch (JMSException jMSException) {
            throw jMSException;
        }
        catch (Exception exception) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
            jMSException.setLinkedException(exception);
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "Linked Exception " + exception);
                Trace.exit(this, "newExitInstance");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "newExitInstance");
        }
        return t;
    }

    String getConnectionID() {
        return this.connectionID;
    }

    private String createUniqueID(MQQueueManager mQQueueManager) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createUniqueID");
        }
        String string = null;
        try {
            MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 18);
            MQMessage mQMessage = new MQMessage();
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            mQPutMessageOptions.options |= 2;
            mQPutMessageOptions.options &= 0xFFFFFFFB;
            mQQueue.put(mQMessage, mQPutMessageOptions);
            try {
                mQQueueManager.backout();
            }
            catch (MQException mQException) {
                try {
                    Logger.log(new LogMessage(2, "MQJMS1016", "failed to backout conID message from queue: " + (Object)((Object)mQException)));
                }
                catch (LogException logException) {
                    System.err.println(ConfigEnvironment.getMessage("MQJMS1038") + logException);
                }
            }
            mQQueue.close();
            string = Utils.bytesToHex(mQMessage.messageId);
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS5062", mQException.toString());
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                Trace.exit(this, "createUniqueID");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "createUniqueID");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionConsumer createConnectionConsumer(Topic topic, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        ConnectionConsumer connectionConsumer;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createConnectionConsumer");
                }
                if (!(topic instanceof MQTopic)) {
                    String string2 = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                    throw invalidDestinationException;
                }
                if (topic instanceof MQTemporaryTopic && ((MQTemporaryTopic)topic).isDeleted()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3019");
                    throw jMSException;
                }
                connectionConsumer = this.createCC((MQTopic)topic, string, serverSessionPool, n, null);
                Object var9_11 = null;
                if (!Trace.isOn) return connectionConsumer;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing: " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createConnectionConsumer");
            throw throwable;
        }
        Trace.exit(this, "createConnectionConsumer");
        return connectionConsumer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionConsumer createDurableConnectionConsumer(Topic topic, String string, String string2, ServerSessionPool serverSessionPool, int n) throws JMSException {
        ConnectionConsumer connectionConsumer;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createDurableConnectionConsumer");
                }
                if (!(topic instanceof MQTopic)) {
                    String string3 = "MQJMS0003";
                    String string4 = ConfigEnvironment.getErrorMessage(string3);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string3);
                    throw invalidDestinationException;
                }
                if (topic instanceof MQTemporaryTopic) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS0003");
                    throw jMSException;
                }
                if (this.getClientID() == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3024");
                    throw jMSException;
                }
                if (string == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3039");
                    throw jMSException;
                }
                connectionConsumer = this.createCC((MQTopic)topic, string2, serverSessionPool, n, string);
                Object var10_14 = null;
                if (!Trace.isOn) return connectionConsumer;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing: " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createDurableConnectionConsumer");
            throw throwable;
        }
        Trace.exit(this, "createDurableConnectionConsumer");
        return connectionConsumer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ConnectionConsumer createCC(MQTopic mQTopic, String string, ServerSessionPool serverSessionPool, int n, String string2) throws JMSException {
        MQConnectionConsumer mQConnectionConsumer;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createCC");
                }
                MQConnectionConsumer mQConnectionConsumer2 = new MQConnectionConsumer(this, mQTopic, string, serverSessionPool, n, string2);
                this.addConsumer(mQConnectionConsumer2);
                mQConnectionConsumer = mQConnectionConsumer2;
                Object var9_9 = null;
                if (!Trace.isOn) return mQConnectionConsumer;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createCC");
            throw throwable;
        }
        Trace.exit(this, "createCC");
        return mQConnectionConsumer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    byte[] getStatusMgrId() throws JMSException {
        byte[] byArray;
        if (Trace.isOn) {
            Trace.entry(this, "getStatusMgrId");
        }
        try {
            if (!(this.subscriptionEngine instanceof MQQueueSubscriptionEngine)) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3048");
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Creating and Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            byArray = ((MQQueueSubscriptionEngine)this.subscriptionEngine).getStatusMgrId();
            Object var3_3 = null;
            if (!Trace.isOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getStatusMgrId");
            throw throwable;
        }
        Trace.exit(this, "getStatusMgrId");
        return byArray;
    }

    MQTopicSession getCCBrokerSession() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getCCBrokerSession");
        }
        if (this.ccBrokerSession == null) {
            Object object = this.ccBrokerSessionLock;
            synchronized (object) {
                if (this.ccBrokerSession == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Creating ccBrokerSession");
                    }
                    this.ccBrokerSession = (MQTopicSession)this.createTopicSession(false, 1);
                }
            }
        }
        return this.ccBrokerSession;
    }
}

