/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Topic;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQTopic
extends MQDestination
implements Topic,
Referenceable,
Serializable,
com.ibm.disthubmq.client.Topic {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTopic.java, jms, j521, j521-L020313 02/03/12 15:39:08 @(#) 1.35.1.4";
    private String baseTopicName;
    private String cachedTopicName;
    private String cachedNameValues;
    private String cachedBaseTopicName;
    private String brokerDurSubQueue;
    private String brokerCCDurSubQueue;
    private int brokerVersion;
    private String cachedTopicNVs;
    private String cachedbrokerDurSubQueue;
    private String cachedbrokerCCDurSubQueue;
    private int cachedbrokerVersion;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopic;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQTopicFactory;

    public MQTopic() {
        this.baseTopicName = null;
        this.cachedTopicName = null;
        this.brokerDurSubQueue = "SYSTEM.JMS.D.SUBSCRIBER.QUEUE";
        this.brokerCCDurSubQueue = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
        this.brokerVersion = 0;
        this.cachedTopicNVs = null;
        this.cachedbrokerDurSubQueue = "SYSTEM.JMS.D.SUBSCRIBER.QUEUE";
        this.cachedbrokerCCDurSubQueue = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
        this.cachedbrokerVersion = 0;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQTopic(String string) throws JMSException {
        block9: {
            block8: {
                this.baseTopicName = null;
                this.cachedTopicName = null;
                this.brokerDurSubQueue = "SYSTEM.JMS.D.SUBSCRIBER.QUEUE";
                this.brokerCCDurSubQueue = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
                this.brokerVersion = 0;
                this.cachedTopicNVs = null;
                this.cachedbrokerDurSubQueue = "SYSTEM.JMS.D.SUBSCRIBER.QUEUE";
                this.cachedbrokerCCDurSubQueue = "SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE";
                this.cachedbrokerVersion = 0;
                String string2 = "MQJMS0003";
                try {
                    String string3;
                    if (Trace.isOn) {
                        Trace.entry(this, "constructor(topicName)");
                    }
                    if (string == null || string.trim().equals("") || string.length() > 0 && string.startsWith("/u0001")) {
                        String string4 = ConfigEnvironment.getErrorMessage(string2);
                        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string2);
                        throw invalidDestinationException;
                    }
                    if (string.startsWith("topic://")) {
                        string3 = string.length() > 8 ? string.substring(8) : "";
                    } else {
                        this.setBaseTopicName(string);
                        Object var8_8 = null;
                        if (!Trace.isOn) return;
                        break block8;
                    }
                    int n = string3.indexOf(63);
                    if (n != -1) {
                        this.setBaseTopicName(string3.substring(0, n));
                        String string5 = string3.substring(n + 1);
                        Properties properties2 = this.getPropertiesFromURI(string5);
                        this.setFromProperties(properties2);
                        break block9;
                    } else {
                        this.setBaseTopicName(string3);
                    }
                    break block9;
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "constructor(topicName)");
                    throw throwable;
                }
            }
            Trace.exit(this, "constructor(topicName)");
            return;
        }
        Object var8_9 = null;
        if (!Trace.isOn) return;
        Trace.exit(this, "constructor(topicName)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTopicName() {
        CharSequence charSequence;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTopicName");
            }
            String string = this.getNVs();
            if (this.cachedTopicName == null || string != this.cachedNameValues || this.baseTopicName != this.cachedBaseTopicName) {
                charSequence = new StringBuffer("topic://");
                if (this.baseTopicName != null) {
                    ((StringBuffer)charSequence).append(this.baseTopicName);
                }
                ((StringBuffer)charSequence).append(string);
                this.cachedTopicName = ((StringBuffer)charSequence).toString();
                this.cachedNameValues = string;
                this.cachedBaseTopicName = this.baseTopicName;
            }
            charSequence = this.cachedTopicName;
            Object var4_3 = null;
            if (!Trace.isOn) return charSequence;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getTopicName");
            throw throwable;
        }
        Trace.exit(this, "getTopicName");
        return charSequence;
    }

    public String getBrokerDurSubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerDurSubQueue");
            Trace.trace(this, "Returning: " + this.brokerDurSubQueue);
            Trace.exit(this, "getBrokerDurSubQueue");
        }
        return this.brokerDurSubQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBrokerDurSubQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBrokerDurSubQueue");
                Trace.trace(this, "Param: " + string);
            }
            if (string == null || string.length() > 48) {
                String string2 = string == null ? "<null>" : string;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerDurSubQueue", string2);
                throw jMSException;
            }
            this.brokerDurSubQueue = string;
            Object var5_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setBrokerDurSubQueue");
            throw throwable;
        }
        Trace.exit(this, "setBrokerDurSubQueue");
    }

    public String getBrokerCCDurSubQueue() {
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerCCDurSubQueue");
            Trace.trace(this, "Returning: " + this.brokerCCDurSubQueue);
            Trace.exit(this, "getBrokerCCDurSubQueue");
        }
        return this.brokerCCDurSubQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBrokerCCDurSubQueue(String string) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setBrokerCCDurSubQueue");
                Trace.trace(this, "Param: " + string);
            }
            if (string == null || string.length() > 48) {
                String string2 = string == null ? "<null>" : string;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerCCDurSubQueue", string2);
                throw jMSException;
            }
            this.brokerCCDurSubQueue = string;
            Object var5_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setBrokerCCDurSubQueue");
            throw throwable;
        }
        Trace.exit(this, "setBrokerCCDurSubQueue");
    }

    public int getBrokerVersion() {
        return this.brokerVersion;
    }

    public void setBrokerVersion(int n) throws JMSException {
        switch (n) {
            case 0: 
            case 1: {
                this.brokerVersion = n;
                break;
            }
            default: {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "brokerVersion", String.valueOf(n));
                throw jMSException;
            }
        }
    }

    public String toString() {
        return this.getTopicName();
    }

    public Reference getReference() throws NamingException {
        String string = null;
        Reference reference = new Reference((class$com$ibm$mq$jms$MQTopic == null ? (class$com$ibm$mq$jms$MQTopic = MQTopic.class$("com.ibm.mq.jms.MQTopic")) : class$com$ibm$mq$jms$MQTopic).getName(), (class$com$ibm$mq$jms$MQTopicFactory == null ? (class$com$ibm$mq$jms$MQTopicFactory = MQTopic.class$("com.ibm.mq.jms.MQTopicFactory")) : class$com$ibm$mq$jms$MQTopicFactory).getName(), null);
        reference.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
        string = this.getDescription();
        if (string != null) {
            reference.add(new StringRefAddr("DESC", string));
        }
        reference.add(new StringRefAddr("EXP", String.valueOf(this.getExpiry())));
        reference.add(new StringRefAddr("PRI", String.valueOf(this.getPriority())));
        reference.add(new StringRefAddr("PER", String.valueOf(this.getPersistence())));
        reference.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
        reference.add(new StringRefAddr("TC", String.valueOf(this.getTargetClient())));
        reference.add(new StringRefAddr("ENC", String.valueOf(this.getEncoding())));
        string = this.getBaseTopicName();
        if (string != null) {
            reference.add(new StringRefAddr("TOP", string));
        }
        if ((string = this.getBrokerDurSubQueue()) != null) {
            reference.add(new StringRefAddr("BDSUB", string));
        }
        if ((string = this.getBrokerCCDurSubQueue()) != null) {
            reference.add(new StringRefAddr("CCDSUB", string));
        }
        reference.add(new StringRefAddr("BVER", String.valueOf(this.getBrokerVersion())));
        return reference;
    }

    public void setBaseTopicName(String string) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setBaseTopicName");
                }
                if (string == null) {
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "<null>";
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "baseTopicName", string2);
                    throw jMSException;
                }
                this.baseTopicName = string;
            }
            catch (JMSException jMSException) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            Trace.exit(this, "setBaseTopicName");
            throw throwable;
        }
        Trace.exit(this, "setBaseTopicName");
    }

    public String getBaseTopicName() {
        String string;
        try {
            Trace.entry(this, "getBaseTopicName");
            string = this.baseTopicName;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.exit(this, "getBaseTopicName");
            throw throwable;
        }
        Trace.exit(this, "getBaseTopicName");
        return string;
    }

    public boolean equals(Object object) {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "equals");
        }
        if (object == null) {
            bl = false;
        } else if (object instanceof MQTopic) {
            MQTopic mQTopic = (MQTopic)object;
            bl = super.equals(object) && this.twoStringsEqual(this.baseTopicName, mQTopic.baseTopicName);
        } else {
            bl = false;
        }
        if (Trace.isOn) {
            Trace.trace(this, "equals - result is " + bl);
            Trace.exit(this, "equals");
        }
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.baseTopicName != null) {
            n ^= this.baseTopicName.hashCode();
        }
        return n;
    }

    String getNVs() {
        StringBuffer stringBuffer;
        boolean bl = false;
        String string = super.getNVs();
        if (string.equals("")) {
            bl = true;
        }
        if (this.cachedTopicNVs == null || this.brokerDurSubQueue != this.cachedbrokerDurSubQueue || this.brokerCCDurSubQueue != this.cachedbrokerCCDurSubQueue || this.brokerVersion != this.cachedbrokerVersion) {
            stringBuffer = new StringBuffer();
            if (!this.brokerDurSubQueue.equals("SYSTEM.JMS.D.SUBSCRIBER.QUEUE")) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("brokerDurSubQueue=" + this.brokerDurSubQueue);
            }
            if (!this.brokerCCDurSubQueue.equals("SYSTEM.JMS.D.CC.SUBSCRIBER.QUEUE")) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("brokerCCDurSubQueue=" + this.brokerCCDurSubQueue);
            }
            if (this.brokerVersion != 0) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("brokerVersion=" + this.brokerVersion);
            }
            this.cachedTopicNVs = stringBuffer.toString();
            this.cachedbrokerDurSubQueue = this.brokerDurSubQueue;
            this.cachedbrokerCCDurSubQueue = this.brokerCCDurSubQueue;
            this.cachedbrokerVersion = this.brokerVersion;
        }
        if (string.equals("")) {
            return this.cachedTopicNVs;
        }
        stringBuffer = new StringBuffer(string);
        stringBuffer.append(this.cachedTopicNVs);
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setFromProperties(Properties properties2) throws JMSException {
        try {
            try {
                String string;
                if (Trace.isOn) {
                    Trace.entry(this, "setFromProperties");
                }
                if ((string = properties2.getProperty("brokerDurSubQueue")) != null) {
                    this.setBrokerDurSubQueue(string);
                }
                if ((string = properties2.getProperty("brokerCCDurSubQueue")) != null) {
                    this.setBrokerCCDurSubQueue(string);
                }
                if ((string = properties2.getProperty("brokerVersion")) != null) {
                    this.setBrokerVersion(Integer.parseInt(string));
                }
                super.setFromProperties(properties2);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            catch (NumberFormatException numberFormatException) {
                String string = "MQJMS0003";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                invalidDestinationException.setLinkedException((Exception)numberFormatException);
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + invalidDestinationException);
                }
                if (!Trace.isOn) throw invalidDestinationException;
                Trace.trace(this, "Linked Exception " + numberFormatException);
                throw invalidDestinationException;
            }
            Object var9_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setFromProperties");
            throw throwable;
        }
        Trace.exit(this, "setFromProperties");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String toStringInternal() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "toStringInternal");
            }
            string = this.getBaseTopicName();
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "toStringInternal");
            throw throwable;
        }
        Trace.exit(this, "toStringInternal");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean containsWildcard() {
        boolean bl;
        block5: {
            boolean bl2;
            block4: {
                try {
                    String string;
                    if (Trace.isOn) {
                        Trace.entry(this, "containsWildcard");
                    }
                    if ((string = this.getBaseTopicName()) != null && (string.indexOf(43) >= 0 || string.indexOf(35) >= 0)) {
                        bl2 = true;
                        Object var4_4 = null;
                        if (!Trace.isOn) return bl2;
                        break block4;
                    }
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "containsWildcard");
                    throw throwable;
                }
            }
            Trace.exit(this, "containsWildcard");
            return bl2;
        }
        Object var4_5 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "containsWildcard");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean containsAnyWildcard() {
        boolean bl;
        block5: {
            boolean bl2;
            block4: {
                try {
                    String string;
                    if (Trace.isOn) {
                        Trace.entry(this, "containsAnyWildcard");
                    }
                    if ((string = this.getBaseTopicName()) != null && (string.indexOf(42) >= 0 || string.indexOf(35) >= 0 || string.indexOf(43) >= 0 || string.indexOf(63) >= 0)) {
                        bl2 = true;
                        Object var4_4 = null;
                        if (!Trace.isOn) return bl2;
                        break block4;
                    }
                    bl = false;
                    break block5;
                }
                catch (Throwable throwable) {
                    Object var4_6 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "containsAnyWildcard");
                    throw throwable;
                }
            }
            Trace.exit(this, "containsAnyWildcard");
            return bl2;
        }
        Object var4_5 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "containsAnyWildcard");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isTemporary() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isTemporary");
            }
            bl = this.getBaseTopicName().length() > 0 && this.getBaseTopicName().startsWith("/u0001");
            Object var3_2 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isTemporary");
            throw throwable;
        }
        Trace.exit(this, "isTemporary");
        return bl;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

