/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.TemporaryTopic;

public class MQTemporaryTopic
extends MQTopic
implements TemporaryTopic {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTemporaryTopic.java, jms, j521, j521-L020126 02/01/25 15:21:32 @(#) 1.10.1.1";
    private static final String ttPrefix = "MQ/MQJMS/TT/";
    private String connID = null;
    private boolean deleteFlag = false;
    private int useCount = 0;
    private MQTopicConnection connection = null;

    MQTemporaryTopic(MQTopicConnection mQTopicConnection, int n) throws JMSException {
        super(ttPrefix + mQTopicConnection.getConnectionID() + "/" + Integer.toString(n));
        this.connection = mQTopicConnection;
        this.connID = mQTopicConnection.getConnectionID();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void delete() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "delete");
                }
                if (this.deleteFlag) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3019");
                    throw jMSException;
                }
                if (this.useCount > 0) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3025");
                    throw jMSException;
                }
                this.deleteFlag = true;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "caught and rethrowing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception = " + exception);
                throw jMSException;
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "delete");
            throw throwable;
        }
        Trace.exit(this, "delete");
    }

    String getConnID() {
        return this.connID;
    }

    boolean isDeleted() {
        return this.deleteFlag || this.connection.isClosed();
    }

    synchronized void usageUp() {
        if (Trace.isOn) {
            Trace.entry(this, "usageUp");
        }
        ++this.useCount;
        if (Trace.isOn) {
            Trace.trace(this, "useCount = " + this.useCount);
            Trace.exit(this, "usageUp");
        }
    }

    synchronized void usageDown() {
        if (Trace.isOn) {
            Trace.entry(this, "usageDown");
        }
        --this.useCount;
        if (Trace.isOn) {
            Trace.trace(this, "useCount = " + this.useCount);
            Trace.exit(this, "usageDown");
        }
    }
}

