/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.TemporaryQueue;

public class MQTemporaryQueue
extends com.ibm.mq.jms.MQQueue
implements TemporaryQueue {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQTemporaryQueue.java, jms, j521, j521-L020126 02/01/25 15:22:55 @(#) 1.17.1.1";
    private MQQueue tmpQueue = null;
    private MQQueueConnection connection = null;

    MQTemporaryQueue(String string, MQQueue mQQueue, MQQueueConnection mQQueueConnection) throws JMSException {
        super(string, mQQueue.name);
        this.connection = mQQueueConnection;
        if (Trace.isOn) {
            Trace.entry(this, "MQTemporaryQueue constructor");
            Trace.trace(this, sccsid);
        }
        this.tmpQueue = mQQueue;
        this.setPersistence(1);
        if (Trace.isOn) {
            Trace.exit(this, "MQTemporaryQueue constructor");
        }
    }

    public void finalize() throws Throwable {
        block7: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            if (this.tmpQueue != null) {
                try {
                    this.tmpQueue.close();
                }
                catch (MQException mQException) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS2000"));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    if (!Trace.isOn) break block7;
                    Trace.exception(this, "finalize", (Throwable)mQException);
                }
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void delete() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "delete");
                }
                if (this.tmpQueue == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3001");
                    throw jMSException;
                }
                try {
                    int n = this.tmpQueue.getOpenInputCount();
                    if (n > 0) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3002");
                        throw jMSException;
                    }
                    int n2 = this.tmpQueue.getDefinitionType();
                    switch (n2) {
                        case 1: {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3003");
                            throw jMSException;
                        }
                        case 2: {
                            this.tmpQueue.closeOptions = 2;
                            break;
                        }
                        case 3: {
                            break;
                        }
                        default: {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2010", String.valueOf(n2));
                            throw jMSException;
                        }
                    }
                    this.tmpQueue.close();
                    this.tmpQueue = null;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3004");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var5_10 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "delete");
            throw throwable;
        }
        Trace.exit(this, "delete");
    }

    void checkAccess(MQQueueConnection mQQueueConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkAccess");
        }
        if (mQQueueConnection != this.connection) {
            String string = "MQJMS0003";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Create & Throwing " + invalidDestinationException);
                Trace.exit(this, "checkAccess");
            }
            throw invalidDestinationException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkAccess");
        }
    }
}

