/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

abstract class MQSubscriptionEngine {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQSubscriptionEngine.java, jms, j521, j521-L020622 02/06/21 11:15:27 @(#) 1.7.1.2";
    private MQTopicConnection topicConnection = null;

    public MQSubscriptionEngine(MQTopicConnection mQTopicConnection) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.topicConnection = mQTopicConnection;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public final MQTopicConnection getMQTopicConnection() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQTopicConnection");
            Trace.exit(this, "getMQTopicConnection");
        }
        return this.topicConnection;
    }

    public abstract MQSubscription openSubscription(MQTopicSession var1, MQTopic var2, String var3, boolean var4, boolean var5, String var6) throws JMSException;

    public abstract void closeSubscription(MQSubscription var1) throws JMSException;

    public abstract MQSubscription openDurableSubscription(MQTopicSession var1, MQTopic var2, String var3, boolean var4, boolean var5, String var6, String var7) throws JMSException;

    public abstract void closeDurableSubscription(MQSubscription var1) throws JMSException;

    public abstract void durableUnsubscribe(MQTopicSession var1, String var2) throws JMSException;

    public abstract void close();

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MQQueue openSubscriberQueue(MQTopicSession mQTopicSession, String string, boolean bl, boolean bl2) throws JMSException {
        MQQueue mQQueue;
        try {
            MQQueue mQQueue2 = null;
            int n = 33;
            String string2 = bl2 ? "SYSTEM.JMS.D." : "SYSTEM.JMS.ND.";
            if (Trace.isOn) {
                Trace.entry(this, "openSubscriberQueue");
            }
            if (string.trim().equals("") && !bl) {
                string = bl2 ? "SYSTEM.JMS.D.*" : "SYSTEM.JMS.ND.*";
            } else if (!string.startsWith(string2)) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3021", string);
                throw jMSException;
            }
            try {
                if (string.endsWith("*") && !bl) {
                    Trace.trace(this, "opening new non-shared subscriber queue");
                    mQQueue2 = mQTopicSession.qm.accessQueue("SYSTEM.JMS.MODEL.QUEUE", n, null, string, null);
                    string = mQQueue2.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using non-shared queue approach.");
                        Trace.trace(this, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                        Trace.trace(this, "Prefix: " + string2);
                        Trace.trace(this, "QName:  " + string);
                    }
                } else if (bl) {
                    mQQueue2 = mQTopicSession.qm.accessQueue(string, n);
                    string = mQQueue2.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using shared queue approach.");
                        Trace.trace(this, "Prefix: " + string2);
                        Trace.trace(this, "QName:  " + string);
                    }
                } else {
                    Trace.trace(this, "Must be re-opening a non-shared queue for an existing subscription");
                    mQQueue2 = mQTopicSession.qm.accessQueue(string, n);
                    string = mQQueue2.name;
                    if (Trace.isOn) {
                        Trace.trace(this, "Using non-shared queue approach.");
                        Trace.trace(this, "Prefix: " + string2);
                        Trace.trace(this, "QName:  " + string);
                    }
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            mQQueue = mQQueue2;
            Object var11_12 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "openSubscriberQueue");
            throw throwable;
        }
        Trace.exit(this, "openSubscriberQueue");
        return mQQueue;
    }
}

