/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQXASession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.TransactionInProgressException;

public class MQSessionHandle
implements Session {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQSessionHandle.java, jms, j521, j521-L020126 02/01/25 15:08:51 @(#) 1.4.1.1";
    private MQSession session;
    private MQXASession xaSession;
    protected boolean closed = false;
    protected JMSException closedException;

    protected MQSessionHandle(MQSession mQSession, MQXASession mQXASession) {
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
        this.session = mQSession;
        this.xaSession = mQXASession;
        String string = "MQJMS1024";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        this.closedException = new IllegalStateException(string2, string);
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BytesMessage createBytesMessage() throws JMSException {
        BytesMessage bytesMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createBytesMessage");
            }
            bytesMessage = this.session.createBytesMessage();
            Object var3_2 = null;
            if (!Trace.isOn) return bytesMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createBytesMessage");
            throw throwable;
        }
        Trace.exit(this, "createBytesMessage");
        return bytesMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapMessage createMapMessage() throws JMSException {
        MapMessage mapMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMapMessage");
            }
            mapMessage = this.session.createMapMessage();
            Object var3_2 = null;
            if (!Trace.isOn) return mapMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createMapMessage");
            throw throwable;
        }
        Trace.exit(this, "createMapMessage");
        return mapMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message createMessage() throws JMSException {
        Message message;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMessage");
            }
            message = this.session.createMessage();
            Object var3_2 = null;
            if (!Trace.isOn) return message;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createMessage");
            throw throwable;
        }
        Trace.exit(this, "createMessage");
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        ObjectMessage objectMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage");
            }
            objectMessage = this.session.createObjectMessage();
            Object var3_2 = null;
            if (!Trace.isOn) return objectMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createObjectMessage");
            throw throwable;
        }
        Trace.exit(this, "createObjectMessage");
        return objectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        ObjectMessage objectMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage(object)");
            }
            objectMessage = this.session.createObjectMessage(serializable);
            Object var4_3 = null;
            if (!Trace.isOn) return objectMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createObjectMessage(object)");
            throw throwable;
        }
        Trace.exit(this, "createObjectMessage(object)");
        return objectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamMessage createStreamMessage() throws JMSException {
        StreamMessage streamMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createStreamMessage");
            }
            streamMessage = this.session.createStreamMessage();
            Object var3_2 = null;
            if (!Trace.isOn) return streamMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createStreamMessage");
            throw throwable;
        }
        Trace.exit(this, "createStreamMessage");
        return streamMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage() throws JMSException {
        TextMessage textMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage");
            }
            textMessage = this.session.createTextMessage();
            Object var3_2 = null;
            if (!Trace.isOn) return textMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTextMessage");
            throw throwable;
        }
        Trace.exit(this, "createTextMessage");
        return textMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage(String string) throws JMSException {
        TextMessage textMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage(stringBuffer)");
            }
            textMessage = this.session.createTextMessage(string);
            Object var4_3 = null;
            if (!Trace.isOn) return textMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTextMessage(stringBuffer)");
            throw throwable;
        }
        Trace.exit(this, "createTextMessage(stringBuffer)");
        return textMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            if (this.closed) {
                if (Trace.isOn) {
                    Trace.trace(this, "already closed");
                }
            } else {
                if (this.session != null) {
                    this.session.closeAllChildren();
                }
                if (this.xaSession != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "XXX Callback mechanism not implemented");
                    }
                } else if (Trace.isOn) {
                    Trace.trace(this, "xaSession is null - can't notify on close");
                }
                this.closed = true;
            }
            Object var2_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    public void commit() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS3027");
        throw new TransactionInProgressException(string);
    }

    public void rollback() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS3027");
        throw new TransactionInProgressException(string);
    }

    public void recover() throws JMSException {
        String string = ConfigEnvironment.getErrorMessage("MQJMS1069");
        throw new IllegalStateException(string);
    }

    public boolean getTransacted() throws JMSException {
        return true;
    }

    public MessageListener getMessageListener() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "getMessageListener");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1010");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var3_4 = null;
                if (!Trace.isOn) break block6;
                Trace.exit(this, "getMessageListener");
            }
            throw throwable;
        }
    }

    public void setMessageListener(MessageListener messageListener) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setMessageListener");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1010");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_5 = null;
                if (!Trace.isOn) break block6;
                Trace.exit(this, "setMessageListener");
            }
            throw throwable;
        }
    }

    public void run() {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "run");
                }
                String string = ConfigEnvironment.getErrorMessage("MQJMS1010");
                RuntimeException runtimeException = new RuntimeException(string);
                throw runtimeException;
            }
            catch (RuntimeException runtimeException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + runtimeException);
                }
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_5 = null;
                if (!Trace.isOn) break block6;
                Trace.exit(this, "run");
            }
            throw throwable;
        }
    }
}

