/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSAcknowledgePoint;
import com.ibm.jms.JMSBytesMessage;
import com.ibm.jms.JMSDestination;
import com.ibm.jms.JMSDestinationFactory;
import com.ibm.jms.JMSMapMessage;
import com.ibm.jms.JMSNullMessage;
import com.ibm.jms.JMSObjectMessage;
import com.ibm.jms.JMSStreamMessage;
import com.ibm.jms.JMSStringResources;
import com.ibm.jms.JMSTextMessage;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQJMSStringResources;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueueReceiver;
import com.ibm.mq.jms.SessionAsyncHelper;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;
import javax.jms.BytesMessage;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TextMessage;
import javax.jms.XAConnection;

public abstract class MQSession
implements Session,
JMSAcknowledgePoint,
JMSDestinationFactory {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQSession.java, jms, j521, j521-L020628 02/06/27 10:59:48 @(#) 1.66.1.3";
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_CLOSED = 2;
    static final JMSStringResources jmsStrings = new MQJMSStringResources();
    static final int DIST_TRAN_NONE = 0;
    static final int DIST_TRAN_XA = 1;
    static final int DIST_TRAN_RRS = 2;
    protected boolean transacted;
    protected int acknowledgeMode;
    protected int distTransactionMode = 0;
    protected MQConnection connection = null;
    MQQueueManager qm = null;
    private int state = 0;
    private Object transactionLock = new Object();
    private Vector messageProducers = new Vector();
    private Vector messageConsumers = new Vector();
    private Vector messages;
    private String messageQueueName;
    private MessageListener messageListener;
    private SessionAsyncHelper asyncHelper = null;
    private boolean playNice = false;
    private Object stateChangeSem = new Object();
    protected boolean persistenceFromMD;
    private MQQueue ccInputQueue = null;
    private String lastQueueName = null;

    MQSession(MQConnection mQConnection, boolean bl, int n) {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "MQSession constructor(connection, transacted, acknowledgeMode)");
            Trace.trace(this, sccsid);
        }
        this.connection = mQConnection;
        this.transacted = bl;
        this.acknowledgeMode = n;
        this.persistenceFromMD = mQConnection != null ? mQConnection.getPersistenceFromMD() : false;
        MQException.log = null;
        if (Trace.isOn) {
            Trace.exit(this, "MQSession constructor(connection, transacted, acknowledgeMode)");
        }
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    public abstract void commit() throws JMSException;

    public abstract void recover() throws JMSException;

    public abstract void rollback() throws JMSException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void deliver(String string, Vector vector) {
        if (Trace.isOn) {
            Trace.entry(this, "deliver");
        }
        try {
            try {
                this.messageQueueName = string;
                Enumeration enumeration = vector.elements();
                MQSession mQSession = this;
                synchronized (mQSession) {
                    if (this.messages != null) {
                        if (!Trace.isOn) throw new JMSException("Session already contains messages");
                        Trace.trace(this, "Session already contains messages");
                        throw new JMSException("Session already contains messages");
                    }
                    this.messages = vector;
                    while (enumeration.hasMoreElements()) {
                        MQMessageReference mQMessageReference = (MQMessageReference)enumeration.nextElement();
                        mQMessageReference.setStatus(2);
                    }
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "deliver", (Throwable)jMSException);
                }
                Object var8_8 = null;
                if (!Trace.isOn) return;
                Trace.exit(this, "deliver");
                return;
            }
            Object var8_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "deliver");
            throw throwable;
        }
        Trace.exit(this, "deliver");
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void close() throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            if (this.state == 1 || this.state == 0) {
                this.state = 2;
                Object object = this.stateChangeSem;
                synchronized (object) {
                    this.stateChangeSem.notifyAll();
                }
                if (this.connection != null) {
                    this.connection.removeSession(this);
                }
            } else if (this.state != 2) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_CLOSED");
                throw jMSException;
            }
            if (this.asyncHelper != null) {
                this.asyncHelper.shutdown();
                this.asyncHelper = null;
            }
            if (this.qm != null) {
                if (this.distTransactionMode == 0 || this.distTransactionMode == 2 && !Utils.isRRSTransactionInProgress()) {
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "backing out queueManager");
                        }
                        this.qm.backout();
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "backout failed with " + (Object)((Object)mQException));
                        }
                        switch (mQException.reasonCode) {
                            case 2071: 
                            case 2102: 
                            case 2124: 
                            case 2195: 
                            case 2219: {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1032", mQException.getMessage());
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                throw jMSException;
                            }
                            case 2009: 
                            case 2012: 
                            case 2018: 
                            case 2101: 
                            case 2123: 
                            case 2130: 
                            case 2157: 
                            case 2162: {
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS1023"));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                break;
                            }
                            default: {
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS1016", mQException.toString()));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                break;
                            }
                        }
                    }
                } else if (Trace.isOn) {
                    if (this.distTransactionMode == 1) {
                        Trace.trace(this, "not calling qm.backout since we are under XA");
                    } else {
                        Trace.trace(this, "not calling qm.backout since an RRS global transaction is in progress");
                    }
                }
            }
            this.closeAllChildren();
            if (this.qm != null) {
                if (this.connection instanceof XAConnection) {
                    Trace.trace(this, "qm.disc postponed because this session is XA aware");
                } else {
                    try {
                        try {
                            Trace.trace(this, "disconnecting queueManager");
                            this.qm.disconnect();
                        }
                        catch (Exception exception) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2003");
                            jMSException.setLinkedException(exception);
                            throw jMSException;
                        }
                        Object var5_12 = null;
                        this.qm = null;
                    }
                    catch (Throwable throwable) {
                        Object var5_13 = null;
                        this.qm = null;
                        throw throwable;
                    }
                }
            }
            Object var7_15 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception: " + exception);
                throw jMSException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BytesMessage createBytesMessage() throws JMSException {
        JMSBytesMessage jMSBytesMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createBytesMessage");
            }
            this.checkSessionOpen();
            jMSBytesMessage = new JMSBytesMessage(jmsStrings);
            Object var3_2 = null;
            if (!Trace.isOn) return jMSBytesMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createBytesMessage");
            throw throwable;
        }
        Trace.exit(this, "createBytesMessage");
        return jMSBytesMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public JMSDestination createDestination(String string) throws JMSException {
        JMSDestination jMSDestination;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createDestination");
            }
            jMSDestination = (JMSDestination)MQDestination.createDestination(string);
            Object var4_3 = null;
            if (!Trace.isOn) return jMSDestination;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createDestination");
            throw throwable;
        }
        Trace.exit(this, "createDestination");
        return jMSDestination;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MapMessage createMapMessage() throws JMSException {
        JMSMapMessage jMSMapMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMapMessage");
            }
            this.checkSessionOpen();
            jMSMapMessage = new JMSMapMessage(jmsStrings);
            Object var3_2 = null;
            if (!Trace.isOn) return jMSMapMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createMapMessage");
            throw throwable;
        }
        Trace.exit(this, "createMapMessage");
        return jMSMapMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message createMessage() throws JMSException {
        JMSNullMessage jMSNullMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createMessage");
            }
            this.checkSessionOpen();
            jMSNullMessage = new JMSNullMessage(jmsStrings);
            Object var3_2 = null;
            if (!Trace.isOn) return jMSNullMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createMessage");
            throw throwable;
        }
        Trace.exit(this, "createMessage");
        return jMSNullMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage() throws JMSException {
        JMSObjectMessage jMSObjectMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage");
            }
            this.checkSessionOpen();
            jMSObjectMessage = new JMSObjectMessage(jmsStrings);
            Object var3_2 = null;
            if (!Trace.isOn) return jMSObjectMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createObjectMessage");
            throw throwable;
        }
        Trace.exit(this, "createObjectMessage");
        return jMSObjectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ObjectMessage createObjectMessage(Serializable serializable) throws JMSException {
        JMSObjectMessage jMSObjectMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createObjectMessage(object)");
            }
            this.checkSessionOpen();
            jMSObjectMessage = new JMSObjectMessage(jmsStrings, serializable);
            Object var4_3 = null;
            if (!Trace.isOn) return jMSObjectMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createObjectMessage(object)");
            throw throwable;
        }
        Trace.exit(this, "createObjectMessage(object)");
        return jMSObjectMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StreamMessage createStreamMessage() throws JMSException {
        JMSStreamMessage jMSStreamMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createStreamMessage");
            }
            this.checkSessionOpen();
            jMSStreamMessage = new JMSStreamMessage(jmsStrings);
            Object var3_2 = null;
            if (!Trace.isOn) return jMSStreamMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createStreamMessage");
            throw throwable;
        }
        Trace.exit(this, "createStreamMessage");
        return jMSStreamMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage() throws JMSException {
        JMSTextMessage jMSTextMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage");
            }
            this.checkSessionOpen();
            jMSTextMessage = new JMSTextMessage(jmsStrings);
            Object var3_2 = null;
            if (!Trace.isOn) return jMSTextMessage;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTextMessage");
            throw throwable;
        }
        Trace.exit(this, "createTextMessage");
        return jMSTextMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public TextMessage createTextMessage(String string) throws JMSException {
        JMSTextMessage jMSTextMessage;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createTextMessage(stringBuffer)");
            }
            this.checkSessionOpen();
            jMSTextMessage = new JMSTextMessage(jmsStrings, string);
            Object var4_3 = null;
            if (!Trace.isOn) return jMSTextMessage;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTextMessage(stringBuffer)");
            throw throwable;
        }
        Trace.exit(this, "createTextMessage(stringBuffer)");
        return jMSTextMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean getTransacted() throws JMSException {
        boolean bl;
        block10: {
            boolean bl2;
            try {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "getTransacted");
                    }
                    this.checkSessionOpen();
                    switch (this.distTransactionMode) {
                        case 0: 
                        case 1: {
                            bl2 = this.transacted;
                            Object var4_3 = null;
                            if (!Trace.isOn) return bl2;
                            break;
                        }
                        case 2: {
                            bl = this.transacted || Utils.isRRSTransactionInProgress();
                            break block10;
                        }
                        default: {
                            if (!Trace.isOn) throw ConfigEnvironment.newException("MQJMS1016");
                            Trace.trace(this, "Bad distributed transactional mode " + this.distTransactionMode);
                            throw ConfigEnvironment.newException("MQJMS1016");
                        }
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked excpetion: " + exception);
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                Object var4_5 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "getTransacted");
                throw throwable;
            }
            Trace.exit(this, "getTransacted");
            return bl2;
        }
        Object var4_4 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "getTransacted");
        return bl;
    }

    public MessageListener getMessageListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getMessageListener");
        }
        this.checkSessionOpen();
        if (Trace.isOn) {
            Trace.exit(this, "getMessageListener");
        }
        return this.messageListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMessageListener");
        }
        try {
            try {
                this.checkSessionOpen();
                if (messageListener != null && this.usingAsyncMode()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                this.messageListener = messageListener;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setMessageListener");
            throw throwable;
        }
        Trace.exit(this, "setMessageListener");
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public void run() {
        block64: {
            block56: {
                block57: {
                    if (Trace.isOn) {
                        Trace.entry(this, "run");
                    }
                    var1_1 = new MQGetMessageOptions();
                    var2_2 = this.qm;
                    var1_1.matchOptions = 1;
                    var1_1.options = 8258;
                    var3_3 = false;
                    try {
                        var3_3 = this.getTransacted();
                        break block56;
                    }
                    catch (JMSException var4_4) {
                        if (Trace.isOn) {
                            Trace.exception(this, "run", (Throwable)var4_4);
                        }
                        if (this.messages == null) break block57;
                        var5_6 = this.messages.elements();
                        ** while (var5_6.hasMoreElements())
                    }
lbl-1000:
                    // 1 sources

                    {
                        var6_8 = (MQMessageReference)var5_6.nextElement();
                        var6_8.setStatus(-1);
                        continue;
                    }
                }
                this.messages = null;
            }
            try {
                block63: {
                    if (this.messages != null && this.messageListener != null && var2_2 != null) {
                        block58: {
                            var4_5 = true;
                            try {
                                if (this.ccInputQueue == null || this.messageQueueName != this.lastQueueName) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Queue " + this.messageQueueName + " to be opened");
                                    }
                                    if (this.ccInputQueue != null) {
                                        this.ccInputQueue.close();
                                    }
                                    this.ccInputQueue = var2_2.accessQueue(this.messageQueueName, 8194);
                                    this.lastQueueName = this.messageQueueName;
                                } else if (Trace.isOn) {
                                    Trace.trace(this, "using cached queue for " + this.messageQueueName);
                                }
                                break block58;
                            }
                            catch (MQException var5_7) {
                                if (var5_7.completionCode != 2) break block58;
                                if (Trace.isOn) {
                                    Trace.exception(this, "run", (Throwable)var5_7);
                                }
                                var4_5 = false;
                                var6_8 = this.messages.elements();
                                ** while (var6_8.hasMoreElements())
                            }
lbl-1000:
                            // 1 sources

                            {
                                var7_9 /* !! */  = (MQMessageReference)var6_8.nextElement();
                                var7_9 /* !! */ .setStatus(-1);
                                continue;
                            }
lbl48:
                            // 1 sources

                            this.messages = null;
                        }
                        if (var4_5) {
                            var5_6 = this.messages.elements();
                            while (var5_6.hasMoreElements()) {
                                var6_8 = (MQMessageReference)var5_6.nextElement();
                                var6_8.setStatus(3);
                            }
                            var5_6 = this.messages.elements();
                            while (var5_6.hasMoreElements()) {
                                block61: {
                                    block59: {
                                        var4_5 = true;
                                        var6_8 = (MQMessageReference)var5_6.nextElement();
                                        var7_9 /* !! */  = var6_8.getMQJMSMessage();
                                        var7_9 /* !! */ .setMessageId(var6_8.getMessageId());
                                        if (this.ccInputQueue != null) {
                                            block60: {
                                                try {
                                                    this.ccInputQueue.getMsg2((MQMsg2)var7_9 /* !! */ , var1_1, 1);
                                                    break block59;
                                                }
                                                catch (MQException var8_12) {
                                                    if (var8_12.completionCode != 2) break block59;
                                                    if (Trace.isOn) {
                                                        Trace.exception(this, "run", (Throwable)var8_12);
                                                    }
                                                    var6_8.setStatus(-1);
                                                    var4_5 = false;
                                                    if (var8_12.reasonCode != 2019) break block59;
                                                    ** while (var5_6.hasMoreElements())
                                                }
lbl-1000:
                                                // 1 sources

                                                {
                                                    var6_8 = (MQMessageReference)var5_6.nextElement();
                                                    var6_8.setStatus(-1);
                                                    continue;
                                                }
lbl77:
                                                // 1 sources

                                                try {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "closing input queue because of error");
                                                    }
                                                    this.ccInputQueue.close();
                                                }
                                                catch (MQException var9_14) {
                                                    if (!Trace.isOn) break block60;
                                                    Trace.exception(this, "run", (Throwable)var9_14);
                                                }
                                            }
                                            this.ccInputQueue = null;
                                        } else {
                                            var6_8.setStatus(-1);
                                            var4_5 = false;
                                        }
                                    }
                                    if (var4_5) {
                                        var8_11 = var6_8.removeMessage();
                                        if (!var3_3 && this.acknowledgeMode == 2) {
                                            var8_11._setSession(this);
                                        }
                                        if (Trace.isOn) {
                                            Trace.trace(this, "calling listener");
                                        }
                                        try {
                                            this.messageListener.onMessage((Message)var8_11);
                                            var12_16 = null;
                                            ** if (!Trace.isOn) goto lbl-1000
                                        }
                                        catch (Throwable var11_18) {
                                            var12_16 = null;
                                            if (Trace.isOn) {
                                                Trace.trace(this, "returned from listener");
                                            }
                                            throw var11_18;
                                        }
lbl-1000:
                                        // 1 sources

                                        {
                                            Trace.trace(this, "returned from listener");
                                        }
lbl-1000:
                                        // 2 sources

                                        {
                                            break block61;
                                            catch (RuntimeException var9_15) {
                                                block62: {
                                                    if (Trace.isOn) {
                                                        Trace.exception(this, "run", (Throwable)var9_15);
                                                    }
                                                    if (!var3_3 && this.acknowledgeMode != 2) {
                                                        try {
                                                            var2_2.backout();
                                                        }
                                                        catch (MQException var10_17) {
                                                            if (!Trace.isOn) break block62;
                                                            Trace.exception(this, "run", (Throwable)var10_17);
                                                        }
                                                    }
                                                }
                                                var6_8.setStatus(-1);
                                                ** while (var5_6.hasMoreElements())
                                            }
lbl-1000:
                                            // 1 sources

                                            {
                                                var6_8 = (MQMessageReference)var5_6.nextElement();
                                                var6_8.setStatus(-1);
                                                continue;
                                            }
lbl121:
                                            // 1 sources

                                            throw var9_15;
                                        }
                                    }
                                }
                                if (!var4_5 || var3_3 || this.acknowledgeMode != 1) continue;
                                try {
                                    var2_2.commit();
                                }
                                catch (MQException var8_13) {
                                    if (!Trace.isOn) continue;
                                    Trace.exception(this, "run", (Throwable)var8_13);
                                }
                            }
                            if (var4_5 && !var3_3 && this.acknowledgeMode == 3) {
                                try {
                                    var2_2.commit();
                                }
                                catch (MQException var7_10) {
                                    if (!Trace.isOn) break block63;
                                    Trace.exception(this, "run", (Throwable)var7_10);
                                }
                            }
                        }
                    }
                }
                var14_19 = null;
                this.messages = null;
                if (var3_3 || this.acknowledgeMode == 2) break block64;
            }
            catch (Throwable var13_23) {
                block65: {
                    var14_20 = null;
                    this.messages = null;
                    if (!var3_3 && this.acknowledgeMode != 2) {
                        try {
                            if (var2_2 != null) {
                                var2_2.backout();
                            }
                        }
                        catch (MQException var15_22) {
                            if (!Trace.isOn) break block65;
                            Trace.exception(this, "run", (Throwable)var15_22);
                        }
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                throw var13_23;
            }
            try {
                if (var2_2 != null) {
                    var2_2.backout();
                }
            }
            catch (MQException var15_21) {
                if (!Trace.isOn) break block64;
                Trace.exception(this, "run", (Throwable)var15_21);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "run");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void _acknowledge() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "_acknowledge");
                }
                if (this.transacted) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1020");
                    throw jMSException;
                }
                if (!this.callingFromOnMessage() && this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    this.qm.commit();
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2009");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var5_10 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "_acknowledge throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "_acknowledge");
            throw throwable;
        }
        Trace.exit(this, "_acknowledge");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Object getTransactionLock() {
        Object object;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTransactionLock");
            }
            object = this.transactionLock;
            Object var3_2 = null;
            if (!Trace.isOn) return object;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getTransactionLock");
            throw throwable;
        }
        Trace.exit(this, "getTransactionLock");
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isClosed() {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "isClosed");
            }
            boolean bl3 = bl2 = this.state == 2;
            if (Trace.isOn) {
                Trace.trace(this, "isClosed returning " + bl2);
            }
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isClosed");
            throw throwable;
        }
        Trace.exit(this, "isClosed");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isStarted() {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "isStarted");
            }
            boolean bl3 = bl2 = this.state == 1;
            if (Trace.isOn) {
                Trace.trace(this, "isStarted returning " + bl2);
            }
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isStarted");
            throw throwable;
        }
        Trace.exit(this, "isStarted");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isStopped() {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "isStopped");
            }
            boolean bl3 = bl2 = this.state == 0;
            if (Trace.isOn) {
                Trace.trace(this, "isStopped returning " + bl2);
            }
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isStopped");
            throw throwable;
        }
        Trace.exit(this, "isStopped");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void start() throws SessionClosedException, JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "start");
                }
                if (this.state == 2) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.state != 1) {
                    if (this.state != 0) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STARTED");
                        throw jMSException;
                    }
                    this.state = 1;
                    Object object = this.stateChangeSem;
                    synchronized (object) {
                        this.stateChangeSem.notifyAll();
                    }
                }
                Object var5_6 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "start");
            throw throwable;
        }
        Trace.exit(this, "start");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void stop() throws SessionClosedException, JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "stop");
                }
                if (this.state == 2) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.state == 1) {
                    this.state = 0;
                    Object object = this.transactionLock;
                    // MONITORENTER : object
                    // MONITOREXIT : object
                } else if (this.state != 0) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STOPPED");
                    throw jMSException;
                }
                Object var5_6 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Trace.exit(this, "stop");
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "stop");
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    void waitForStart() throws SessionClosedException, JMSException {
        block20: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "waitForStart");
                }
                while (this.state == 0) {
                    var1_1 = this.stateChangeSem;
                    synchronized (var1_1) {
                        try {
                            this.stateChangeSem.wait(5000L);
                        }
                        catch (InterruptedException var2_3) {
                            // empty catch block
                        }
                    }
                }
                switch (this.state) {
                    case 1: {
                        break;
                    }
                    case 2: {
                        var1_1 = ConfigEnvironment.getErrorMessage("MQJMS1024");
                        var2_4 = new SessionClosedException((String)var1_1);
                        throw var2_4;
                    }
                    default: {
                        try {
                            var3_6 /* !! */  = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                            Logger.log(new LogMessage(2, "MQJMS1016", var3_6 /* !! */ ));
                        }
                        catch (LogException var3_7) {
                            System.err.println("failed to log error because of " + var3_7);
                        }
                        var3_6 /* !! */  = ConfigEnvironment.newException("MQJMS1016", "unknown value of state " + this.state);
                        throw var3_6 /* !! */ ;
                    }
                }
                var5_8 = null;
                ** if (!Trace.isOn) goto lbl-1000
            }
            catch (Throwable var4_10) {
                var5_9 = null;
                if (Trace.isOn) {
                    Trace.exit(this, "waitForStart");
                }
                throw var4_10;
            }
lbl-1000:
            // 1 sources

            {
                Trace.exit(this, "waitForStart");
            }
lbl-1000:
            // 2 sources

            {
                break block20;
                catch (JMSException var1_2) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)var1_2);
                    }
                    throw var1_2;
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    long waitForStart(long l) throws SessionClosedException, JMSException {
        try {
            try {
                Object object;
                if (Trace.isOn) {
                    Trace.entry(this, "waitForStart");
                }
                long l2 = 0L;
                long l3 = System.currentTimeMillis();
                long l4 = l3 + l;
                long l5 = l3;
                while (this.state == 0 && l5 < l4) {
                    object = this.stateChangeSem;
                    synchronized (object) {
                        try {
                            this.stateChangeSem.wait(l4 - l5);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        l5 = System.currentTimeMillis();
                    }
                }
                switch (this.state) {
                    case 1: {
                        l2 = Math.max(0L, l4 - l5);
                        break;
                    }
                    case 2: {
                        object = ConfigEnvironment.getErrorMessage("MQJMS1024");
                        SessionClosedException sessionClosedException = new SessionClosedException((String)object);
                        throw sessionClosedException;
                    }
                    case 0: {
                        l2 = 0L;
                        break;
                    }
                    default: {
                        Object object2;
                        try {
                            object2 = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                            Logger.log(new LogMessage(2, "MQJMS1016", object2));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        object2 = ConfigEnvironment.newException("MQJMS1016", "unknown value of state " + this.state);
                        throw object2;
                    }
                }
                long l6 = l2;
                Object var17_13 = null;
                if (!Trace.isOn) return l6;
                Trace.exit(this, "waitForStart");
                return l6;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var17_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "waitForStart");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void resetQRs() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "resetQRs");
            }
            Enumeration enumeration = this.messageConsumers.elements();
            while (enumeration.hasMoreElements()) {
                Object e = enumeration.nextElement();
                if (e instanceof MQQueueReceiver) {
                    ((MQQueueReceiver)e).resetBrowse();
                    continue;
                }
                if (!Trace.isOn) continue;
                Trace.trace(this, "Oddness: resetQRs found consumer that wasn't a QR");
            }
            Object var4_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "resetQRs");
            throw throwable;
        }
        Trace.exit(this, "resetQRs");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void closeAllChildren() {
        try {
            Vector vector;
            if (Trace.isOn) {
                Trace.entry(this, "closeAllChildren");
            }
            Vector vector2 = (Vector)this.messageProducers.clone();
            Enumeration enumeration = vector2.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    vector = (MessageProducer)enumeration.nextElement();
                    vector.close();
                }
                catch (JMSException jMSException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
            vector = (Vector)this.messageConsumers.clone();
            enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                try {
                    MessageConsumer messageConsumer = (MessageConsumer)enumeration.nextElement();
                    messageConsumer.close();
                }
                catch (JMSException jMSException) {
                }
                catch (NoSuchElementException noSuchElementException) {
                    break;
                }
            }
            Object var7_9 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "closeAllChildren");
            throw throwable;
        }
        Trace.exit(this, "closeAllChildren");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addProducer(MessageProducer messageProducer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addProducer");
            }
            this.messageProducers.addElement(messageProducer);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "addProducer");
            throw throwable;
        }
        Trace.exit(this, "addProducer");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removeProducer(MessageProducer messageProducer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeProducer");
            }
            this.messageProducers.removeElement(messageProducer);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "removeProducer");
            throw throwable;
        }
        Trace.exit(this, "removeProducer");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addConsumer(MessageConsumer messageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addConsumer");
            }
            this.messageConsumers.addElement(messageConsumer);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "addConsumer");
            throw throwable;
        }
        Trace.exit(this, "addConsumer");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removeConsumer(MessageConsumer messageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeConsumer");
            }
            this.messageConsumers.removeElement(messageConsumer);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "removeConsumer");
            throw throwable;
        }
        Trace.exit(this, "removeConsumer");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean usingAsyncMode() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "usingAsyncMode");
            }
            boolean bl2 = this.asyncHelper == null ? false : this.asyncHelper.hasReceivers();
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "usingAsyncMode");
            throw throwable;
        }
        Trace.exit(this, "usingAsyncMode");
        return bl;
    }

    boolean hasMessageListener() {
        return this.messageListener != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void addAsync(MQMessageConsumer mQMessageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addAsync");
            }
            if (this.asyncHelper == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "creating asyncHelper Thread");
                }
                this.asyncHelper = new SessionAsyncHelper(this.connection, this);
            }
            this.asyncHelper.addReceiver(mQMessageConsumer);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "addAsync");
            throw throwable;
        }
        Trace.exit(this, "addAsync");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removeAsync(MQMessageConsumer mQMessageConsumer) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeAsync");
            }
            if (this.asyncHelper != null) {
                this.asyncHelper.removeReceiver(mQMessageConsumer);
            }
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "removeAsync");
            throw throwable;
        }
        Trace.exit(this, "removeAsync");
    }

    boolean getSyncpointAllGets() {
        return this.connection.getSyncpointAllGets();
    }

    boolean getPersistenceFromMD() {
        return this.persistenceFromMD;
    }

    boolean getPlayNice() {
        return this.playNice;
    }

    void setPlayNice(boolean bl) {
        this.playNice = bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean callingFromOnMessage() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "callingFromOnMessage");
            }
            boolean bl2 = this.asyncHelper == null ? false : this.asyncHelper.callingFromOnMessage();
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "callingFromOnMessage");
            throw throwable;
        }
        Trace.exit(this, "callingFromOnMessage");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void discQM() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "discQM");
            }
            if (this.qm != null) {
                try {
                    this.qm.disconnect();
                    this.qm = null;
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "qm.disc failed with " + (Object)((Object)mQException));
                    }
                }
            } else if (Trace.isOn) {
                Trace.trace(this, "qm already null");
            }
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "discQM");
            throw throwable;
        }
        Trace.exit(this, "discQM");
    }

    int getDistTransactionMode() {
        return this.distTransactionMode;
    }

    void setDistTransactionMode(int n) {
        this.distTransactionMode = n;
        if (Trace.isOn) {
            Trace.trace(this, "setDistTransactionMode setting mode to " + n);
        }
    }

    void checkSessionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkSessionOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS1024";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Session is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkSessionOpen");
        }
    }
}

