/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQPSStatusMgr;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

class MQQueueSubscriptionEngine
extends MQSubscriptionEngine {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueSubscriptionEngine.java, jms, j521, j521-L020620 02/06/19 17:15:34 @(#) 1.11.1.11";
    private static final int REGISTER_SUBSCRIBER = 1;
    private static final int DEREGISTER_SUBSCRIBER = 2;
    private static final int REGISTER_PUBLISHER = 3;
    private static final int DEREGISTER_PUBLISHER = 4;
    private MQPSStatusMgr pubsubStatusMgr;
    private byte[] statusMgrId;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MQQueueSubscriptionEngine(MQTopicConnection mQTopicConnection, MQQueueManager mQQueueManager) {
        super(mQTopicConnection);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        try {
            try {
                this.pubsubStatusMgr = new MQPSStatusMgr(mQQueueManager, mQTopicConnection.getBrkControlQueue(), mQTopicConnection.getBrkPubQueue());
                this.statusMgrId = this.pubsubStatusMgr.addConnection(mQTopicConnection);
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "Constructor", (Throwable)jMSException);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "constructor");
                }
                Object var5_4 = null;
                if (!Trace.isOn) return;
                Trace.exit(this, "constructor");
                return;
            }
            Object var5_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor");
            throw throwable;
        }
        Trace.exit(this, "constructor");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MQSubscription openSubscription(MQTopicSession mQTopicSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2) throws JMSException {
        MQQueue mQQueue = null;
        MQQueueSubscription mQQueueSubscription = null;
        byte[] byArray = null;
        boolean bl3 = false;
        if (Trace.isOn) {
            Trace.entry(this, "openSubscription()");
        }
        try {
            try {
                mQQueueSubscription = new MQQueueSubscription(this, mQTopicSession, false, bl2, mQTopicSession.qm.name, this.getMQTopicConnection().getClientID(), null, mQTopic.getBaseTopicName(), string, bl, string2, null, null);
                if (Trace.isOn) {
                    Trace.trace(this, "setting StatusMgrId = " + Utils.bytesToHex(this.statusMgrId));
                }
                mQQueueSubscription.setStatusMgrId(this.statusMgrId);
                mQQueue = this.openSubscriberQueue(mQTopicSession, string2, bl2, false);
                mQQueueSubscription.setSubscriberQueue(mQQueue);
                mQQueueSubscription.setQueueName(mQQueue.name);
                byArray = MQQueueSubscriptionEngine.addNDSubscriptionEntry(mQQueueSubscription);
                mQQueueSubscription.setCorrelationId(byArray);
                if (Trace.isOn) {
                    Trace.trace(this, "Using correl ID = " + Utils.bytesToHex(byArray));
                }
                try {
                    this.sendBrokerCommand(mQQueueSubscription, 1, true);
                    bl3 = true;
                }
                catch (NoBrokerResponseException noBrokerResponseException) {
                    bl3 = true;
                    throw noBrokerResponseException;
                }
                catch (BrokerCommandFailedException brokerCommandFailedException) {
                    throw brokerCommandFailedException;
                }
                Object var16_17 = null;
                if (!Trace.isOn) return mQQueueSubscription;
            }
            catch (JMSException jMSException) {
                boolean bl4;
                block27: {
                    block26: {
                        if (Trace.isOn) {
                            Trace.trace(this, "cleaning up partial subscription");
                        }
                        bl4 = false;
                        if (bl3) {
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "deregistering");
                                }
                                this.sendBrokerCommand(mQQueueSubscription, 2, false);
                            }
                            catch (JMSException jMSException2) {
                                bl4 = true;
                                if (!Trace.isOn) break block26;
                                Trace.trace(this, "the cancel command also failed with " + (Object)((Object)jMSException2));
                                Exception exception = jMSException2.getLinkedException();
                                if (exception == null) break block26;
                                Trace.trace(this, "linked exception = " + exception);
                            }
                        }
                    }
                    if (mQQueue != null) {
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "deleting subscription queue");
                            }
                            if (!bl2) {
                                mQQueue.closeOptions = 2;
                            }
                            mQQueue.close();
                        }
                        catch (Exception exception) {
                            bl4 = true;
                            if (!Trace.isOn) break block27;
                            Trace.trace(this, "queue delete failed with " + exception);
                        }
                    }
                }
                if (!bl4) {
                    MQQueueSubscriptionEngine.removeNDSubscriptionEntry(mQQueueSubscription);
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception = " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "openSubscriber()");
            throw throwable;
        }
        Trace.exit(this, "openSubscriber()");
        return mQQueueSubscription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSubscription(MQSubscription mQSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "closeSubscription");
        }
        try {
            block16: {
                try {
                    MQQueueSubscription mQQueueSubscription = null;
                    if (!(mQSubscription instanceof MQQueueSubscription)) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        if (!Trace.isOn) throw jMSException;
                        Trace.exception(this, "closeSubscription", (Throwable)jMSException);
                        Trace.exit(this, "closeSubscription");
                        throw jMSException;
                    }
                    mQQueueSubscription = (MQQueueSubscription)mQSubscription;
                    MQTopicSession mQTopicSession = mQQueueSubscription.getMQTopicSession();
                    if (mQQueueSubscription.isDurable()) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        if (!Trace.isOn) throw jMSException;
                        Trace.exception(this, "closeSubscription", (Throwable)jMSException);
                        Trace.exit(this, "closeSubscription");
                        throw jMSException;
                    }
                    try {
                        if (mQQueueSubscription.isClosed()) {
                            if (mQQueueSubscription.getSubscriberQueue() != null) {
                                SubscriptionHelper.deleteSubscriberMessages(mQQueueSubscription);
                            }
                        } else {
                            this.deleteSubscriber(mQQueueSubscription);
                        }
                        mQQueueSubscription.setSubscriberQueue(null);
                    }
                    catch (JMSException jMSException) {
                        Exception exception = jMSException.getLinkedException();
                        if (exception instanceof MQException && ((MQException)((Object)exception)).reasonCode == 2055) {
                            if (Trace.isOn) {
                                Trace.trace(this, "close ignoring MQException 2055");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "closeSubscription() ignoring exception " + (Object)((Object)jMSException));
                            if (exception != null) {
                                Trace.trace(this, "linked exception " + exception);
                            }
                        }
                        mQQueueSubscription.setSubscriberQueue(null);
                    }
                    if (mQQueueSubscription.isClosed() || mQQueueSubscription.isDurable()) break block16;
                    MQQueueSubscriptionEngine.removeNDSubscriptionEntry(mQQueueSubscription);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception " + exception);
                    throw jMSException;
                }
            }
            Object var7_10 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "closeSubscription");
            return;
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "closeSubscription");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQSubscription openDurableSubscription(MQTopicSession mQTopicSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2, String string3) throws JMSException {
        MQQueueSubscription mQQueueSubscription;
        block27: {
            Object var8_8 = null;
            MQQueue mQQueue = null;
            MQQueueSubscription mQQueueSubscription2 = null;
            MQQueueSubscription mQQueueSubscription3 = null;
            mQQueueSubscription = null;
            Object var13_13 = null;
            if (Trace.isOn) {
                Trace.entry(this, "openDurableSubscription()");
            }
            try {
                block26: {
                    try {
                        String string4;
                        if (Trace.isOn) {
                            Trace.trace(this, "Topic name = " + mQTopic.getBaseTopicName());
                            Trace.trace(this, "Sub Q name = " + string2);
                            Trace.trace(this, "sub Name   = " + string3);
                            Trace.trace(this, "Selector   = " + string);
                            Trace.trace(this, "noLocal    = " + bl);
                        }
                        mQQueue = this.getAdminQueueAccess(mQTopicSession);
                        String string5 = this.getMQTopicConnection().getClientID();
                        if (string5 == null) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3024");
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "openDurableSubscriber", (Throwable)jMSException);
                            throw jMSException;
                        }
                        mQQueueSubscription3 = new MQQueueSubscription(this, mQTopicSession, true, bl2, mQTopicSession.qm.name, string5, string3, mQTopic.getBaseTopicName(), string, bl, string2, null, null);
                        mQQueueSubscription2 = this.getResolvedSubscription(mQQueue, mQQueueSubscription3, null, false);
                        if (mQQueueSubscription2 == null) {
                            if (Trace.isOn) {
                                Trace.trace(this, "DurSubEntry not found; new durable subscriber");
                                Trace.trace(this, "setting StatusMgrId = " + Utils.bytesToHex(this.statusMgrId));
                            }
                            mQQueueSubscription3.setStatusMgrId(this.statusMgrId);
                            mQQueueSubscription = this.createNewDurableSubscription(mQQueue, mQQueueSubscription3);
                            break block26;
                        }
                        String string6 = mQQueueSubscription3.getSelector();
                        if (string6 == null) {
                            string6 = "";
                        }
                        if ((string4 = mQQueueSubscription2.getSelector()) == null) {
                            string4 = "";
                        }
                        if (mQQueueSubscription3.getFullName().equals(mQQueueSubscription2.getFullName()) && mQQueueSubscription3.getTopic().equals(mQQueueSubscription2.getTopic()) && string6.equals(string4)) {
                            String string7;
                            if (Trace.isOn) {
                                Trace.trace(this, "Found an entry for this client");
                                Trace.trace(this, "Name                  = " + mQQueueSubscription2.getSubName());
                                Trace.trace(this, "Topic name            = " + mQQueueSubscription2.getTopic());
                                Trace.trace(this, "Subscriber queue name = " + mQQueueSubscription2.getQueueName());
                                Trace.trace(this, "Comparing given subscriber queue name: " + string2);
                            }
                            if (!(string7 = mQQueueSubscription2.getQueueName().trim()).equals(string2 = string2.trim())) {
                                if (!string2.endsWith("*")) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3022", string2, string7);
                                    throw jMSException;
                                }
                                if (mQQueueSubscription2.isSharedQueue() || !string7.regionMatches(0, string2, 0, string2.length() - 1)) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3022", string2, string7);
                                    throw jMSException;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "Using original subscriber queue: " + string7);
                                }
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "Reset durable subscriber options");
                            }
                            try {
                                this.sendBrokerCommand(mQQueueSubscription2, 1, true);
                            }
                            catch (NoBrokerResponseException noBrokerResponseException) {
                                if (!Trace.isOn) throw noBrokerResponseException;
                                Trace.trace(this, "re-subscribe command failed");
                                throw noBrokerResponseException;
                            }
                            mQQueueSubscription = this.createExistingDurableSubscription(mQQueue, mQQueueSubscription2);
                            break block26;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Updating a durable subscriber:");
                            Trace.trace(this, "Old subscriber: " + mQQueueSubscription2.toString());
                            Trace.trace(this, "New subscriber: " + mQQueueSubscription3.toString());
                        }
                        mQQueueSubscription = this.createUpdatedDurableSubscriber(mQQueue, mQQueueSubscription3);
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception == null) throw jMSException;
                        Trace.trace(this, "linked exception " + exception);
                        throw jMSException;
                    }
                }
                Object var20_24 = null;
                if (mQQueue == null) break block27;
            }
            catch (Throwable throwable) {
                Object var20_25 = null;
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = new JMSException("MQJMS2000");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "createDurableSubscriber(t,n,s,n)");
                throw throwable;
            }
            try {}
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            mQQueue.close();
        }
        if (!Trace.isOn) return mQQueueSubscription;
        Trace.exit(this, "createDurableSubscriber(t,n,s,n)");
        return mQQueueSubscription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDurableSubscription(MQSubscription mQSubscription) throws JMSException {
        boolean bl = true;
        MQQueue mQQueue = null;
        if (Trace.isOn) {
            Trace.entry(this, "closeDurableSubscription");
        }
        try {
            try {
                block17: {
                    MQQueueSubscription mQQueueSubscription = null;
                    if (!(mQSubscription instanceof MQQueueSubscription)) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3005");
                        if (!Trace.isOn) throw jMSException;
                        Trace.exception(this, "closeDurableSubscription", (Throwable)jMSException);
                        Trace.exit(this, "closeDurableSubscription");
                        throw jMSException;
                    }
                    mQQueueSubscription = (MQQueueSubscription)mQSubscription;
                    if (mQQueueSubscription.isDurable() && mQQueueSubscription.getSubscriberQueue() != null) {
                        MQQueue mQQueue2 = null;
                        try {
                            try {
                                mQQueue2 = mQQueueSubscription.getSubscriberQueue();
                                mQQueue2.close();
                                mQQueue2 = null;
                                mQQueue = this.getAdminQueueAccess(mQQueueSubscription.getMQTopicSession());
                                mQQueueSubscription.setSubscriberState('i');
                                if (Trace.isOn) {
                                    Trace.trace(this, "Add new subscription entry");
                                }
                                this.addSubscriptionEntry(mQQueue, mQQueueSubscription, false);
                                if (Trace.isOn) {
                                    Trace.trace(this, "Remove old subscription entry");
                                }
                                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
                            }
                            catch (MQException mQException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", mQQueueSubscription.getQueueName());
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                throw jMSException;
                            }
                            Object var9_9 = null;
                            if (mQQueue == null) break block17;
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            if (mQQueue == null) throw throwable;
                            try {
                                mQQueue.close();
                                throw throwable;
                            }
                            catch (MQException mQException) {
                                JMSException jMSException = new JMSException("MQJMS2000");
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                throw jMSException;
                            }
                        }
                        try {}
                        catch (MQException mQException) {
                            JMSException jMSException = new JMSException("MQJMS2000");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                        mQQueue.close();
                    }
                }
                Object var13_18 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var13_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "closeDurableSubscription");
            throw throwable;
        }
        Trace.exit(this, "closeDurableSubscription");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableUnsubscribe(MQTopicSession mQTopicSession, String string) throws JMSException {
        block11: {
            MQQueue mQQueue = null;
            try {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "durableUnsubscribe");
                    }
                    if (mQTopicSession.isClosed()) {
                        String string2 = "MQJMS1024";
                        String string3 = ConfigEnvironment.getErrorMessage(string2);
                        IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                        if (!Trace.isOn) throw illegalStateException;
                        Trace.trace(this, "Session is closed. Throwing IllegalStateException.");
                        throw illegalStateException;
                    }
                    mQQueue = this.getAdminQueueAccess(mQTopicSession);
                    this.unsubscribe(mQQueue, mQTopicSession, string);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception = " + exception);
                    throw jMSException;
                }
                Object var8_9 = null;
                if (mQQueue == null) break block11;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = new JMSException("MQJMS2000");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "durableUnsubscribe");
                throw throwable;
            }
            try {}
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            mQQueue.close();
        }
        if (!Trace.isOn) return;
        Trace.exit(this, "durableUnsubscribe");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            block6: {
                try {
                    if (this.pubsubStatusMgr == null) break block6;
                    MQTopicConnection mQTopicConnection = this.getMQTopicConnection();
                    this.pubsubStatusMgr.removeConnection(mQTopicConnection.qmgrName, mQTopicConnection.mqProperties, mQTopicConnection.getConnectionID());
                    this.pubsubStatusMgr.close();
                    this.pubsubStatusMgr = null;
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Problem encountered closing MQQueueSubscriptionEngine");
                        Trace.exception(this, "close", (Throwable)jMSException);
                        Trace.exit(this, "Close");
                    }
                    Object var3_4 = null;
                    if (!Trace.isOn) return;
                    Trace.exit(this, "Close");
                    return;
                }
            }
            Object var3_3 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "Close");
            return;
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "Close");
            throw throwable;
        }
    }

    private static byte[] addNDSubscriptionEntry(MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQQueueSubscriptionEngine", "addNDSubscriptionEntry");
        }
        MQQueue mQQueue = null;
        MQQueueManager mQQueueManager = mQQueueSubscription.getMQTopicSession().qm;
        byte[] byArray = null;
        MQMessage mQMessage = mQQueueSubscription.toMessage();
        try {
            mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 16);
            mQQueue.put(mQMessage);
            byArray = mQMessage.messageId;
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.exception("MQQueueSubscriptionEngine", "addNDSubscriptionEntry", (Throwable)jMSException);
                Trace.exit("MQQueueSubscriptionEngine", "addNDSubscriptionEntry");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit("MQQueueSubscriptionEngine", "addNDSubscriptionEntry");
        }
        return byArray;
    }

    private static void removeNDSubscriptionEntry(MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry");
        }
        MQQueue mQQueue = null;
        MQMessage mQMessage = new MQMessage();
        mQMessage.messageId = mQQueueSubscription.getCorrelationId();
        try {
            MQQueueManager mQQueueManager = mQQueueSubscription.getMQTopicSession().qm;
            mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 2);
            mQQueue.get(mQMessage);
            mQQueue.close();
        }
        catch (MQException mQException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (Trace.isOn) {
                Trace.exception("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry", (Throwable)jMSException);
                Trace.exit("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit("MQQueueSubscriptionEngine", "removeNDSubscriptionEntry");
        }
    }

    private MQQueueSubscription getResolvedSubscription(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription, byte[] byArray, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getResolvedSubscription");
        }
        MQQueueManager mQQueueManager = mQQueueSubscription.getMQTopicSession().qm;
        BrokerConnectionInfo brokerConnectionInfo = mQQueueSubscription.getMQTopicSession().getBrk();
        String string = mQQueueSubscription.getFullName();
        MQQueueSubscription mQQueueSubscription2 = null;
        MQSubscription mQSubscription = null;
        mQQueueSubscription2 = this.getSubscriptionEntry(mQQueue, mQQueueSubscription.getMQTopicSession(), string, null, null, bl);
        if (mQQueueSubscription2 != null) {
            mQQueueSubscription2.setDurable(true);
            if (Trace.isOn) {
                Trace.trace(this, "Matching subscriber found. Checking for a second record.");
            }
            mQSubscription = this.getSubscriptionEntry(mQQueue, mQQueueSubscription.getMQTopicSession(), null, mQQueueSubscription2.getCorrelationId(), null, true);
        }
        if (mQSubscription != null) {
            mQSubscription.setDurable(true);
            if (Trace.isOn) {
                Trace.trace(this, "Second record found: earlier problem must have occurred.");
            }
            if (this.getSubscriptionEntry(mQQueue, mQQueueSubscription.getMQTopicSession(), null, mQQueueSubscription2.getCorrelationId(), null, false) == null) {
                if (Trace.isOn) {
                    Trace.trace(this, "getResolved ERROR: couldn't reset browse cursor position");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
                throw jMSException;
            }
            if (mQQueueSubscription2.getSubscriberState() == 't' || ((MQQueueSubscription)mQSubscription).getSubscriberState() == 't') {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier create or unsubscribe.");
                }
                this.deleteSubscriber(mQQueueSubscription2);
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
                this.removeSubscriptionEntry(mQQueue, (MQQueueSubscription)mQSubscription);
                if (byArray != null) {
                    mQQueueSubscription2.setSubscriberState('i');
                } else {
                    mQQueueSubscription2 = null;
                }
            } else {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier re-create or close.");
                }
                MQQueueSubscription mQQueueSubscription3 = mQQueueSubscription2;
                mQQueueSubscription2.setSubscriberState('i');
                mQQueueSubscription2.setStatusMgrId(MQC.MQCI_NONE);
                if (Trace.isOn) {
                    Trace.trace(this, "Remove the first old subscriptionEntry");
                }
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
                if (Trace.isOn) {
                    Trace.trace(this, "Add the new subscriptionEntry");
                }
                this.addSubscriptionEntry(mQQueue, mQQueueSubscription3, false);
                if (Trace.isOn) {
                    Trace.trace(this, "Remove the second old subscriptionEntry");
                }
                this.removeSubscriptionEntry(mQQueue, (MQQueueSubscription)mQSubscription);
                mQQueueSubscription2 = mQQueueSubscription3;
            }
        } else if (mQQueueSubscription2 != null && mQQueueSubscription2.getSubscriberState() == 't') {
            block26: {
                if (Trace.isOn) {
                    Trace.trace(this, "Trying to resolve problem detected with earlier create or unsubscribe.");
                }
                try {
                    this.deleteSubscriber(mQQueueSubscription2);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block26;
                    Trace.trace(this, "cleanup ERROR: deleteSubscriber encountered error " + (Object)((Object)jMSException));
                }
            }
            this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
            if (byArray != null) {
                mQQueueSubscription2.setSubscriberState('i');
            } else {
                mQQueueSubscription2 = null;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getResolvedSubscription");
        }
        return mQQueueSubscription2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MQQueueSubscription createNewDurableSubscription(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        String string = null;
        MQQueue mQQueue2 = null;
        Object var5_5 = null;
        int n = 33;
        byte[] byArray = null;
        boolean bl = false;
        MQQueueManager mQQueueManager = null;
        int n2 = 0;
        MQTopicSession mQTopicSession = mQQueueSubscription.getMQTopicSession();
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createNewDurablesubscription");
                }
                try {
                    mQQueueManager = mQTopicSession.qm;
                    string = mQQueueSubscription.getQueueName();
                    if (!mQQueueSubscription.isSharedQueue()) {
                        int n3 = 2;
                        n2 = 3;
                        mQQueue2 = mQQueueManager.accessQueue("SYSTEM.JMS.MODEL.QUEUE", n, null, string, null);
                        mQQueueSubscription.setQueueName(mQQueue2.name);
                        string = mQQueue2.name;
                        if (Trace.isOn) {
                            Trace.trace(this, "Using multiple-queue approach.");
                            Trace.trace(this, "Model:  SYSTEM.JMS.MODEL.QUEUE");
                            Trace.trace(this, "Prefix: SYSTEM.JMS.D.*");
                            Trace.trace(this, "QName:  " + string);
                        }
                    } else {
                        int n4 = 4;
                        n2 = 5;
                        mQQueue2 = mQQueueManager.accessQueue(string, n);
                        string = mQQueue2.name;
                        if (Trace.isOn) {
                            Trace.trace(this, "Using shared-queue approach.");
                            Trace.trace(this, "Prefix: SYSTEM.JMS.D.");
                            Trace.trace(this, "QName:  " + string);
                        }
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                try {
                    mQQueueSubscription.setSubscriberQueue(mQQueue2);
                    mQQueueSubscription.setSubscriberState('t');
                    byArray = this.addSubscriptionEntry(mQQueue, mQQueueSubscription, true);
                    mQQueueSubscription.setCorrelationId(byArray);
                }
                catch (JMSException jMSException) {
                    try {
                        mQQueue2.close();
                        throw jMSException;
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.exception(this, "createNewDurableSubscription - error closing subscriber queue:", (Throwable)mQException);
                    }
                    throw jMSException;
                }
                try {
                    this.sendBrokerCommand(mQQueueSubscription, 1, true);
                    bl = true;
                }
                catch (NoBrokerResponseException noBrokerResponseException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "subscribe command failed, sending an unsubscribe to cancel it");
                    }
                    try {
                        this.sendBrokerCommand(mQQueueSubscription, 2, false);
                        throw noBrokerResponseException;
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw noBrokerResponseException;
                        Trace.trace(this, "the cancel command also failed with " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception == null) throw noBrokerResponseException;
                        Trace.trace(this, "linked exception = " + exception);
                    }
                    throw noBrokerResponseException;
                }
                catch (BrokerCommandFailedException brokerCommandFailedException) {
                    throw brokerCommandFailedException;
                }
                mQQueueSubscription.setSubscriberState('u');
                this.addSubscriptionEntry(mQQueue, mQQueueSubscription, false);
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
            }
            catch (JMSException jMSException) {
                boolean bl2;
                block35: {
                    if (Trace.isOn) {
                        Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null) {
                            Trace.trace(this, "linked exception = " + exception);
                        }
                    }
                    bl2 = false;
                    if (bl) {
                        if (Trace.isOn) {
                            Trace.trace(this, "cleanup sending a cancel command");
                        }
                        try {
                            this.sendBrokerCommand(mQQueueSubscription, 2, false);
                        }
                        catch (JMSException jMSException2) {
                            bl2 = true;
                            if (!Trace.isOn) break block35;
                            Trace.trace(this, "the cancel command also failed with " + (Object)((Object)jMSException2));
                            Exception exception = jMSException2.getLinkedException();
                            if (exception == null) break block35;
                            Trace.trace(this, "linked exception = " + exception);
                        }
                    }
                }
                if (mQQueue2 != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "closing subscription queue");
                    }
                    if (!mQQueueSubscription.isSharedQueue()) {
                        if (Trace.isOn) {
                            Trace.trace(this, "not a shared queue so will be deleted");
                        }
                        mQQueue2.closeOptions = 2;
                    }
                    try {
                        mQQueue2.close();
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "failed to delete subscription queue because of " + (Object)((Object)mQException));
                        }
                        bl2 = true;
                    }
                }
                if (bl2) throw jMSException;
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
                throw jMSException;
            }
            Object var18_27 = null;
            if (!Trace.isOn) return mQQueueSubscription;
        }
        catch (Throwable throwable) {
            Object var18_28 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createNewDurableSubscription");
            throw throwable;
        }
        Trace.exit(this, "createNewDurableSubscription");
        return mQQueueSubscription;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MQQueueSubscription createExistingDurableSubscription(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "createExistingDurableSubscription");
        }
        MQQueue mQQueue2 = null;
        MQQueueSubscription mQQueueSubscription2 = null;
        try {
            try {
                mQQueue2 = this.checkInactive(mQQueueSubscription);
                mQQueueSubscription.setSubscriberQueue(mQQueue2);
                mQQueueSubscription2 = mQQueueSubscription;
                mQQueueSubscription2.setSubscriberState('u');
                mQQueueSubscription2.setStatusMgrId(this.statusMgrId);
                this.addSubscriptionEntry(mQQueue, mQQueueSubscription2, false);
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "createExistingDurableSubscription", (Throwable)jMSException);
                throw jMSException;
            }
            Object var7_5 = null;
            if (!Trace.isOn) return mQQueueSubscription2;
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createExistingDurableSubscription");
            throw throwable;
        }
        Trace.exit(this, "createExistingDurableSubscription");
        return mQQueueSubscription2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MQQueueSubscription createUpdatedDurableSubscriber(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        MQQueueSubscription mQQueueSubscription2 = null;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createUpdatedDurableSubscription");
                }
                MQQueueSubscription mQQueueSubscription3 = null;
                Object var5_6 = null;
                mQQueueSubscription3 = mQQueueSubscription;
                this.unsubscribe(mQQueue, mQQueueSubscription.getMQTopicSession(), mQQueueSubscription.getSubName());
                mQQueueSubscription3.setStatusMgrId(this.statusMgrId);
                mQQueueSubscription2 = this.createNewDurableSubscription(mQQueue, mQQueueSubscription3);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var7_8 = null;
            if (!Trace.isOn) return mQQueueSubscription2;
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createUpdatedDurableSubscription");
            throw throwable;
        }
        Trace.exit(this, "createUpdatedDurableSubscription");
        return mQQueueSubscription2;
    }

    private MQQueue getAdminQueueAccess(MQTopicSession mQTopicSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getAdminQueueAccess");
        }
        MQQueueManager mQQueueManager = mQTopicSession.qm;
        MQQueue mQQueue = null;
        int n = 0;
        block7: while (true) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Try to open the adminQueue");
                }
                mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", 60);
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "I'm sorry Dave. I can't do that");
                }
                switch (mQException.reasonCode) {
                    case 2042: {
                        if (++n < 20) {
                            if (Trace.isOn) {
                                Trace.trace(this, "admin queue locked, tried " + n + "times");
                            }
                            Trace.trace(this, "suppressing exception and retrying after wait");
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Daisy, Daisy....");
                                }
                                Thread.sleep((long)(100.0 + 5000.0 * Math.random()));
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block7;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Tried 20 attempts. I'm bored now so I'll throw an exception");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.trace(this, "Obtaining the admin queue lock required " + n + " retries");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getAdminQueueAccess");
        }
        return mQQueue;
    }

    private byte[] addSubscriptionEntry(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "addSubscriptionEntry");
            Trace.trace(this, "add was passed:" + mQQueueSubscription);
        }
        byte[] byArray = null;
        if (bl && this.contains(mQQueue, mQQueueSubscription.getMQTopicSession(), mQQueueSubscription.getSubName())) {
            if (Trace.isOn) {
                Trace.trace(this, "In addSubscriptionEntry() - entry already exists!");
                Trace.exit(this, "addSubscriptionEntry");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            throw jMSException;
        }
        MQMessage mQMessage = mQQueueSubscription.toMessage();
        if (Trace.isOn) {
            Trace.trace(this, "MQPUT with messageId '" + Utils.bytesToHex(mQMessage.messageId) + "'");
        }
        try {
            mQQueue.put(mQMessage, new MQPutMessageOptions());
            byArray = mQMessage.messageId;
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.trace(this, "In addSubscriptionEntry() - unable to MQPUT new entry");
                Trace.exit(this, "addSubscriptionEntry");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3013");
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "addSubscriptionEntry");
        }
        return byArray;
    }

    private void removeSubscriptionEntry(MQQueue mQQueue, MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeSubscriptionEntry");
        }
        MQQueueSubscription mQQueueSubscription2 = null;
        Object var4_4 = null;
        byte[] byArray = mQQueueSubscription.getCorrelationId();
        String string = mQQueueSubscription.getSubName();
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        if (byArray == null) {
            mQGetMessageOptions.options = 16;
        }
        boolean bl = true;
        while (bl) {
            JMSException jMSException;
            try {
                MQMessage mQMessage = new MQMessage();
                if (byArray != null) {
                    mQMessage.messageId = byArray;
                    mQGetMessageOptions.matchOptions |= 1;
                }
                mQQueue.get(mQMessage, mQGetMessageOptions);
                mQQueueSubscription2 = new MQQueueSubscription(this, mQQueueSubscription.getMQTopicSession(), mQMessage);
                if (byArray != null) {
                    bl = false;
                    continue;
                }
                if (mQQueueSubscription2.isValid() && mQQueueSubscription2.getSubName().equals(string)) {
                    mQGetMessageOptions.options = 256;
                    jMSException = new MQMessage();
                    mQQueue.get((MQMessage)jMSException, mQGetMessageOptions);
                    bl = false;
                    continue;
                }
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                jMSException = ConfigEnvironment.newException("MQJMS3013");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(this, "In removeSubscriptionEntry() - cannot remove msg!");
                }
                throw jMSException;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeSubscriptionEntry");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private MQQueue checkInactive(MQQueueSubscription mQQueueSubscription) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkInactive");
        }
        MQQueueManager mQQueueManager = null;
        MQQueue mQQueue = null;
        boolean bl = false;
        mQQueueManager = mQQueueSubscription.getMQTopicSession().qm;
        if (mQQueueSubscription.getSubscriberState() == 'i') {
            bl = true;
        } else if (mQQueueSubscription.getSubscriberState() != 'u') {
            if (Trace.isOn) {
                Trace.trace(this, "checkInactive: state is neither unknown or inactive!");
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3005");
            throw jMSException;
        }
        try {
            try {
                if (mQQueueSubscription.isSharedQueue() && !bl) {
                    int n = 10;
                    MQQueue mQQueue2 = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n);
                    MQMessage mQMessage = new MQMessage();
                    mQMessage.messageId = mQQueueSubscription.getStatusMgrId();
                    MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                    mQGetMessageOptions.options = 16;
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "attempting MQGET for jvm reference msg.");
                        }
                        mQQueue2.get(mQMessage, mQGetMessageOptions);
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode != 2033) throw mQException;
                        if (Trace.isOn) {
                            Trace.trace(this, "shared subscriber assumed active. Throwing ex.");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3023");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                    mQQueue2.close();
                }
                if (Trace.isOn) {
                    Trace.trace(this, "opening subscription queue");
                }
                mQQueue = this.openSubscriberQueue(mQQueueSubscription.getMQTopicSession(), mQQueueSubscription.getQueueName(), mQQueueSubscription.isSharedQueue(), true);
            }
            catch (MQException mQException) {
                JMSException jMSException = mQException.reasonCode == 2042 ? ConfigEnvironment.newException("MQJMS3023") : ConfigEnvironment.newException("MQJMS3005");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "StatusMgrConnection", (Throwable)jMSException);
                throw jMSException;
            }
            Object var12_14 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var12_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "checkInactive");
            throw throwable;
        }
        Trace.exit(this, "checkInactive");
        return mQQueue;
    }

    private MQQueueSubscription getSubscriptionEntry(MQQueue mQQueue, MQTopicSession mQTopicSession, String string, byte[] byArray, byte[] byArray2, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getSubscriptionEntry");
        }
        MQQueueSubscription mQQueueSubscription = null;
        MQQueueSubscription mQQueueSubscription2 = null;
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = bl ? 32 : 16;
        boolean bl2 = true;
        while (bl2) {
            try {
                MQMessage mQMessage = new MQMessage();
                if (byArray != null) {
                    mQMessage.messageId = byArray;
                }
                if (byArray2 != null) {
                    mQMessage.correlationId = byArray2;
                }
                mQQueue.get(mQMessage, mQGetMessageOptions);
                mQQueueSubscription = new MQQueueSubscription(this, mQTopicSession, mQMessage);
                if (string == null && mQQueueSubscription.isValid()) {
                    mQQueueSubscription2 = mQQueueSubscription;
                    bl2 = false;
                    continue;
                }
                if (string != null && mQQueueSubscription.isValid() && mQQueueSubscription.getFullName().equals(string)) {
                    mQQueueSubscription2 = mQQueueSubscription;
                    bl2 = false;
                    continue;
                }
                mQGetMessageOptions.options = 32;
            }
            catch (MQException mQException) {
                bl2 = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "getSubscriptionEntry");
        }
        return mQQueueSubscription2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deleteSubscriber(MQQueueSubscription mQQueueSubscription) throws JMSException {
        JMSException jMSException = null;
        if (Trace.isOn) {
            Trace.entry(this, "deleteSubscriber");
        }
        String string = mQQueueSubscription.isDurable() ? mQQueueSubscription.getClientId() + ":" + mQQueueSubscription.getSubName() : "";
        MQSubEntry mQSubEntry = new MQSubEntry(string, mQQueueSubscription.getTopic(), mQQueueSubscription.getQueueName(), mQQueueSubscription.getSelector(), mQQueueSubscription.getNoLocal(), mQQueueSubscription.getStatusMgrId(), mQQueueSubscription.isSharedQueue());
        mQSubEntry.setSubscriberId(mQQueueSubscription.getCorrelationId());
        MQQueue mQQueue = mQQueueSubscription.getSubscriberQueue();
        try {
            try {
                block10: {
                    try {
                        this.sendBrokerCommand(mQQueueSubscription, 2, false);
                    }
                    catch (JMSException jMSException2) {
                        jMSException = jMSException2;
                        if (!Trace.isOn) break block10;
                        Trace.trace(this, "Failed to deregister due to " + (Object)((Object)jMSException2));
                    }
                }
                SubscriptionHelper.deleteSubscriberMessages(mQSubEntry, mQQueue);
                if (jMSException != null) {
                    throw jMSException;
                }
                Object var9_8 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException3) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing from deleteSubscriber: " + (Object)((Object)jMSException3));
                    Exception exception = jMSException3.getLinkedException();
                    if (exception != null) {
                        Trace.trace(this, "Linked exception: " + exception);
                    }
                }
                if (jMSException == null || jMSException3 == jMSException) throw jMSException3;
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "NOTE! Throwing pending deregException instead!");
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "deleteSubscriber");
            throw throwable;
        }
        Trace.exit(this, "deleteSubscriber");
    }

    /*
     * Exception decompiling
     */
    private void sendBrokerCommand(MQQueueSubscription var1_1, int var2_2, boolean var3_3) throws JMSException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [19[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void getBrokerResponse(MQTopicSession mQTopicSession, MQMsg2 mQMsg2) throws NoBrokerResponseException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "getBrokerResponse");
                }
                MQQueue mQQueue = mQTopicSession.getResponseQueue();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 1;
                mQGetMessageOptions.matchOptions = 2;
                mQGetMessageOptions.waitInterval = mQTopicSession.getBrokerTimeout();
                mQQueue.getMsg2(mQMsg2, mQGetMessageOptions);
            }
            catch (MQException mQException) {
                String string = "MQJMS5053";
                String string2 = ConfigEnvironment.getErrorMessage(string);
                NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                throw noBrokerResponseException;
            }
            Object var8_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getBrokerResponse");
            throw throwable;
        }
        Trace.exit(this, "getBrokerResponse");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsubscribe(MQQueue mQQueue, MQTopicSession mQTopicSession, String string) throws JMSException {
        try {
            try {
                Throwable throwable;
                MQQueueSubscription mQQueueSubscription;
                MQQueueSubscription mQQueueSubscription2;
                if (Trace.isOn) {
                    Trace.entry(this, "unsubscribe");
                }
                if ((mQQueueSubscription2 = this.getResolvedSubscription(mQQueue, mQQueueSubscription = new MQQueueSubscription(this, mQTopicSession, true, false, mQTopicSession.qm.name, this.getMQTopicConnection().getClientID(), string, null, null, false, null, null, null), null, false)) == null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "No entry found for '" + string + "'");
                    }
                    String string2 = "MQJMS3018";
                    String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                    throw invalidDestinationException;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Entry found for '" + string + "'");
                    Trace.trace(this, mQQueueSubscription2.toString());
                }
                MQQueue mQQueue2 = null;
                try {
                    mQQueue2 = this.checkInactive(mQQueueSubscription2);
                }
                catch (JMSException jMSException) {
                    throwable = (MQException)((Object)jMSException.getLinkedException());
                    switch (((MQException)throwable).reasonCode) {
                        case 2052: 
                        case 2085: {
                            if (!Trace.isOn) break;
                            Trace.trace(this, "Warning: durable sub queue '" + mQQueueSubscription2.getQueueName() + " is missing\n");
                            Trace.trace(this, "Carrying on with deregister");
                            break;
                        }
                        default: {
                            throw jMSException;
                        }
                    }
                }
                mQQueueSubscription2.setSubscriberState('t');
                this.addSubscriptionEntry(mQQueue, mQQueueSubscription2, false);
                this.deleteSubscriber(mQQueueSubscription2);
                try {
                    this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "unsubscribe problem - failed to remove the admin entry: " + (Object)((Object)jMSException));
                    }
                    throwable = ConfigEnvironment.newException("MQJMS3013");
                    throw throwable;
                }
                this.removeSubscriptionEntry(mQQueue, mQQueueSubscription2);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "unsubscribe throwing: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception: " + exception);
                throw jMSException;
            }
            Object var10_15 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "unsubscribe");
            throw throwable;
        }
        Trace.exit(this, "unsubscribe");
    }

    MQPSStatusMgr getPubSubStatusMgr() {
        return this.pubsubStatusMgr;
    }

    byte[] getStatusMgrId() {
        return this.statusMgrId;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean contains(MQQueue mQQueue, MQTopicSession mQTopicSession, String string) throws JMSException {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "contains");
        }
        try {
            bl = this.getSubscriptionEntry(mQQueue, mQTopicSession, string, null, null, false) != null;
            Object var6_5 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "contains");
            throw throwable;
        }
        Trace.exit(this, "contains");
        return bl;
    }
}

