/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQSessionHandle;
import com.ibm.mq.jms.MQXAQueueSession;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.TemporaryQueue;

public class MQQueueSessionHandle
extends MQSessionHandle
implements QueueSession {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueSessionHandle.java, jms, j521, j521-L020126 02/01/25 15:08:41 @(#) 1.3.1.1";
    private MQQueueSession session;

    protected MQQueueSessionHandle(MQQueueSession mQQueueSession, MQXAQueueSession mQXAQueueSession) {
        super(mQQueueSession, mQXAQueueSession);
        if (Trace.isOn) {
            Trace.trace(this, sccsid);
        }
        this.session = mQQueueSession;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Queue createQueue(String string) throws JMSException {
        Queue queue;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createQueue");
            }
            if (this.closed) {
                throw this.closedException;
            }
            queue = this.session.createQueue(string);
            Object var4_3 = null;
            if (!Trace.isOn) return queue;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueue");
            throw throwable;
        }
        Trace.exit(this, "createQueue");
        return queue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        QueueSender queueSender;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createSender");
                }
                if (this.closed) {
                    throw this.closedException;
                }
                queueSender = this.session.createSender(queue);
                Object var4_4 = null;
                if (!Trace.isOn) return queueSender;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createSender");
            throw throwable;
        }
        Trace.exit(this, "createSender");
        return queueSender;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        QueueReceiver queueReceiver;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createReceiver");
                }
                if (this.closed) {
                    throw this.closedException;
                }
                queueReceiver = this.session.createReceiver(queue, string);
                Object var5_5 = null;
                if (!Trace.isOn) return queueReceiver;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createReceiver");
            throw throwable;
        }
        Trace.exit(this, "createReceiver");
        return queueReceiver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        TemporaryQueue temporaryQueue;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createTemporaryQueue");
                }
                if (this.closed) {
                    throw this.closedException;
                }
                temporaryQueue = this.session.createTemporaryQueue();
                Object var3_3 = null;
                if (!Trace.isOn) return temporaryQueue;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var3_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTemporaryQueue");
            throw throwable;
        }
        Trace.exit(this, "createTemporaryQueue");
        return temporaryQueue;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        QueueBrowser queueBrowser;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "CreateBrowser");
                }
                if (this.closed) {
                    throw this.closedException;
                }
                queueBrowser = this.session.createBrowser(queue, string);
                Object var5_5 = null;
                if (!Trace.isOn) return queueBrowser;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueueBrowser");
            throw throwable;
        }
        Trace.exit(this, "createQueueBrowser");
        return queueBrowser;
    }
}

