/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQQueueBrowser;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueReceiver;
import com.ibm.mq.jms.MQQueueSender;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.ResourceAllocationException;
import javax.jms.TemporaryQueue;
import javax.jms.TransactionRolledBackException;

public class MQQueueSession
extends MQSession
implements QueueSession {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueSession.java, jms, j521, j521-L020126 02/01/25 15:18:10 @(#) 1.65.1.1";
    private String deadLetterQueue = null;
    private String resolvedQmName = null;
    private String resolvedQueueName = "";

    MQQueueSession(MQQueueConnection mQQueueConnection, MQQueueManager mQQueueManager, boolean bl, int n) throws JMSException {
        super(mQQueueConnection, bl, n);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.qm = mQQueueManager;
        try {
            int n2 = 2015;
            this.resolvedQmName = mQQueueManager.getAttributeString(n2, 48).trim();
        }
        catch (Exception exception) {
            this.resolvedQmName = mQQueueManager.name;
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Queue createQueue(String string) throws JMSException {
        com.ibm.mq.jms.MQQueue mQQueue;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "createQueue");
            }
            this.checkSessionOpen();
            mQQueue = new com.ibm.mq.jms.MQQueue(string);
            Object var4_3 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueue");
            throw throwable;
        }
        Trace.exit(this, "createQueue");
        return mQQueue;
    }

    public String getLastQueueName() {
        if (this.resolvedQueueName != null) {
            return this.resolvedQueueName;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueSender createSender(Queue queue) throws JMSException {
        MQQueueSender mQQueueSender;
        try {
            try {
                com.ibm.mq.jms.MQQueue mQQueue = null;
                MQQueue mQQueue2 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "createSender");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                if (queue != null) {
                    if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                        String string = "MQJMS0003";
                        String string3 = ConfigEnvironment.getErrorMessage(string);
                        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string);
                        throw invalidDestinationException;
                    }
                    mQQueue = (com.ibm.mq.jms.MQQueue)queue;
                    mQQueue2 = this.getOutputQueue(mQQueue);
                    this.resolvedQueueName = mQQueue2.name;
                    mQQueue.setBaseQueueName(mQQueue2.name);
                }
                MQQueueSender mQQueueSender2 = new MQQueueSender(mQQueue, mQQueue2, this);
                super.addProducer(mQQueueSender2);
                mQQueueSender = mQQueueSender2;
                Object var8_14 = null;
                if (!Trace.isOn) return mQQueueSender;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createSender");
            throw throwable;
        }
        Trace.exit(this, "createSender");
        return mQQueueSender;
    }

    public QueueReceiver createReceiver(Queue queue) throws JMSException {
        return this.createReceiver(queue, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueReceiver createReceiver(Queue queue, String string) throws JMSException {
        MQQueueReceiver mQQueueReceiver;
        try {
            try {
                MQQueue mQQueue = null;
                if (Trace.isOn) {
                    Trace.entry(this, "createReceiver");
                }
                if (this.isClosed()) {
                    String string2 = "MQJMS1024";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string4 = "MQJMS0003";
                    String string5 = ConfigEnvironment.getErrorMessage(string4);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                    throw invalidDestinationException;
                }
                com.ibm.mq.jms.MQQueue mQQueue2 = (com.ibm.mq.jms.MQQueue)queue;
                this.checkQueueAccess(mQQueue2);
                String string6 = mQQueue2.getBaseQueueName();
                String string7 = mQQueue2.getBaseQueueManagerName();
                if (string7 != null && !string7.equals("") && !string7.equals(this.resolvedQmName)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                    throw jMSException;
                }
                int n = 9;
                n |= 0x20;
                try {
                    mQQueue = this.qm.accessQueue(string6, n);
                }
                catch (MQException mQException) {
                    JMSException jMSException = this.getQueueOpenException(mQException);
                    throw jMSException;
                }
                MQQueueReceiver mQQueueReceiver2 = new MQQueueReceiver(mQQueue2, string, mQQueue, this.transacted, this.acknowledgeMode, this);
                super.addConsumer(mQQueueReceiver2);
                mQQueueReceiver = mQQueueReceiver2;
                Object var11_21 = null;
                if (!Trace.isOn) return mQQueueReceiver;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_22 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createReceiver");
            throw throwable;
        }
        Trace.exit(this, "createReceiver");
        return mQQueueReceiver;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TemporaryQueue createTemporaryQueue() throws JMSException {
        MQTemporaryQueue mQTemporaryQueue;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createTemporaryQueue");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (this.connection == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1018");
                    throw jMSException;
                }
                mQTemporaryQueue = ((MQQueueConnection)this.connection).createTemporaryQueue();
                Object var5_7 = null;
                if (!Trace.isOn) return mQTemporaryQueue;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTemporaryQueue");
            throw throwable;
        }
        Trace.exit(this, "createTemporaryQueue");
        return mQTemporaryQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void commit() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "commit");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (!this.transacted) {
                    String string = "MQJMS1019";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    Object object = this.getTransactionLock();
                    synchronized (object) {
                        this.qm.commit();
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException;
                    int n = mQException.completionCode;
                    int n2 = mQException.reasonCode;
                    if (n == 1 && n2 == 2003) {
                        String string = "MQJMS0011";
                        String string4 = ConfigEnvironment.getErrorMessage(string);
                        jMSException = new TransactionRolledBackException(string4, string);
                    } else {
                        jMSException = ConfigEnvironment.newException("MQJMS2009");
                    }
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var8_17 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_18 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "commit");
            throw throwable;
        }
        Trace.exit(this, "commit");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void rollback() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "rollback");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (!this.transacted) {
                    String string = "MQJMS1019";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    Object object = this.getTransactionLock();
                    synchronized (object) {
                        this.qm.backout();
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1023");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var6_13 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "rollback");
            throw throwable;
        }
        Trace.exit(this, "rollback");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void recover() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "recover");
                }
                if (this.isClosed()) {
                    String string = "MQJMS1024";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string2, string);
                    throw illegalStateException;
                }
                if (this.transacted) {
                    String string = "MQJMS1020";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string);
                    throw illegalStateException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                try {
                    Object object = this.getTransactionLock();
                    synchronized (object) {
                        if (this.qm.isConnected()) {
                            try {
                                this.qm.backout();
                            }
                            catch (NullPointerException nullPointerException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                                jMSException.setLinkedException((Exception)nullPointerException);
                                throw jMSException;
                            }
                            super.resetQRs();
                        } else if (Trace.isOn) {
                            Trace.trace(this, "qm not connected - race condition?");
                        }
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1021");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var6_16 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_17 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "recover");
            throw throwable;
        }
        Trace.exit(this, "recover");
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueBrowser createBrowser(Queue queue, String string) throws JMSException {
        MQQueueBrowser mQQueueBrowser;
        try {
            try {
                MQQueueBrowser mQQueueBrowser2;
                if (Trace.isOn) {
                    Trace.entry(this, "CreateBrowser");
                }
                if (this.isClosed()) {
                    String string2 = "MQJMS1024";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    IllegalStateException illegalStateException = new IllegalStateException(string3, string2);
                    throw illegalStateException;
                }
                if (queue == null || !(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string4 = "MQJMS0003";
                    String string5 = ConfigEnvironment.getErrorMessage(string4);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                    throw invalidDestinationException;
                }
                com.ibm.mq.jms.MQQueue mQQueue = (com.ibm.mq.jms.MQQueue)queue;
                String string6 = mQQueue.getBaseQueueManagerName();
                this.checkQueueAccess(mQQueue);
                if (string6 != null && !string6.equals("") && !string6.equals(this.resolvedQmName)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                    throw jMSException;
                }
                String string7 = mQQueue.getBaseQueueName();
                if (string7 == null) {
                    String string8 = "MQJMS0003";
                    String string9 = ConfigEnvironment.getErrorMessage(string8);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string9, string8);
                    throw invalidDestinationException;
                }
                mQQueueBrowser = mQQueueBrowser2 = new MQQueueBrowser(queue, string, this);
                Object var10_19 = null;
                if (!Trace.isOn) return mQQueueBrowser;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueueBrowser");
            throw throwable;
        }
        Trace.exit(this, "createQueueBrowser");
        return mQQueueBrowser;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQQueue getQueueForBrowse(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        MQQueue mQQueue2;
        try {
            try {
                MQQueue mQQueue3;
                if (Trace.isOn) {
                    Trace.entry(this, "getQueueForBrowse");
                }
                if (this.isClosed()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                    throw jMSException;
                }
                if (mQQueue == null) {
                    String string = "MQJMS0003";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                    throw invalidDestinationException;
                }
                if (this.qm == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                    throw jMSException;
                }
                String string = mQQueue.getBaseQueueManagerName();
                if (string != null && !string.equals("") && !string.equals(this.resolvedQmName)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1017");
                    throw jMSException;
                }
                String string3 = mQQueue.getBaseQueueName();
                int n = 8;
                String string4 = null;
                try {
                    string4 = mQQueue.getDynamicPrefix();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    mQQueue3 = this.qm.accessQueue(string3, n);
                }
                catch (MQException mQException) {
                    JMSException jMSException = this.getQueueOpenException(mQException);
                    throw jMSException;
                }
                mQQueue2 = mQQueue3;
                Object var10_18 = null;
                if (!Trace.isOn) return mQQueue2;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getQueueForBrowse");
            throw throwable;
        }
        Trace.exit(this, "getQueueForBrowse");
        return mQQueue2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQQueue getOutputQueue(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        String string;
        try {
            try {
                MQQueue mQQueue2 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "getOutputQueue");
                }
                if (this.isClosed()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                    throw jMSException;
                }
                if (mQQueue == null) {
                    String string2 = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                    throw invalidDestinationException;
                }
                string = mQQueue.getBaseQueueName();
                String string4 = mQQueue.getBaseQueueManagerName();
                String string5 = null;
                try {
                    string5 = mQQueue.getDynamicPrefix();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                int n = 16;
                try {
                    mQQueue2 = this.qm.accessQueue(string, n, string4, string5, "");
                }
                catch (MQException mQException) {
                    JMSException jMSException = this.getQueueOpenException(mQException);
                    throw jMSException;
                }
                string = mQQueue2;
                Object var10_15 = null;
                if (!Trace.isOn) return string;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getOutputQueue");
            throw throwable;
        }
        Trace.exit(this, "getOutputQueue");
        return string;
    }

    private JMSException getQueueOpenException(MQException mQException) {
        Object object;
        String string = "MQJMS2008";
        String string2 = ConfigEnvironment.getErrorMessage(string);
        switch (mQException.reasonCode) {
            case 2001: 
            case 2011: 
            case 2043: 
            case 2052: 
            case 2057: 
            case 2058: 
            case 2082: 
            case 2085: 
            case 2086: 
            case 2087: 
            case 2091: 
            case 2092: 
            case 2152: 
            case 2153: 
            case 2184: 
            case 2194: 
            case 2196: 
            case 2197: 
            case 2198: 
            case 2199: {
                object = new InvalidDestinationException(string2, string);
                break;
            }
            case 2017: 
            case 2071: 
            case 2102: 
            case 2192: {
                object = new ResourceAllocationException(string2, string);
                break;
            }
            case 2035: {
                object = new JMSSecurityException(string2, string);
                break;
            }
            default: {
                object = new JMSException(string2, string);
            }
        }
        object.setLinkedException((Exception)((Object)mQException));
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    String getDLQName() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDLQName");
            }
            string = this.deadLetterQueue;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDLQName");
            throw throwable;
        }
        Trace.exit(this, "getDLQName");
        return string;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void redirectMessage(String string, MQMsg2 mQMsg2) throws JMSException {
        try {
            block22: {
                MQQueue mQQueue;
                block20: {
                    mQQueue = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "redirectMessage");
                        Trace.trace(this, "sending message to '" + string + "'");
                    }
                    if (this.isClosed()) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1024");
                        throw jMSException;
                    }
                    if (this.qm == null) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2004");
                        throw jMSException;
                    }
                    try {
                        int n = 16;
                        mQQueue = this.qm.accessQueue(string, n);
                        MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                        mQPutMessageOptions.options |= 2;
                        mQPutMessageOptions.options &= 0xFFFFFFFB;
                        mQQueue.putMsg2(mQMsg2, mQPutMessageOptions);
                        Object var7_11 = null;
                        if (!Trace.isOn) break block20;
                    }
                    catch (Throwable throwable) {
                        Object var7_12 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "redirectMessage finally block");
                        }
                        if (mQQueue == null) throw throwable;
                        try {
                            mQQueue.close();
                            throw throwable;
                        }
                        catch (MQException mQException) {
                            try {
                                Logger.log(new LogMessage(2, "MQJMS2000"));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                            if (!Trace.isOn) throw throwable;
                            Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                        }
                        throw throwable;
                    }
                    Trace.trace(this, "redirectMessage finally block");
                }
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS2000"));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        if (Trace.isOn) {
                            Trace.exception(this, "redirectMessage() failed to close queue", (Throwable)mQException);
                        }
                        break block22;
                    }
                }
                break block22;
                {
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            Object var11_18 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "redirectMessage");
            throw throwable;
        }
        Trace.exit(this, "redirectMessage");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void removeSender(MQQueueSender mQQueueSender) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "removeSender");
            }
            super.removeProducer(mQQueueSender);
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "removeSender");
            throw throwable;
        }
        Trace.exit(this, "removeSender");
    }

    MQQueueManager getQM() {
        return this.qm;
    }

    void checkQueueAccess(com.ibm.mq.jms.MQQueue mQQueue) throws JMSException {
        mQQueue.checkAccess((MQQueueConnection)this.connection);
    }
}

