/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageProducer;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import javax.jms.Destination;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.QueueSender;

public class MQQueueSender
extends MQMessageProducer
implements QueueSender {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueSender.java, jms, j521, j521-L020126 02/01/25 15:19:06 @(#) 1.68.1.1";
    private com.ibm.mq.jms.MQQueue queueSpec = null;
    private MQQueue queue = null;
    private MQPutMessageOptions pmo;
    private MQJMSMessage mqMessage = new MQJMSMessage();
    private MQQueueSession session = null;

    MQQueueSender(com.ibm.mq.jms.MQQueue mQQueue, MQQueue mQQueue2, MQQueueSession mQQueueSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.queueSpec = mQQueue;
        this.queue = mQQueue2;
        this.session = mQQueueSession;
        this.pmo = new MQPutMessageOptions(true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Queue getQueue() throws JMSException {
        com.ibm.mq.jms.MQQueue mQQueue;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueue");
            }
            this.checkProducerOpen();
            mQQueue = this.queueSpec;
            Object var3_2 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getQueue");
            throw throwable;
        }
        Trace.exit(this, "getQueue");
        return mQQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(Message message, int n, int n2, long l) throws JMSException {
        try {
            try {
                Trace.checkForTurnTracingOn();
                if (Trace.isOn) {
                    Trace.entry(this, "send(message, d, p, t)");
                }
                if (this.closed) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS3026");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                if (this.session.isClosed()) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.queue == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2001");
                    throw jMSException;
                }
                if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "can't send because session is actively using async delivery");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                this.sendInternal(this.queueSpec, this.queue, message, n, n2, l);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var9_12 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "send(message, d, p, t)");
            throw throwable;
        }
        Trace.exit(this, "send(message, d, p, t)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(Message message) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "send(message)");
                }
                this.send(message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var4_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "send(message)");
            throw throwable;
        }
        Trace.exit(this, "send(message)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void send(Queue queue, Message message, int n, int n2, long l) throws JMSException {
        try {
            try {
                Trace.checkForTurnTracingOn();
                if (Trace.isOn) {
                    Trace.entry(this, "send(queue, message, d,p,t)");
                }
                if (this.closed) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS3026");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                if (this.session.isClosed()) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1024");
                    SessionClosedException sessionClosedException = new SessionClosedException(string);
                    throw sessionClosedException;
                }
                if (this.queueSpec != null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1014");
                    throw jMSException;
                }
                if (!this.session.callingFromOnMessage() && this.session.usingAsyncMode() && this.session.isStarted()) {
                    if (Trace.isOn) {
                        Trace.trace(this, "can't publish because session is actively using async delivery");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string = "MQJMS0003";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                    throw invalidDestinationException;
                }
                com.ibm.mq.jms.MQQueue mQQueue = (com.ibm.mq.jms.MQQueue)queue;
                if (mQQueue == null) {
                    String string = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string);
                    throw invalidDestinationException;
                }
                try {
                    try {
                        this.sendInternal(mQQueue, null, message, n, n2, l);
                    }
                    catch (JMSException jMSException) {
                        boolean bl = false;
                        Exception exception = jMSException.getLinkedException();
                        if (exception != null && exception instanceof MQException) {
                            MQException mQException = (MQException)((Object)exception);
                            boolean bl2 = bl = mQException.reasonCode == 2057 && mQException.completionCode == 2;
                        }
                        if (!bl) throw jMSException;
                        MQQueue mQQueue2 = this.session.getOutputQueue(mQQueue);
                        this.sendInternal(mQQueue, mQQueue2, message, n, n2, l);
                        mQQueue2.close();
                    }
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var14_27 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var14_28 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "send(queue, message, d,p,t)");
            throw throwable;
        }
        Trace.exit(this, "send(queue, message, d,p,t)");
    }

    public void send(Queue queue, Message message) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "send(queue, message)");
        }
        this.send(queue, message, this.getDeliveryMode(), this.getPriority(), this.getTimeToLive());
        if (Trace.isOn) {
            Trace.exit(this, "send(queue, message)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "close");
                }
                this.closed = true;
                if (this.session != null) {
                    this.session.removeSender(this);
                } else if (Trace.isOn) {
                    Trace.trace(this, "session null, can't call removeSender");
                }
                if (this.queue != null) {
                    try {
                        this.queue.close();
                        this.queue = null;
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                Object var4_5 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void sendInternal(com.ibm.mq.jms.MQQueue mQQueue, MQQueue mQQueue2, Message message, int n, int n2, long l) throws JMSException {
        try {
            block58: {
                try {
                    JMSMessage jMSMessage = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "sendInternal");
                    }
                    if (message == null) {
                        if (Trace.isOn) {
                            Trace.trace(this, "sendInternal given a null message");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "message", "null");
                        throw jMSException;
                    }
                    if (!(message instanceof JMSMessage)) {
                        if (Trace.isOn) {
                            Trace.trace(this, "sendInternal publishing alien message of class " + message.getClass().getName());
                        }
                        jMSMessage = JMSMessage._copyFromMessage(this.session, message);
                    } else {
                        jMSMessage = (JMSMessage)message;
                    }
                    boolean bl = this.session.getTransacted();
                    if (bl) {
                        this.pmo.options |= 2;
                        this.pmo.options &= 0xFFFFFFFB;
                    } else {
                        this.pmo.options |= 4;
                        this.pmo.options &= 0xFFFFFFFD;
                    }
                    long l2 = System.currentTimeMillis();
                    try {
                        int n3;
                        String string;
                        int n4;
                        int n5;
                        block61: {
                            block60: {
                                block57: {
                                    block59: {
                                        this.mqMessage.clearMessageData();
                                        this.mqMessage.setFormat("MQHRF2  ");
                                        this.mqMessage.setEncoding(mQQueue.getEncoding());
                                        if (mQQueue2 != null) {
                                            this.mqMessage.setCharacterSet(mQQueue2._getConnectionCCSID());
                                        } else {
                                            this.mqMessage.setCharacterSet(this.session.qm._getConnectionCCSID());
                                        }
                                        jMSMessage.setJMSDestination(mQQueue);
                                        jMSMessage.setJMSTimestamp(l2);
                                        this.mqMessage.setPersistenceFromMD(this.session.getPersistenceFromMD());
                                        long l3 = mQQueue.getExpiry();
                                        if (l3 == -2L) {
                                            if (l == -1L) {
                                                jMSMessage._setTimeToLive(l2, this.getTimeToLive());
                                            } else {
                                                if (l < 0L) {
                                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "timeToLive", String.valueOf(l));
                                                    throw jMSException;
                                                }
                                                jMSMessage._setTimeToLive(l2, l);
                                            }
                                        } else {
                                            jMSMessage._setTimeToLive(l2, l3);
                                        }
                                        n5 = mQQueue.getPriority();
                                        if (n5 != -2) break block59;
                                        if (n2 == -1) {
                                            jMSMessage.setJMSPriority(this.getPriority());
                                            break block57;
                                        } else if (n2 >= 0 && n2 <= 9) {
                                            jMSMessage.setJMSPriority(n2);
                                            break block57;
                                        } else {
                                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(n2));
                                            throw jMSException;
                                        }
                                    }
                                    if (n5 == -1) {
                                        jMSMessage.setJMSPriority(4);
                                    } else {
                                        jMSMessage.setJMSPriority(n5);
                                    }
                                }
                                n4 = mQQueue.getPersistence();
                                if (n4 != -2) break block60;
                                switch (n) {
                                    case -1: {
                                        jMSMessage.setJMSDeliveryMode(this.getDeliveryMode());
                                        break block61;
                                    }
                                    case 1: 
                                    case 2: {
                                        jMSMessage.setJMSDeliveryMode(n);
                                        break block61;
                                    }
                                    default: {
                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "deliveryMode", String.valueOf(n));
                                        throw jMSException;
                                    }
                                }
                            }
                            if (n4 == -1) {
                                jMSMessage.setJMSDeliveryMode(2);
                            } else {
                                jMSMessage.setJMSDeliveryMode(n4);
                            }
                        }
                        Integer n6 = (Integer)jMSMessage.getObjectProperty("JMS_IBM_Encoding");
                        if (n6 != null) {
                            this.mqMessage.setEncoding(n6);
                        }
                        if ((string = jMSMessage.getStringProperty("JMS_IBM_Character_Set")) == null) {
                            n3 = mQQueue.getCCSID();
                        } else {
                            n3 = MQJMSMessage.getCCSID(string);
                            if (n3 == 0) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "JMS_IBM_Character_Set", string);
                                throw jMSException;
                            }
                        }
                        switch (mQQueue.getTargetClient()) {
                            case 1: {
                                this.mqMessage.write(jMSMessage, false, n3);
                                break;
                            }
                            case 0: {
                                this.mqMessage.write(jMSMessage, true, n3);
                                break;
                            }
                            default: {
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS1015", String.valueOf(mQQueue.getTargetClient())));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                String string2 = "MQJMS1015";
                                String string3 = ConfigEnvironment.getErrorMessage(string2, String.valueOf(mQQueue.getTargetClient()));
                                InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                                throw invalidDestinationException;
                            }
                        }
                        if (n5 == -1) {
                            if (Trace.isOn) {
                                Trace.trace(this, "sendInternal fixing MQMD for priority as qdef");
                            }
                            this.mqMessage.setPriority(-1);
                        }
                        if (n4 == -1) {
                            if (Trace.isOn) {
                                Trace.trace(this, "sendInternal fixing MQMD for persistence as qdef");
                            }
                            this.mqMessage.setPersistence(2);
                        }
                    }
                    catch (JMSException jMSException) {
                        throw jMSException;
                    }
                    catch (Exception exception) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1016", exception.toString()));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016", exception.toString());
                        jMSException.setLinkedException(exception);
                        throw jMSException;
                    }
                    try {
                        if (mQQueue2 == null) {
                            this.session.qm.putMsg2(mQQueue.getBaseQueueName(), mQQueue.getBaseQueueManagerName(), (MQMsg2)this.mqMessage, this.pmo);
                        } else {
                            mQQueue2.putMsg2((MQMsg2)this.mqMessage, this.pmo);
                        }
                        this.mqMessage.setHeaderFromMQMD(message);
                    }
                    catch (MQException mQException) {
                        JMSException jMSException;
                        if (mQException.reasonCode == 2052) {
                            String string = "MQJMS3001";
                            String string4 = ConfigEnvironment.getErrorMessage(string);
                            jMSException = new InvalidDestinationException(string4, string);
                        } else {
                            jMSException = ConfigEnvironment.newException("MQJMS2007");
                        }
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                    if (jMSMessage == message) break block58;
                    message.setJMSDestination((Destination)mQQueue);
                    message.setJMSDeliveryMode(n);
                    message.setJMSTimestamp(l2);
                    message.setJMSExpiration(jMSMessage.getJMSExpiration());
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var23_34 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "sendInternal");
            return;
        }
        catch (Throwable throwable) {
            Object var23_35 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "sendInternal");
            throw throwable;
        }
    }
}

