/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageConsumer;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import java.util.Hashtable;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;

public class MQQueueReceiver
extends MQMessageConsumer
implements QueueReceiver {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueReceiver.java, jms, j521, j521-L020126 02/01/25 15:19:42 @(#) 1.84.1.1";
    private static final int CHUNKTIME = 5000;
    public static final int DEFAULT_MAX_ASYNC_ATTEMPTS = 5;
    private com.ibm.mq.jms.MQQueue queueSpec;
    private MQQueue queue;
    private MQGetMessageOptions gmo;
    private MQJMSMessage baseMessage;
    private int acknowledgeMode;
    private MQQueueSession session;
    private boolean needBrowse;
    private MessageListener listener;
    private Hashtable nextGenSeenList;
    private Hashtable prevGenSeenList;
    private int maxAsyncAttempts;
    private String backoutRetryQueue;
    private boolean needsRestart;
    private boolean specialCase;
    private boolean useSPIP;

    MQQueueReceiver(com.ibm.mq.jms.MQQueue mQQueue, String string, MQQueue mQQueue2, boolean bl, int n, MQQueueSession mQQueueSession) throws JMSException {
        block15: {
            this.queueSpec = null;
            this.queue = null;
            this.session = null;
            this.listener = null;
            this.nextGenSeenList = new Hashtable();
            this.prevGenSeenList = new Hashtable();
            this.maxAsyncAttempts = 5;
            this.backoutRetryQueue = null;
            this.needsRestart = true;
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
            }
            this.queueSpec = mQQueue;
            this.baseMessage = new MQJMSMessage();
            this.gmo = new MQGetMessageOptions(true);
            this.gmo.matchOptions = 0;
            this.specialCase = this.setMessageSelector(string, this.baseMessage, this.gmo);
            if (!this.specialCase) {
                this.gmo.matchOptions = 0;
            }
            if (string == null || string.trim().equals("")) {
                this.needBrowse = false;
            } else {
                boolean bl2 = this.needBrowse = !this.specialCase;
            }
            if (this.needBrowse) {
                this.gmo.options |= 0x20;
            } else {
                boolean bl3 = mQQueueSession.getSyncpointAllGets();
                if (bl || bl3 || n == 2 || mQQueueSession.getDistTransactionMode() == 2) {
                    this.useSPIP = false;
                    this.gmo.options |= 2;
                    this.gmo.options &= 0xFFFFFFFB;
                    if (Trace.isOn) {
                        Trace.trace(this, "syncpoint enabled");
                    }
                } else {
                    this.useSPIP = true;
                    this.gmo.options |= 0x1000;
                    this.gmo.options &= 0xFFFFFFFB;
                    if (Trace.isOn) {
                        Trace.trace(this, "using syncpoint if persistent");
                    }
                }
            }
            this.queue = mQQueue2;
            this.acknowledgeMode = n;
            this.session = mQQueueSession;
            try {
                int[] nArray = new int[]{22};
                int[] nArray2 = new int[1];
                mQQueue2.inquire(nArray, nArray2, null);
                String string2 = mQQueue2.getAttributeString(2019, 48).trim();
                int n2 = nArray2[0];
                if (Trace.isOn) {
                    Trace.trace(this, "returned from inquire, threshold = " + n2 + ", borq = '" + string2 + "'");
                }
                if (n2 != 0) {
                    this.maxAsyncAttempts = n2;
                }
                this.backoutRetryQueue = !string2.equals("") ? string2 : mQQueueSession.getDLQName();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block15;
                Trace.trace(this, "constructor: queue.inquire threw " + exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    public void finalize() throws Throwable {
        block5: {
            if (Trace.isOn) {
                Trace.entry(this, "finalize");
            }
            if (this.queue != null) {
                try {
                    this.queue.close();
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block5;
                    Trace.trace(this, "failed to close queue from finalizer: " + (Object)((Object)mQException));
                }
            }
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Queue getQueue() throws JMSException {
        com.ibm.mq.jms.MQQueue mQQueue;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueue");
            }
            this.checkConsumerOpen();
            mQQueue = this.queueSpec;
            Object var3_2 = null;
            if (!Trace.isOn) return mQQueue;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getQueue");
            throw throwable;
        }
        Trace.exit(this, "getQueue");
        return mQQueue;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive() throws JMSException {
        Message message = null;
        try {
            try {
                Trace.checkForTurnTracingOn();
                if (Trace.isOn) {
                    Trace.entry(this, "receive()");
                }
                while ((message = this.receiveInternal(-1L)) == null && !this.session.isClosed()) {
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var5_2 = null;
            if (!Trace.isOn) return message;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "receive()");
            throw throwable;
        }
        Trace.exit(this, "receive()");
        return message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Message receiveNoWait() throws JMSException {
        Message message;
        try {
            Message message2;
            Trace.checkForTurnTracingOn();
            if (Trace.isOn) {
                Trace.entry(this, "receiveNoWait()");
            }
            message = message2 = this.receiveInternal(0L);
            Object var4_3 = null;
            if (!Trace.isOn) return message;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "receiveNoWait()");
            throw throwable;
        }
        Trace.exit(this, "receiveNoWait()");
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Message receive(long l) throws JMSException {
        Message message;
        try {
            try {
                Trace.checkForTurnTracingOn();
                if (Trace.isOn) {
                    Trace.entry(this, "receive(timeout)");
                }
                Message message2 = l == 0L ? this.receive() : this.receiveInternal(l);
                message = message2;
                Object var7_5 = null;
                if (!Trace.isOn) return message;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var7_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "receive(timeout)");
            throw throwable;
        }
        Trace.exit(this, "receive(timeout)");
        return message;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            try {
                if (this.session != null) {
                    this.session.setPlayNice(true);
                }
                MQQueueReceiver mQQueueReceiver = this;
                synchronized (mQQueueReceiver) {
                    if (this.session != null) {
                        this.session.removeConsumer(this);
                    }
                    if (this.listener != null) {
                        if (this.session != null) {
                            this.session.removeAsync(this);
                        }
                        this.listener = null;
                    }
                    this.closed = true;
                    if (this.queue != null) {
                        try {
                            this.queue.close();
                            this.queue = null;
                        }
                        catch (MQException mQException) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                    }
                    if (this.session != null) {
                        this.session.setPlayNice(false);
                    }
                    this.session = null;
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "close throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var6_6 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (this.session != null) {
                this.session.setPlayNice(false);
            }
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MessageListener getMessageListener() throws JMSException {
        MessageListener messageListener;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getMessageListener");
            }
            this.checkConsumerOpen();
            messageListener = this.listener;
            Object var3_2 = null;
            if (!Trace.isOn) return messageListener;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getMessageListener");
            throw throwable;
        }
        Trace.exit(this, "getMessageListener");
        return messageListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setMessageListener(MessageListener messageListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setMessageListener");
        }
        this.checkConsumerOpen();
        try {
            try {
                if (this.closed || this.session == null) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS3033");
                    IllegalStateException illegalStateException = new IllegalStateException(string);
                    throw illegalStateException;
                }
                if (messageListener != null && this.session.hasMessageListener()) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                    throw jMSException;
                }
                this.listener = messageListener;
                if (messageListener == null) {
                    this.session.removeAsync(this);
                }
                this.session.addAsync(this);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setMessageListener");
            throw throwable;
        }
        Trace.exit(this, "setMessageListener");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized boolean receiveAsync(long l) throws NoMsgListenerException, JMSException {
        boolean bl;
        block30: {
            boolean bl2;
            block29: {
                bl = false;
                try {
                    try {
                        if (Trace.isOn) {
                            Trace.entry(this, "receiveAsync");
                        }
                        if (this.closed) {
                            String string = ConfigEnvironment.getErrorMessage("MQJMS3033");
                            IllegalStateException illegalStateException = new IllegalStateException(string);
                            throw illegalStateException;
                        }
                        if (this.listener == null) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1012");
                            throw jMSException;
                        }
                        if (this.queue == null) {
                            throw ConfigEnvironment.newException("MQJMS2001");
                        }
                        boolean bl3 = this.session.getTransacted();
                        Object object = this.session.getTransactionLock();
                        synchronized (object) {
                            if (!this.session.isStarted()) {
                                bl2 = false;
                                // MONITOREXIT @DISABLED, blocks:[0, 1, 7, 28] lbl20 : MonitorExitStatement: MONITOREXIT : var5_8
                                Object var15_10 = null;
                                if (!Trace.isOn) return bl2;
                                break block29;
                            }
                            JMSMessage jMSMessage = this.getMessage(l);
                            if (jMSMessage != null) {
                                if (!bl3 && this.acknowledgeMode == 2) {
                                    jMSMessage._setSession(this.session);
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiveAsync - entering delivery block");
                                }
                                if (this.listener == null) throw new NoMsgListenerException("no message listener registered");
                                boolean bl4 = true;
                                int n = 0;
                                while (true) {
                                    if (!bl4) {
                                        this.acknowledgeOrSet(jMSMessage);
                                        bl = true;
                                        break;
                                    }
                                    try {
                                        bl4 = false;
                                        ++n;
                                        this.listener.onMessage((Message)jMSMessage);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            Logger.log(new LogMessage(2, "MQJMS1034", throwable.toString()));
                                        }
                                        catch (LogException logException) {
                                            System.err.println("failed to log error because of " + logException);
                                        }
                                        if (Trace.isOn) {
                                            Trace.trace(this, "onMessage threw " + throwable);
                                        }
                                        if (!(bl3 || this.acknowledgeMode != 1 && this.acknowledgeMode != 3 || n >= this.maxAsyncAttempts)) {
                                            bl4 = true;
                                            jMSMessage.setJMSRedelivered(true);
                                            continue;
                                        }
                                        try {
                                            if (this.backoutRetryQueue == null) {
                                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1022");
                                                if (!Trace.isOn) throw jMSException;
                                                Trace.trace(this, "receiveAsync() no backout queue defined.");
                                                throw jMSException;
                                            }
                                            this.session.redirectMessage(this.backoutRetryQueue, this.baseMessage);
                                            if (!this.useSPIP || this.baseMessage.getPersistence() == 1) continue;
                                            this.session._acknowledge();
                                        }
                                        catch (JMSException jMSException) {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "failed to redirect message. Closing receiver");
                                            }
                                            try {
                                                Logger.log(new LogMessage(2, "MQJMS1022"));
                                            }
                                            catch (LogException logException) {
                                                System.err.println("failed to log error because of " + logException);
                                            }
                                            this.close();
                                            throw jMSException;
                                        }
                                    }
                                }
                            }
                            break block30;
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var15_12 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "receiveAsync");
                    throw throwable;
                }
            }
            Trace.exit(this, "receiveAsync");
            return bl2;
        }
        Object var15_11 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "receiveAsync");
        return bl;
    }

    void resetBrowse() {
        if (Trace.isOn) {
            Trace.entry(this, "resetBrowse");
        }
        this.needsRestart = true;
        if (Trace.isOn) {
            Trace.exit(this, "resetBrowse");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Message receiveInternal(long l) throws NoMsgListenerException, JMSException {
        JMSMessage jMSMessage;
        block22: {
            Message message;
            block21: {
                Message message2;
                block20: {
                    Message message3;
                    block19: {
                        try {
                            try {
                                long l2;
                                JMSMessage jMSMessage2 = null;
                                if (Trace.isOn) {
                                    Trace.entry(this, "receiveInternal");
                                }
                                if (this.closed) {
                                    String string = ConfigEnvironment.getErrorMessage("MQJMS3033");
                                    IllegalStateException illegalStateException = new IllegalStateException(string);
                                    throw illegalStateException;
                                }
                                if (this.queue == null) {
                                    throw ConfigEnvironment.newException("MQJMS2001");
                                }
                                if (this.session.usingAsyncMode() || this.session.hasMessageListener()) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1013");
                                    throw jMSException;
                                }
                                if (l != -1L && (l > Integer.MAX_VALUE || l < 0L)) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1067");
                                    throw jMSException;
                                }
                                if (l == 0L && this.session.isStopped()) {
                                    message3 = null;
                                    Object var12_11 = null;
                                    if (!Trace.isOn) return message3;
                                    break block19;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiveInternal - waiting for session start");
                                }
                                if (l == -1L) {
                                    this.session.waitForStart();
                                    l2 = -1L;
                                } else {
                                    l2 = this.session.waitForStart(l);
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "receiveInternal - session started");
                                }
                                if (l > 0L && l2 == 0L) {
                                    message2 = null;
                                    break block20;
                                }
                                Object object = this.session.getTransactionLock();
                                synchronized (object) {
                                    if (!this.session.isStarted()) {
                                        message = null;
                                        // MONITOREXIT @DISABLED, blocks:[16, 0, 1, 3] lbl41 : MonitorExitStatement: MONITOREXIT : var8_17
                                        break block21;
                                    }
                                    jMSMessage2 = this.getMessage(l2);
                                    if (jMSMessage2 != null) {
                                        this.acknowledgeOrSet(jMSMessage2);
                                    }
                                }
                                jMSMessage = jMSMessage2;
                                break block22;
                            }
                            catch (JMSException jMSException) {
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "receiveInternal throwing " + (Object)((Object)jMSException));
                                Exception exception = jMSException.getLinkedException();
                                if (exception == null) throw jMSException;
                                Trace.trace(this, "linked exception " + exception);
                                throw jMSException;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var12_15 = null;
                            if (!Trace.isOn) throw throwable;
                            Trace.exit(this, "receiveInternal");
                            throw throwable;
                        }
                    }
                    Trace.exit(this, "receiveInternal");
                    return message3;
                }
                Object var12_12 = null;
                if (!Trace.isOn) return message2;
                Trace.exit(this, "receiveInternal");
                return message2;
            }
            Object var12_13 = null;
            if (!Trace.isOn) return message;
            Trace.exit(this, "receiveInternal");
            return message;
        }
        Object var12_14 = null;
        if (!Trace.isOn) return jMSMessage;
        Trace.exit(this, "receiveInternal");
        return jMSMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getIDFromMessage(MQMsg2 mQMsg2) {
        String string;
        block19: {
            String string2;
            block18: {
                String string3;
                block17: {
                    String string4;
                    block16: {
                        String string5;
                        block15: {
                            String string6;
                            block14: {
                                String string7;
                                block13: {
                                    try {
                                        if (Trace.isOn) {
                                            Trace.entry(this, "getIDFromMessage");
                                        }
                                        if (mQMsg2 == null) {
                                            string7 = null;
                                            Object var13_3 = null;
                                            if (!Trace.isOn) return string7;
                                            break block13;
                                        }
                                        byte[] byArray = mQMsg2.getMessageId();
                                        switch (byArray[0]) {
                                            case 65: {
                                                if (byArray[1] == 77 && byArray[2] == 81 && byArray[3] == 32) break;
                                                string6 = null;
                                                break block14;
                                            }
                                            case 67: {
                                                if (byArray[1] == 83 && byArray[2] == 81 && byArray[3] == 32) break;
                                                string5 = null;
                                                break block15;
                                            }
                                            case -63: {
                                                if (byArray[1] == -44 && byArray[2] == -40 && byArray[3] == 64) break;
                                                string4 = null;
                                                break block16;
                                            }
                                            case -61: {
                                                if (byArray[1] == -30 && byArray[2] == -40 && byArray[3] == 64) break;
                                                string3 = null;
                                                break block17;
                                            }
                                            default: {
                                                string2 = null;
                                                break block18;
                                            }
                                        }
                                        StringBuffer stringBuffer = new StringBuffer();
                                        int n = 4;
                                        while (true) {
                                            if (n >= byArray.length) {
                                                string = stringBuffer.toString();
                                                break block19;
                                            }
                                            int n2 = byArray[n] & 0xFF;
                                            if (n2 < 16) {
                                                stringBuffer.append("0");
                                            }
                                            stringBuffer.append(Integer.toHexString(n2));
                                            ++n;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var13_10 = null;
                                        if (!Trace.isOn) throw throwable;
                                        Trace.exit(this, "getIDFromMessage");
                                        throw throwable;
                                    }
                                }
                                Trace.exit(this, "getIDFromMessage");
                                return string7;
                            }
                            Object var13_4 = null;
                            if (!Trace.isOn) return string6;
                            Trace.exit(this, "getIDFromMessage");
                            return string6;
                        }
                        Object var13_5 = null;
                        if (!Trace.isOn) return string5;
                        Trace.exit(this, "getIDFromMessage");
                        return string5;
                    }
                    Object var13_6 = null;
                    if (!Trace.isOn) return string4;
                    Trace.exit(this, "getIDFromMessage");
                    return string4;
                }
                Object var13_7 = null;
                if (!Trace.isOn) return string3;
                Trace.exit(this, "getIDFromMessage");
                return string3;
            }
            Object var13_8 = null;
            if (!Trace.isOn) return string2;
            Trace.exit(this, "getIDFromMessage");
            return string2;
        }
        Object var13_9 = null;
        if (!Trace.isOn) return string;
        Trace.exit(this, "getIDFromMessage");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JMSMessage getMessage(long l) throws JMSException {
        JMSMessage jMSMessage;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "getMessage");
                }
                boolean bl = true;
                long l2 = 0L;
                int n = 0;
                JMSMessage jMSMessage2 = null;
                Object object = new Object();
                do {
                    int n2;
                    int n3;
                    n = l == -1L ? 5000 : ((n3 = (int)(l - l2)) > 5000 ? 5000 : n3);
                    if (this.needBrowse) {
                        if (Trace.isOn) {
                            Trace.trace(this, "getMessage setting up for browse");
                        }
                        if (bl || l == 0L) {
                            this.gmo.options |= 0;
                            this.gmo.options &= 0xFFFFFFFE;
                            n = 0;
                        } else {
                            this.gmo.options |= 1;
                            this.gmo.options &= 0xFFFFFFFF;
                            if (Trace.isOn) {
                                Trace.trace(this, "getMessage setting waitInterval to " + n);
                            }
                            this.gmo.waitInterval = n;
                        }
                        if (this.needsRestart) {
                            if (Trace.isOn) {
                                Trace.trace(this, "getMessage using browse first");
                            }
                            this.gmo.options &= 0xFFFFFFDF;
                            this.gmo.options |= 0x10;
                            this.needsRestart = false;
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "getMessage using browse next");
                            }
                            this.gmo.options &= 0xFFFFFFEF;
                            this.gmo.options |= 0x20;
                        }
                        this.gmo.options &= 0xFFFFFFFD;
                        this.gmo.options &= 0xFFFFEFFF;
                        this.gmo.options |= 4;
                    } else {
                        if (l == 0L) {
                            if (Trace.isOn) {
                                Trace.trace(this, "getMessage setting no wait");
                            }
                            this.gmo.options |= 0;
                            this.gmo.options &= 0xFFFFFFFE;
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "getMessage setting waitInterval");
                            }
                            this.gmo.options |= 1;
                            this.gmo.options &= 0xFFFFFFFF;
                            this.gmo.waitInterval = n;
                        }
                        this.gmo.options &= 0xFFFFFFDF;
                        this.gmo.options &= 0xFFFFFFFB;
                        this.gmo.options = this.useSPIP ? (this.gmo.options |= 0x1000) : (this.gmo.options |= 2);
                    }
                    if (!this.specialCase) {
                        this.gmo.matchOptions = 0;
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "getMessage GET");
                        }
                        this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo);
                        if (Trace.isOn) {
                            Trace.trace(this, "getMessage GET done");
                        }
                        if (this.needBrowse) {
                            String string = this.getIDFromMessage(this.baseMessage);
                            int n4 = n2 = string != null && this.prevGenSeenList.containsKey(string) && !this.nextGenSeenList.containsKey(string) ? 1 : 0;
                            if (n2 != 0) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "message found in seen list. Skipping.");
                                }
                                this.nextGenSeenList.put(string, object);
                                jMSMessage2 = null;
                                continue;
                            }
                            jMSMessage2 = this.baseMessage.createJMSMessage(this.session);
                            if (this.messageSelector.isSelected(jMSMessage2, this.baseMessage)) {
                                Object var14_19;
                                if (Trace.isOn) {
                                    Trace.trace(this, "getMessage() message accepted");
                                }
                                this.gmo.options = this.useSPIP ? (this.gmo.options |= 0x1000) : (this.gmo.options |= 2);
                                this.gmo.options &= 0xFFFFFFFB;
                                this.gmo.options &= 0xFFFFFFDF;
                                this.gmo.options &= 0xFFFFFFEF;
                                this.gmo.options |= 0x100;
                                try {
                                    try {
                                        this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo);
                                    }
                                    catch (MQException mQException) {
                                        if (mQException.reasonCode == 2034) {
                                            jMSMessage2 = null;
                                            if (Trace.isOn) {
                                                Trace.trace(this, "couldn't dequeue message - message expired or competing consumers?");
                                            }
                                        } else {
                                            if (mQException.reasonCode != 2033) {
                                                JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                                                jMSException.setLinkedException((Exception)((Object)mQException));
                                                throw jMSException;
                                            }
                                            jMSMessage2 = null;
                                            if (Trace.isOn) {
                                                Trace.trace(this, "couldn't dequeue message - message expired or competing consumers?");
                                            }
                                        }
                                        var14_19 = null;
                                        this.gmo.options &= 0xFFFFFEFF;
                                        continue;
                                    }
                                    var14_19 = null;
                                    this.gmo.options &= 0xFFFFFEFF;
                                    continue;
                                }
                                catch (Throwable throwable) {
                                    var14_19 = null;
                                    this.gmo.options &= 0xFFFFFEFF;
                                    throw throwable;
                                }
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "getMessage() message rejected");
                            }
                            if (string != null) {
                                this.nextGenSeenList.put(string, object);
                            }
                            jMSMessage2 = null;
                            continue;
                        }
                        jMSMessage2 = this.baseMessage.createJMSMessage(this.session);
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode != 2033) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                        if (this.session.isClosed()) {
                            if (Trace.isOn) {
                                Trace.trace(this, "session closed, aborting receive");
                            }
                            JMSMessage jMSMessage3 = null;
                            Object var16_22 = null;
                            if (!Trace.isOn) return jMSMessage3;
                            Trace.exit(this, "getMessage");
                            return jMSMessage3;
                        }
                        l2 += (long)n;
                        if (Trace.isOn) {
                            Trace.trace(this, "used " + l2 + " of " + l + " ms");
                        }
                        if (l != -1L && l2 >= l) {
                            JMSMessage jMSMessage4 = null;
                            Object var16_23 = null;
                            if (!Trace.isOn) return jMSMessage4;
                            Trace.exit(this, "getMessage");
                            return jMSMessage4;
                        }
                        if (!this.needBrowse) continue;
                        if (bl) {
                            bl = false;
                            if (Trace.isOn) {
                                Trace.trace(this, "reached end of first pass");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "requesting restart");
                        }
                        this.needsRestart = true;
                        this.prevGenSeenList = this.nextGenSeenList;
                        n2 = this.prevGenSeenList.size();
                        if (n2 < 10) {
                            n2 = 10;
                        }
                        this.nextGenSeenList = new Hashtable(n2);
                    }
                    catch (IOException iOException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1000");
                        jMSException.setLinkedException((Exception)iOException);
                        throw jMSException;
                    }
                } while (jMSMessage2 == null);
                jMSMessage = jMSMessage2;
                Object var16_24 = null;
                if (!Trace.isOn) return jMSMessage;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getMessage");
            throw throwable;
        }
        Trace.exit(this, "getMessage");
        return jMSMessage;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void acknowledgeOrSet(JMSMessage jMSMessage) throws JMSException {
        try {
            block12: {
                if (Trace.isOn) {
                    Trace.entry(this, "acknowledgeOrSet");
                }
                if (this.session.getTransacted()) break block12;
                if (Trace.isOn) {
                    Trace.trace(this, "acknowledgeOrSet - checking ack mode");
                }
                switch (this.acknowledgeMode) {
                    case 2: {
                        jMSMessage._setSession(this.session);
                        break;
                    }
                    case 1: 
                    case 3: {
                        if (this.useSPIP) {
                            if (this.baseMessage.getPersistence() == 1) {
                                this.session._acknowledge();
                            }
                            break;
                        }
                        this.session._acknowledge();
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1001", new Integer(this.acknowledgeMode));
                        throw jMSException;
                    }
                }
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "acknowledgeOrSet");
            throw throwable;
        }
        Trace.exit(this, "acknowledgeOrSet");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
    }

    static {
        Trace.trace("MQQueueReceiver init ", sccsid);
    }
}

