/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQC;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQQueue;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.IOException;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import javax.jms.JMSException;

public class MQQueueEnumeration
implements Enumeration {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueEnumeration.java, jms, j521, j521-L020126 02/01/25 15:26:14 @(#) 1.19.1.1";
    private MQQueueSession session;
    private MQQueue queue;
    private JMSMessage message;
    private boolean bufferFilled = false;
    private MQJMSMessage baseMessage;
    private MQGetMessageOptions gmo;
    private MQMessageSelector messageSelector;

    MQQueueEnumeration(MQQueueSession mQQueueSession, MQQueue mQQueue, MQMessageSelector mQMessageSelector) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "MQQueueEnumeration constructor");
        }
        this.session = mQQueueSession;
        this.queue = mQQueue;
        this.messageSelector = mQMessageSelector;
        this.gmo = new MQGetMessageOptions();
        this.gmo.options |= 0x10;
        this.baseMessage = new MQJMSMessage();
        if (Trace.isOn) {
            Trace.exit(this, "MQQueueEnumeration constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean hasMoreElements() {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "hasMoreElements");
            }
            if (this.bufferFilled) {
                if (Trace.isOn) {
                    Trace.trace(this, "hasMoreElements found previously cached message");
                }
                bl2 = true;
            } else {
                block11: {
                    try {
                        this.message = null;
                        this.message = this.retrieveMessage();
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) break block11;
                        Trace.trace(this, "hasMoreElements caught " + (Object)((Object)jMSException));
                    }
                }
                if (this.message == null) {
                    bl2 = false;
                } else {
                    this.bufferFilled = true;
                    bl2 = true;
                    if (Trace.isOn) {
                        Trace.trace(this, "hasMoreElements put message in cache");
                    }
                }
            }
            bl = bl2;
            Object var4_4 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "hasMoreElements");
            throw throwable;
        }
        Trace.exit(this, "hasMoreElements");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object nextElement() throws NoSuchElementException {
        JMSMessage jMSMessage;
        try {
            try {
                JMSMessage jMSMessage2;
                block14: {
                    jMSMessage2 = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "nextElement");
                    }
                    if (this.bufferFilled) {
                        jMSMessage2 = this.message;
                        this.bufferFilled = false;
                    } else {
                        try {
                            jMSMessage2 = this.retrieveMessage();
                        }
                        catch (JMSException jMSException) {
                            if (Trace.isOn) {
                                Trace.exception(this, "nextElement caught exception thrown by retrieveMessage()", (Throwable)jMSException);
                            }
                        }
                        catch (Exception exception) {
                            try {
                                Logger.log(new LogMessage(2, "MQJMS1016", exception.toString()));
                            }
                            catch (LogException logException) {
                                System.err.println("failed to log error because of " + logException);
                            }
                            if (!Trace.isOn) break block14;
                            Trace.exception(this, "nextElement caught unexpected exception thrown by retrieveMessage()", (Throwable)exception);
                        }
                    }
                }
                if (jMSMessage2 == null) {
                    throw new NoSuchElementException();
                }
                jMSMessage = jMSMessage2;
                Object var6_7 = null;
                if (!Trace.isOn) return jMSMessage;
            }
            catch (NoSuchElementException noSuchElementException) {
                if (!Trace.isOn) throw noSuchElementException;
                Trace.trace(this, "Throwing " + noSuchElementException);
                throw noSuchElementException;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "nextElement");
            throw throwable;
        }
        Trace.exit(this, "nextElement");
        return jMSMessage;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JMSMessage retrieveMessage() throws JMSException {
        JMSMessage jMSMessage;
        block22: {
            JMSMessage jMSMessage2;
            block21: {
                try {
                    try {
                        JMSMessage jMSMessage3 = null;
                        if (Trace.isOn) {
                            Trace.entry(this, "retrieveMessage");
                        }
                        if (this.queue == null) {
                            jMSMessage2 = null;
                            Object var8_6 = null;
                            if (!Trace.isOn) return jMSMessage2;
                            break block21;
                        }
                        while (true) {
                            if (jMSMessage3 != null) {
                                jMSMessage = jMSMessage3;
                                break block22;
                            }
                            this.baseMessage.setMessageId(MQC.MQMI_NONE);
                            this.baseMessage.setCorrelationId(MQC.MQCI_NONE);
                            try {
                                this.queue.getMsg2((MQMsg2)this.baseMessage, this.gmo);
                                jMSMessage3 = this.baseMessage.createJMSMessage(this.session);
                            }
                            catch (MQException mQException) {
                                block23: {
                                    if (mQException.reasonCode != 2033) {
                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1025");
                                        jMSException.setLinkedException((Exception)((Object)mQException));
                                        throw jMSException;
                                    }
                                    try {
                                        try {
                                            this.queue.close();
                                        }
                                        catch (MQException mQException2) {
                                            try {
                                                Logger.log(new LogMessage(2, "MQJMS2000"));
                                            }
                                            catch (LogException logException) {
                                                System.err.println("failed to log error because of " + logException);
                                            }
                                            Object var6_11 = null;
                                            this.queue = null;
                                            break block23;
                                        }
                                        Object var6_10 = null;
                                        this.queue = null;
                                    }
                                    catch (Throwable throwable) {
                                        Object var6_12 = null;
                                        this.queue = null;
                                        throw throwable;
                                    }
                                }
                                if (Trace.isOn) {
                                    Trace.exit(this, "retrieveMessage");
                                }
                                JMSMessage jMSMessage4 = null;
                                Object var8_7 = null;
                                if (!Trace.isOn) return jMSMessage4;
                                Trace.exit(this, "retrieveMessage");
                                return jMSMessage4;
                            }
                            catch (IOException iOException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1000");
                                jMSException.setLinkedException((Exception)iOException);
                                throw jMSException;
                            }
                            if (this.messageSelector != null && !this.messageSelector.isSelected(jMSMessage3, this.baseMessage)) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "retrieveMessage() message rejected");
                                }
                                jMSMessage3 = null;
                            }
                            this.gmo.options &= 0xFFFFFFEF;
                            this.gmo.options |= 0x20;
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_9 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "retrieveMessage");
                    throw throwable;
                }
            }
            Trace.exit(this, "retrieveMessage");
            return jMSMessage2;
        }
        Object var8_8 = null;
        if (!Trace.isOn) return jMSMessage;
        Trace.exit(this, "retrieveMessage");
        return jMSMessage;
    }
}

