/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQQueueConnectionFactory
extends MQConnectionFactory
implements QueueConnectionFactory,
Referenceable,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueConnectionFactory.java, jms, j521, j521-L020601 02/05/31 12:02:50 @(#) 1.35.1.1";
    static final long serialVersionUID = 3763813191978525893L;
    public static final String KEY_TEMPORARY_MODEL = "TM";
    public static final String KEY_MESSAGE_RETENTION = "MRET";
    private String temporaryModel = "SYSTEM.DEFAULT.MODEL.QUEUE";
    private int messageRetention = 1;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueConnectionFactory;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTemporaryModel(String string) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setTemporaryModel");
                }
                if (string == null || string.length() > 48) {
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "<null>";
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "temporaryModel", string2);
                    throw jMSException;
                }
                this.temporaryModel = string;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setTemporaryModel");
            throw throwable;
        }
        Trace.exit(this, "setTemporaryModel");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getTemporaryModel() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTemporaryModel");
            }
            string = this.temporaryModel;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getTemporaryModel");
            throw throwable;
        }
        Trace.exit(this, "getTemporaryModel");
        return string;
    }

    public void setMessageRetention(int n) throws JMSException {
        if (n != 1 && n != 0) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "messageRetention", new Integer(n));
            throw jMSException;
        }
        this.messageRetention = n;
    }

    public int getMessageRetention() {
        return this.messageRetention;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueConnection createQueueConnection() throws JMSException {
        MQQueueConnection mQQueueConnection;
        try {
            try {
                MQQueueConnection mQQueueConnection2;
                if (Trace.isOn) {
                    Trace.entry(this, "createQueueConnection");
                }
                mQQueueConnection = mQQueueConnection2 = new MQQueueConnection(this);
                Object var4_5 = null;
                if (!Trace.isOn) return mQQueueConnection;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueueConnection");
            throw throwable;
        }
        Trace.exit(this, "createQueueConnection");
        return mQQueueConnection;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public QueueConnection createQueueConnection(String string, String string2) throws JMSException {
        MQQueueConnection mQQueueConnection;
        try {
            try {
                MQQueueConnection mQQueueConnection2;
                if (Trace.isOn) {
                    Trace.entry(this, "createQueueConnection");
                    Trace.trace(this, "userName, password = " + string + ", " + string2);
                }
                int n = this.getTransportType();
                switch (n) {
                    case 1: 
                    case 3: {
                        mQQueueConnection2 = new MQQueueConnection(this, string, string2);
                        break;
                    }
                    case 0: {
                        String string3 = (String)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                return System.getProperty("user.name");
                            }
                        });
                        if (!string3.equals(string)) {
                            String string4 = "MQJMS2013";
                            String string5 = ConfigEnvironment.getErrorMessage(string4);
                            throw new JMSSecurityException(string5, string4);
                        }
                        mQQueueConnection2 = new MQQueueConnection(this);
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                        throw jMSException;
                    }
                }
                mQQueueConnection = mQQueueConnection2;
                Object var10_12 = null;
                if (!Trace.isOn) return mQQueueConnection;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Exception exception = jMSException.getLinkedException();
                Trace.trace(this, "Caught & Throwing " + (Object)((Object)jMSException));
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception: " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueueConnection");
            throw throwable;
        }
        Trace.exit(this, "createQueueConnection");
        return mQQueueConnection;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reference getReference() throws NamingException {
        Reference reference;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            Reference reference2 = new Reference((class$com$ibm$mq$jms$MQQueueConnectionFactory == null ? (class$com$ibm$mq$jms$MQQueueConnectionFactory = MQQueueConnectionFactory.class$("com.ibm.mq.jms.MQQueueConnectionFactory")) : class$com$ibm$mq$jms$MQQueueConnectionFactory).getName(), (class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory == null ? (class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory = MQQueueConnectionFactory.class$("com.ibm.mq.jms.MQQueueConnectionFactoryFactory")) : class$com$ibm$mq$jms$MQQueueConnectionFactoryFactory).getName(), null);
            this.populateReference(reference2);
            reference = reference2;
            Object var4_3 = null;
            if (!Trace.isOn) return reference;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getReference");
            throw throwable;
        }
        Trace.exit(this, "getReference");
        return reference;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl2 = false;
            } else if (object instanceof MQQueueConnectionFactory) {
                MQQueueConnectionFactory mQQueueConnectionFactory = (MQQueueConnectionFactory)object;
                bl2 = super.equals(object) && MQConnectionFactory.twoStringsEqual(this.temporaryModel, mQQueueConnectionFactory.temporaryModel) && this.messageRetention == mQQueueConnectionFactory.messageRetention;
            } else {
                bl2 = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl2);
            }
            bl = bl2;
            Object var6_5 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "equals");
            throw throwable;
        }
        Trace.exit(this, "equals");
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.temporaryModel != null) {
            n ^= this.temporaryModel.hashCode();
        }
        return n ^= this.messageRetention << 13;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void populateReference(Reference reference) {
        String string = null;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "populateReference");
            }
            super.updateReference(reference);
            string = this.getTemporaryModel();
            if (string != null) {
                reference.add(new StringRefAddr(KEY_TEMPORARY_MODEL, string));
            }
            reference.add(new StringRefAddr(KEY_MESSAGE_RETENTION, String.valueOf(this.getMessageRetention())));
            Object var4_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "populateReference");
            throw throwable;
        }
        Trace.exit(this, "populateReference");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setFromReference(Reference reference) throws JMSException {
        try {
            block6: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "setFromReference");
                    }
                    super.setFromReference(reference);
                    RefAddr refAddr = reference.get(KEY_TEMPORARY_MODEL);
                    if (refAddr != null) {
                        this.setTemporaryModel((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_MESSAGE_RETENTION)) == null) break block6;
                    this.setMessageRetention(Integer.parseInt((String)refAddr.getContent()));
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception " + exception);
                    throw jMSException;
                }
            }
            Object var6_3 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "setFromReference");
            return;
        }
        catch (Throwable throwable) {
            Object var6_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setFromReference");
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

