/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQRRSQueueManager;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionConsumer;
import com.ibm.mq.jms.MQQueueConnectionFactory;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQRRSQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTemporaryQueue;
import com.ibm.mq.jms.MQXAQueueConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.lang.reflect.Constructor;
import javax.jms.ConnectionConsumer;
import javax.jms.IllegalStateException;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueSession;
import javax.jms.ServerSessionPool;

public class MQQueueConnection
extends MQConnection
implements QueueConnection {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueConnection.java, jms, j521, j521-L020601 02/05/31 12:02:46 @(#) 1.50.1.2";
    private MQQueueManager tempQqm = null;
    private MQQueueManager initialQm = null;
    private String qmName = null;
    private final int tmpQOpenOptions = 32;
    private String temporaryModelQ;
    private int messageRetention;

    MQQueueConnection(MQQueueConnectionFactory mQQueueConnectionFactory) throws JMSException {
        this(mQQueueConnectionFactory, null, null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQQueueConnection(MQQueueConnectionFactory mQQueueConnectionFactory, String string, String string2) throws JMSException {
        super(mQQueueConnectionFactory);
        try {
            try {
                MQRRSQueueManager mQRRSQueueManager;
                String string3;
                if (Trace.isOn) {
                    Trace.entry(this, "constructor");
                    Trace.trace(this, sccsid);
                }
                if ((string3 = mQQueueConnectionFactory.getClientId()) != null) {
                    this.setClientID(string3);
                }
                this.qmgrName = mQQueueConnectionFactory.getQueueManager();
                this.temporaryModelQ = mQQueueConnectionFactory.getTemporaryModel();
                this.messageRetention = mQQueueConnectionFactory.getMessageRetention();
                switch (mQQueueConnectionFactory.getTransportType()) {
                    case 0: {
                        this.mqProperties.put("transport", "MQSeries Bindings");
                        break;
                    }
                    case 3: {
                        this.mqProperties.put("transport", "MQJD");
                        break;
                    }
                    case 1: {
                        this.mqProperties.put("transport", "MQSeries");
                        this.mqProperties.put("CCSID", new Integer(mQQueueConnectionFactory.getCCSID()));
                        this.mqProperties.put("channel", mQQueueConnectionFactory.getChannel());
                        this.mqProperties.put("hostname", mQQueueConnectionFactory.getHostName());
                        this.mqProperties.put("port", new Integer(mQQueueConnectionFactory.getPort()));
                        if (string != null) {
                            this.mqProperties.put("userID", string);
                        }
                        if (string2 != null) {
                            this.mqProperties.put("password", string2);
                        }
                        String string4 = "<unset>";
                        try {
                            String string5;
                            string4 = mQQueueConnectionFactory.getReceiveExit();
                            if (string4 != null) {
                                string5 = mQQueueConnectionFactory.getReceiveExitInit();
                                mQRRSQueueManager = (MQReceiveExit)this.newExitInstance(string4, string5);
                                this.mqProperties.put("receiveExit", mQRRSQueueManager);
                            }
                            if ((string4 = mQQueueConnectionFactory.getSecurityExit()) != null) {
                                string5 = mQQueueConnectionFactory.getSecurityExitInit();
                                mQRRSQueueManager = (MQSecurityExit)this.newExitInstance(string4, string5);
                                this.mqProperties.put("securityExit", mQRRSQueueManager);
                            }
                            if ((string4 = mQQueueConnectionFactory.getSendExit()) == null) break;
                            string5 = mQQueueConnectionFactory.getSendExitInit();
                            mQRRSQueueManager = (MQSendExit)this.newExitInstance(string4, string5);
                            this.mqProperties.put("sendExit", mQRRSQueueManager);
                            break;
                        }
                        catch (JMSException jMSException) {
                            throw jMSException;
                        }
                        catch (Exception exception) {
                            jMSException = ConfigEnvironment.newException("MQJMS1007", string4);
                            jMSException.setLinkedException(exception);
                            throw jMSException;
                        }
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(mQQueueConnectionFactory.getTransportType()));
                        throw jMSException;
                    }
                }
                if (this instanceof MQXAQueueConnection) {
                    this.initialQm = this.createQMXA();
                    try {
                        try {
                            this.initialQm.disconnect();
                        }
                        catch (Exception exception) {
                            Object var10_16 = null;
                            this.initialQm = null;
                        }
                        Object var10_15 = null;
                        this.initialQm = null;
                    }
                    catch (Throwable throwable) {
                        Object var10_17 = null;
                        this.initialQm = null;
                        throw throwable;
                    }
                }
                if (this instanceof MQRRSQueueConnection) {
                    this.initialQm = this.createQMNonXA();
                    mQRRSQueueManager = new MQRRSQueueManager(this.initialQm);
                    try {
                        mQRRSQueueManager.honourRRS();
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        try {
                            this.initialQm.disconnect();
                        }
                        catch (MQException mQException2) {
                            // empty catch block
                        }
                        this.initialQm = null;
                        throw jMSException;
                    }
                }
                this.initialQm = this.createQMNonXA();
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var12_21 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var12_22 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor");
            throw throwable;
        }
        Trace.exit(this, "constructor");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void finalize() throws Throwable {
        try {
            block7: {
                if (Trace.isOn) {
                    Trace.entry(this, "finalize");
                }
                try {
                    this.close();
                }
                catch (Exception exception) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1032", exception.toString()));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    if (!Trace.isOn) break block7;
                    Trace.trace(this, "finalize caught " + exception);
                }
            }
            super.finalize();
            Object var4_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "finalize");
            throw throwable;
        }
        Trace.exit(this, "finalize");
    }

    public QueueSession createQueueSession(boolean bl, int n) throws JMSException {
        return this.createQueueSession(bl, n, 0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close() throws JMSException {
        try {
            block10: {
                try {
                    if (Trace.isOn) {
                        Trace.entry(this, "close");
                    }
                    if (this.tempQqm != null) {
                        try {
                            this.tempQqm.disconnect();
                            this.tempQqm = null;
                        }
                        catch (Exception exception) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2003");
                            jMSException.setLinkedException(exception);
                            throw jMSException;
                        }
                    }
                    super.close();
                    if (this.initialQm == null) break block10;
                    try {
                        this.initialQm.disconnect();
                    }
                    catch (MQException mQException) {
                        // empty catch block
                    }
                    this.initialQm = null;
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception " + exception);
                    throw jMSException;
                }
            }
            Object var4_6 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "close");
            return;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQTemporaryQueue createTemporaryQueue() throws JMSException {
        MQTemporaryQueue mQTemporaryQueue;
        try {
            try {
                MQQueue mQQueue;
                MQTemporaryQueue mQTemporaryQueue2 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "createTemporaryQueue");
                }
                if (this.tempQqm == null) {
                    this.tempQqm = this.createQMNonXA();
                    try {
                        int n = 2015;
                        this.qmName = this.tempQqm.getAttributeString(n, 48).trim();
                    }
                    catch (Exception exception) {
                        this.qmName = this.tempQqm.name;
                    }
                }
                try {
                    mQQueue = this.tempQqm.accessQueue(this.temporaryModelQ, 32);
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3000", this.temporaryModelQ);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                mQTemporaryQueue = mQTemporaryQueue2 = new MQTemporaryQueue(this.qmName, mQQueue, this);
                Object var6_10 = null;
                if (!Trace.isOn) return mQTemporaryQueue;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createTemporaryQueue");
            throw throwable;
        }
        Trace.exit(this, "createTemporaryQueue");
        return mQTemporaryQueue;
    }

    int getMessageRetention() {
        return this.messageRetention;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    synchronized QueueSession createQueueSession(boolean bl, int n, int n2) throws JMSException {
        Object object;
        try {
            try {
                Object object2;
                MQQueueManager mQQueueManager = null;
                if (Trace.isOn) {
                    Trace.entry(this, "createQueueSession");
                }
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        if (!Trace.isOn) break;
                        Trace.trace(this, "distributed transactional mode " + n2);
                        break;
                    }
                    default: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Bad distributed transactional mode " + n2);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
                if (this.isClosed()) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                this.setClientIDFixed();
                if (this.initialQm != null) {
                    mQQueueManager = this.initialQm;
                    this.initialQm = null;
                } else {
                    switch (n2) {
                        case 0: {
                            mQQueueManager = this.createQMNonXA();
                            break;
                        }
                        case 1: {
                            mQQueueManager = this.createQMXA();
                            break;
                        }
                        case 2: {
                            mQQueueManager = this.createQMNonXA();
                            object2 = new MQRRSQueueManager(mQQueueManager);
                            try {
                                object2.honourRRS();
                                break;
                            }
                            catch (MQException mQException) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.qmgrName);
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                try {
                                    mQQueueManager.disconnect();
                                }
                                catch (MQException mQException2) {
                                    // empty catch block
                                }
                                mQQueueManager = null;
                                throw jMSException;
                            }
                        }
                        default: {
                            if (Trace.isOn) {
                                Trace.trace(this, "Distibuted transactional mode unexpectedly changed! Now " + n2);
                            }
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                            throw jMSException;
                        }
                    }
                }
                object2 = new MQQueueSession(this, mQQueueManager, bl, n);
                ((MQSession)object2).setDistTransactionMode(n2);
                this.addSession((MQSession)object2);
                if (this.isStarted()) {
                    try {
                        ((MQSession)object2).start();
                    }
                    catch (JMSException jMSException) {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1033", jMSException.toString()));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                    }
                }
                object = object2;
                Object var11_18 = null;
                if (!Trace.isOn) return object;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linkedException " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQueueSession");
            throw throwable;
        }
        Trace.exit(this, "createQueueSession");
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object newExitInstance(String string, String string2) throws JMSException {
        Object object;
        try {
            try {
                Object t;
                if (Trace.isOn) {
                    Trace.entry(this, "newExitInstance");
                    object = string2 != null ? string2 : "<null>";
                    Trace.trace(this, "classname = " + string + ", initString = " + (String)object);
                }
                try {
                    Constructor constructor;
                    Object[] objectArray;
                    object = Class.forName(string);
                    Class<?> clazz = Class.forName("java.lang.String");
                    try {
                        objectArray = new Class[]{clazz};
                        constructor = ((Class)object).getConstructor((Class<?>[])objectArray);
                    }
                    catch (NoSuchMethodException noSuchMethodException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1009");
                        jMSException.setLinkedException((Exception)noSuchMethodException);
                        throw jMSException;
                    }
                    objectArray = new Object[]{string2};
                    t = constructor.newInstance(objectArray);
                }
                catch (JMSException jMSException) {
                    throw jMSException;
                }
                catch (Exception exception) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                object = t;
                Object var10_14 = null;
                if (!Trace.isOn) return object;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "newExitInstance");
            throw throwable;
        }
        Trace.exit(this, "newExitInstance");
        return object;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ConnectionConsumer createConnectionConsumer(Queue queue, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        MQConnectionConsumer mQConnectionConsumer;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "createConnectionConsumer");
                }
                if (!(queue instanceof com.ibm.mq.jms.MQQueue)) {
                    String string2 = "MQJMS0003";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string3, string2);
                    throw invalidDestinationException;
                }
                ((com.ibm.mq.jms.MQQueue)queue).checkAccess(this);
                MQConnectionConsumer mQConnectionConsumer2 = new MQConnectionConsumer(this, (com.ibm.mq.jms.MQQueue)queue, string, serverSessionPool, n);
                this.addConsumer(mQConnectionConsumer2);
                mQConnectionConsumer = mQConnectionConsumer2;
                Object var9_11 = null;
                if (!Trace.isOn) return mQConnectionConsumer;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createConnectionConsumer");
            throw throwable;
        }
        Trace.exit(this, "createConnectionConsumer");
        return mQConnectionConsumer;
    }
}

