/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.DLH;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageGroup;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueueAgent;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import javax.jms.JMSException;

class MQQueueAgentThread
implements Runnable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueAgentThread.java, jms, j521, j521-L020126 02/01/25 15:24:17 @(#) 1.18.1.1";
    private static final int BROWSE_FIRST = 0;
    private static final int BROWSE_NEXT = 1;
    private static final int BROWSE_SPECIFIC = 2;
    private MQQueueAgent mqQueueAgent;
    private String qmgrName;
    private String qName;
    private MQConnection jmsConnection;
    private MQSession jmsSession;
    private MQQueueManager mqQueueManager;
    private MQQueue mqQueue;
    private String mqBORQName = null;
    private int backoutThreshold;
    private MQGetMessageOptions mqGMO;
    private MQMessageGroup oldGroup = new MQMessageGroup();
    private MQMessageGroup curGroup = new MQMessageGroup();
    private boolean retainMessages = false;
    private boolean redeliverUnwanted = false;
    private long stopTime;
    private boolean stopTimeLocked;
    private boolean fullMessages = true;
    private boolean active = false;
    private boolean quit = false;
    private JMSException exception = null;
    private int oldCount;
    private int newCount;
    private int failedCount;
    private Thread thread;

    MQQueueAgentThread(MQQueueAgent mQQueueAgent, MQConnection mQConnection, String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.mqQueueAgent = mQQueueAgent;
        this.jmsConnection = mQConnection;
        this.qmgrName = string;
        this.qName = string2;
        String string3 = "MQQueueAgent (" + string2 + ")";
        this.thread = MQEnvironment.createThread((Runnable)this, (String)string3, (boolean)true);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void go() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "go");
        }
        this.thread.start();
        MQQueueAgentThread mQQueueAgentThread = this;
        // MONITORENTER : mQQueueAgentThread
        while (!this.active && this.exception == null) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "go() waiting for thread to start up");
                }
                this.wait();
                if (!Trace.isOn) continue;
                Trace.trace(this, "go() woken up");
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : mQQueueAgentThread
        if (!Trace.isOn) return;
        Trace.exit(this, "go");
    }

    void retainAllMessages() {
        if (Trace.isOn) {
            Trace.entry(this, "retainAllMessages");
        }
        this.retainMessages = true;
        if (Trace.isOn) {
            Trace.entry(this, "retainAllMessages");
        }
    }

    void redeliverUnwanted() {
        if (Trace.isOn) {
            Trace.entry(this, "redeliverUnwanted");
        }
        this.redeliverUnwanted = true;
        if (Trace.isOn) {
            Trace.exit(this, "redeliverUnwanted");
        }
    }

    void quit() {
        if (Trace.isOn) {
            Trace.entry(this, "quit");
        }
        this.quit = true;
        if (Trace.isOn) {
            Trace.exit(this, "quit");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void waitForEnd() {
        if (Trace.isOn) {
            Trace.entry(this, "waitForEnd");
            Trace.trace(this, "Waiting for thread to finish");
        }
        MQQueueAgentThread mQQueueAgentThread = this;
        // MONITORENTER : mQQueueAgentThread
        while (this.active && this.exception == null) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        // MONITOREXIT : mQQueueAgentThread
        if (!Trace.isOn) return;
        Trace.exit(this, "waitForEnd");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setup() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setup");
        }
        try {
            block17: {
                try {
                    this.mqQueueManager = this.jmsConnection.createQMNonXA();
                    this.jmsSession = this.jmsConnection instanceof MQQueueConnection ? new MQQueueSession(null, this.mqQueueManager, false, 0) : new MQTopicSession(this.mqQueueManager, null, null);
                    if (Trace.isOn) {
                        Trace.trace(this, "session created");
                    }
                    this.jmsConnection = null;
                    try {
                        int n = 8362;
                        this.mqQueue = this.mqQueueManager.accessQueue(this.qName, n);
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                        if (Trace.isOn) {
                            Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                        }
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                    this.mqGMO = new MQGetMessageOptions();
                    this.backoutThreshold = Utils.inquireInt((MQManagedObject)this.mqQueue, 22);
                    if (this.backoutThreshold != -1) break block17;
                    if (Trace.isOn) {
                        Trace.trace(this, "Inquire on backoutThreshold failed. Defaulting to 20.");
                    }
                    this.backoutThreshold = 20;
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    }
                    try {
                        if (this.jmsSession != null) {
                            this.jmsSession.close();
                        }
                        if (this.mqQueueManager != null) {
                            this.mqQueueManager.disconnect();
                        }
                    }
                    catch (JMSException jMSException2) {
                    }
                    catch (MQException mQException) {
                        // empty catch block
                    }
                    this.jmsSession = null;
                    this.mqQueueManager = null;
                    this.mqQueue = null;
                    this.mqGMO = null;
                    throw jMSException;
                }
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "setup");
            return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setup");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void shutdown() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "shutdown");
        }
        try {
            block6: {
                try {
                    if (this.jmsSession == null) break block6;
                    this.jmsSession.close();
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.exception(this, "shutdown", (Throwable)jMSException);
                    }
                    Object var3_2 = null;
                    this.jmsSession = null;
                    this.mqQueueManager = null;
                    this.mqQueue = null;
                    this.mqGMO = null;
                    if (!Trace.isOn) return;
                    Trace.exit(this, "shutdown");
                    return;
                }
            }
            Object var3_1 = null;
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
            this.mqGMO = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "shutdown");
            return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.jmsSession = null;
            this.mqQueueManager = null;
            this.mqQueue = null;
            this.mqGMO = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "shutdown");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean browseFullMessage(MQMessageReference mQMessageReference) throws JMSException {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "browseFullMessage");
            }
            this.fullMessages = true;
            if (Trace.isOn) {
                Trace.trace(this, "Getting full messages from now on");
            }
            boolean bl2 = this.browse(mQMessageReference, 2, 0);
            if (Trace.isOn) {
                Trace.trace(this, "browseFullMessage returning " + bl2);
            }
            bl = bl2;
            Object var5_4 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "browseFullMessage");
            throw throwable;
        }
        Trace.exit(this, "browseFullMessage");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean browse(MQMessageReference mQMessageReference, int n, int n2) throws JMSException {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "browse");
            Trace.trace(this, "msgRef passed in follows:\n" + mQMessageReference);
            Trace.trace(this, "browse type = " + (n == 0 ? "BROWSE_FIRST" : (n == 1 ? "BROWSE_NEXT" : (n == 2 ? "BROWSE_SPECIFIC" : "?"))));
            Trace.trace(this, "wait time = " + n2);
        }
        boolean bl2 = true;
        try {
            try {
                MQJMSMessage mQJMSMessage;
                block35: {
                    mQJMSMessage = mQMessageReference.getMQJMSMessage();
                    this.mqGMO.options = 8192;
                    if (!this.fullMessages) {
                        this.mqGMO.options |= 0x40;
                        if (Trace.isOn) {
                            Trace.trace(this, "accepting truncated message");
                        }
                    } else if (Trace.isOn) {
                        Trace.trace(this, "getting full message");
                    }
                    switch (n) {
                        case 0: {
                            this.mqGMO.options |= 0x10;
                            this.mqGMO.matchOptions = 0;
                            break;
                        }
                        case 1: {
                            this.mqGMO.options |= 0x20;
                            this.mqGMO.matchOptions = 0;
                            break;
                        }
                        case 2: {
                            this.mqGMO.options |= 0x10;
                            this.mqGMO.matchOptions = 1;
                            mQJMSMessage.setMessageId(mQMessageReference.getMessageId());
                            break;
                        }
                    }
                    if (n2 > 0) {
                        this.mqGMO.options |= 1;
                        this.mqGMO.waitInterval = n2;
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "Calling Queue.get");
                            Trace.trace(this, "messageId = " + Utils.bytesToHex(mQJMSMessage.getMessageId()));
                        }
                        if (this.fullMessages) {
                            this.mqQueue.getMsg2((MQMsg2)mQJMSMessage, this.mqGMO);
                        } else {
                            this.mqQueue.getMsg2((MQMsg2)mQJMSMessage, this.mqGMO, 1);
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Queue.get returned without exception");
                        }
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Queue.get threw exception...");
                        }
                        if (mQException.completionCode == 2) {
                            bl2 = false;
                            if (mQException.reasonCode != 2033) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                if (Trace.isOn) {
                                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                                }
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                                throw jMSException;
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "...only a 2033 though");
                            }
                        }
                        if (!Trace.isOn) break block35;
                        Trace.trace(this, "...which was the following warning:");
                        Trace.exception(this, "browse", (Throwable)mQException);
                    }
                }
                mQMessageReference.setMQJMSMessage(mQJMSMessage);
                if (Trace.isOn) {
                    Trace.trace(this, "Message reference updated:\n" + mQMessageReference.toString());
                }
                if (bl2 && this.fullMessages) {
                    try {
                        JMSMessage jMSMessage = mQJMSMessage.createJMSMessage(this.jmsSession);
                        mQMessageReference.setJMSMessage(jMSMessage);
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "browse", (Throwable)jMSException);
                        }
                        this.removeBadMessage(mQMessageReference, 2364);
                        bl2 = false;
                    }
                    catch (IOException iOException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "browse", (Throwable)iOException);
                        }
                        this.removeBadMessage(mQMessageReference, 2364);
                        bl2 = false;
                    }
                } else {
                    mQMessageReference.setJMSMessage(null);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Final state of message reference:\n" + mQMessageReference);
                    Trace.trace(this, "browse will return " + bl2);
                }
                bl = bl2;
                Object var9_13 = null;
                if (!Trace.isOn) return bl;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "browse");
            throw throwable;
        }
        Trace.exit(this, "browse");
        return bl;
    }

    private void processMessage(MQMessageReference mQMessageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "processMessage");
            Trace.trace(this, "msgRef passed in:\n" + mQMessageReference.toString());
        }
        try {
            block64: {
                try {
                    MQJMSMessage mQJMSMessage = mQMessageReference.getMQJMSMessage();
                    if (this.backoutThreshold != 0 && mQJMSMessage.getBackoutCount() >= this.backoutThreshold) {
                        if (Trace.isOn) {
                            Trace.trace(this, "backoutThreshold reached");
                        }
                        try {
                            this.backoutRequeue(mQMessageReference);
                        }
                        catch (JMSException jMSException) {
                            Exception exception;
                            if (Trace.isOn) {
                                Trace.trace(this, "Message requeue failed. Treating itas a bad message");
                            }
                            int n = (exception = jMSException.getLinkedException()) != null && exception instanceof MQException ? ((MQException)((Object)exception)).reasonCode : 2362;
                            try {
                                this.removeBadMessage(mQMessageReference, n);
                            }
                            catch (JMSException jMSException2) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "removeBadMessage failed with exception:");
                                    Trace.trace(this, "" + (Object)((Object)jMSException2));
                                    Trace.trace(this, "throwing exception from backoutRequeue");
                                }
                                throw jMSException;
                            }
                        }
                    } else {
                        int n;
                        boolean bl;
                        if (this.oldGroup != null) {
                            MQMessageReference mQMessageReference2;
                            if (Trace.isOn) {
                                Trace.trace(this, "Checking oldGroup for messageRef");
                            }
                            if ((mQMessageReference2 = this.oldGroup.removeMessage(mQMessageReference)) != null) {
                                if (mQMessageReference2.isComplete()) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Complete reference found in oldGroup");
                                    }
                                    if (mQMessageReference.isComplete()) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "New message is complete too; switching to partial browse");
                                        }
                                        this.fullMessages = false;
                                    }
                                    mQMessageReference = mQMessageReference2;
                                } else if (mQMessageReference.isComplete()) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Incomplete reference found in oldGroup, new msg is complete; copying status info over");
                                    }
                                    mQMessageReference.setStatus(mQMessageReference2.getStatus());
                                } else {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Neither message is complete");
                                    }
                                    mQMessageReference = mQMessageReference2;
                                }
                            } else if (Trace.isOn) {
                                Trace.trace(this, "No messageRef found in oldGroup");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Adding following msgRef to curGroup:\n" + mQMessageReference);
                        }
                        this.curGroup.addMessage(mQMessageReference);
                        switch (mQMessageReference.getStatus()) {
                            case 0: {
                                ++this.newCount;
                                if (!this.stopTimeLocked) {
                                    this.stopTimeLocked = true;
                                    if (Trace.isOn) {
                                        Trace.trace(this, "stopTime locked at " + this.stopTime);
                                    }
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "newCount incremented to " + this.newCount);
                                }
                                bl = true;
                                break;
                            }
                            case -1: {
                                ++this.failedCount;
                                if (Trace.isOn) {
                                    Trace.trace(this, "failedCount incremented to " + this.failedCount);
                                }
                                bl = true;
                                break;
                            }
                            case 1: 
                            case 2: {
                                ++this.oldCount;
                                if (Trace.isOn) {
                                    Trace.trace(this, "oldCount incremented to " + this.oldCount);
                                }
                                bl = false;
                                break;
                            }
                            case 3: {
                                ++this.oldCount;
                                if (Trace.isOn) {
                                    Trace.trace(this, "oldCount incremented to " + this.oldCount);
                                    Trace.trace(this, "setting msgRef status to FAILED");
                                }
                                mQMessageReference.setStatus(-1);
                                bl = false;
                                break;
                            }
                            case 4: {
                                ++this.oldCount;
                                if (Trace.isOn) {
                                    Trace.trace(this, "oldCount incremented to " + this.oldCount);
                                }
                                if (this.redeliverUnwanted) {
                                    bl = true;
                                    break;
                                }
                                bl = false;
                                if (this.stopTimeLocked) break;
                                this.stopTime = System.currentTimeMillis() + this.mqQueueAgent.sweepInterval;
                                if (!Trace.isOn) break;
                                Trace.trace(this, "stopTime updated to " + this.stopTime);
                                break;
                            }
                            default: {
                                if (Trace.isOn) {
                                    Trace.trace(this, "bad MQMessageRefence status: " + mQMessageReference.getStatus());
                                }
                                throw ConfigEnvironment.newException("MQJMS1031");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "deliver=" + bl);
                        }
                        if (bl && !mQMessageReference.isComplete()) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Getting full message in preparationfor delivery");
                            }
                            bl = this.browseFullMessage(mQMessageReference);
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "deliver=" + bl);
                        }
                        if (bl && (n = this.mqQueueAgent.deliver(mQMessageReference)) != 0) {
                            if (this.mqQueueAgent.getDomain() == 1) {
                                if (n == 2) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Failed to deliver message: discard it");
                                    }
                                    this.curGroup.removeMessage(mQMessageReference);
                                    MQMessage mQMessage = new MQMessage();
                                    mQMessage.messageId = mQMessageReference.getMessageId();
                                    MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                                    mQGetMessageOptions.options = 0;
                                    mQGetMessageOptions.matchOptions = 1;
                                    try {
                                        this.mqQueue.get(mQMessage, mQGetMessageOptions);
                                    }
                                    catch (MQException mQException) {
                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1031");
                                        jMSException.setLinkedException((Exception)((Object)mQException));
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Unable to discard message:" + (Object)((Object)jMSException));
                                        }
                                        throw jMSException;
                                    }
                                } else {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Failed to deliver message: leave it on queue");
                                    }
                                    mQMessageReference.setStatus(4);
                                }
                            } else if (this.retainMessages) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Failed to deliver message: leave it on queue");
                                }
                                mQMessageReference.setStatus(4);
                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Failed to deliver message");
                                }
                                this.curGroup.removeMessage(mQMessageReference);
                                this.removeBadMessage(mQMessageReference, 2363);
                            }
                        }
                    }
                    if (!Trace.isOn) break block64;
                    Trace.trace(this, "On leaving processMessage, msgRef is:\n" + mQMessageReference);
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Fatal error during processMessage");
                        Trace.trace(this, "Rethrowing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
            }
            Object var10_15 = null;
        }
        catch (Throwable throwable) {
            Object var10_16 = null;
            Trace.exit(this, "processMesssage");
            throw throwable;
        }
        Trace.exit(this, "processMesssage");
    }

    /*
     * Loose catch block
     */
    public void run() {
        block79: {
            Object object2222;
            block75: {
                block74: {
                    block73: {
                        if (Trace.isOn) {
                            Trace.entry(this, "run");
                        }
                        this.setup();
                        if (Trace.isOn) {
                            Trace.trace(this, "setup() returned");
                        }
                        MQQueueAgentThread mQQueueAgentThread = this;
                        synchronized (mQQueueAgentThread) {
                            this.active = true;
                            if (Trace.isOn) {
                                Trace.trace(this, "Notifying waiting thread");
                            }
                            this.notifyAll();
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Waiting thread notified");
                            Trace.trace(this, "quit flag is " + (this.quit ? "true" : "false"));
                        }
                        while (!this.quit) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Starting to sweep the queue");
                            }
                            MQMessageReference mQMessageReference = new MQMessageReference();
                            boolean bl = false;
                            this.newCount = 0;
                            this.oldCount = 0;
                            this.failedCount = 0;
                            MQMessageGroup mQMessageGroup = this.oldGroup;
                            this.oldGroup = this.curGroup;
                            this.curGroup = mQMessageGroup;
                            if (this.curGroup != null) {
                                this.curGroup.clear();
                            }
                            this.redeliverUnwanted = false;
                            if (Trace.isOn) {
                                Trace.trace(this, "redeliverUnwanted set to false");
                            }
                            this.mqQueueAgent.sweepStarting();
                            if (Trace.isOn) {
                                Trace.trace(this, "Entering BROWSE_FIRST loop");
                            }
                            while (!this.quit && !bl) {
                                bl = this.browse(mQMessageReference, 0, 5000);
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "Exiting BROWSE_FIRST loop(quit==" + this.quit + " success==" + bl + ")");
                            }
                            if (bl) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "success==true, process the messageRef");
                                }
                                this.processMessage(mQMessageReference);
                            }
                            int n = 0;
                            this.stopTime = System.currentTimeMillis() + this.mqQueueAgent.sweepInterval;
                            this.stopTimeLocked = false;
                            if (Trace.isOn) {
                                Trace.trace(this, "stopTime initially set to " + this.stopTime);
                            }
                            boolean bl2 = false;
                            while (!this.quit && !bl2) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Performing a BROWSE_NEXT with wait " + n);
                                }
                                if (bl = this.browse(mQMessageReference = new MQMessageReference(), 1, n)) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "browse success==true, process the messageRef");
                                    }
                                    this.processMessage(mQMessageReference);
                                    n = 0;
                                } else {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "browse success==false...");
                                    }
                                    if (n == 0) {
                                        n = 5000;
                                        if (Trace.isOn) {
                                            Trace.trace(this, "...and waitTime was 0, so reset waitTime to " + 5000 + "and start consumers");
                                        }
                                        this.mqQueueAgent.startConsumers();
                                    } else {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "...and waitTime was non-0");
                                        }
                                        bl2 = true;
                                    }
                                }
                                if (bl2) continue;
                                boolean bl3 = bl2 = this.stopTime < System.currentTimeMillis();
                                if (!bl2 || !Trace.isOn) continue;
                                Trace.trace(this, "sweepInterval expired");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Exiting BROWSE_NEXT loop");
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "End of a sweep, so start consumers");
                        }
                        this.mqQueueAgent.startConsumers();
                        if (!Trace.isOn) break block73;
                        Trace.trace(this, "new message count    : " + this.newCount);
                        Trace.trace(this, "old message count    : " + this.oldCount);
                        Trace.trace(this, "failed message count : " + this.failedCount);
                    }
                    Object var8_11 = null;
                    if (!Trace.isOn) break block74;
                    Trace.trace(this, "QueueAgent about to stop; start consumers");
                }
                this.mqQueueAgent.startConsumers();
                if (Trace.isOn) {
                    Trace.trace(this, "new message count    : " + this.newCount);
                    Trace.trace(this, "old message count    : " + this.oldCount);
                    Trace.trace(this, "failed message count : " + this.failedCount);
                }
                try {
                    this.shutdown();
                }
                catch (JMSException object2222) {
                    if (this.exception == null) {
                        this.exception = object2222;
                    }
                }
                catch (Exception exception) {
                    if (this.exception != null) break block75;
                    this.exception = ConfigEnvironment.newException("MQJMS1016");
                    this.exception.setLinkedException(exception);
                }
            }
            object2222 = this;
            synchronized (object2222) {
                this.active = false;
                this.notifyAll();
            }
            if (this.exception != null) {
                this.mqQueueAgent.deliverException(this.exception);
            }
            if (Trace.isOn) {
                Trace.exit(this, "run");
            }
            break block79;
            {
                catch (JMSException jMSException) {
                    Object object32222;
                    block77: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Fatal error duing run() - leaving exception for another thread to pick up");
                            Trace.exception(this, "run", (Throwable)jMSException);
                        }
                        this.exception = jMSException;
                        Object var8_12 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "QueueAgent about to stop; start consumers");
                        }
                        this.mqQueueAgent.startConsumers();
                        if (Trace.isOn) {
                            Trace.trace(this, "new message count    : " + this.newCount);
                            Trace.trace(this, "old message count    : " + this.oldCount);
                            Trace.trace(this, "failed message count : " + this.failedCount);
                        }
                        try {
                            this.shutdown();
                        }
                        catch (JMSException object32222) {
                            if (this.exception == null) {
                                this.exception = object32222;
                            }
                        }
                        catch (Exception exception) {
                            if (this.exception != null) break block77;
                            this.exception = ConfigEnvironment.newException("MQJMS1016");
                            this.exception.setLinkedException(exception);
                        }
                    }
                    object32222 = this;
                    synchronized (object32222) {
                        this.active = false;
                        this.notifyAll();
                    }
                    if (this.exception != null) {
                        this.mqQueueAgent.deliverException(this.exception);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                    break block79;
                }
                catch (Exception exception) {
                    Object object42222;
                    block80: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Unexpected exception thrown during run: " + exception);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        jMSException.setLinkedException(exception);
                        this.exception = jMSException;
                        Object var8_13 = null;
                        if (Trace.isOn) {
                            Trace.trace(this, "QueueAgent about to stop; start consumers");
                        }
                        this.mqQueueAgent.startConsumers();
                        if (Trace.isOn) {
                            Trace.trace(this, "new message count    : " + this.newCount);
                            Trace.trace(this, "old message count    : " + this.oldCount);
                            Trace.trace(this, "failed message count : " + this.failedCount);
                        }
                        try {
                            this.shutdown();
                        }
                        catch (JMSException object42222) {
                            if (this.exception == null) {
                                this.exception = object42222;
                            }
                        }
                        catch (Exception exception2) {
                            if (this.exception != null) break block80;
                            this.exception = ConfigEnvironment.newException("MQJMS1016");
                            this.exception.setLinkedException(exception2);
                        }
                    }
                    object42222 = this;
                    synchronized (object42222) {
                        this.active = false;
                        this.notifyAll();
                    }
                    if (this.exception != null) {
                        this.mqQueueAgent.deliverException(this.exception);
                    }
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                }
            }
            catch (Throwable throwable) {
                Object object52222;
                block82: {
                    Object var8_14 = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "QueueAgent about to stop; start consumers");
                    }
                    this.mqQueueAgent.startConsumers();
                    if (Trace.isOn) {
                        Trace.trace(this, "new message count    : " + this.newCount);
                        Trace.trace(this, "old message count    : " + this.oldCount);
                        Trace.trace(this, "failed message count : " + this.failedCount);
                    }
                    try {
                        this.shutdown();
                    }
                    catch (JMSException object52222) {
                        if (this.exception == null) {
                            this.exception = object52222;
                        }
                    }
                    catch (Exception exception) {
                        if (this.exception != null) break block82;
                        this.exception = ConfigEnvironment.newException("MQJMS1016");
                        this.exception.setLinkedException(exception);
                    }
                }
                object52222 = this;
                synchronized (object52222) {
                    this.active = false;
                    this.notifyAll();
                }
                if (this.exception != null) {
                    this.mqQueueAgent.deliverException(this.exception);
                }
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void removeBadMessage(MQMessageReference mQMessageReference, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeBadMessage");
        }
        try {
            try {
                MQJMSMessage mQJMSMessage = mQMessageReference.getMQJMSMessage();
                if ((mQJMSMessage.getReport() & 0x8000000) == 0x8000000) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Discarding message as per MQMD.Report");
                    }
                    this.discard(mQMessageReference, n);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Dead-lettering message as per MQMD.Report");
                }
                this.deadLetter(mQMessageReference, n);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "removeBadMessage");
            throw throwable;
        }
        Trace.exit(this, "removeBadMessage");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void deadLetter(MQMessageReference mQMessageReference, int n) throws JMSException {
        Object object;
        if (Trace.isOn) {
            Trace.entry(this, "deadLetter");
        }
        MQMessage mQMessage = null;
        MQMessage mQMessage2 = null;
        String string = null;
        String string2 = null;
        try {
            mQMessage = this.retrieveMessage(mQMessageReference);
            String string3 = Utils.inquireString((MQManagedObject)this.mqQueueManager, 2006);
            if (Trace.isOn) {
                Trace.trace(this, "DLQ = <" + string3 + ">");
            }
            if (string3 == null || string3.length() == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Unable to find DLQ name - is one defined?");
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
                throw jMSException;
            }
            if ((mQMessage.report & 0x7000000) != 0) {
                mQMessage2 = this.generateReport(mQMessage, n);
                string = mQMessage.replyToQueueName.trim();
                string2 = mQMessage.replyToQueueManagerName.trim();
            }
            if (Trace.isOn) {
                Trace.trace(this, "Constructing DLH");
            }
            object = new DLH();
            ((DLH)object).reason = n;
            ((DLH)object).destQName = this.qName;
            ((DLH)object).destQMgrName = this.qmgrName;
            ((DLH)object).putApplType = 28;
            ((DLH)object).putApplName = "MQ JMS ConnectionConsumer";
            GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
            ((DLH)object).putDate = Utils.getDate(gregorianCalendar);
            ((DLH)object).putTime = Utils.getTime(gregorianCalendar);
            ((DLH)object).write(mQMessage);
            this.put1WithContext(mQMessage, string3, null);
            if (mQMessage2 != null) {
                try {
                    this.put1WithContext(mQMessage2, string, string2);
                }
                catch (MQException mQException) {
                    ((DLH)object).destQName = string;
                    ((DLH)object).destQMgrName = string2;
                    ((DLH)object).reason = mQException.reasonCode;
                    ((DLH)object).write(mQMessage2);
                    this.put1WithContext(mQMessage2, string3, null);
                }
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)mQException);
            }
            if (mQException.reasonCode == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message to dead-letter has disappeared! Continue as normal");
                }
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not send report message, but message isnon-persistent - so subsume the error");
                }
            }
            try {
                this.mqQueueManager.backout();
            }
            catch (MQException mQException2) {
                // empty catch block
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (!Trace.isOn) throw jMSException;
            Trace.exit(this, "deadLetter");
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "deadLetter", (Throwable)jMSException);
                Trace.exit(this, "deadLetter");
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message is non-persistent so ignoring error");
                }
            }
            try {
                this.mqQueueManager.backout();
                throw jMSException;
            }
            catch (MQException mQException) {
                // empty catch block
            }
            throw jMSException;
        }
        try {
            try {
                this.mqQueueManager.commit();
            }
            catch (MQException mQException) {
                object = ConfigEnvironment.newException("MQJMS1079");
                object.setLinkedException((Exception)((Object)mQException));
                if (!Trace.isOn) throw object;
                Trace.exception(this, "deadLetter", (Throwable)object);
                Trace.exception(this, "deadLetter - linked exception: ", (Throwable)mQException);
                throw object;
            }
            Object var12_18 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var12_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "deadLetter");
            throw throwable;
        }
        Trace.exit(this, "deadLetter");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void backoutRequeue(MQMessageReference mQMessageReference) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "backoutRequeue");
        }
        try {
            try {
                if (this.mqBORQName == null) {
                    this.mqBORQName = Utils.inquireString((MQManagedObject)this.mqQueue, 2019);
                    this.mqBORQName = this.mqBORQName.trim();
                    if (Trace.isOn) {
                        Trace.trace(this, "BORQ = <" + this.mqBORQName + ">");
                    }
                }
                if (this.mqBORQName == null || this.mqBORQName.equals("")) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1080");
                    throw jMSException;
                }
                try {
                    MQMessage mQMessage = this.retrieveMessage(mQMessageReference);
                    this.put1WithContext(mQMessage, this.mqBORQName, null);
                    this.mqQueueManager.commit();
                }
                catch (MQException mQException) {
                    block15: {
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Message to requeue has disappeared! Continue as normal");
                            }
                        } else {
                            try {
                                this.mqQueueManager.backout();
                            }
                            catch (MQException mQException2) {
                                if (!Trace.isOn) break block15;
                                Trace.trace(this, "WARNING: backout after failed requeue failed!");
                                Trace.exception(this, "backoutRequeue", (Throwable)mQException2);
                            }
                        }
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1081");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var5_8 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "backoutRequeue");
            throw throwable;
        }
        Trace.exit(this, "backoutRequeue");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void discard(MQMessageReference mQMessageReference, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "discard");
        }
        MQMessage mQMessage = null;
        MQMessage mQMessage2 = null;
        try {
            mQMessage = this.retrieveMessage(mQMessageReference);
            if ((mQMessage.report & 0x7000000) != 0) {
                mQMessage2 = this.generateReport(mQMessage, n);
                String string = mQMessage.replyToQueueName.trim();
                String string2 = mQMessage.replyToQueueManagerName.trim();
                try {
                    this.put1WithContext(mQMessage2, string, string2);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Could not put report message to replyToQ");
                        Trace.exception(this, "discard", (Throwable)mQException);
                        Trace.trace(this, "Attempting to put to DLQ instead");
                    }
                    String string3 = Utils.inquireString((MQManagedObject)this.mqQueueManager, 2006);
                    if (Trace.isOn) {
                        Trace.trace(this, "DLQ = <" + string3 + ">");
                    }
                    if (string3 == null || string3.length() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Unable to find DLQ name - is one defined?");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1079");
                        throw jMSException;
                    }
                    DLH dLH = new DLH();
                    dLH.reason = mQException.reasonCode;
                    dLH.destQName = string;
                    dLH.destQMgrName = string2;
                    dLH.putApplType = 28;
                    dLH.putApplName = "MQ JMS ConnectionConsumer";
                    GregorianCalendar gregorianCalendar = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
                    dLH.putDate = Utils.getDate(gregorianCalendar);
                    dLH.putTime = Utils.getTime(gregorianCalendar);
                    dLH.write(mQMessage2);
                    this.put1WithContext(mQMessage2, string3, null);
                }
            }
        }
        catch (MQException mQException) {
            if (Trace.isOn) {
                Trace.exception(this, "discard", (Throwable)mQException);
            }
            if (mQException.reasonCode == 2033) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message to discard has disappeared! Continue as normal");
                }
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not send report message, but message isnon-persistent - so subsume the error");
                }
            }
            try {
                this.mqQueueManager.backout();
            }
            catch (MQException mQException2) {
                // empty catch block
            }
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1082");
            jMSException.setLinkedException((Exception)((Object)mQException));
            if (!Trace.isOn) throw jMSException;
            Trace.exit(this, "discard");
            throw jMSException;
        }
        catch (JMSException jMSException) {
            if (Trace.isOn) {
                Trace.exception(this, "discard", (Throwable)jMSException);
            }
            if (Trace.isOn) {
                Trace.exit(this, "discard");
            }
            if (mQMessage != null && mQMessage.persistence == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "Message is non-persistent so ignoring error");
                }
            }
            try {
                this.mqQueueManager.backout();
                throw jMSException;
            }
            catch (MQException mQException) {
                // empty catch block
            }
            throw jMSException;
        }
        try {
            try {
                this.mqQueueManager.commit();
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1082");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "linked exception: " + (Object)((Object)mQException));
                throw jMSException;
            }
            Object var12_20 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var12_21 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "discard");
            throw throwable;
        }
        Trace.exit(this, "discard");
    }

    private MQMessage generateReport(MQMessage mQMessage, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "generateReport");
        }
        MQMessage mQMessage2 = new MQMessage();
        mQMessage2.report = 0;
        mQMessage2.messageType = 4;
        mQMessage2.expiry = -1;
        mQMessage2.feedback = n;
        mQMessage2.encoding = mQMessage.encoding;
        mQMessage2.characterSet = mQMessage.characterSet;
        mQMessage2.format = mQMessage.format;
        mQMessage2.priority = mQMessage.priority;
        mQMessage2.persistence = mQMessage.persistence;
        if ((mQMessage.report & 0x80) == 128) {
            mQMessage2.messageId = mQMessage.messageId;
        }
        mQMessage2.correlationId = (mQMessage.report & 0x40) == 64 ? mQMessage.correlationId : mQMessage.messageId;
        mQMessage2.backoutCount = 0;
        mQMessage2.replyToQueueName = "";
        mQMessage2.replyToQueueManagerName = this.qmgrName;
        mQMessage2.putApplicationType = 28;
        mQMessage2.putApplicationName = "MQ JMS ConnectionConsumer";
        try {
            if ((mQMessage.report & 0x7000000) == 0x7000000) {
                byte[] byArray = new byte[mQMessage.getMessageLength()];
                mQMessage.seek(0);
                mQMessage.readFully(byArray);
                mQMessage2.write(byArray);
            } else if ((mQMessage.report & 0x3000000) == 0x3000000) {
                mQMessage.seek(0);
                int n2 = 0;
                String string = mQMessage.format;
                int n3 = mQMessage.characterSet;
                int n4 = mQMessage.encoding;
                boolean bl = false;
                int n5 = 0;
                int n6 = 0;
                int n7 = 0;
                String string2 = null;
                while (!bl) {
                    try {
                        if (string.startsWith("MQH")) {
                            mQMessage.skipBytes(8);
                            n5 = mQMessage.readInt();
                            n6 = mQMessage.readInt();
                            n7 = mQMessage.readInt();
                            string2 = mQMessage.readString(8);
                            mQMessage.skipBytes(n5 - 28);
                        } else if (string.equals("MQDEAD  ")) {
                            n5 = 172;
                            mQMessage.skipBytes(108);
                            n6 = mQMessage.readInt();
                            n7 = mQMessage.readInt();
                            string2 = mQMessage.readString(8);
                            mQMessage.skipBytes(48);
                        } else if (string.equals("MQXMIT  ")) {
                            n5 = 428;
                            mQMessage.skipBytes(128);
                            n6 = mQMessage.readInt();
                            n7 = mQMessage.readInt();
                            string2 = mQMessage.readString(8);
                            mQMessage.skipBytes(284);
                        } else if (string.equals("MQCICS  ")) {
                            mQMessage.skipBytes(8);
                            n5 = mQMessage.readInt();
                            mQMessage.skipBytes(8);
                            string2 = mQMessage.readString(8);
                            n6 = mQMessage.encoding;
                            n7 = mQMessage.characterSet;
                            mQMessage.skipBytes(n5 - 36);
                        } else {
                            bl = true;
                        }
                        if (bl) continue;
                        n2 += n5;
                        string = string2;
                        mQMessage.encoding = n6;
                        mQMessage.characterSet = n7;
                    }
                    catch (IOException iOException) {
                        bl = true;
                    }
                }
                mQMessage.encoding = n4;
                mQMessage.characterSet = n3;
                mQMessage.seek(0);
                byte[] byArray = new byte[Math.min(n2 + 100, mQMessage.getMessageLength())];
                mQMessage.readFully(byArray);
                mQMessage2.write(byArray);
            }
        }
        catch (IOException iOException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException((Exception)iOException);
            if (Trace.isOn) {
                Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                Trace.trace(this, "Linked Exception " + iOException);
                Trace.exit(this, "generateReport");
            }
            throw jMSException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "generateReport");
        }
        return mQMessage2;
    }

    private MQMessage retrieveMessage(MQMessageReference mQMessageReference) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "retrieveMessage");
        }
        MQMessage mQMessage = new MQMessage();
        mQMessage.messageId = mQMessageReference.getMessageId();
        MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
        mQGetMessageOptions.options = 2;
        mQGetMessageOptions.matchOptions = 1;
        this.mqQueue.get(mQMessage, mQGetMessageOptions);
        if (Trace.isOn) {
            Trace.exit(this, "retrieveMessage");
        }
        return mQMessage;
    }

    private void put1WithContext(MQMessage mQMessage, String string, String string2) throws MQException {
        if (Trace.isOn) {
            Trace.entry(this, "put1WithContext");
        }
        MQQueue mQQueue = null;
        try {
            int n = 8720;
            mQQueue = this.mqQueueManager.accessQueue(string, n, string2, null, null);
            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
            mQPutMessageOptions.options = 514;
            mQPutMessageOptions.contextReference = this.mqQueue;
            mQQueue.put(mQMessage, mQPutMessageOptions);
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            block10: {
                Object var8_8 = null;
                if (mQQueue != null && mQQueue.isOpen()) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block10;
                        Trace.trace(this, "Could not close destination queue. Carrying on regardless.");
                        Trace.exception(this, "put1WithContext", (Throwable)mQException);
                    }
                }
            }
            throw throwable;
        }
        if (mQQueue != null && mQQueue.isOpen()) {
            try {
                mQQueue.close();
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Could not close destination queue. Carrying on regardless.");
                    Trace.exception(this, "put1WithContext", (Throwable)mQException);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "put1WithContext");
        }
    }
}

