/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionConsumer;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQQueueAgentThread;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQQueueSession;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;

class MQQueueAgent {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueueAgent.java, jms, j521, j521-L020126 02/01/25 14:57:13 @(#) 1.18.1.1";
    private String agentKey;
    private static Hashtable agents = new Hashtable();
    private String mqQmgrName;
    private String mqQueueName;
    static final int DOMAIN_PTP = 0;
    static final int DOMAIN_PS = 1;
    private int domainFlag;
    static final int DELIVERED = 0;
    static final int NOT_DELIVERED = 1;
    static final int MSG_SELECTOR_FAILED = 2;
    static final int NO_CONSUMER = 3;
    private Vector consumers = new Vector();
    private boolean allConsumersReceiving = true;
    private int activeCount = 0;
    private int firstConsumer = 0;
    private MQQueueAgentThread thread = null;
    private static final int QAT_STOPPED = 0;
    private static final int QAT_STARTED = 1;
    private static final int QAT_STOPPING = 2;
    private int threadStatus = 0;
    private Object threadLock = new Object();
    static final int defWaitTime = 5000;
    long sweepInterval = 30000L;
    private Hashtable pubSubConsumerLookup = new Hashtable();
    private boolean useCorrelId = true;
    private static final String EXCLUSIVE_SUB_KEY = "XXX-Exclusive-Subscriber-Key-XXX";
    boolean retainAllMessages = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static MQQueueAgent getQueueAgent(MQConnection mQConnection, String string, boolean bl) throws JMSException {
        MQQueueAgent mQQueueAgent = null;
        if (Trace.isOn) {
            Trace.entry("MQQueueAgent", "getQueueAgent");
        }
        try {
            try {
                MQSession mQSession;
                int n;
                if (mQConnection instanceof MQQueueConnection) {
                    n = 0;
                    mQSession = (MQSession)((MQQueueConnection)mQConnection).createQueueSession(true, 0);
                } else {
                    n = 1;
                    mQSession = (MQSession)((MQTopicConnection)mQConnection).createTopicSession(true, 0);
                }
                String string2 = MQQueueAgent.resolveQmgrName(mQSession);
                String string3 = MQQueueAgent.resolveQueue(mQSession, string);
                String string4 = string2 + "/" + string3;
                mQSession.close();
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "QueueAgent ID is " + string4);
                }
                Hashtable hashtable = agents;
                synchronized (hashtable) {
                    mQQueueAgent = (MQQueueAgent)agents.get(string4);
                    if (mQQueueAgent == null) {
                        mQQueueAgent = new MQQueueAgent(string2, string3, string4, n, bl);
                        agents.put(string4, mQQueueAgent);
                    } else if (mQQueueAgent.getDomain() != n) {
                        throw ConfigEnvironment.newException("MQJMS1088");
                    }
                }
                Object var12_12 = null;
                if (!Trace.isOn) return mQQueueAgent;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace("MQQueueAgent", "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit("MQQueueAgent", "getQueueAgent");
            throw throwable;
        }
        Trace.exit("MQQueueAgent", "getQueueAgent");
        return mQQueueAgent;
    }

    private MQQueueAgent(String string, String string2, String string3, int n, boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.mqQmgrName = string;
        this.mqQueueName = string2;
        this.agentKey = string3;
        this.domainFlag = n;
        this.useCorrelId = bl;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resolveQmgrName(MQSession mQSession) throws JMSException {
        String string;
        if (Trace.isOn) {
            Trace.entry("MQQueueAgent", "resolveQmgrName");
        }
        try {
            try {
                MQQueueManager mQQueueManager;
                if (mQSession instanceof MQQueueSession) {
                    mQQueueManager = ((MQQueueSession)mQSession).getQM();
                } else {
                    if (!(mQSession instanceof MQTopicSession)) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1069");
                        throw jMSException;
                    }
                    mQQueueManager = ((MQTopicSession)mQSession).getQM();
                }
                String string2 = Utils.inquireString((MQManagedObject)mQQueueManager, 2015);
                if (string2 == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1072");
                    throw jMSException;
                }
                if (Trace.isOn) {
                    Trace.trace("MQQueueAgent", "Fully resolve Qmgr Name is " + string2);
                }
                string = string2;
                Object var5_7 = null;
                if (!Trace.isOn) return string;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace("MQQueueAgent", "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit("MQQueueAgent", "resolveQmgrName");
            throw throwable;
        }
        Trace.exit("MQQueueAgent", "resolveQmgrName");
        return string;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String resolveQueue(MQSession var0, String var1_1) throws JMSException {
        block31: {
            if (Trace.isOn) {
                Trace.entry("MQQueueAgent", "resolveQueue");
            }
            var2_2 = null;
            try {
                try {
                    if (var0 instanceof MQQueueSession) {
                        var3_3 = ((MQQueueSession)var0).getQM();
                    } else {
                        if (!(var0 instanceof MQTopicSession)) {
                            var4_5 = ConfigEnvironment.newException("MQJMS1069");
                            throw var4_5;
                        }
                        var3_3 = ((MQTopicSession)var0).getQM();
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.trace("MQQueueAgent", "resolveQueue is opening queue");
                        }
                        var2_2 = var3_3.accessQueue(var1_1, 8232);
                        if (Trace.isOn) {
                            Trace.trace("MQQueueAgent", "resolveQueue opened queue OK");
                        }
                    }
                    catch (MQException var4_6) {
                        var5_8 = ConfigEnvironment.newException("MQJMS2008");
                        var5_8.setLinkedException((Exception)var4_6);
                        throw var5_8;
                    }
                    var4_7 = Utils.inquireInt((MQManagedObject)var2_2, 20);
                    switch (var4_7) {
                        case 1: {
                            var5_9 = Utils.inquireInt((MQManagedObject)var2_2, 7);
                            if (var5_9 == 1) ** GOTO lbl42
                            var6_10 = Utils.inquireString((MQManagedObject)var2_2, 2016);
                            if (var1_1.trim().equals(var6_10.trim())) break;
                            var2_2.closeOptions = 1;
                            try {
                                var2_2.close();
                                var2_2 = null;
                            }
                            catch (MQException var7_12) {
                                if (!Trace.isOn) ** GOTO lbl39
                                Trace.trace("MQQueueAgent", "Warning: could not close queue on implicit close");
                            }
lbl39:
                            // 3 sources

                            if (Trace.isOn == false) throw ConfigEnvironment.newException("MQJMS1073");
                            Trace.trace("MQQueueAgent", "Queue is a QMODEL");
                            throw ConfigEnvironment.newException("MQJMS1073");
lbl42:
                            // 1 sources

                            if (!Trace.isOn) break;
                            Trace.trace("MQQueueAgent", "Queue is a QLOCAL");
                            break;
                        }
                        case 3: {
                            if (Trace.isOn) {
                                Trace.trace("MQQueueAgent", "Queue is a QALIAS");
                            }
                            var1_1 = Utils.inquireString((MQManagedObject)var2_2, 2002);
                            break;
                        }
                        default: {
                            if (Trace.isOn == false) throw ConfigEnvironment.newException("MQJMS1073");
                            Trace.trace("MQQueueAgent", "Unexpected response when determining Queue type: " + var4_7);
                            throw ConfigEnvironment.newException("MQJMS1073");
                        }
                    }
                    try {
                        if (Trace.isOn) {
                            Trace.trace("MQQueueAgent", "resolveQueue is closing queue");
                        }
                        var2_2.close();
                        var2_2 = null;
                        if (Trace.isOn) {
                            Trace.trace("MQQueueAgent", "resolveQueue closed queue okay");
                        }
                    }
                    catch (MQException var6_11) {
                        var7_13 = ConfigEnvironment.newException("MQJMS2000");
                        throw var7_13;
                    }
                    if (Trace.isOn) {
                        Trace.trace("MQQueueAgent", "Fully resolved Queue name is " + var1_1);
                    }
                    var6_10 = var1_1;
                    var9_14 = null;
                }
                catch (JMSException var3_4) {
                    if (Trace.isOn == false) throw var3_4;
                    Trace.trace("MQQueueAgent", "Throwing " + (Object)var3_4);
                    throw var3_4;
                }
            }
            catch (Throwable var8_18) {
                block30: {
                    var9_15 = null;
                    try {
                        if (var2_2 != null) {
                            var2_2.close();
                        }
                    }
                    catch (MQException var10_17) {
                        if (!Trace.isOn) break block30;
                        Trace.trace("MQQueueAgent", "Warning: could not close queue on implicit close");
                        Trace.exception("MQQueueAgent", "resolveQueue", (Throwable)var10_17);
                    }
                }
                if (Trace.isOn == false) throw var8_18;
                Trace.exit("MQQueueAgent", "resolveQueue");
                throw var8_18;
            }
            ** try [egrp 5[TRYBLOCK] [5 : 464->475)] { 
lbl92:
            // 1 sources

            if (var2_2 != null) {
                var2_2.close();
            }
            break block31;
lbl95:
            // 1 sources

            catch (MQException var10_16) {
                if (!Trace.isOn) break block31;
                Trace.trace("MQQueueAgent", "Warning: could not close queue on implicit close");
                Trace.exception("MQQueueAgent", "resolveQueue", (Throwable)var10_16);
            }
        }
        if (Trace.isOn == false) return var6_10;
        Trace.exit("MQQueueAgent", "resolveQueue");
        return var6_10;
    }

    void addConsumer(MQConnectionConsumer mQConnectionConsumer, boolean bl) {
        if (Trace.isOn) {
            Trace.entry(this, "addConsumer");
        }
        Vector vector = this.consumers;
        synchronized (vector) {
            if (!this.consumers.contains(mQConnectionConsumer)) {
                this.consumers.addElement(mQConnectionConsumer);
                if (mQConnectionConsumer.isPubSub()) {
                    if (this.useCorrelId) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Consumer is Pub/Sub, and uses correlIdAsIdentity, so storing its correlId in lookup table");
                            Trace.trace(this, "correlId = '" + Utils.bytesToHex(mQConnectionConsumer.getCorrelId()) + "'");
                        }
                        this.pubSubConsumerLookup.put(Utils.bytesToHex(mQConnectionConsumer.getCorrelId()), mQConnectionConsumer);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Consumer is Pub/Sub, but does NOT use correlIdAsIdentity. correlId storage not required");
                        }
                        this.pubSubConsumerLookup.put(EXCLUSIVE_SUB_KEY, mQConnectionConsumer);
                    }
                }
                mQConnectionConsumer.receiving = false;
                this.allConsumersReceiving = false;
                if (bl) {
                    this.retainAllMessages = true;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "addConsumer");
        }
    }

    void removeConsumer(MQConnectionConsumer mQConnectionConsumer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeConsumer");
        }
        Object object = this.threadLock;
        synchronized (object) {
            if (this.threadStatus == 2) {
                this.thread.waitForEnd();
                this.threadStatus = 0;
                this.thread = null;
                this.threadLock.notifyAll();
            }
        }
        Vector vector = this.consumers;
        synchronized (vector) {
            this.consumers.removeElement(mQConnectionConsumer);
            this.firstConsumer = 0;
            if (mQConnectionConsumer.isPubSub()) {
                if (this.useCorrelId) {
                    this.pubSubConsumerLookup.remove(Utils.bytesToHex(mQConnectionConsumer.getCorrelId()));
                } else {
                    this.pubSubConsumerLookup.remove(EXCLUSIVE_SUB_KEY);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeConsumer");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void activate(MQConnection mQConnection) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "activate");
        }
        Object object = this.threadLock;
        // MONITORENTER : object
        while (this.threadStatus == 2) {
            try {
                this.threadLock.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        ++this.activeCount;
        if (this.threadStatus == 0) {
            if (Trace.isOn) {
                Trace.trace(this, "Creating MQQueueAgentThread");
            }
            this.thread = new MQQueueAgentThread(this, mQConnection, this.mqQmgrName, this.mqQueueName);
            this.threadStatus = 1;
            if (this.retainAllMessages) {
                this.thread.retainAllMessages();
            }
            this.thread.go();
        } else if (this.retainAllMessages) {
            this.thread.retainAllMessages();
        }
        // MONITOREXIT : object
        if (!Trace.isOn) return;
        Trace.exit(this, "activate");
    }

    void deactivate() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "activate");
        }
        Object object = this.threadLock;
        synchronized (object) {
            --this.activeCount;
            if (this.activeCount == 0) {
                this.thread.quit();
                this.threadStatus = 2;
                this.retainAllMessages = false;
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "activate");
        }
    }

    void sweepStarting() {
        if (Trace.isOn) {
            Trace.entry(this, "sweepStarting");
        }
        Vector vector = this.consumers;
        synchronized (vector) {
            if (!this.allConsumersReceiving) {
                if (Trace.isOn) {
                    Trace.trace(this, "Setting all ConnectionConsumers to receive messages");
                }
                Enumeration enumeration = this.consumers.elements();
                while (enumeration.hasMoreElements()) {
                    ((MQConnectionConsumer)enumeration.nextElement()).receiving = true;
                }
                this.allConsumersReceiving = true;
                this.thread.redeliverUnwanted();
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "sweepStarting");
        }
    }

    int deliver(MQMessageReference mQMessageReference) {
        if (Trace.isOn) {
            Trace.entry(this, "deliver");
        }
        int n = 1;
        if (this.domainFlag == 1) {
            n = this.deliverPubSub(mQMessageReference);
        } else {
            Vector vector = this.consumers;
            synchronized (vector) {
                int n2 = this.consumers.size();
                int n3 = this.firstConsumer;
                int n4 = 0;
                while (n != 0 && n4 < n2) {
                    MQConnectionConsumer mQConnectionConsumer = (MQConnectionConsumer)this.consumers.elementAt(n3);
                    try {
                        if (mQConnectionConsumer.getException() == null && mQConnectionConsumer.receiving) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Attempting delivery to consumer " + n3);
                            }
                            if (mQConnectionConsumer.deliver(mQMessageReference)) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "consumer.deliver returned DELIVERED");
                                }
                                n = 0;
                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(this, "consumer.deliver returned NOT_DELIVERED");
                                }
                                n = 1;
                            }
                        }
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "ConnectionConsumer threw exception from deliver; reject it");
                            Trace.exception(this, "deliver", (Throwable)jMSException);
                        }
                        mQConnectionConsumer.setException(jMSException);
                    }
                    n3 = (n3 + 1) % n2;
                    ++n4;
                }
                if (n2 != 0) {
                    this.firstConsumer = (this.firstConsumer + 1) % n2;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliver");
        }
        return n;
    }

    int deliverPubSub(MQMessageReference mQMessageReference) {
        if (Trace.isOn) {
            Trace.entry(this, "deliverPubSub");
        }
        int n = 1;
        byte[] byArray = mQMessageReference.getCorrelId();
        Hashtable hashtable = this.pubSubConsumerLookup;
        synchronized (hashtable) {
            block16: {
                MQConnectionConsumer mQConnectionConsumer = null;
                mQConnectionConsumer = this.useCorrelId ? (MQConnectionConsumer)this.pubSubConsumerLookup.get(Utils.bytesToHex(byArray)) : (MQConnectionConsumer)this.pubSubConsumerLookup.get(EXCLUSIVE_SUB_KEY);
                if (mQConnectionConsumer != null) {
                    try {
                        if (mQConnectionConsumer.getException() != null) break block16;
                        if (Trace.isOn) {
                            Trace.trace(this, "Found a prospective pub/sub consumer to deliver to");
                        }
                        if (mQConnectionConsumer.deliver(mQMessageReference)) {
                            n = 0;
                            if (Trace.isOn) {
                                Trace.trace(this, "consumer.deliver returned DELIVERED");
                            }
                        } else {
                            n = 2;
                            if (Trace.isOn) {
                                Trace.trace(this, "consumer.deliver returned false; result is MSG_SELECTOR_FAILED");
                            }
                        }
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "ConnectionConsumer threw exception from deliver; reject it");
                            Trace.exception(this, "deliver", (Throwable)jMSException);
                        }
                        mQConnectionConsumer.setException(jMSException);
                    }
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "No consumer matching message correlId '" + Utils.bytesToHex(byArray) + "'");
                        Trace.trace(this, "outcome is NO_CONSUMER");
                    }
                    n = 3;
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverPubSub");
        }
        return n;
    }

    void startConsumers() {
        if (Trace.isOn) {
            Trace.entry(this, "startConsumers");
        }
        Enumeration enumeration = this.consumers.elements();
        while (enumeration.hasMoreElements()) {
            MQConnectionConsumer mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
            try {
                if (mQConnectionConsumer.getException() != null) continue;
                mQConnectionConsumer.deliverNow();
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "ConnectionConsumer threw exception from deliverNow; reject it");
                    Trace.exception(this, "startConsumers", (Throwable)jMSException);
                }
                mQConnectionConsumer.setException(jMSException);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "startConsumers");
        }
    }

    void deliverException(JMSException jMSException) {
        MQConnection[] mQConnectionArray;
        if (Trace.isOn) {
            Trace.entry(this, "deliverException");
        }
        int n = 0;
        Vector vector = this.consumers;
        synchronized (vector) {
            mQConnectionArray = new MQConnection[this.consumers.size()];
            Enumeration enumeration = this.consumers.elements();
            while (enumeration.hasMoreElements()) {
                MQConnectionConsumer mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                MQConnection mQConnection = mQConnectionConsumer.getConnection();
                boolean bl = false;
                int n2 = 0;
                while (n2 < n && !bl) {
                    if (mQConnectionArray[n2] == mQConnection) {
                        bl = true;
                    }
                    ++n2;
                }
                if (bl) continue;
                mQConnectionArray[n] = mQConnection;
                ++n;
            }
        }
        if (Trace.isOn) {
            Trace.trace(this, n + " unique Connections using QueueAgent");
        }
        int n3 = 0;
        while (n3 < n) {
            mQConnectionArray[n3].deliverException(jMSException);
            ++n3;
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverException");
        }
    }

    int getDomain() {
        return this.domainFlag;
    }
}

