/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import java.util.Properties;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.Referenceable;
import javax.naming.StringRefAddr;

public class MQQueue
extends MQDestination
implements Queue,
Referenceable,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002.    All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQQueue.java, jms, j521, j521-L020126 02/01/25 15:18:51 @(#) 1.39.1.1";
    private String baseQueueName;
    private String baseQueueManagerName;
    private String cachedQueueName;
    private String cachedNameValues;
    private String cachedBaseQmgrName;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueue;
    static /* synthetic */ Class class$com$ibm$mq$jms$MQQueueFactory;

    public MQQueue() {
        this.baseQueueName = null;
        this.baseQueueManagerName = "";
        this.cachedQueueName = null;
        this.cachedNameValues = null;
        this.cachedBaseQmgrName = null;
        if (Trace.isOn) {
            Trace.entry(this, "constructor()");
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor()");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQQueue(String string) throws JMSException {
        block11: {
            block10: {
                this.baseQueueName = null;
                this.baseQueueManagerName = "";
                this.cachedQueueName = null;
                this.cachedNameValues = null;
                this.cachedBaseQmgrName = null;
                String string2 = "MQJMS0003";
                try {
                    String string3;
                    if (Trace.isOn) {
                        Trace.entry(this, "constructor(queueName)");
                    }
                    if (string == null || string.trim().equals("")) {
                        String string4 = ConfigEnvironment.getErrorMessage(string2);
                        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string4, string2);
                        throw invalidDestinationException;
                    }
                    if (string.startsWith("queue://")) {
                        string3 = string.length() > 8 ? string.substring(8) : "";
                    } else {
                        this.setBaseQueueName(string);
                        Object var9_10 = null;
                        if (!Trace.isOn) return;
                        break block10;
                    }
                    int n = string3.indexOf(47);
                    if (n == -1) {
                        String string5 = ConfigEnvironment.getErrorMessage(string2);
                        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string2);
                        throw invalidDestinationException;
                    }
                    this.setBaseQueueManagerName(string3.substring(0, n));
                    if (string3.length() <= n + 1) {
                        String string6 = ConfigEnvironment.getErrorMessage(string2);
                        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string6, string2);
                        throw invalidDestinationException;
                    }
                    int n2 = (string3 = string3.substring(n + 1)).indexOf(63);
                    if (n2 != -1) {
                        this.setBaseQueueName(string3.substring(0, n2));
                        String string7 = string3.substring(n2 + 1);
                        Properties properties2 = this.getPropertiesFromURI(string7);
                        this.setFromProperties(properties2);
                        break block11;
                    } else {
                        this.setBaseQueueName(string3);
                    }
                    break block11;
                }
                catch (Throwable throwable) {
                    Object var9_12 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "constructor(queueName)");
                    throw throwable;
                }
            }
            Trace.exit(this, "constructor(queueName)");
            return;
        }
        Object var9_11 = null;
        if (!Trace.isOn) return;
        Trace.exit(this, "constructor(queueName)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MQQueue(String string, String string2) throws JMSException {
        this.baseQueueName = null;
        this.baseQueueManagerName = "";
        this.cachedQueueName = null;
        this.cachedNameValues = null;
        this.cachedBaseQmgrName = null;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "constructor(qmgr, q)");
                }
                this.setBaseQueueName(string2);
                this.setBaseQueueManagerName(string);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_3 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor(qmgr, q)");
            throw throwable;
        }
        Trace.exit(this, "constructor(qmgr, q)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getQueueName() {
        CharSequence charSequence;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueueName");
            }
            String string = this.getNVs();
            if (this.cachedQueueName == null || string != this.cachedNameValues || this.baseQueueManagerName != this.cachedBaseQmgrName) {
                charSequence = new StringBuffer("queue://");
                if (this.baseQueueManagerName != null) {
                    ((StringBuffer)charSequence).append(this.baseQueueManagerName);
                }
                ((StringBuffer)charSequence).append("/");
                if (this.baseQueueName != null) {
                    ((StringBuffer)charSequence).append(this.baseQueueName);
                }
                ((StringBuffer)charSequence).append(this.getNVs());
                this.cachedQueueName = ((StringBuffer)charSequence).toString();
                this.cachedNameValues = string;
                this.cachedBaseQmgrName = this.baseQueueManagerName;
            }
            charSequence = this.cachedQueueName;
            Object var4_3 = null;
            if (!Trace.isOn) return charSequence;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getQueueName");
            throw throwable;
        }
        Trace.exit(this, "getQueueName");
        return charSequence;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String toString() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "toString");
            }
            string = this.getQueueName();
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "toString");
            throw throwable;
        }
        Trace.exit(this, "toString");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Reference getReference() throws NamingException {
        Reference reference;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReference");
            }
            String string = null;
            Reference reference2 = new Reference((class$com$ibm$mq$jms$MQQueue == null ? (class$com$ibm$mq$jms$MQQueue = MQQueue.class$("com.ibm.mq.jms.MQQueue")) : class$com$ibm$mq$jms$MQQueue).getName(), (class$com$ibm$mq$jms$MQQueueFactory == null ? (class$com$ibm$mq$jms$MQQueueFactory = MQQueue.class$("com.ibm.mq.jms.MQQueueFactory")) : class$com$ibm$mq$jms$MQQueueFactory).getName(), null);
            reference2.add(new StringRefAddr("VER", String.valueOf(this.getVersion())));
            string = this.getDescription();
            if (string != null) {
                reference2.add(new StringRefAddr("DESC", string));
            }
            reference2.add(new StringRefAddr("EXP", String.valueOf(this.getExpiry())));
            reference2.add(new StringRefAddr("PRI", String.valueOf(this.getPriority())));
            reference2.add(new StringRefAddr("PER", String.valueOf(this.getPersistence())));
            reference2.add(new StringRefAddr("CCS", String.valueOf(this.getCCSID())));
            reference2.add(new StringRefAddr("TC", String.valueOf(this.getTargetClient())));
            reference2.add(new StringRefAddr("ENC", String.valueOf(this.getEncoding())));
            string = this.getBaseQueueName();
            if (string != null) {
                reference2.add(new StringRefAddr("QU", string));
            }
            if ((string = this.getBaseQueueManagerName()) != null) {
                reference2.add(new StringRefAddr("QMGR", string));
            }
            reference = reference2;
            Object var5_4 = null;
            if (!Trace.isOn) return reference;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getReference");
            throw throwable;
        }
        Trace.exit(this, "getReference");
        return reference;
    }

    public void setBaseQueueName(String string) throws JMSException {
        String string2 = null;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setBaseQueueName");
                }
                if (string != null) {
                    string2 = string.trim();
                }
                if (string2 == null || string2.length() > 48 || string2.equals("")) {
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "<null>";
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "baseQueueName", string3);
                    throw jMSException;
                }
                this.baseQueueName = string2;
            }
            catch (JMSException jMSException) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Trace.exit(this, "setBaseQueueName");
            throw throwable;
        }
        Trace.exit(this, "setBaseQueueName");
    }

    public void setBaseQueueManagerName(String string) throws JMSException {
        String string2 = null;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setBaseQueueManagerName");
                }
                if (string != null) {
                    string2 = string.trim();
                }
                if (string2 == null || string2.length() > 48) {
                    String string3 = string2;
                    if (string3 == null) {
                        string3 = "<null>";
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "baseQueueManagerName", string3);
                    throw jMSException;
                }
                this.baseQueueManagerName = string2;
            }
            catch (JMSException jMSException) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var6_6 = null;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            Trace.exit(this, "setBaseQueueManagerName");
            throw throwable;
        }
        Trace.exit(this, "setBaseQueueManagerName");
    }

    public String getBaseQueueName() {
        String string;
        try {
            Trace.entry(this, "getBaseQueueName");
            string = this.baseQueueName;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.exit(this, "getBaseQueueName");
            throw throwable;
        }
        Trace.exit(this, "getBaseQueueName");
        return string;
    }

    public String getBaseQueueManagerName() {
        String string;
        try {
            Trace.entry(this, "getBaseQueueManagerName");
            string = this.baseQueueManagerName;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.exit(this, "getBaseQueueManagerName");
            throw throwable;
        }
        Trace.exit(this, "getBaseQueueManagerName");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl2 = false;
            } else if (object instanceof MQQueue) {
                MQQueue mQQueue = (MQQueue)object;
                bl2 = super.equals(object) && this.twoStringsEqual(this.baseQueueName, mQQueue.baseQueueName) && this.twoStringsEqual(this.baseQueueManagerName, mQQueue.baseQueueManagerName);
            } else {
                bl2 = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl2);
            }
            bl = bl2;
            Object var6_5 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "equals");
            throw throwable;
        }
        Trace.exit(this, "equals");
        return bl;
    }

    public int hashCode() {
        int n = super.hashCode();
        if (this.baseQueueName != null) {
            n ^= this.baseQueueName.hashCode();
        }
        if (this.baseQueueManagerName != null) {
            n ^= this.baseQueueManagerName.hashCode();
        }
        return n;
    }

    void setFromProperties(Properties properties2) throws JMSException {
        super.setFromProperties(properties2);
    }

    void checkAccess(MQQueueConnection mQQueueConnection) throws JMSException {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

