/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQC;
import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQManagedObject;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.JMSC;
import com.ibm.mq.jms.MQSubAdmin;
import com.ibm.mq.jms.MQSubEntry;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.SubscriptionInfo;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.TopicSession;

class MQPSStatusMgr {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQPSStatusMgr.java, jms, j521, j521-L020703 02/07/02 11:42:22 @(#) 1.16.1.2";
    private final String JVM_MSG_SIGNATURE = "MQJMS_PS_JVM_STATUS_MSG";
    private static Hashtable statusMgrConnections;
    private static Integer statusMgrConnectionsLock;
    private MQQueueManager cleanup_qmgr;
    private String cleanup_controlQName;
    private String cleanup_streamQName;
    private static long monitorDelay;
    private static int messageReadDelay;
    private static int statusMgrConnectionThreadID;

    MQPSStatusMgr() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    MQPSStatusMgr(MQQueueManager mQQueueManager, String string, String string2) {
        if (Trace.isOn) {
            Trace.entry(this, "constructor(qmgr,conq,streamq)");
            Trace.trace(this, sccsid);
        }
        this.cleanup_qmgr = mQQueueManager;
        this.cleanup_controlQName = string;
        this.cleanup_streamQName = string2;
        MQException.log = null;
        if (Trace.isOn) {
            Trace.exit(this, "constructor(qmgr,conq,streamq)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    byte[] addConnection(MQTopicConnection mQTopicConnection) throws JMSException {
        byte[] byArray;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "addConnection");
            }
            Hashtable hashtable = mQTopicConnection.mqProperties;
            String string = mQTopicConnection.getConnectionID();
            StatusMgrConnection statusMgrConnection = null;
            String string2 = hashtable.get("transport").equals("MQSeries Bindings") ? this.cleanup_qmgr.name.trim() : this.cleanup_qmgr.name.trim() + hashtable.get("hostname") + hashtable.get("channel") + hashtable.get("port");
            Integer n = statusMgrConnectionsLock;
            synchronized (n) {
                if (statusMgrConnections == null) {
                    statusMgrConnections = new Hashtable();
                } else {
                    statusMgrConnection = (StatusMgrConnection)statusMgrConnections.get(string2);
                }
                if (statusMgrConnection != null) {
                    statusMgrConnection.addUser(string);
                    try {
                        this.cleanup_qmgr.disconnect();
                        this.cleanup_qmgr = null;
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        throw jMSException;
                    }
                } else {
                    statusMgrConnection = new StatusMgrConnection(this.cleanup_qmgr, mQTopicConnection);
                    statusMgrConnections.put(string2, statusMgrConnection);
                    this.cleanup_qmgr = null;
                }
            }
            if (Trace.isOn) {
                Trace.trace(this, "addConnection: JVM reference id = " + statusMgrConnection.jvmReferenceId());
            }
            byArray = statusMgrConnection.jvmReferenceId();
            Object var11_11 = null;
            if (!Trace.isOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "addConnection");
            throw throwable;
        }
        Trace.exit(this, "addConnection");
        return byArray;
    }

    void removeConnection(String string, Hashtable hashtable, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "removeConnection");
        }
        String string3 = hashtable.get("transport").equals("MQSeries Bindings") ? string : string + hashtable.get("hostname") + hashtable.get("channel") + hashtable.get("port");
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            StatusMgrConnection statusMgrConnection = (StatusMgrConnection)statusMgrConnections.get(string3);
            if (statusMgrConnection != null) {
                if (statusMgrConnection.removeUser(string2) == 0 && (statusMgrConnection = (StatusMgrConnection)statusMgrConnections.remove(string3)) == null && Trace.isOn) {
                    Trace.trace(this, "removeConnection error: hashtable remove failed");
                }
            } else if (Trace.isOn) {
                Trace.trace(this, "removeConnection error: connection not found. Called from TC finalizer after initial close?");
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "removeConnection");
        }
    }

    void cleanup(MQQueueManager mQQueueManager) {
        block54: {
            if (Trace.isOn) {
                Trace.entry(this, "cleanup");
            }
            try {
                MQQueue mQQueue;
                MQTopicSession mQTopicSession;
                block53: {
                    mQTopicSession = new MQTopicSession(mQQueueManager, this.cleanup_controlQName, this.cleanup_streamQName);
                    int n = 26;
                    mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n);
                    int n2 = 0;
                    try {
                        while (true) {
                            block52: {
                                boolean bl = false;
                                MQMessage mQMessage = new MQMessage();
                                mQMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                                mQGetMessageOptions.options = n2 == 0 ? 16 : 32;
                                mQQueue.get(mQMessage, mQGetMessageOptions);
                                boolean bl2 = false;
                                String string = "";
                                if (mQMessage.getMessageLength() > 0) {
                                    string = mQMessage.readLine();
                                }
                                if (string.indexOf("MQJMS_PS_JVM_STATUS_MSG") != 0) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "cleanup: Invalid JVM message signature found within status queue message! Removing.");
                                    }
                                    try {
                                        mQQueue.get(mQMessage);
                                    }
                                    catch (MQException mQException) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "cleanup: remove of invalid msg failed, ignoring. Exception: " + (Object)((Object)mQException));
                                        }
                                    }
                                } else if (string.indexOf("backout") != -1) {
                                    if (mQMessage.backoutCount > 0) {
                                        bl2 = true;
                                    } else if (Trace.isOn) {
                                        Trace.trace(this, "cleanup: invalid backout count detected; ignoring message.");
                                    }
                                } else {
                                    bl2 = true;
                                }
                                byte[] byArray = mQMessage.messageId;
                                if (bl2) {
                                    block51: {
                                        int n3 = 0;
                                        try {
                                            while (true) {
                                                MQMessage mQMessage2;
                                                block49: {
                                                    mQMessage2 = new MQMessage();
                                                    mQMessage2.correlationId = byArray;
                                                    mQGetMessageOptions = new MQGetMessageOptions();
                                                    mQGetMessageOptions.options = n3 == 0 ? 16 : 32;
                                                    mQQueue.get(mQMessage2, mQGetMessageOptions);
                                                    MQSubEntry mQSubEntry = new MQSubEntry(mQMessage2);
                                                    try {
                                                        SubscriptionHelper.deleteSubscriber(mQTopicSession.getQM(), mQTopicSession.getBrk(), mQSubEntry);
                                                    }
                                                    catch (JMSException jMSException) {
                                                        bl = true;
                                                        if (!Trace.isOn) break block49;
                                                        Trace.trace(this, "cleanup: Non durable record search caught unexpected exception: " + (Object)((Object)jMSException));
                                                    }
                                                }
                                                if (!bl) {
                                                    try {
                                                        mQQueue.get(mQMessage2);
                                                    }
                                                    catch (MQException mQException) {
                                                        bl = true;
                                                        throw mQException;
                                                    }
                                                }
                                                ++n3;
                                            }
                                        }
                                        catch (MQException mQException) {
                                            if (mQException.reasonCode == 2033) {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "cleanup: Finished retrieving all non durable records (caught 2033). Found " + n3 + " records");
                                                }
                                            } else {
                                                bl = true;
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "cleanup: Non durable record search caught unexpected exception: " + (Object)((Object)mQException));
                                                }
                                            }
                                            int n4 = 0;
                                            boolean bl3 = true;
                                            MQSubAdmin mQSubAdmin = null;
                                            try {
                                                mQSubAdmin = new MQSubAdmin(mQTopicSession.qm);
                                                while (bl3) {
                                                    MQSubEntry mQSubEntry = null;
                                                    mQSubEntry = n4 == 0 ? mQSubAdmin.getResolved(mQTopicSession.getQM(), mQTopicSession.getBrk(), null, byArray, false) : mQSubAdmin.getResolved(mQTopicSession.getQM(), mQTopicSession.getBrk(), null, byArray, true);
                                                    if (mQSubEntry != null) {
                                                        block50: {
                                                            if (mQSubEntry.getSubscriberState() == 'u') {
                                                                try {
                                                                    mQSubEntry.setSubscriberState('i');
                                                                    mQSubEntry.setStatusMgrId(MQC.MQCI_NONE);
                                                                    mQSubAdmin.add(mQSubEntry, false);
                                                                    mQSubAdmin.remove(mQSubEntry);
                                                                }
                                                                catch (JMSException jMSException) {
                                                                    bl = true;
                                                                    if (!Trace.isOn) break block50;
                                                                    Trace.trace(this, "cleanup: Durable record search caught unexpected exception: " + (Object)((Object)jMSException));
                                                                }
                                                            }
                                                        }
                                                        ++n4;
                                                        continue;
                                                    }
                                                    bl3 = false;
                                                }
                                                mQSubAdmin.close();
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "cleanup: Finished retrieving all durable records. Found " + n4 + " records");
                                                }
                                            }
                                            catch (JMSException jMSException) {
                                                if (mQSubAdmin != null) {
                                                    mQSubAdmin.close();
                                                }
                                                bl = true;
                                                if (!Trace.isOn) break block51;
                                                Trace.trace(this, "cleanup: Durable record search caught unexpected exception: " + (Object)((Object)jMSException));
                                            }
                                        }
                                    }
                                    try {
                                        mQGetMessageOptions.options = 16;
                                        mQQueue.get(mQMessage, mQGetMessageOptions);
                                        if (!bl) {
                                            mQQueue.get(mQMessage);
                                        }
                                    }
                                    catch (MQException mQException) {
                                        if (!Trace.isOn) break block52;
                                        Trace.trace(this, "cleanup: status queue jvm msg remove failed with exception: " + (Object)((Object)mQException));
                                    }
                                }
                            }
                            ++n2;
                        }
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(this, "cleanup: Finished retrieving all JVM reference messages (caught 2033). Found " + n2 + " msgs");
                            }
                        } else if (Trace.isOn) {
                            Trace.trace(this, "cleanup: JVM ref. msg search caught unexpected  exception: " + (Object)((Object)mQException));
                        }
                    }
                    catch (IOException iOException) {
                        if (!Trace.isOn) break block53;
                        Trace.trace(this, "cleanup: JVM ref. msg search caught unexpected IO exception: " + iOException);
                    }
                }
                mQTopicSession.qm = null;
                mQTopicSession.close();
                mQTopicSession = null;
                mQQueue.close();
            }
            catch (Exception exception) {
                if (!Trace.isOn) break block54;
                Trace.trace(this, "cleanup ERROR: Caught unexpected exception: " + exception);
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "cleanup");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void forcedCleanup(MQQueueManager mQQueueManager) {
        try {
            String string;
            String[] stringArray;
            Object object;
            Vector vector;
            Exception exception;
            Object object2;
            MQGetMessageOptions mQGetMessageOptions;
            MQMessage mQMessage;
            int n;
            BrokerConnectionInfo brokerConnectionInfo;
            block59: {
                MQTopicSession mQTopicSession = new MQTopicSession(mQQueueManager, this.cleanup_controlQName, this.cleanup_streamQName);
                brokerConnectionInfo = mQTopicSession.getBrk();
                System.out.println("Processing SYSTEM.JMS.PS.STATUS.QUEUE");
                n = 26;
                MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", n);
                mQMessage = new MQMessage();
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 16;
                mQGetMessageOptions.matchOptions = 0;
                while (true) {
                    block57: {
                        try {
                            mQQueue.get(mQMessage, mQGetMessageOptions);
                        }
                        catch (MQException mQException) {
                            break;
                        }
                        if (Utils.byteArraysEqual(mQMessage.correlationId, JMSC.PS_TERMMSG_CORRELID)) {
                            System.out.println("deleting termination message");
                            mQGetMessageOptions.options = 256;
                            mQQueue.get(mQMessage, mQGetMessageOptions);
                        } else if (Utils.byteArraysEqual(mQMessage.correlationId, JMSC.PS_JVM_REFMSG_CORRELID)) {
                            System.out.println("deleting JVM reference message");
                            mQGetMessageOptions.options = 256;
                            mQQueue.get(mQMessage, mQGetMessageOptions);
                        } else {
                            String string2 = "";
                            try {
                                string2 = mQMessage.readString("MQJMS_PS_SUBENTRY_v2".length());
                            }
                            catch (Exception exception2) {
                                // empty catch block
                            }
                            if (string2.equals("MQJMS_PS_SUBENTRY_v2") || string2.equals("MQJMS_PS_ADMIN_ENTRY")) {
                                try {
                                    mQMessage.seek(0);
                                    MQSubEntry mQSubEntry = new MQSubEntry(mQMessage);
                                    System.out.println("deleting subscription: " + mQSubEntry);
                                    SubscriptionHelper.deleteSubscriber(mQQueueManager, brokerConnectionInfo, mQSubEntry);
                                    mQGetMessageOptions.options = 256;
                                    mQQueue.get(mQMessage, mQGetMessageOptions);
                                }
                                catch (JMSException jMSException) {
                                    System.err.println("failed to process non-durable subscription: " + (Object)((Object)jMSException));
                                    object2 = jMSException.getLinkedException();
                                    if (object2 != null) {
                                        System.err.println("linked exception: " + object2);
                                    }
                                    break block57;
                                }
                            }
                            System.out.println("ignoring unrecognised message on SYSTEM.JMS.PS.STATUS.QUEUE");
                        }
                    }
                    mQGetMessageOptions.options = 32;
                }
                mQQueue.close();
                System.out.println("processing SYSTEM.JMS.ADMIN.QUEUE");
                MQSubAdmin mQSubAdmin = null;
                try {
                    try {
                        mQSubAdmin = new MQSubAdmin(mQQueueManager);
                        boolean bl = false;
                        while (true) {
                            object2 = mQSubAdmin.getResolved(mQQueueManager, brokerConnectionInfo, null, null, bl);
                            bl = true;
                            if (object2 == null) {
                                mQSubAdmin.close();
                                mQSubAdmin = null;
                                break;
                            }
                            System.out.println("examining " + object2);
                            if (((MQSubEntry)object2).getSubscriberState() == 'u') {
                                System.out.println("converting to inactive state");
                                try {
                                    ((MQSubEntry)object2).setSubscriberState('i');
                                    ((MQSubEntry)object2).setStatusMgrId(MQC.MQCI_NONE);
                                    mQSubAdmin.add((MQSubEntry)object2, false);
                                    mQSubAdmin.remove((MQSubEntry)object2);
                                }
                                catch (JMSException jMSException) {
                                    System.err.println("problem changing durable subscription to inactive state: " + (Object)((Object)jMSException));
                                    exception = jMSException.getLinkedException();
                                    if (exception == null) continue;
                                    System.err.println("linked exception: " + exception);
                                }
                                continue;
                            }
                            if (((MQSubEntry)object2).getSubscriberState() != 'i') continue;
                            System.out.println("XXX qmEntries needed");
                        }
                    }
                    catch (JMSException jMSException) {
                        System.err.println("problem whilst processing SYSTEM.JMS.ADMIN.QUEUE: " + (Object)((Object)jMSException));
                        object2 = jMSException.getLinkedException();
                        if (object2 != null) {
                            System.err.println("linked exception: " + object2);
                        }
                        vector = null;
                        if (mQSubAdmin != null) {
                            mQSubAdmin.close();
                        }
                        break block59;
                    }
                    vector = null;
                    if (mQSubAdmin == null) break block59;
                }
                catch (Throwable throwable) {
                    Object var14_30 = null;
                    if (mQSubAdmin == null) throw throwable;
                    mQSubAdmin.close();
                    throw throwable;
                }
                mQSubAdmin.close();
            }
            try {
                System.out.println("Emptying SYSTEM.JMS.ND.SUBSCRIBER.QUEUE");
                try {
                    Utils.clearQueue(mQQueueManager, "SYSTEM.JMS.ND.SUBSCRIBER.QUEUE");
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                n = 2;
                object = mQQueueManager.accessQueue("SYSTEM.JMS.ND.SUBSCRIBER.QUEUE", n);
                mQMessage = new MQMessage();
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 64;
                mQGetMessageOptions.matchOptions = 0;
                while (true) {
                    try {
                        while (true) {
                            object.get(mQMessage, mQGetMessageOptions, 1);
                        }
                    }
                    catch (MQException mQException) {
                        if (mQException.completionCode != 2) continue;
                        object.close();
                    }
                    break;
                }
            }
            catch (Exception exception3) {
                System.err.println("problem whilst processing SYSTEM.JMS.ND.SUBSCRIBER.QUEUE: " + exception3);
            }
            try {
                System.out.println("Emptying SYSTEM.JMS.REPORT.QUEUE");
                try {
                    Utils.clearQueue(mQQueueManager, "SYSTEM.JMS.REPORT.QUEUE");
                }
                catch (JMSException jMSException) {
                    // empty catch block
                }
                n = 2;
                object = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", n);
                mQMessage = new MQMessage();
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 64;
                mQGetMessageOptions.matchOptions = 0;
                while (true) {
                    try {
                        while (true) {
                            object.get(mQMessage, mQGetMessageOptions, 1);
                        }
                    }
                    catch (MQException mQException) {
                        if (mQException.completionCode != 2) continue;
                        object.close();
                    }
                    break;
                }
            }
            catch (Exception exception4) {
                System.err.println("problem whilst processing SYSTEM.JMS.REPORT.QUEUE: " + exception4);
            }
            object = new MQTopicConnectionFactory();
            ((MQTopicConnectionFactory)object).setBrokerControlQueue(this.cleanup_controlQName);
            ((MQTopicConnectionFactory)object).setBrokerPubQueue(this.cleanup_streamQName);
            object2 = null;
            try {
                object2 = ((MQTopicConnectionFactory)object).createTopicConnection();
                stringArray = (String[])object2.createTopicSession(false, 1);
                exception = stringArray.getQM();
                object2.start();
                string = Utils.inquireString((MQManagedObject)exception, 2015);
                if (string == null) {
                    throw new Exception("Unable to resolve queue manager name. Check current user has INQ access to queue manager. Quitting.");
                }
                vector = SubscriptionHelper.getBrokerSubs(string, (TopicSession)stringArray);
                SubscriptionInfo subscriptionInfo = new SubscriptionInfo();
                subscriptionInfo.qName = "SYSTEM.JMS.ND.*";
                subscriptionInfo.qMgrName = string;
                if ((vector = SubscriptionHelper.getMatchingSubs(vector, subscriptionInfo)) != null) {
                    int n2 = 0;
                    while (n2 < vector.size()) {
                        SubscriptionInfo subscriptionInfo2 = (SubscriptionInfo)vector.elementAt(n2);
                        boolean bl = subscriptionInfo2.correlId != null;
                        MQSubEntry mQSubEntry = new MQSubEntry(null, subscriptionInfo2.topicName, subscriptionInfo2.qName, null, bl);
                        if (bl) {
                            mQSubEntry.setSubscriberId(this.toByteArray(subscriptionInfo2.correlId));
                        }
                        try {
                            System.out.print("Destroying " + subscriptionInfo2.qName.trim());
                            if (bl) {
                                System.out.print(" [" + subscriptionInfo2.correlId + "]");
                            }
                            System.out.println(" subscription... ");
                            System.out.println(mQSubEntry);
                            SubscriptionHelper.deleteSubscriber((MQQueueManager)exception, brokerConnectionInfo, mQSubEntry);
                        }
                        catch (JMSException jMSException) {
                            System.err.println("FAILED with " + (Object)((Object)jMSException));
                        }
                        ++n2;
                    }
                }
                System.out.println("force cleanup incomplete - code needed to check broker durable subs");
                Object var22_40 = null;
            }
            catch (Throwable throwable) {
                Object var22_41 = null;
                object2.close();
                throw throwable;
            }
            object2.close();
            System.out.println("Checking for orphaned non-durable queues");
            stringArray = Utils.listMatchingQueues(mQQueueManager, "SYSTEM.JMS.ND.*");
            if (stringArray == null) {
                System.out.println("Unable to get list of queues from queue manager - is the command server running?");
                return;
            }
            int n3 = 0;
            while (true) {
                if (n3 >= stringArray.length) {
                    return;
                }
                try {
                    System.out.println("checking queue: " + stringArray[n3]);
                    n = 32;
                    string = mQQueueManager.accessQueue(stringArray[n3], n);
                    if (string.getDefinitionType() == 2) {
                        System.out.println("deleting");
                        ((MQManagedObject)string).closeOptions = 2;
                        string.close();
                    }
                }
                catch (MQException mQException) {
                    System.out.println("couldn't delete " + stringArray[n3] + " because of " + (Object)((Object)mQException));
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            System.err.println("Forced cleanup failed: " + exception);
            exception.printStackTrace();
        }
    }

    public void close() {
        this.cleanup_qmgr = null;
        Integer n = statusMgrConnectionsLock;
        synchronized (n) {
            if (statusMgrConnections != null && statusMgrConnections.isEmpty()) {
                statusMgrConnections = null;
            }
        }
    }

    public static void main(String[] stringArray) {
        boolean bl = false;
        String string = "";
        try {
            Object object;
            System.out.println("IBM MQSeries JMS pub/sub status manager utility.");
            int n = 0;
            while (n < stringArray.length) {
                object = stringArray[n].toUpperCase();
                if (((String)object).equals("-M")) {
                    if (n + 1 == stringArray.length) {
                        MQPSStatusMgr.showUsage();
                    } else {
                        string = stringArray[++n];
                    }
                } else {
                    MQPSStatusMgr.showUsage();
                }
                ++n;
            }
            object = new MQQueueManager(string);
            MQPSStatusMgr mQPSStatusMgr = new MQPSStatusMgr((MQQueueManager)object, "SYSTEM.BROKER.CONTROL.QUEUE", "SYSTEM.BROKER.DEFAULT.STREAM");
            if (bl) {
                mQPSStatusMgr.forcedCleanup((MQQueueManager)object);
                System.exit(0);
            }
            System.out.println("Monitor started.");
            System.out.println("Hit ctrl-c to end monitor at any time.");
            while (true) {
                System.out.print("Attempting cleanup... ");
                mQPSStatusMgr.cleanup((MQQueueManager)object);
                System.out.println("cleanup complete.");
                try {
                    Thread.sleep(monitorDelay * 1000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception exception) {
            System.out.println("Exception thrown during MQPSStatusMgr init: " + exception);
            return;
        }
    }

    public static void showUsage() {
        System.out.println("Usage: java com.ibm.mq.jms.MQPSStatusMgr [options]");
        System.out.println("Options:");
        System.out.println("-m <qmgrName>\tSpecify the queue manager to connect to");
        System.exit(-1);
    }

    private byte[] toByteArray(String string) {
        byte[] byArray = null;
        if (string != null) {
            int n = string.length();
            byArray = new byte[n / 2];
            int n2 = 0;
            while (n2 < n) {
                byte by;
                byArray[n2 / 2] = by = (byte)Integer.parseInt(string.substring(n2, n2 + 2), 16);
                n2 += 2;
            }
        }
        return byArray;
    }

    static {
        statusMgrConnectionsLock = new Integer(0);
        monitorDelay = 30L;
        statusMgrConnectionThreadID = 0;
    }

    class StatusMgrConnection
    implements Runnable {
        public static final int MAX_SHUTDOWN_TIME = 5000;
        private MQQueueManager qmgr;
        private MQQueue statusQueue;
        private byte[] jvmReferenceId = null;
        private boolean refreshRequired = true;
        private boolean runFinished = false;
        private int refreshDelay;
        private MQTopicConnection topicConn;
        private Vector usageVector;
        private Thread thread;

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        StatusMgrConnection(MQQueueManager mQQueueManager, MQTopicConnection mQTopicConnection) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "constructor");
            }
            this.qmgr = mQQueueManager;
            this.topicConn = mQTopicConnection;
            this.refreshDelay = mQTopicConnection.getStatusRefreshInterval();
            try {
                try {
                    this.statusQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 18);
                    this.putJVMMessage(this.qmgr);
                    this.usageVector = new Vector();
                    this.addUser(mQTopicConnection.getConnectionID());
                    String string = "statusMgrConnection" + statusMgrConnectionThreadID;
                    statusMgrConnectionThreadID++;
                    this.thread = MQEnvironment.createThread((Runnable)this, (String)string, (boolean)true);
                    this.thread.start();
                }
                catch (MQException mQException) {
                    JMSException jMSException = mQException.reasonCode == 2085 ? ConfigEnvironment.newException("MQJMS3014", "SYSTEM.JMS.PS.STATUS.QUEUE") : ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
                Object var7_6 = null;
                if (!Trace.isOn) return;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "constructor");
                throw throwable;
            }
            Trace.exit(this, "constructor");
        }

        void addUser(String string) {
            if (Trace.isOn) {
                Trace.entry(this, "addUser");
            }
            if (!this.usageVector.contains(string)) {
                this.usageVector.addElement(string);
            } else if (Trace.isOn) {
                Trace.trace(this, "addUser error: token already exists.");
            }
            if (Trace.isOn) {
                Trace.exit(this, "addUser");
            }
        }

        int removeUser(String string) throws JMSException {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "removeUser");
            }
            if (!this.usageVector.contains(string)) {
                if (Trace.isOn) {
                    Trace.trace(this, "removeUser error: token not found.");
                }
            } else {
                this.usageVector.removeElement(string);
            }
            if ((n = this.usageVector.size()) == 0) {
                if (Trace.isOn) {
                    Trace.trace(this, "removeUser: no users left; closing connection.");
                }
                this.close();
            }
            if (Trace.isOn) {
                Trace.exit(this, "removeUser");
            }
            return n;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void putJVMMessage(MQQueueManager mQQueueManager) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "putJVMMessage");
            }
            try {
                try {
                    MQMessage mQMessage = new MQMessage();
                    if (this.jvmReferenceId != null) {
                        mQMessage.messageId = this.jvmReferenceId;
                    }
                    mQMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                    mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                    mQMessage.writeString("backout");
                    this.statusQueue.put(mQMessage);
                    if (this.jvmReferenceId == null) {
                        this.jvmReferenceId = mQMessage.messageId;
                    }
                    MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                    mQGetMessageOptions.options = 2;
                    this.statusQueue.get(mQMessage, mQGetMessageOptions);
                    mQMessage.clearMessage();
                    mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                    mQMessage.writeString("commit");
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    mQPutMessageOptions.options = 2;
                    this.statusQueue.put(mQMessage, mQPutMessageOptions);
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
                catch (IOException iOException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", iOException.toString());
                    jMSException.setLinkedException((Exception)iOException);
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
                Object var6_9 = null;
                if (!Trace.isOn) return;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "putJVMMessage");
                throw throwable;
            }
            Trace.exit(this, "putJVMMessage");
        }

        private void removeJVMMessage(MQQueueManager mQQueueManager) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "removeJVMMessage");
            }
            try {
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 2;
                MQMessage mQMessage = new MQMessage();
                mQMessage.messageId = this.jvmReferenceId;
                this.statusQueue.get(mQMessage, mQGetMessageOptions);
                if (mQQueueManager != null) {
                    mQQueueManager.commit();
                } else {
                    Trace.trace(this, "Saved NullPointerException on qm.commit");
                }
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    Trace.exit(this, "removeJVMMessage");
                }
                throw jMSException;
            }
            if (Trace.isOn) {
                Trace.exit(this, "removeJVMMessage");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void refreshJVMMessage(MQQueueManager mQQueueManager) throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "refreshJVMMessage");
            }
            try {
                try {
                    MQMessage mQMessage = new MQMessage();
                    mQMessage.messageId = this.jvmReferenceId;
                    mQMessage.correlationId = JMSC.PS_JVM_REFMSG_CORRELID;
                    mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                    mQMessage.writeString("backout");
                    this.statusQueue.put(mQMessage);
                    MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                    mQGetMessageOptions.options = 2;
                    this.statusQueue.get(mQMessage, mQGetMessageOptions);
                    mQQueueManager.commit();
                    this.statusQueue.get(mQMessage, mQGetMessageOptions);
                    mQMessage.clearMessage();
                    mQMessage.writeString("MQJMS_PS_JVM_STATUS_MSG");
                    mQMessage.writeString("commit");
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    mQPutMessageOptions.options = 2;
                    this.statusQueue.put(mQMessage, mQPutMessageOptions);
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    }
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    throw jMSException;
                }
                catch (IOException iOException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", iOException.toString());
                    jMSException.setLinkedException((Exception)iOException);
                    if (Trace.isOn) {
                        Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    }
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Linked Exception " + iOException);
                    throw jMSException;
                }
                Object var6_9 = null;
                if (!Trace.isOn) return;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "refreshJVMMessage");
                throw throwable;
            }
            Trace.exit(this, "refreshJVMMessage");
        }

        byte[] jvmReferenceId() {
            return this.jvmReferenceId;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        void close() throws JMSException {
            if (Trace.isOn) {
                Trace.entry(this, "close");
            }
            this.refreshRequired = false;
            if (Trace.isOn) {
                Trace.trace(this, "close ending run() loop");
            }
            try {
                try {
                    MQQueueManager mQQueueManager = this.topicConn.createQMNonXA();
                    this.topicConn = null;
                    MQQueue mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.PS.STATUS.QUEUE", 16);
                    MQMessage mQMessage = new MQMessage();
                    mQMessage.messageId = this.jvmReferenceId;
                    mQMessage.correlationId = JMSC.PS_TERMMSG_CORRELID;
                    mQMessage.expiry = 36000;
                    mQMessage.persistence = 0;
                    mQQueue.put(mQMessage);
                    this.waitForRunFinished();
                    mQQueueManager.disconnect();
                    this.usageVector = null;
                    this.qmgr = null;
                    this.jvmReferenceId = null;
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                    }
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                    throw jMSException;
                }
                Object var5_6 = null;
                if (!Trace.isOn) return;
            }
            catch (Throwable throwable) {
                Object var5_7 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "close");
                throw throwable;
            }
            Trace.exit(this, "close");
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private synchronized void setRunFinished() {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setRunFinished");
                }
                this.runFinished = true;
                this.notifyAll();
                Object var2_1 = null;
                if (!Trace.isOn) return;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "setRunFinished");
                throw throwable;
            }
            Trace.exit(this, "setRunFinished");
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private synchronized void waitForRunFinished() {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "waitForRunFinished");
                }
                long l = System.currentTimeMillis();
                long l2 = l + 5000L;
                while (true) {
                    block9: {
                        block8: {
                            if (this.runFinished) break block8;
                            if (l < l2) break block9;
                        }
                        Object var7_4 = null;
                        if (!Trace.isOn) return;
                        break;
                    }
                    try {
                        this.wait(l2 - l);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    l = System.currentTimeMillis();
                }
            }
            catch (Throwable throwable) {
                Object var7_5 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "waitForRunFinished");
                throw throwable;
            }
            Trace.exit(this, "waitForRunFinished");
        }

        /*
         * Loose catch block
         */
        public void run() {
            block25: {
                if (Trace.isOn) {
                    Trace.entry(this, "run");
                }
                MQPSStatusMgr.this.cleanup(this.qmgr);
                MQMessage mQMessage = new MQMessage();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                while (this.refreshRequired) {
                    mQMessage.messageId = this.jvmReferenceId;
                    mQMessage.correlationId = JMSC.PS_TERMMSG_CORRELID;
                    mQGetMessageOptions.options = 1;
                    mQGetMessageOptions.waitInterval = this.refreshDelay;
                    try {
                        if (Trace.isOn) {
                            Trace.trace(this, "run() attempting get/wait");
                        }
                        this.statusQueue.get(mQMessage, mQGetMessageOptions);
                        if (!this.refreshRequired) continue;
                        if (Trace.isOn) {
                            Trace.trace(this, "run() error: invalid message retrieved?");
                        }
                        this.refreshRequired = false;
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(this, "run() get/wait finished with 2033 - refreshing JVM msg");
                            }
                            this.refreshJVMMessage(this.qmgr);
                            continue;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "run() error: caught unexpected  exception attempting get/wait: " + (Object)((Object)mQException));
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        if (Trace.isOn) {
                            Trace.trace(this, "Create & Throwing " + (Object)((Object)jMSException));
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                        }
                        throw jMSException;
                    }
                }
                this.removeJVMMessage(this.qmgr);
                Object var6_6 = null;
                try {
                    this.qmgr.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.qmgr = null;
                this.setRunFinished();
                if (Trace.isOn) {
                    Trace.exit(this, "run");
                }
                break block25;
                {
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "run", (Throwable)jMSException);
                        }
                        Object var6_7 = null;
                        try {
                            this.qmgr.disconnect();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.qmgr = null;
                        this.setRunFinished();
                        if (Trace.isOn) {
                            Trace.exit(this, "run");
                        }
                    }
                }
                catch (Throwable throwable) {
                    Object var6_8 = null;
                    try {
                        this.qmgr.disconnect();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.qmgr = null;
                    this.setRunFinished();
                    if (Trace.isOn) {
                        Trace.exit(this, "run");
                    }
                    throw throwable;
                }
            }
        }
    }
}

