/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQBrokerSubscription;
import com.ibm.mq.jms.MQBrokerSubscriptionEngine;
import com.ibm.mq.jms.MQQueueSubscription;
import com.ibm.mq.jms.MQQueueSubscriptionEngine;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQMigrateSubscriptionEngine
extends MQSubscriptionEngine {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQMigrateSubscriptionEngine.java, jms, j521, j521-L020529 02/05/28 18:03:57 @(#) 1.2.1.18";
    private int useBrokerSubStore;
    private static final int BSS_AVAILABLE = 1;
    private static final int BSS_UNAVAILABLE = 0;
    private static final int BSS_UNKNOWN = -1;
    private MQQueueSubscriptionEngine queueSubStore;
    private MQBrokerSubscriptionEngine brokerSubStore;
    private int WSClone = 0;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQMigrateSubscriptionEngine(MQTopicConnection mQTopicConnection, MQTopicConnectionFactory mQTopicConnectionFactory, MQQueueManager mQQueueManager, String string) throws JMSException {
        super(mQTopicConnection);
        if (Trace.isOn) {
            Trace.entry(this, "MQMigrateSubscriptionEngine (constructor)");
        }
        try {
            block10: {
                try {
                    this.WSClone = mQTopicConnectionFactory.getCloneSupport();
                    this.useBrokerSubStore = -1;
                    if (!((MQSPIQueueManager)mQQueueManager).spiSupportsDeferred()) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Queue Manager doesn't support deferred messages - using Queue substore");
                        }
                        this.useBrokerSubStore = 0;
                    }
                    if (this.useBrokerSubStore == -1 || this.useBrokerSubStore == 0) {
                        this.queueSubStore = new MQQueueSubscriptionEngine(mQTopicConnection, mQQueueManager);
                    }
                    if (this.useBrokerSubStore != -1 && this.useBrokerSubStore != 1) break block10;
                    this.brokerSubStore = new MQBrokerSubscriptionEngine(mQTopicConnection, mQTopicConnectionFactory, string);
                }
                catch (MQException mQException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    Trace.exception(this, "MQMigrateSubscriptionEngine (constructor)", (Throwable)mQException);
                    throw jMSException;
                }
                catch (JMSException jMSException) {
                    Trace.exception(this, "MQMigrateSubscriptionEngine (constructor)", (Throwable)jMSException);
                    if (this.queueSubStore != null) {
                        this.queueSubStore.close();
                    }
                    if (this.brokerSubStore == null) throw jMSException;
                    this.brokerSubStore.close();
                    throw jMSException;
                }
            }
            Object var8_5 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "MQMigrateSubscriptionEngine (constructor)");
            return;
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "MQMigrateSubscriptionEngine (constructor)");
            throw throwable;
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQSubscription openSubscription(MQTopicSession var1_1, MQTopic var2_2, String var3_3, boolean var4_4, boolean var5_5, String var6_6) throws JMSException {
        var7_7 = true;
        var8_8 = null;
        if (Trace.isOn) {
            Trace.entry(this, "openSubscription");
        }
        try {
            try {
                block12: while (true) lbl-1000:
                // 4 sources

                {
                    if (!var7_7) {
                        var9_12 = var8_8;
                        var12_15 = null;
                        if (Trace.isOn == false) return var9_12;
                        break;
                    }
                    switch (this.useBrokerSubStore) {
                        case 1: {
                            var7_7 = false;
                            var8_8 = this.brokerSubStore.openSubscription(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6);
                            ** break;
                        }
                        case -1: {
                            try {
                                if (!((MQSPIQueueManager)var1_1.getQM()).spiSupportsDeferred()) {
                                    if (this.useBrokerSubStore != 0) {
                                        this.useBrokerSubStore = 0;
                                        this.brokerSubStore.close();
                                        this.brokerSubStore = null;
                                    }
                                    var7_7 = true;
                                    ** break;
                                }
                                try {
                                    var8_8 = (MQBrokerSubscription)this.brokerSubStore.openSubscription(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6);
                                    this.useBrokerSubStore = 1;
                                    var7_7 = false;
                                    ** break;
                                }
                                catch (JMSException var9_9) {
                                    if (var9_9 instanceof BrokerCommandFailedException && ((var10_14 = (BrokerCommandFailedException)var9_9).getReason() == 3083 || var10_14.getReason() == 2337)) {
                                        if (this.useBrokerSubStore != 0) {
                                            this.useBrokerSubStore = 0;
                                            this.brokerSubStore.close();
                                            this.brokerSubStore = null;
                                        }
                                        var7_7 = true;
                                        ** break;
                                    }
                                    if (Trace.isOn == false) throw var9_9;
                                    Trace.trace(this, "test of brokerSubStore failed. Broker type still unknown");
                                    throw var9_9;
                                }
lbl44:
                                // 3 sources

                                continue block12;
                            }
                            catch (Exception var9_10) {
                                if (var9_10 instanceof JMSException) {
                                    var10_14 = (JMSException)var9_10;
                                    throw var10_14;
                                }
                                var10_14 = ConfigEnvironment.newException("MQJMS1016");
                                var10_14.setLinkedException(var9_10);
                                throw var10_14;
                            }
                        }
                    }
                    if (this.WSClone == 1) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                        }
                        var9_11 = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                        throw var9_11;
                    }
                    var7_7 = false;
                    var8_8 = this.queueSubStore.openSubscription(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6);
                }
            }
            catch (JMSException var9_13) {
                if (Trace.isOn == false) throw var9_13;
                Trace.trace(this, "leaving via exception");
                throw var9_13;
            }
        }
        catch (Throwable var11_17) {
            var12_16 = null;
            if (Trace.isOn == false) throw var11_17;
            Trace.exit(this, "openSubscription");
            throw var11_17;
        }
        Trace.exit(this, "openSubscription");
        return var9_12;
    }

    public void closeSubscription(MQSubscription mQSubscription) throws JMSException {
        if (mQSubscription instanceof MQBrokerSubscription) {
            this.brokerSubStore.closeSubscription(mQSubscription);
        } else if (mQSubscription instanceof MQQueueSubscription) {
            this.queueSubStore.closeSubscription(mQSubscription);
        } else {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3049");
            throw jMSException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQSubscription openDurableSubscription(MQTopicSession mQTopicSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2, String string3) throws JMSException {
        MQBrokerSubscription mQBrokerSubscription;
        block72: {
            MQBrokerSubscription mQBrokerSubscription2;
            block71: {
                MQBrokerSubscription mQBrokerSubscription3;
                block68: {
                    MQSubscription mQSubscription;
                    block65: {
                        MQSubscription mQSubscription2;
                        block63: {
                            MQQueue mQQueue = null;
                            Object var9_9 = null;
                            MQQueueSubscription mQQueueSubscription = null;
                            MQBrokerSubscription mQBrokerSubscription4 = null;
                            boolean bl3 = false;
                            boolean bl4 = false;
                            Object var14_14 = null;
                            Object var15_15 = null;
                            Object var16_16 = null;
                            boolean bl5 = false;
                            boolean bl6 = false;
                            Object var20_19 = null;
                            Object var21_20 = null;
                            Object var22_21 = null;
                            Object var23_22 = null;
                            Object var24_23 = null;
                            Object var25_24 = null;
                            Object var26_25 = null;
                            if (Trace.isOn) {
                                Trace.entry(this, "openDurableSubscription");
                            }
                            try {
                                try {
                                    block66: {
                                        block67: {
                                            block64: {
                                                if (this.useBrokerSubStore == 0) {
                                                    if (this.WSClone == 1) {
                                                        if (Trace.isOn) {
                                                            Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                                                        }
                                                        JMSException jMSException = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                                                        throw jMSException;
                                                    }
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "BrokerSubStore unavailable. returning queueSubscription");
                                                    }
                                                    mQSubscription2 = this.queueSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                                    Object var31_44 = null;
                                                    if (!Trace.isOn) return mQSubscription2;
                                                    break block63;
                                                }
                                                if (this.useBrokerSubStore == -1) {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "brokerSubStore state unknown. Checking QM level");
                                                    }
                                                    try {
                                                        if (((MQSPIQueueManager)mQTopicSession.getQM()).spiSupportsDeferred()) break block64;
                                                        if (Trace.isOn) {
                                                            Trace.trace(this, "deferred messages not supported. Returning queueSubscription");
                                                        }
                                                        if (this.useBrokerSubStore != 0) {
                                                            this.useBrokerSubStore = 0;
                                                            this.brokerSubStore.close();
                                                            this.brokerSubStore = null;
                                                        }
                                                        if (this.WSClone == 1) {
                                                            if (Trace.isOn) {
                                                                Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                                                            }
                                                            JMSException jMSException = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                                                            throw jMSException;
                                                        }
                                                        mQSubscription = this.queueSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                                        break block65;
                                                    }
                                                    catch (Exception exception) {
                                                        JMSException jMSException;
                                                        if (exception instanceof JMSException) {
                                                            jMSException = (JMSException)((Object)exception);
                                                            throw jMSException;
                                                        }
                                                        jMSException = ConfigEnvironment.newException(exception.getMessage());
                                                        jMSException.setLinkedException(exception);
                                                        throw jMSException;
                                                    }
                                                }
                                            }
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Checking for existing queueSubscription");
                                            }
                                            try {
                                                mQQueue = this.getAdminQueueAccess(mQTopicSession);
                                            }
                                            catch (JMSException jMSException) {
                                                Exception exception = jMSException.getLinkedException();
                                                if (exception instanceof MQException && ((MQException)((Object)exception)).reasonCode == 2085) {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "adminQueue does not exist. Using brokerSubStore");
                                                    }
                                                    this.useBrokerSubStore = 1;
                                                    MQBrokerSubscription mQBrokerSubscription5 = mQBrokerSubscription4 = (MQBrokerSubscription)this.brokerSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                                    Object var31_46 = null;
                                                    if (!Trace.isOn) return mQBrokerSubscription5;
                                                    Trace.exit(this, "openDurableSubscription");
                                                    return mQBrokerSubscription5;
                                                }
                                                if (!Trace.isOn) throw jMSException;
                                                Trace.trace(this, "problem opening admin queue to check for existing subscription");
                                                Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                                                throw jMSException;
                                            }
                                            if (Trace.isOn) {
                                                Trace.trace(this, "opened adminQueue. Checking for existing subscription");
                                            }
                                            if ((mQQueueSubscription = this.checkQueueSubscription(mQTopicSession, string3, mQQueue)) != null) break block66;
                                            try {
                                                mQQueue.close();
                                            }
                                            catch (MQException mQException) {
                                                if (!Trace.isOn) break block67;
                                                Trace.trace(this, "error closing adminQueue");
                                                Trace.exception(this, "openDurableSubscription", (Throwable)mQException);
                                            }
                                        }
                                        try {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "no existing queueSubscription. attempting to return brokerSubscription");
                                            }
                                            mQBrokerSubscription4 = (MQBrokerSubscription)this.brokerSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                            this.useBrokerSubStore = 1;
                                            mQBrokerSubscription3 = mQBrokerSubscription4;
                                            break block68;
                                        }
                                        catch (JMSException jMSException) {
                                            BrokerCommandFailedException brokerCommandFailedException;
                                            if (jMSException instanceof BrokerCommandFailedException && ((brokerCommandFailedException = (BrokerCommandFailedException)jMSException).getReason() == 3083 || brokerCommandFailedException.getReason() == 2337)) {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "new broker commands not recognized. Returning new queueSubscription");
                                                }
                                                if (this.useBrokerSubStore != 0) {
                                                    this.useBrokerSubStore = 0;
                                                    this.brokerSubStore.close();
                                                    this.brokerSubStore = null;
                                                }
                                                if (this.WSClone != 1) {
                                                    MQQueueSubscription mQQueueSubscription2 = mQQueueSubscription = (MQQueueSubscription)this.queueSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                                    Object var31_48 = null;
                                                    if (!Trace.isOn) return mQQueueSubscription2;
                                                    Trace.exit(this, "openDurableSubscription");
                                                    return mQQueueSubscription2;
                                                }
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                                                }
                                                JMSException jMSException2 = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                                                throw jMSException2;
                                            }
                                            if (!Trace.isOn) throw jMSException;
                                            Trace.trace(this, "test of brokerSubStore failed. Broker type still unknown");
                                            throw jMSException;
                                        }
                                    }
                                    if (Trace.isOn) {
                                        Trace.trace(this, "queueSubscription exists:");
                                        Trace.trace(this, mQQueueSubscription.toString());
                                    }
                                    if (string == null) {
                                        string = new String();
                                    }
                                    if (mQQueueSubscription.getSelector() == null) {
                                        mQQueueSubscription.setSelector("");
                                    }
                                    if (!mQTopic.getBaseTopicName().equals(mQQueueSubscription.getTopic()) || !string.equals(mQQueueSubscription.getSelector())) {
                                        bl4 = true;
                                    }
                                    try {
                                        block69: {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "opening existing queueSubscription");
                                            }
                                            try {
                                                mQQueue.close();
                                            }
                                            catch (MQException mQException) {
                                                if (!Trace.isOn) break block69;
                                                Trace.trace(this, "error closing adminQueue");
                                                Trace.exception(this, "openDurableSubscription", (Throwable)mQException);
                                            }
                                        }
                                        mQQueueSubscription = (MQQueueSubscription)this.queueSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                        bl3 = true;
                                    }
                                    catch (JMSException jMSException) {
                                        if (!Trace.isOn) throw jMSException;
                                        Trace.trace(this, "error opening existing queueSubscription");
                                        throw jMSException;
                                    }
                                    if (bl4) {
                                        block70: {
                                            try {
                                                mQBrokerSubscription4 = (MQBrokerSubscription)this.brokerSubStore.openDurableSubscription(mQTopicSession, mQTopic, string, bl, bl2, string2, string3);
                                            }
                                            catch (JMSException jMSException) {
                                                BrokerCommandFailedException brokerCommandFailedException;
                                                if (!(jMSException instanceof BrokerCommandFailedException) || (brokerCommandFailedException = (BrokerCommandFailedException)jMSException).getReason() != 3083 && brokerCommandFailedException.getReason() != 2337) break block70;
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "new broker commands not recognized. Returning new queueSubscription");
                                                }
                                                if (this.useBrokerSubStore != 0) {
                                                    this.useBrokerSubStore = 0;
                                                    this.brokerSubStore.close();
                                                    this.brokerSubStore = null;
                                                }
                                                if (this.WSClone != 1) {
                                                    MQQueueSubscription mQQueueSubscription3 = mQQueueSubscription;
                                                    Object var31_49 = null;
                                                    if (!Trace.isOn) return mQQueueSubscription3;
                                                    Trace.exit(this, "openDurableSubscription");
                                                    return mQQueueSubscription3;
                                                }
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Cannot have clone support enabled for a queueSubscriptionEngine. Throwing Exception");
                                                }
                                                mQQueueSubscription.close();
                                                JMSException jMSException3 = ConfigEnvironment.newException("MQJMS4125", "SUBSTORE(BROKER)", "CLONESUPP(ENABLED)");
                                                throw jMSException3;
                                            }
                                        }
                                        mQQueueSubscription.close();
                                        this.queueSubStore.durableUnsubscribe(mQTopicSession, string3);
                                        mQBrokerSubscription2 = mQBrokerSubscription4;
                                        break block71;
                                    }
                                    try {
                                        mQBrokerSubscription4 = this.getMigratedSubscription(mQQueueSubscription, mQTopicSession, string3);
                                    }
                                    catch (JMSException jMSException) {
                                        if (this.useBrokerSubStore != 0) throw jMSException;
                                        if (Trace.isOn) {
                                            Trace.trace(this, "broker appears not to support brokerSubscriptions. Returning queueSubscription");
                                        }
                                        MQQueueSubscription mQQueueSubscription4 = mQQueueSubscription;
                                        Object var31_51 = null;
                                        if (!Trace.isOn) return mQQueueSubscription4;
                                        Trace.exit(this, "openDurableSubscription");
                                        return mQQueueSubscription4;
                                    }
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "removing old adminQueue entry");
                                        }
                                        this.removeQueueSubscription(mQTopicSession, mQQueueSubscription);
                                    }
                                    catch (JMSException jMSException) {
                                        if (!Trace.isOn) throw jMSException;
                                        Trace.trace(this, "error removing queueSubscription");
                                        throw jMSException;
                                    }
                                    mQBrokerSubscription = mQBrokerSubscription4;
                                    break block72;
                                }
                                catch (JMSException jMSException) {
                                    if (!bl3) throw jMSException;
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "closing opened queueSubscription");
                                        }
                                        this.queueSubStore.closeDurableSubscription(mQQueueSubscription);
                                        throw jMSException;
                                    }
                                    catch (JMSException jMSException4) {
                                        if (!Trace.isOn) throw jMSException;
                                        Trace.trace(this, "error closing queueSubscription after exception");
                                        Trace.exception(this, "openDurableSubscription", (Throwable)jMSException4);
                                    }
                                    throw jMSException;
                                }
                                catch (Exception exception) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Caught an unexpected exception (non MQ or JMS Exception)");
                                        Trace.exception(this, "openDurableSubscription", (Throwable)exception);
                                    }
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1031");
                                    jMSException.setLinkedException(exception);
                                    throw jMSException;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var31_53 = null;
                                if (!Trace.isOn) throw throwable;
                                Trace.exit(this, "openDurableSubscription");
                                throw throwable;
                            }
                        }
                        Trace.exit(this, "openDurableSubscription");
                        return mQSubscription2;
                    }
                    Object var31_45 = null;
                    if (!Trace.isOn) return mQSubscription;
                    Trace.exit(this, "openDurableSubscription");
                    return mQSubscription;
                }
                Object var31_47 = null;
                if (!Trace.isOn) return mQBrokerSubscription3;
                Trace.exit(this, "openDurableSubscription");
                return mQBrokerSubscription3;
            }
            Object var31_50 = null;
            if (!Trace.isOn) return mQBrokerSubscription2;
            Trace.exit(this, "openDurableSubscription");
            return mQBrokerSubscription2;
        }
        Object var31_52 = null;
        if (!Trace.isOn) return mQBrokerSubscription;
        Trace.exit(this, "openDurableSubscription");
        return mQBrokerSubscription;
    }

    public void closeDurableSubscription(MQSubscription mQSubscription) throws JMSException {
        if (mQSubscription instanceof MQBrokerSubscription) {
            this.brokerSubStore.closeDurableSubscription(mQSubscription);
        } else if (mQSubscription instanceof MQQueueSubscription) {
            this.queueSubStore.closeDurableSubscription(mQSubscription);
        } else {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS3049");
            throw jMSException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void durableUnsubscribe(MQTopicSession mQTopicSession, String string) throws JMSException {
        MQQueue mQQueue = null;
        try {
            mQQueue = this.getAdminQueueAccess(mQTopicSession);
            if (this.brokerSubStore != null && this.checkQueueSubscription(mQTopicSession, string, mQQueue) == null) {
                this.brokerSubStore.durableUnsubscribe(mQTopicSession, string);
            } else {
                block9: {
                    try {
                        mQQueue.close();
                        mQQueue = null;
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block9;
                        Trace.trace(this, "error closing adminQueue");
                        Trace.exception(this, "durableUnsubscribe", (Throwable)mQException);
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1032", new Integer(mQException.reasonCode));
                        throw jMSException;
                    }
                }
                this.queueSubStore.durableUnsubscribe(mQTopicSession, string);
            }
            Object var7_6 = null;
            if (mQQueue == null) return;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (mQQueue == null) throw throwable;
            try {
                mQQueue.close();
                throw throwable;
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS2000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
        }
        try {
            mQQueue.close();
            return;
        }
        catch (MQException mQException) {
            JMSException jMSException = new JMSException("MQJMS2000");
            jMSException.setLinkedException((Exception)((Object)mQException));
            throw jMSException;
        }
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.queueSubStore != null) {
            this.queueSubStore.close();
        }
        if (this.brokerSubStore != null) {
            this.brokerSubStore.close();
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQQueueSubscription checkQueueSubscription(MQTopicSession mQTopicSession, String string, MQQueue mQQueue) throws JMSException {
        MQMessage mQMessage;
        Object object = null;
        String string2 = null;
        String string3 = null;
        MQGetMessageOptions mQGetMessageOptions = null;
        if (Trace.isOn) {
            Trace.entry(this, "checkQueueSubscription");
        }
        try {
            try {
                string2 = this.getMQTopicConnection().getClientID();
                if (string2 == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3024");
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "checkQueueSubscription", (Throwable)jMSException);
                    throw jMSException;
                }
                string3 = string2 + ":" + string;
                mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 16;
                boolean bl = true;
                while (true) {
                    if (!bl) {
                        mQMessage = object;
                        Object var11_13 = null;
                        if (!Trace.isOn) return mQMessage;
                        break;
                    }
                    try {
                        mQMessage = new MQMessage();
                        mQQueue.get(mQMessage, mQGetMessageOptions);
                        object = new MQQueueSubscription(this, mQTopicSession, mQMessage);
                        if (((MQQueueSubscription)object).isValid() && ((MQQueueSubscription)object).getFullName().equals(string3)) {
                            bl = false;
                            continue;
                        }
                        mQGetMessageOptions.options = 32;
                    }
                    catch (MQException mQException) {
                        object = null;
                        bl = false;
                    }
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "checkQueueSubscription", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "checkQueueSubscription");
            throw throwable;
        }
        Trace.exit(this, "checkQueueSubscription");
        return mQMessage;
    }

    private MQQueue getAdminQueueAccess(MQTopicSession mQTopicSession) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getAdminQueueAccess");
        }
        MQQueueManager mQQueueManager = mQTopicSession.qm;
        MQQueue mQQueue = null;
        int n = 0;
        block7: while (true) {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Try to open the adminQueue");
                }
                mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.ADMIN.QUEUE", 60);
            }
            catch (MQException mQException) {
                if (Trace.isOn) {
                    Trace.trace(this, "I'm sorry Dave. I can't do that");
                }
                switch (mQException.reasonCode) {
                    case 2042: {
                        if (++n < 20) {
                            if (Trace.isOn) {
                                Trace.trace(this, "admin queue locked, tried " + n + "times");
                            }
                            Trace.trace(this, "suppressing exception and retrying after wait");
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Daisy, Daisy....");
                                }
                                Thread.sleep((long)(100.0 + 5000.0 * Math.random()));
                            }
                            catch (InterruptedException interruptedException) {}
                            continue block7;
                        }
                        if (Trace.isOn) {
                            Trace.trace(this, "Tried 20 attempts. I'm bored now so I'll throw an exception");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
            break;
        }
        if (Trace.isOn) {
            Trace.trace(this, "Obtaining the admin queue lock required " + n + " retries");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getAdminQueueAccess");
        }
        return mQQueue;
    }

    byte[] getStatusMgrId() {
        return this.queueSubStore.getStatusMgrId();
    }

    byte[] createSessionName(MQTopicSession mQTopicSession) throws JMSException {
        if (this.brokerSubStore != null) {
            return this.brokerSubStore.createSessionName(mQTopicSession);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQMsg2 sendBrokerMessage(MQTopicSession mQTopicSession, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl) throws JMSException {
        block17: {
            MQMsg2 mQMsg22;
            block15: {
                MQQueue mQQueue = null;
                Object var6_6 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2, pmo, deferred)");
                }
                try {
                    try {
                        BrokerConnectionInfo brokerConnectionInfo = mQTopicSession.getBrk();
                        try {
                            Object object;
                            block16: {
                                try {
                                    int n = 16;
                                    object = mQTopicSession.qm;
                                    if (mQPutMessageOptions == null) {
                                        mQPutMessageOptions = new MQPutMessageOptions();
                                    }
                                    if (bl) {
                                        MQSPIQueueManager mQSPIQueueManager = (MQSPIQueueManager)object;
                                        if (!mQSPIQueueManager.spiSupportsDeferred()) {
                                            mQMsg22 = null;
                                            Object var13_17 = null;
                                            if (!Trace.isOn) return mQMsg22;
                                            break block15;
                                        }
                                        mQQueue = mQSPIQueueManager.accessQueue(brokerConnectionInfo.controlQ, n, brokerConnectionInfo.qmName, null, null);
                                        ((MQSPIQueue)mQQueue).spiDeferredPut(mQMsg2, mQPutMessageOptions);
                                        break block16;
                                    }
                                    mQQueue = mQTopicSession.qm.accessQueue(brokerConnectionInfo.controlQ, n, brokerConnectionInfo.qmName, null, null);
                                    mQQueue.putMsg2(mQMsg2, mQPutMessageOptions);
                                }
                                catch (MQException mQException) {
                                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                                    jMSException.setLinkedException((Exception)((Object)mQException));
                                    if (!Trace.isOn) throw jMSException;
                                    Trace.trace(this, "Failed to MQPUT broker command due to: " + (Object)((Object)mQException));
                                    throw jMSException;
                                }
                            }
                            try {
                                mQQueue.close();
                                break block17;
                            }
                            catch (MQException mQException) {
                                object = ConfigEnvironment.newException("MQJMS2000");
                                object.setLinkedException((Exception)((Object)mQException));
                                if (!Trace.isOn) throw object;
                                Trace.trace(this, "Failed to close broker queue");
                                throw object;
                            }
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) throw jMSException;
                            Trace.trace(this, "Failed to put message to broker queue");
                            throw jMSException;
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.exception(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)", (Throwable)jMSException);
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var13_19 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)");
                    throw throwable;
                }
            }
            Trace.exit(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)");
            return mQMsg22;
        }
        Object var13_18 = null;
        if (!Trace.isOn) return mQMsg2;
        Trace.exit(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)");
        return mQMsg2;
    }

    private MQMsg2 sendBrokerMessage(MQTopicSession mQTopicSession, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws JMSException {
        return this.sendBrokerMessage(mQTopicSession, mQMsg2, mQPutMessageOptions, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQBrokerMessage getBrokerResponse(MQTopicSession mQTopicSession, MQMsg2 mQMsg2) throws JMSException {
        MQBrokerMessage mQBrokerMessage = null;
        MQMsg2 mQMsg22 = null;
        MQQueue mQQueue = null;
        MQGetMessageOptions mQGetMessageOptions = null;
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerResponse");
        }
        try {
            block12: {
                try {
                    MQBrokerMessage mQBrokerMessage2;
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                        mQBrokerMessage2 = new RFH1BrokerMessageImpl();
                    } else {
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                        mQBrokerMessage2 = new RFH2BrokerMessageImpl();
                    }
                    mQMsg22 = new MQMsg2();
                    mQMsg22.setCorrelationId(mQMsg2.getMessageId());
                    try {
                        mQQueue = mQTopicSession.getResponseQueue();
                        mQGetMessageOptions = new MQGetMessageOptions();
                        mQGetMessageOptions.options = 1;
                        mQGetMessageOptions.waitInterval = mQTopicSession.getBrokerTimeout();
                        if (Trace.isOn) {
                            Trace.trace(this, "setting broker timeout to " + mQTopicSession.getBrokerTimeout());
                        }
                        mQQueue.getMsg2(mQMsg22, mQGetMessageOptions);
                    }
                    catch (MQException mQException) {
                        String string = "MQJMS5053";
                        String string2 = ConfigEnvironment.getErrorMessage(string);
                        NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                        noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                        if (!Trace.isOn) throw noBrokerResponseException;
                        Trace.exception(this, "error getting broker response: ", (Throwable)((Object)noBrokerResponseException));
                        throw noBrokerResponseException;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "got broker response");
                    }
                    mQBrokerMessage.initializeFromMessage(mQMsg22);
                    mQBrokerMessage2.initializeFromMessage(mQMsg2);
                    if (!mQBrokerMessage2.isOptionSet("MQPSRegOpts", 65536) || Integer.parseInt(mQBrokerMessage.get("MQPSCompCode")) == 2 || mQBrokerMessage2.get("MQPSTopic") != null) break block12;
                    if (Trace.isOn) {
                        Trace.trace(this, "Full response didn't work, using workaround and setting fail");
                    }
                    mQBrokerMessage.set("MQPSCompCode", Integer.toString(2));
                    mQBrokerMessage.set("MQPSReason", Integer.toString(2337));
                    mQBrokerMessage.set("MQPSReasonText", "MQRC_RFH_PARM_ERROR");
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "exception thrown getting broker response", (Throwable)jMSException);
                    throw jMSException;
                }
            }
            Object var13_13 = null;
            if (!Trace.isOn) return mQBrokerMessage;
            Trace.exit(this, "getBrokerResponse");
            return mQBrokerMessage;
        }
        catch (Throwable throwable) {
            Object var13_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getBrokerResponse");
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    void removeQueueSubscription(MQTopicSession mQTopicSession, MQQueueSubscription mQQueueSubscription) throws JMSException {
        block25: {
            MQQueue mQQueue;
            block23: {
                JMSException jMSException;
                mQQueue = null;
                MQQueue mQQueue2 = null;
                MQQueueSubscription mQQueueSubscription2 = null;
                byte[] byArray = null;
                String string = null;
                MQGetMessageOptions mQGetMessageOptions = null;
                mQQueue = this.getAdminQueueAccess(mQTopicSession);
                byArray = mQQueueSubscription.getCorrelationId();
                string = mQQueueSubscription.getSubName();
                mQGetMessageOptions = new MQGetMessageOptions();
                if (byArray == null) {
                    mQGetMessageOptions.options = 16;
                }
                boolean bl = true;
                while (bl) {
                    try {
                        MQMessage mQMessage = new MQMessage();
                        if (byArray != null) {
                            mQMessage.messageId = byArray;
                            mQGetMessageOptions.matchOptions |= 1;
                        }
                        mQQueue.get(mQMessage, mQGetMessageOptions);
                        mQQueueSubscription2 = new MQQueueSubscription(this, mQQueueSubscription.getMQTopicSession(), mQMessage);
                        if (byArray != null) {
                            bl = false;
                            continue;
                        }
                        if (mQQueueSubscription2.isValid() && mQQueueSubscription2.getSubName().equals(string)) {
                            mQGetMessageOptions.options = 256;
                            jMSException = new MQMessage();
                            mQQueue.get((MQMessage)jMSException, mQGetMessageOptions);
                            bl = false;
                            continue;
                        }
                        mQGetMessageOptions.options = 32;
                    }
                    catch (MQException mQException) {
                        jMSException = ConfigEnvironment.newException("MQJMS3013");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        if (Trace.isOn) {
                            Trace.trace(this, "In removeSubscriptionEntry() - cannot remove msg!");
                        }
                        throw jMSException;
                    }
                }
                try {
                    if (mQQueueSubscription.getSubscriberQueue() != null) {
                        mQQueue2 = mQQueueSubscription.getSubscriberQueue();
                        mQQueue2.close();
                        mQQueue2 = null;
                    }
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "error closing subscriber queue");
                        Trace.exception(this, "removeQueueSubscription", (Throwable)mQException);
                    }
                    jMSException = ConfigEnvironment.newException("MQJMS1032", new Integer(mQException.reasonCode));
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var13_15 = null;
                try {
                    if (mQQueue != null) {
                        mQQueue.close();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block23;
                    Trace.trace(this, "error closing adminQueue - tracing exception only");
                    Trace.exception(this, "removeQueueSubscription", (Throwable)mQException);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "removeQueueSubscription");
            }
            break block25;
            {
                catch (JMSException jMSException) {
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block24: {
                    Object var13_16 = null;
                    try {
                        if (mQQueue != null) {
                            mQQueue.close();
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block24;
                        Trace.trace(this, "error closing adminQueue - tracing exception only");
                        Trace.exception(this, "removeQueueSubscription", (Throwable)mQException);
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "removeQueueSubscription");
                }
                throw throwable;
            }
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQBrokerSubscription getMigratedSubscription(MQQueueSubscription var1_1, MQTopicSession var2_2, String var3_3) throws JMSException {
        var4_4 = null;
        var5_5 = null;
        var6_6 = null;
        var7_7 = null;
        var8_8 = null;
        var9_9 = null;
        var10_10 = null;
        var11_11 = null;
        var12_12 = null;
        var13_13 = 0;
        var14_14 = null;
        var15_15 = null;
        var16_16 = null;
        var17_17 = false;
        var18_18 = false;
        var19_19 = null;
        var20_20 = null;
        var21_21 = null;
        var22_22 = null;
        var23_23 = null;
        var24_24 = null;
        var25_25 = null;
        var26_26 = null;
        var28_27 = 0;
        try {
            try {
                var26_26 = var2_2.getBrk();
                var5_5 = this.escapeString(var1_1.getQmgrName());
                var6_6 = this.escapeString(this.getMQTopicConnection().getClientID());
                var7_7 = this.escapeString(var3_3);
                var4_4 = "JMS:" + var5_5 + ":" + var6_6 + ":" + var7_7;
                if (Trace.isOn) {
                    Trace.trace(this, "Fullname = '" + var4_4 + "'");
                }
                if ((var24_24 = var1_1.getSelector()) != null && !var24_24.trim().equals("")) {
                    var8_8 = this.escapeString(var24_24);
                    var9_9 = "sel=\"" + var8_8 + "\"";
                } else {
                    var9_9 = "";
                }
                try {
                    try {
                        var13_13 = 0x180000;
                        if (var1_1.isSharedQueue()) {
                            ++var13_13;
                        }
                        var11_11 = this.getMQTopicConnection().getBrkVersion() == 0 ? new RFH1BrokerMessageImpl() : new RFH2BrokerMessageImpl();
                        var11_11.set("MQPSCommand", "DeregSub");
                        var11_11.set("MQPSRegOpts", var13_13);
                        var11_11.set("MQPSSubName", var4_4);
                        var11_11.set("MQPSSubIdentity", Utils.bytesToHex(var2_2.getSessionName()));
                        var11_11.set("MQPSQMgrName", var1_1.getQmgrName());
                        var11_11.set("MQPSQName", var1_1.getQueueName());
                        var11_11.set("MQPSStreamName", var26_26.streamQ);
                        var11_11.set("MQPSTopic", var1_1.getTopic());
                    }
                    catch (JMSException var29_28) {
                        if (Trace.isOn == false) throw var29_28;
                        Trace.trace(this, "error composing update MQBrokerMessage");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var29_28);
                        throw var29_28;
                    }
                    try {
                        var14_14 = new MQMsg2();
                        var11_11.writeToMessage(var14_14);
                        var14_14.setCorrelationId(var1_1.getCorrelationId());
                        var14_14.setReplyToQueueManagerName("");
                        var14_14.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                        var14_14.setFormat(var11_11.getHeaderFormat());
                        var14_14.setMessageType(8);
                    }
                    catch (Exception var29_29) {
                        if (var29_29 instanceof JMSException) {
                            var30_41 = (JMSException)var29_29;
                        } else {
                            var30_41 = ConfigEnvironment.newException(var29_29.getMessage());
                            var30_41.setLinkedException(var29_29);
                        }
                        if (Trace.isOn == false) throw var30_41;
                        Trace.trace(this, "error building deferred deregister MQMsg2");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var30_41);
                        throw var30_41;
                    }
                    try {
                        var14_14 = this.sendBrokerMessage(var2_2, var14_14, null, true);
                        var18_18 = true;
                    }
                    catch (JMSException var29_30) {
                        if (Trace.isOn == false) throw var29_30;
                        Trace.trace(this, "error sending deferred broker message");
                        throw var29_30;
                    }
                }
                catch (JMSException var29_31) {
                    if (Trace.isOn == false) throw var29_31;
                    Trace.trace(this, "error attempting to put deferred deregister");
                    throw var29_31;
                }
                var16_16 = var14_14.getMessageId();
                try {
                    try {
                        var13_13 = 0x114000;
                        var13_13 = this.WSClone == 1 ? (var13_13 += 131072) : (var13_13 += 262144);
                        if (var2_2.acknowledgeMode == 3 && this.getMQTopicConnection().getBrkOptLevel() > 0) {
                            var13_13 += 512;
                        }
                        if (var1_1.isSharedQueue()) {
                            ++var13_13;
                        }
                        var11_11 = this.getMQTopicConnection().getBrkVersion() == 0 ? new RFH1BrokerMessageImpl() : new RFH2BrokerMessageImpl();
                        var11_11.set("MQPSCommand", "RegSub");
                        var11_11.set("MQPSRegOpts", var13_13);
                        var11_11.set("MQPSSubName", var4_4);
                        var11_11.set("MQPSSubIdentity", Utils.bytesToHex(var2_2.getSessionName()));
                        var11_11.set("MQPSQMgrName", var1_1.getQmgrName());
                        var11_11.set("MQPSQName", var1_1.getQueueName());
                        var11_11.set("MQPSStreamName", var26_26.streamQ);
                        var11_11.set("MQPSTopic", var1_1.getTopic());
                        var11_11.set("MQPSSubUserData", var9_9);
                    }
                    catch (JMSException var29_32) {
                        if (Trace.isOn == false) throw var29_32;
                        Trace.trace(this, "error composing update MQBrokerMessage");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var29_32);
                        throw var29_32;
                    }
                    try {
                        var14_14 = new MQMsg2();
                        var11_11.writeToMessage(var14_14);
                        var14_14.setCorrelationId(var1_1.getCorrelationId());
                        var14_14.setReplyToQueueManagerName("");
                        var14_14.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                        var14_14.setFormat(var11_11.getHeaderFormat());
                        var14_14.setMessageType(1);
                    }
                    catch (Exception var29_33) {
                        if (var29_33 instanceof JMSException) {
                            var30_42 = (JMSException)var29_33;
                        } else {
                            var30_42 = ConfigEnvironment.newException(var29_33.getMessage());
                            var30_42.setLinkedException(var29_33);
                        }
                        if (Trace.isOn == false) throw var30_42;
                        Trace.trace(this, "error building broker update MQMsg2");
                        Trace.exception(this, "getMigratedSubscription", (Throwable)var30_42);
                        throw var30_42;
                    }
                    try {
                        var14_14 = this.sendBrokerMessage(var2_2, var14_14, null);
                    }
                    catch (JMSException var29_34) {
                        if (Trace.isOn == false) throw var29_34;
                        Trace.trace(this, "error sending update subscription message to broker");
                        throw var29_34;
                    }
                }
                catch (JMSException var29_35) {
                    if (Trace.isOn == false) throw var29_35;
                    Trace.trace(this, "error sending broker update message");
                    throw var29_35;
                }
                try {
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        var12_12 = new RFH1BrokerMessageImpl();
                        var12_12 = (RFH1BrokerMessageImpl)this.getBrokerResponse(var2_2, var14_14);
                    } else {
                        var12_12 = new RFH2BrokerMessageImpl();
                        var12_12 = (RFH2BrokerMessageImpl)this.getBrokerResponse(var2_2, var14_14);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "got update response from broker");
                    }
                    var27_46 = Integer.parseInt(var12_12.get("MQPSCompCode"));
                    var28_27 = Integer.parseInt(var12_12.get("MQPSReason"));
                }
                catch (JMSException var29_36) {
                    if (Trace.isOn == false) throw var29_36;
                    Trace.trace(this, "error getting response from broker update message");
                    throw var29_36;
                }
                switch (var27_46) {
                    case 0: {
                        break;
                    }
                    case 1: 
                    case 2: {
                        if (var28_27 != 3083 && var28_27 != 2337) ** GOTO lbl177
                        this.useBrokerSubStore = 0;
                        try {
                            this.brokerSubStore.close();
                        }
                        catch (Exception var29_37) {
                            if (!Trace.isOn) ** GOTO lbl176
                            Trace.trace(this, "error attempting to close brokerSubStore");
                            Trace.exception(this, "getMigratedSubscription", (Throwable)var29_37);
                        }
lbl176:
                        // 3 sources

                        this.brokerSubStore = null;
                    }
lbl177:
                    // 3 sources

                    default: {
                        if (Trace.isOn == false) throw new JMSException(var12_12.get("MQPSReasonText"));
                        Trace.trace(this, "something went wrong updating the subscription");
                        Trace.trace(this, var12_12.get("MQPSReasonText"));
                        throw new JMSException(var12_12.get("MQPSReasonText"));
                    }
                }
                try {
                    var29_38 = var12_12.get("MQPSQMgrName").trim();
                    var30_43 = var12_12.get("MQPSTopic").trim();
                    var31_47 = var12_12.get("MQPSQName").trim();
                    var32_51 = var12_12.get("MQPSCorrelId").trim();
                    var10_10 = new MQBrokerSubscription(this, var2_2, true, var1_1.isSharedQueue(), (String)var29_38, this.getMQTopicConnection().getClientID(), var3_3, var30_43, var1_1.getSelector(), var1_1.getNoLocal(), var31_47, null, Utils.hexToBytes(var32_51));
                    var25_25 = this.openSubscriberQueue(var2_2, var31_47, var1_1.isSharedQueue(), true);
                    var10_10.setSubscriberQueue(var25_25);
                    var10_10.setDeferredMsgId(var16_16);
                }
                catch (JMSException var29_39) {
                    if (Trace.isOn == false) throw var29_39;
                    Trace.trace(this, "error creating new MQBrokerSubscription object from migrated subscription");
                    Trace.exception(this, "getMigratedSubscription", (Throwable)var29_39);
                    throw var29_39;
                }
                var29_38 = var10_10;
                var34_52 = null;
                if (Trace.isOn == false) return var29_38;
            }
            catch (JMSException var29_40) {
                if (Trace.isOn) {
                    Trace.trace(this, "error encountered while trying to migrate subscription - exiting via exception");
                }
                if (var18_18 == false) throw var29_40;
                if (Trace.isOn) {
                    Trace.trace(this, "cancelling deferred message");
                }
                try {
                    var30_44 = var2_2.qm;
                    if (!(var30_44 instanceof MQSPIQueueManager)) {
                        var31_48 = new JMSException("MQJMS3047");
                        throw var31_48;
                    }
                    var31_49 = (MQSPIQueueManager)var30_44;
                    var31_49.spiCancelDeferred(var16_16);
                    throw var29_40;
                }
                catch (Exception var30_45) {
                    if (var30_45 instanceof JMSException) {
                        var31_50 = (JMSException)var30_45;
                    } else {
                        var31_50 = new JMSException(var30_45.getMessage());
                        var31_50.setLinkedException(var30_45);
                    }
                    if (Trace.isOn == false) throw var29_40;
                    Trace.trace(this, "error cancelling deferred deregister message");
                    Trace.exception(this, "getMigratedSubscription", (Throwable)var31_50);
                }
                throw var29_40;
            }
        }
        catch (Throwable var33_54) {
            var34_53 = null;
            if (Trace.isOn == false) throw var33_54;
            Trace.exit(this, "getMigratedSubscription");
            throw var33_54;
        }
        Trace.exit(this, "getMigratedSubscription");
        return var29_38;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String escapeString(String string) {
        String string2;
        StringBuffer stringBuffer;
        block11: {
            String string3;
            block10: {
                stringBuffer = new StringBuffer();
                boolean bl = false;
                char c = '\u0000';
                String string4 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "escapeString: " + string);
                }
                try {
                    if (string == null) {
                        string3 = "";
                        Object var10_7 = null;
                        if (!Trace.isOn) return string3;
                        break block10;
                    }
                    int n = 0;
                    while (true) {
                        if (n >= string.length()) {
                            string2 = stringBuffer.toString();
                            break block11;
                        }
                        c = string.charAt(n);
                        switch (c) {
                            case '\"': 
                            case ':': 
                            case ';': 
                            case '\\': {
                                string4 = "0000" + Integer.toString(c, 16);
                                stringBuffer.append("\\u" + string4.substring(string4.length() - 4, string4.length()));
                                break;
                            }
                            default: {
                                if (c < ' ' || c > '~') {
                                    string4 = "0000" + Integer.toString(c, 16);
                                    stringBuffer.append("\\u" + string4.substring(string4.length() - 4, string4.length()));
                                    break;
                                }
                                stringBuffer.append(c);
                            }
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.trace(this, "Returning string: " + stringBuffer.toString());
                    Trace.exit(this, "escapeString");
                    throw throwable;
                }
            }
            Trace.trace(this, "Returning string: " + stringBuffer.toString());
            Trace.exit(this, "escapeString");
            return string3;
        }
        Object var10_8 = null;
        if (!Trace.isOn) return string2;
        Trace.trace(this, "Returning string: " + stringBuffer.toString());
        Trace.exit(this, "escapeString");
        return string2;
    }
}

