/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.matching.ExpressionParser;
import com.ibm.disthubmq.impl.matching.FieldTypeException;
import com.ibm.disthubmq.impl.matching.SyntaxException;
import com.ibm.jms.JMSMessage;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.SelectorDataAccessor;
import com.ibm.mq.jms.SelectorFieldMonitor;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQMessageSelector {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQMessageSelector.java, jms, j521, j521-L020207 02/02/06 13:24:45 @(#) 1.25.1.2";
    private static final String JMSCORRELATIONID = "JMSCorrelationID";
    private static final String JMSMESSAGEID = "JMSMessageID";
    private static final int ID_LENGTH = 24;
    private ExpressionParser oparser = null;
    private SelectorFieldMonitor omonitor = null;
    private String specialSelector = null;

    public MQMessageSelector() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSelector() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSelector");
            }
            String string2 = this.oparser == null ? this.specialSelector : this.oparser.getExpression();
            string = string2;
            Object var4_3 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getSelector");
            throw throwable;
        }
        Trace.exit(this, "getSelector");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSelected(JMSMessage jMSMessage, MQMsg2 mQMsg2) throws JMSException {
        boolean bl;
        try {
            try {
                boolean bl2;
                if (this.oparser == null || this.oparser.getExpression() == null) {
                    bl2 = true;
                } else {
                    try {
                        bl2 = this.oparser.eval(new SelectorDataAccessor(jMSMessage, mQMsg2));
                    }
                    catch (FieldTypeException fieldTypeException) {
                        throw new JMSException(fieldTypeException.toString());
                    }
                }
                bl = bl2;
                Object var6_7 = null;
                if (!Trace.isOn) return bl;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isSelected");
            throw throwable;
        }
        Trace.exit(this, "isSelected");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean requiresBrowse() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "requiresBrowse");
            }
            boolean bl2 = true;
            bl2 = this.requiresMQSeriesOtherData() || this.requiresXMLEncodedData();
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "requiresBrowse");
            throw throwable;
        }
        Trace.exit(this, "requiresBrowse");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresMQSeriesMatchingData() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "requiresMQSeriesMatchingData");
            }
            boolean bl2 = this.omonitor == null ? false : this.omonitor.requiresMQSeriesMatchingData();
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "requiresMQSeriesMatchingData");
            throw throwable;
        }
        Trace.exit(this, "requiresMQSeriesMatchingData");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresMQSeriesOtherData() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "requiresMQSeriesOtherData");
            }
            boolean bl2 = this.omonitor == null ? false : this.omonitor.requiresMQSeriesOtherData();
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "requiresMQSeriesOtherData");
            throw throwable;
        }
        Trace.exit(this, "requiresMQSeriesOtherData");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean requiresXMLEncodedData() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "requiresXMLEncodedData");
            }
            boolean bl2 = this.omonitor == null ? false : this.omonitor.requiresXMLEncodedData();
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "requiresXMLEncodedData");
            throw throwable;
        }
        Trace.exit(this, "requiresXMLEncodedData");
        return bl;
    }

    public void setSelector(String string) throws SyntaxException {
        if (Trace.isOn) {
            Trace.entry(this, "setSelector(selector)");
        }
        this.setSelector(string, null);
        if (Trace.isOn) {
            Trace.exit(this, "setSelector(selector)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSelector(String string, MQMsg2 mQMsg2) throws SyntaxException {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setSelector(selector, mqmd)");
            }
            bl = this.setSelector(string, mQMsg2, null);
            Object var5_4 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setSelector(selector, mqmd)");
            throw throwable;
        }
        Trace.exit(this, "setSelector(selector, mqmd)");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setSelector(String string, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws SyntaxException {
        boolean bl;
        try {
            boolean bl2 = false;
            if (mQMsg2 != null && string != null && string.length() > 0) {
                String string2 = new String(string.trim());
                try {
                    byte[] byArray = null;
                    byte[] byArray2 = null;
                    byte[] byArray3 = null;
                    int n = 0;
                    boolean bl3 = false;
                    if (string2.startsWith(JMSCORRELATIONID)) {
                        string2 = string2.substring(JMSCORRELATIONID.length()).trim();
                        n = 24;
                        bl3 = true;
                        byArray = byArray3 = new byte[n];
                        if (mQGetMessageOptions != null) {
                            mQGetMessageOptions.matchOptions |= 2;
                        }
                    }
                    if (string2.startsWith(JMSMESSAGEID)) {
                        string2 = string2.substring(JMSMESSAGEID.length()).trim();
                        n = 24;
                        bl3 = true;
                        byArray2 = new byte[n];
                        byArray = byArray2;
                        if (mQGetMessageOptions != null) {
                            mQGetMessageOptions.matchOptions |= 1;
                        }
                    }
                    if (bl3 && string2.charAt(0) == '=' && (string2 = string2.substring(1).trim()).startsWith("'ID:")) {
                        boolean bl4 = false;
                        if ((string2 = string2.substring(4).toLowerCase()).length() == n * 2 + 1 && string2.charAt(n * 2) == '\'') {
                            bl4 = true;
                            int n2 = 0;
                            while (n2 < 24) {
                                int n3 = 0;
                                char c = string2.charAt(n2 * 2);
                                if (c >= '0' && c <= '9') {
                                    n3 += c - 48;
                                } else if (c >= 'a' && c <= 'f') {
                                    n3 += c - 97 + 10;
                                } else {
                                    bl4 = false;
                                }
                                n3 *= 16;
                                char c2 = string2.charAt(n2 * 2 + 1);
                                if (c2 >= '0' && c2 <= '9') {
                                    n3 += c2 - 48;
                                } else if (c2 >= 'a' && c2 <= 'f') {
                                    n3 += c2 - 97 + 10;
                                } else {
                                    bl4 = false;
                                }
                                byArray[n2] = (byte)n3;
                                ++n2;
                            }
                        }
                        if (bl4) {
                            bl2 = true;
                        }
                    }
                    if (byArray2 != null) {
                        mQMsg2.setMessageId(byArray2);
                    } else if (byArray3 != null) {
                        mQMsg2.setCorrelationId(byArray3);
                    }
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    // empty catch block
                }
            }
            if (bl2) {
                if (Trace.isOn) {
                    Trace.trace(this, "Selector is a special case.");
                }
                this.specialSelector = string;
            } else {
                if (this.oparser == null) {
                    this.oparser = new ExpressionParser();
                    this.omonitor = new SelectorFieldMonitor();
                }
                this.oparser.setExpression(string, this.omonitor);
            }
            bl = bl2;
            Object var17_18 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setSelector(selector, mqmsg2, gmo)");
            throw throwable;
        }
        Trace.exit(this, "setSelector(selector, mqmsg2, gmo)");
        return bl;
    }
}

