/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.Trace;
import javax.jms.JMSException;

class MQMessageReference {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQMessageReference.java, jms, j521, j521-L020514.1 02/02/18 19:35:02 @(#) 1.8.1.2";
    static final int NONE = 0;
    static final int PASSED_TO_CONSUMER = 1;
    static final int PASSED_TO_SESSION = 2;
    static final int PASSED_TO_LISTENER = 3;
    static final int UNWANTED = 4;
    static final int FAILED = -1;
    private static final long prime1 = 2147483587L;
    private static final long prime2 = Integer.MAX_VALUE;
    private JMSMessage jmsMessage;
    private MQJMSMessage mqjmsMessage;
    private byte[] messageId;
    private byte[] correlId;
    private int hashcode;
    private int status;

    MQMessageReference() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        this.mqjmsMessage = new MQJMSMessage();
        this.jmsMessage = null;
        this.messageId = null;
        this.correlId = null;
        this.hashcode = -1;
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    JMSMessage removeMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "removeMessage");
        }
        JMSMessage jMSMessage = this.jmsMessage;
        this.jmsMessage = null;
        if (Trace.isOn) {
            Trace.exit(this, "removeMessage");
        }
        return jMSMessage;
    }

    void setJMSMessage(JMSMessage jMSMessage) {
        if (Trace.isOn) {
            Trace.entry(this, "setJMSMessage");
        }
        this.jmsMessage = jMSMessage;
        if (Trace.isOn) {
            Trace.exit(this, "setJMSMessage");
        }
    }

    MQJMSMessage getMQJMSMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "getMQJMSMessage");
        }
        MQJMSMessage mQJMSMessage = this.mqjmsMessage;
        if (Trace.isOn) {
            Trace.exit(this, "getMQJMSMessage");
        }
        return mQJMSMessage;
    }

    void setMQJMSMessage(MQJMSMessage mQJMSMessage) {
        if (Trace.isOn) {
            Trace.entry(this, "setMQJMSMessage");
        }
        this.mqjmsMessage = mQJMSMessage;
        if (this.mqjmsMessage != null && this.mqjmsMessage.getMessageId() != null) {
            this.messageId = this.mqjmsMessage.getMessageId();
            this.correlId = this.mqjmsMessage.getCorrelationId();
            this.hashcode = 0;
            byte[] byArray = new byte[8];
            int n = 0;
            while (n + 8 <= this.messageId.length) {
                System.arraycopy(this.messageId, n, byArray, 0, 8);
                this.hashcode ^= this.hash8bytes(byArray);
                n += 8;
            }
        } else {
            this.messageId = null;
            this.correlId = null;
            this.hashcode = -1;
        }
        if (Trace.isOn) {
            Trace.exit(this, "setMQJMSMessage");
        }
    }

    private int hash8bytes(byte[] byArray) {
        int n = byArray[0] & 0xFF;
        int n2 = (byArray[1] & 0xFF) << 8;
        int n3 = (byArray[2] & 0xFF) << 16;
        long l = (long)(byArray[3] & 0xFF) << 24;
        long l2 = (long)(n + n2 + n3) + l | 0x40404040L;
        l2 *= 2147483587L;
        l2 = l2 >>> 32 ^ l2 & 0xFFFFFFFFL;
        n = byArray[4] & 0xFF;
        n2 = (byArray[5] & 0xFF) << 8;
        n3 = (byArray[6] & 0xFF) << 16;
        l = (long)(byArray[7] & 0xFF) << 24;
        long l3 = (long)(n + n2 + n3) + l | 0x40404040L;
        l3 *= Integer.MAX_VALUE;
        l3 = l3 >>> 32 ^ l3 & 0xFFFFFFFFL;
        l2 *= l3;
        l2 = l2 >>> 32 ^ l2 & 0xFFFFFFFFL;
        return (int)l2;
    }

    byte[] getMessageId() {
        byte[] byArray = null;
        if (Trace.isOn) {
            Trace.entry(this, "getMessageId");
        }
        if (this.messageId != null) {
            byArray = new byte[this.messageId.length];
            System.arraycopy(this.messageId, 0, byArray, 0, this.messageId.length);
        }
        if (Trace.isOn) {
            Trace.exit(this, "getMessageId");
        }
        return byArray;
    }

    byte[] getCorrelId() {
        byte[] byArray = null;
        if (Trace.isOn) {
            Trace.entry(this, "getCorrelId");
        }
        if (this.correlId != null) {
            byArray = new byte[this.correlId.length];
            System.arraycopy(this.correlId, 0, byArray, 0, this.correlId.length);
        }
        if (Trace.isOn) {
            Trace.exit(this, "getCorrelId");
        }
        return byArray;
    }

    int getStatus() {
        if (Trace.isOn) {
            Trace.entry(this, "getStatus");
        }
        if (Trace.isOn) {
            Trace.exit(this, "getStatus");
        }
        return this.status;
    }

    void setStatus(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setStatus");
        }
        this.status = n;
        if (Trace.isOn) {
            Trace.exit(this, "setStatus");
        }
    }

    boolean isComplete() {
        if (Trace.isOn) {
            Trace.entry(this, "complete");
        }
        boolean bl = false;
        if (this.jmsMessage != null) {
            bl = true;
        }
        if (Trace.isOn) {
            Trace.exit(this, "complete");
        }
        return bl;
    }

    public int hashCode() {
        int n = this.hashcode;
        return n;
    }

    public boolean equals(Object object) {
        boolean bl = false;
        if (object instanceof MQMessageReference) {
            MQMessageReference mQMessageReference = (MQMessageReference)object;
            if (mQMessageReference.messageId != null && this.messageId != null && mQMessageReference.hashcode == this.hashcode && mQMessageReference.messageId.length == this.messageId.length) {
                bl = true;
                int n = 0;
                while (n < this.messageId.length) {
                    if (mQMessageReference.messageId[n] != this.messageId[n]) {
                        bl = false;
                        break;
                    }
                    ++n;
                }
            }
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean matches(MQMessageSelector mQMessageSelector) throws JMSException {
        boolean bl = false;
        if (Trace.isOn) {
            Trace.entry(this, "matches");
        }
        try {
            try {
                bl = mQMessageSelector.isSelected(this.jmsMessage, this.mqjmsMessage);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.trace(this, "Match result " + bl);
            Trace.exit(this, "matches");
            throw throwable;
        }
        Trace.trace(this, "Match result " + bl);
        Trace.exit(this, "matches");
        return bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("jmsMessage=" + this.jmsMessage);
        stringBuffer.append("\nmqjmsMessage=" + (Object)((Object)this.mqjmsMessage));
        stringBuffer.append("\nmessageId=");
        stringBuffer.append(Utils.bytesToHex(this.messageId));
        stringBuffer.append("\nstatus=");
        stringBuffer.append(this.status == 0 ? "NONE" : (this.status == 1 ? "PASSED_TO_CONSUMER" : (this.status == 2 ? "PASSED_TO_SESSION" : (this.status == 3 ? "PASSED_TO_LISTENER" : (this.status == -1 ? "FAILED" : "<unknown>")))));
        return stringBuffer.toString();
    }
}

