/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.MessageProducer;

public abstract class MQMessageProducer
implements MessageProducer {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQMessageProducer.java, jms, j521, j521-L020126 02/01/25 15:19:16 @(#) 1.14.1.1";
    public static final int JMS101_DEFAULT_VAL = -1;
    private boolean disableMessageID = false;
    private boolean disableMessageTimestamp = false;
    private int deliveryMode = 2;
    private int priority = 4;
    private long timeToLive = 0L;
    protected boolean closed = false;

    public abstract void close() throws JMSException;

    public void setDisableMessageID(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setDisableMessageID");
        }
        this.checkProducerOpen();
        this.disableMessageID = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setDisableMessageID");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getDisableMessageID() throws JMSException {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDisableMessageID");
            }
            this.checkProducerOpen();
            bl = this.disableMessageID;
            Object var3_2 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDesableMessageID");
            throw throwable;
        }
        Trace.exit(this, "getDesableMessageID");
        return bl;
    }

    public void setDisableMessageTimestamp(boolean bl) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setDisableMessageTimestamp");
        }
        this.checkProducerOpen();
        this.disableMessageTimestamp = bl;
        if (Trace.isOn) {
            Trace.exit(this, "setDisableMessageTimestamp");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean getDisableMessageTimestamp() throws JMSException {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDisableMessageTimestamp");
            }
            this.checkProducerOpen();
            bl = this.disableMessageTimestamp;
            Object var3_2 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDisableMessageTimestamp");
            throw throwable;
        }
        Trace.exit(this, "getDisableMessageTimestamp");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setDeliveryMode(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setDeliveryMode");
                }
                this.checkProducerOpen();
                if (n != 2 && n != 1) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "deliveryMode", String.valueOf(n));
                    throw jMSException;
                }
                this.deliveryMode = n;
                Object var4_4 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setDeliveryMode");
            throw throwable;
        }
        Trace.exit(this, "setDeliveryMode");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getDeliveryMode() throws JMSException {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDeliveryMode");
            }
            this.checkProducerOpen();
            n = this.deliveryMode;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDeliveryMode");
            throw throwable;
        }
        Trace.exit(this, "getDeliveryMode");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPriority(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setPriority");
                }
                this.checkProducerOpen();
                if (n < 0 || n > 9) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(n));
                    throw jMSException;
                }
                this.priority = n;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPriority");
            throw throwable;
        }
        Trace.exit(this, "setPriority");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority() throws JMSException {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getPriority");
            }
            this.checkProducerOpen();
            n = this.priority;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getPriority");
            throw throwable;
        }
        Trace.exit(this, "getPriority");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTimeToLive(long l) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setTimeToLive");
                }
                this.checkProducerOpen();
                if (l < 0L) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "timeToLive", Long.toString(l));
                    throw jMSException;
                }
                this.timeToLive = l;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setTimeToLive");
            throw throwable;
        }
        Trace.exit(this, "setTimeToLive");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getTimeToLive() throws JMSException {
        long l;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTimeToLive");
            }
            this.checkProducerOpen();
            l = this.timeToLive;
            Object var4_2 = null;
            if (!Trace.isOn) return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getTimeToLive");
            throw throwable;
        }
        Trace.exit(this, "getTimeToLive");
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isClosed() {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "isClosed");
            }
            boolean bl3 = bl2 = this.closed;
            if (Trace.isOn) {
                Trace.trace(this, "isClosed returning " + bl2);
            }
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isClosed");
            throw throwable;
        }
        Trace.exit(this, "isClosed");
        return bl;
    }

    void checkProducerOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkProducerOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS3037";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "MessageProducer is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkProducerOpen");
        }
    }
}

