/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.matching.SyntaxException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.NoMsgListenerException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import javax.jms.IllegalStateException;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;

public abstract class MQMessageConsumer
implements MessageConsumer {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQMessageConsumer.java, jms, j521, j521-L020126 02/01/25 15:19:29 @(#) 1.31.1.1";
    protected MQMessageSelector messageSelector = null;
    protected boolean closed = false;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getMessageSelector() throws JMSException {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getMessageSelector");
            }
            this.checkConsumerOpen();
            String string2 = this.messageSelector != null ? this.messageSelector.getSelector() : null;
            string = string2;
            Object var4_3 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getMessageSelector");
            throw throwable;
        }
        Trace.exit(this, "getMessageSelector");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setMessageSelector(String string) throws InvalidSelectorException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setMessageSelector");
                }
                if (this.messageSelector == null) {
                    this.messageSelector = new MQMessageSelector();
                }
                try {
                    if (string != null && string.equals("")) {
                        string = null;
                    }
                    this.messageSelector.setSelector(string);
                }
                catch (SyntaxException syntaxException) {
                    String string2 = "MQJMS0004";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string3, string2);
                    invalidSelectorException.setLinkedException((Exception)syntaxException);
                    throw invalidSelectorException;
                }
                Object var7_7 = null;
                if (!Trace.isOn) return;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                Trace.trace(this, "Throwing" + (Object)((Object)invalidSelectorException));
                throw invalidSelectorException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setMessageSelector");
            throw throwable;
        }
        Trace.exit(this, "setMessageSelector");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean setMessageSelector(String string, MQMsg2 mQMsg2, MQGetMessageOptions mQGetMessageOptions) throws InvalidSelectorException {
        boolean bl;
        try {
            try {
                boolean bl2;
                if (Trace.isOn) {
                    Trace.entry(this, "setMessageSelector");
                }
                if (this.messageSelector == null) {
                    this.messageSelector = new MQMessageSelector();
                }
                try {
                    if (string != null && string.equals("")) {
                        string = null;
                    }
                    bl2 = this.messageSelector.setSelector(string, mQMsg2, mQGetMessageOptions);
                }
                catch (SyntaxException syntaxException) {
                    String string2 = "MQJMS0004";
                    String string3 = ConfigEnvironment.getErrorMessage(string2);
                    InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string3, string2);
                    invalidSelectorException.setLinkedException((Exception)syntaxException);
                    throw invalidSelectorException;
                }
                bl = bl2;
                Object var10_11 = null;
                if (!Trace.isOn) return bl;
            }
            catch (InvalidSelectorException invalidSelectorException) {
                Trace.exception(this, "setMessageSelector", (Throwable)invalidSelectorException);
                throw invalidSelectorException;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setMessageSelector");
            throw throwable;
        }
        Trace.exit(this, "setMessageSelector");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected MQMessageSelector getSelectorInstance() {
        MQMessageSelector mQMessageSelector;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSelectorInstance");
            }
            if (this.messageSelector == null) {
                this.messageSelector = new MQMessageSelector();
            }
            mQMessageSelector = this.messageSelector;
            Object var3_2 = null;
            if (!Trace.isOn) return mQMessageSelector;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getSelectorInstance");
            throw throwable;
        }
        Trace.exit(this, "getSelectorInstance");
        return mQMessageSelector;
    }

    public abstract Message receive() throws JMSException;

    public abstract Message receive(long var1) throws JMSException;

    public abstract Message receiveNoWait() throws JMSException;

    public abstract void close() throws JMSException;

    public abstract MessageListener getMessageListener() throws JMSException;

    public abstract void setMessageListener(MessageListener var1) throws JMSException;

    abstract boolean receiveAsync(long var1) throws NoMsgListenerException, JMSException;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isClosed() {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "isClosed");
            }
            boolean bl3 = bl2 = this.closed;
            if (Trace.isOn) {
                Trace.trace(this, "isClosed returning " + bl2);
            }
            bl = bl2;
            Object var4_3 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isClosed");
            throw throwable;
        }
        Trace.exit(this, "isClosed");
        return bl;
    }

    void checkConsumerOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkConsumerOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS3038";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "MessageConsumer is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkConsumerOpen");
        }
    }
}

