/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSMapMessage;
import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStreamMessage;
import com.ibm.jms.JMSTextMessage;
import com.ibm.mq.MQCcsidTable;
import com.ibm.mq.MQException;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Hashtable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;

class MQJMSMessage
extends MQMsg2 {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQJMSMessage.java, jms, j521, j521-L020426 02/04/25 14:01:40 @(#) 1.60.1.6";
    public static final String CLASSNAME = "com.ibm.mq.jms.MQJMSMessage";
    private static final int RFH_CHARACTER_SET = 1208;
    private static final byte[] SPACES = new byte[]{32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32};
    private static final String RFH_CHAR_SET_STRING = "UTF8";
    public static final String MQRFH_STRUC_ID = "RFH ";
    public static final int MQRFH_VERSION_1 = 1;
    public static final int MQRFH_VERSION_2 = 2;
    public static final int MQRFH_NO_FLAGS = 0;
    public static final String MQFMT_RF_HEADER_1 = "MQHRF   ";
    public static final String MQFMT_RF_HEADER_2 = "MQHRF2  ";
    public static final int MQRFH_STRUC_LENGTH_FIXED_1 = 32;
    public static final int MQRFH_STRUC_LENGTH_FIXED_2 = 36;
    public static final int MQCCSI_INHERIT = -2;
    private static final long MQHEADER_ASCII = 5571313378871214080L;
    private static final long MQHEADER_EBCDIC = -3109515640373772288L;
    private static final long MQHEADER_MASK = -1099511627776L;
    public static final long MQRFH2_ASCII = 5571313732236222496L;
    public static final long MQRFH2_EBCDIC = -3109514705028104128L;
    public static final long MQRFH1_ASCII = 5571313732235042848L;
    public static final long MQRFH1_EBCDIC = -3109514705039769536L;
    private static final String BLANK_STRING15 = "               ";
    private static final Integer ZERO = new Integer(0);
    private static final byte[] MQ_NONE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    private byte[] cachedFixedRFH2 = null;
    private static final int RFH2_FIXED_SIZE = 36;
    private static final int MQRFH_VERSION_OFFSET = 4;
    private static final int RFH2_LENGTH_OFFSET = 8;
    private static final int RFH2_ENCODING_OFFSET = 12;
    private static final int RFH2_CHARSET_OFFSET = 16;
    private static final int RFH2_FORMAT_OFFSET = 20;
    private static final int RFH_CHAR_SET_OFFSET = 32;
    private int cachedRFH2Length;
    private int cachedRFH2Encoding;
    private int cachedRFH2CharSet;
    String cachedRFH2Format;
    private boolean persistenceFromMD;
    private byte[] formatAsByteArray = new byte[8];
    private static Hashtable ccsidTable = new Hashtable(7);

    MQJMSMessage() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    JMSMessage createJMSMessage(MQSession mQSession) throws JMSException, IOException {
        JMSMessage jMSMessage;
        int n = this.getCharacterSet();
        int n2 = this.getEncoding();
        this.persistenceFromMD = mQSession.getPersistenceFromMD();
        try {
            try {
                String string;
                boolean bl;
                int n3;
                JMSMessage jMSMessage2;
                block37: {
                    String string2;
                    String string3;
                    String string4;
                    block30: {
                        String string5;
                        byte[] byArray;
                        jMSMessage2 = null;
                        n3 = 0;
                        String string6 = null;
                        string4 = null;
                        string3 = null;
                        string2 = null;
                        int n4 = 0;
                        int n5 = 0;
                        int n6 = 0;
                        int n7 = 0;
                        int n8 = 0;
                        int n9 = 0;
                        boolean bl2 = false;
                        bl = false;
                        if (Trace.isOn) {
                            Trace.entry((Object)this, "createJMSMessage");
                        }
                        int n10 = n2;
                        long l = this.getFormatAsLong();
                        n3 = 0;
                        int n11 = 0;
                        while (true) {
                            int n12;
                            int n13;
                            int n14;
                            block36: {
                                block32: {
                                    if ((l & 0xFFFFFF0000000000L) != 5571313378871214080L && (l & 0xFFFFFF0000000000L) != -3109515640373772288L) {
                                        this.formatAsByteArray[0] = (byte)(l >>> 56 & 0xFFL);
                                        this.formatAsByteArray[1] = (byte)(l >>> 48 & 0xFFL);
                                        this.formatAsByteArray[2] = (byte)(l >>> 40 & 0xFFL);
                                        this.formatAsByteArray[3] = (byte)(l >>> 32 & 0xFFL);
                                        this.formatAsByteArray[4] = (byte)(l >>> 24 & 0xFFL);
                                        this.formatAsByteArray[5] = (byte)(l >>> 16 & 0xFFL);
                                        this.formatAsByteArray[6] = (byte)(l >>> 8 & 0xFFL);
                                        this.formatAsByteArray[7] = (byte)(l >>> 0 & 0xFFL);
                                        string = new String(this.formatAsByteArray);
                                        if (bl2 && n5 > 0) {
                                            byArray = this.getMessageData(false);
                                            string5 = string.equals("MQSTR   ") ? "jms_text" : "jms_bytes";
                                        }
                                        break block30;
                                    }
                                    this.skipReadingBytes(8);
                                    n14 = this.readInt(n10);
                                    n13 = this.readInt(n10);
                                    n12 = this.readInt(n10);
                                    if (l != 5571313732236222496L && l != -3109514705028104128L) break block32;
                                    l = (long)this.readInt(1) << 32;
                                    l += (long)this.readInt(1) & 0xFFFFFFFFL;
                                    this.skipReadingBytes(4);
                                    int n15 = this.readInt(n10);
                                    if (n15 == 1208) {
                                        bl2 = true;
                                    } else {
                                        string6 = MQJMSMessage.getCharacterSetString(n15, n10);
                                        bl2 = false;
                                    }
                                    n3 += 36;
                                    while (n3 < n14 + n11) {
                                        int n16;
                                        block35: {
                                            block33: {
                                                int n17;
                                                byte[] byArray2;
                                                block34: {
                                                    n16 = this.readInt(n10);
                                                    n3 += 4;
                                                    if (!bl2) break block33;
                                                    byArray2 = this.getMessageData(false);
                                                    if (byArray2[(n17 = n3) + 0] != 60 || byArray2[n17 + 1] != 109 || byArray2[n17 + 2] != 99 || byArray2[n17 + 3] != 100 || byArray2[n17 + 4] != 62) break block34;
                                                    n4 = n3;
                                                    n5 = n16;
                                                    break block35;
                                                }
                                                if (byArray2[n17 + 0] == 60 && byArray2[n17 + 1] == 106 && byArray2[n17 + 2] == 109 && byArray2[n17 + 3] == 115 && byArray2[n17 + 4] == 62) {
                                                    n8 = n3;
                                                    n9 = n16;
                                                    break block35;
                                                } else if (byArray2[n17 + 0] == 60 && byArray2[n17 + 1] == 117 && byArray2[n17 + 2] == 115 && byArray2[n17 + 3] == 114 && byArray2[n17 + 4] == 62) {
                                                    n6 = n3;
                                                    n7 = n16;
                                                }
                                                break block35;
                                            }
                                            String string7 = new String(this.getMessageData(false), n3, n16, string6);
                                            if (Trace.isOn) {
                                                Trace.trace((Object)this, "createJMSMessage found Folder " + string7);
                                            }
                                            if (string7.startsWith("<mcd>")) {
                                                string4 = string7;
                                            } else if (string7.startsWith("<usr>")) {
                                                string3 = string7;
                                            } else if (string7.startsWith("<jms>")) {
                                                string2 = string7;
                                            }
                                        }
                                        n3 += n16;
                                        this.skipReadingBytes(n16);
                                    }
                                    break block36;
                                }
                                l = this.readInt(1);
                                l = (l << 32) + (long)this.readInt(1);
                                this.skipReadingBytes(n14 - 28);
                                n3 += n14;
                            }
                            n10 = n13;
                            this.setEncoding(n13);
                            n11 += n14;
                            if (n12 == -2) continue;
                            this.setCharacterSet(n12);
                        }
                        jMSMessage2 = JMSMessage._parseMcdFolderUtf8(mQSession, MQSession.jmsStrings, string5, byArray, n4, n5);
                        if (n9 > 0) {
                            jMSMessage2._parseJmsFolderUtf8(byArray, n8, n9, mQSession, this.persistenceFromMD);
                            bl = true;
                        }
                        if (n7 > 0) {
                            string3 = new String(byArray, n6, n7, RFH_CHAR_SET_STRING);
                            jMSMessage2._parseUsrFolder(string3);
                        }
                        break block37;
                    }
                    if (string4 != null) {
                        String string8 = string.equals("MQSTR   ") ? "jms_text" : "jms_bytes";
                        jMSMessage2 = JMSMessage._parseMcdFolder(mQSession, MQSession.jmsStrings, string4, string8);
                        if (string2 != null) {
                            jMSMessage2._parseJmsFolder(mQSession, string2, this.persistenceFromMD);
                            bl = true;
                        }
                        if (string3 != null) {
                            jMSMessage2._parseUsrFolder(string3);
                        }
                    } else {
                        jMSMessage2 = this.getMessageDataLength() == 0 ? (JMSMessage)mQSession.createMessage() : (string.equals("MQSTR   ") ? (JMSMessage)mQSession.createTextMessage() : (JMSMessage)mQSession.createBytesMessage());
                    }
                }
                if (!bl) {
                    jMSMessage2.setJMSDeliveryMode(-3);
                }
                this.setHeaderFromMQMD(jMSMessage2);
                this.setHeaderFromMQMD_on_Receive(jMSMessage2, string);
                if (n3 < this.getMessageDataLength()) {
                    jMSMessage2._importBody(this.getMessageData(true), n3, this.getEncoding(), MQJMSMessage.getCharacterSetString(this.getCharacterSet(), this.getEncoding()));
                }
                jMSMessage2._setReadOnly();
                jMSMessage = jMSMessage2;
                Object var32_39 = null;
            }
            catch (IOException iOException) {
                if (!Trace.isOn) throw iOException;
                Trace.trace((Object)this, "createJMSMessage throwing " + iOException);
                throw iOException;
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                Trace.trace((Object)this, "createJMSMessage throwing " + (Object)((Object)jMSException));
                Trace.trace((Object)this, "linked exception " + (Object)((Object)mQException));
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace((Object)this, "createJMSMessage throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace((Object)this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var32_40 = null;
            this.setCharacterSet(n);
            this.setEncoding(n2);
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "createJMSMessage");
            throw throwable;
        }
        this.setCharacterSet(n);
        this.setEncoding(n2);
        if (!Trace.isOn) return jMSMessage;
        Trace.exit((Object)this, "createJMSMessage");
        return jMSMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getCharacterSetString(int n, int n2) {
        String string;
        try {
            String string2;
            if (Trace.isOn) {
                Trace.entry(CLASSNAME, "getCharacterSetString");
            }
            if (n == 0) {
                n = 819;
            }
            if (n % 4096 == 1200) {
                string2 = (n2 & 0xF) == 2 ? "UnicodeLittle" : "UnicodeBig";
            } else {
                string = Integer.toString(n);
                string2 = MQCcsidTable.lookup((String)string);
                if (string2 == null) {
                    string2 = "Cp" + string;
                }
            }
            if (Trace.isOn) {
                Trace.trace(2, CLASSNAME, "Mapped " + n + " -> " + string2);
            }
            string = string2;
            Object var5_4 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "getCharacterSetString");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "getCharacterSetString");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setHeaderFromMQMD(Message message) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry((Object)this, "setHeaderFromMQMD");
                }
                message.setJMSPriority(this.getPriority());
                if (message.getJMSDeliveryMode() == -2 || this.persistenceFromMD) {
                    if (this.getPersistence() == 0) {
                        message.setJMSDeliveryMode(1);
                    } else if (this.getPersistence() == 1) {
                        message.setJMSDeliveryMode(2);
                    } else {
                        message.setJMSDeliveryMode(-1);
                    }
                }
                if (message.getJMSCorrelationID() == null) {
                    message.setJMSCorrelationIDAsBytes(this.getCorrelationId());
                }
                if (message.getJMSReplyTo() == null && this.getReplyToQueueName() != null && !this.getReplyToQueueName().trim().equals("")) {
                    message.setJMSReplyTo((Destination)new MQQueue(this.getReplyToQueueManagerName(), this.getReplyToQueueName()));
                }
                if (message instanceof JMSMessage) {
                    if (Trace.isOn) {
                        Trace.trace((Object)this, "message is from com.ibm.jms");
                    }
                    JMSMessage jMSMessage = (JMSMessage)message;
                    jMSMessage._setCcsidForStrings(this._getCcsid(), this._getIsCcsidAscii(), this._doStringsNeedCcsidConversion());
                    jMSMessage._setJMSMessageIDAsBytes(this.getMessageId());
                    jMSMessage._setJMSXUserIDFromBytes(this.getUserIdAsBytes());
                    jMSMessage._setJMSXPutAppIDFromBytes(this.getPutApplicationNameAsBytes());
                    if ((this.getMessageFlags() & 8) != 0 || (this.getMessageFlags() & 0x10) != 0) {
                        jMSMessage._setJMSXGroupSeqFromInt(this.getMessageSequenceNumber());
                        String string = JMSMessage._idToString(this.getGroupId());
                        if (string != null) {
                            jMSMessage._setJMSXObjectProperty("JMSXGroupID", string);
                        }
                    }
                    jMSMessage._setJMSIBMPutDateFromBytes(this.getPutDateAsBytes());
                    jMSMessage._setJMSIBMPutTimeFromBytes(this.getPutTimeAsBytes());
                    jMSMessage._setJMSIBMPutApplTypeFromInt(this.getPutApplicationType());
                }
                if (Trace.isOn) {
                    Trace.trace((Object)this, "message is from another vendor, only updating subset of properties");
                }
                message.setJMSMessageID(JMSMessage._idToString(this.getMessageId()));
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                Trace.trace((Object)this, "setHeaderFromMQMD throwing " + (Object)((Object)jMSException));
                Trace.trace((Object)this, "linked exception " + (Object)((Object)mQException));
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "setHeaderFromMQMD");
            throw throwable;
        }
        Trace.exit((Object)this, "setHeaderFromMQMD");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setHeaderFromMQMD_on_Receive(JMSMessage jMSMessage, String string) throws JMSException {
        try {
            block18: {
                try {
                    int n;
                    int n2;
                    if (Trace.isOn) {
                        Trace.entry((Object)this, "setHeaderFromMQMD_on_Receive");
                    }
                    if (jMSMessage.getJMSTimestamp() == 0L) {
                        jMSMessage.setJMSTimestamp(this.getPutTimeMillis());
                    }
                    if (jMSMessage.getJMSExpiration() == 0L && this.getExpiry() > 0) {
                        jMSMessage.setJMSExpiration(System.currentTimeMillis() + (long)(this.getExpiry() * 100));
                    }
                    if (this.getBackoutCount() > 0) {
                        jMSMessage.setJMSRedelivered(true);
                    }
                    jMSMessage._setJMSXDeliveryCountFromInt(this.getBackoutCount() + 1);
                    jMSMessage._setJMSIBMMsgTypeFromInt(this.getMessageType());
                    jMSMessage._setJMSXObjectProperty("JMS_IBM_Format", string);
                    if (this.getFeedback() != 0) {
                        jMSMessage._setJMSIBMFeedbackFromInt(this.getFeedback());
                    }
                    if ((n2 = (n = this.getReport()) & 0x7000000) != 0) {
                        jMSMessage._setJMSIBMReportExceptionFromInt(n2);
                    }
                    if ((n2 = n & 0xE00000) != 0) {
                        jMSMessage._setJMSIBMReportExpirationFromInt(n2);
                    }
                    if ((n2 = n & 0x700) != 0) {
                        jMSMessage._setJMSIBMReportCOAFromInt(n2);
                    }
                    if ((n2 = n & 0x3800) != 0) {
                        jMSMessage._setJMSIBMReportCODFromInt(n2);
                    }
                    if ((n2 = n & 1) != 0) {
                        jMSMessage._setJMSIBMReportPANFromInt(n2);
                    }
                    if ((n2 = n & 2) != 0) {
                        jMSMessage._setJMSIBMReportNANFromInt(n2);
                    }
                    if ((n2 = n & 0x40) != 0) {
                        jMSMessage._setJMSIBMPassCorrelIDFromInt(n2);
                    }
                    if ((n2 = n & 0x80) != 0) {
                        jMSMessage._setJMSIBMReportMsgIDFromInt(n2);
                    }
                    if ((n2 = n & 0x8000000) != 0) {
                        jMSMessage._setJMSIBMReportDiscardFromInt(n2);
                    }
                    if ((this.getMessageFlags() & 0x10) == 0) break block18;
                    jMSMessage._setJMSIBMLastMsgInGroupFromBool(true);
                }
                catch (MQException mQException) {
                    JMSException jMSException = new JMSException("MQJMS1000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    Trace.trace((Object)this, "setHeaderFromMQMD_on_Receive throwing " + (Object)((Object)jMSException));
                    Trace.trace((Object)this, "linked exception " + (Object)((Object)mQException));
                    throw jMSException;
                }
            }
            Object var6_7 = null;
            if (!Trace.isOn) return;
            Trace.exit((Object)this, "setHeaderFromMQMD_on_Receive");
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "setHeaderFromMQMD_on_Receive");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void write(JMSMessage jMSMessage, boolean bl, int n) throws JMSException {
        try {
            block9: {
                try {
                    if (Trace.isOn) {
                        Trace.entry((Object)this, "write");
                    }
                    jMSMessage.setJMSRedelivered(false);
                    jMSMessage._setJMSXObjectProperty("JMSXDeliveryCount", ZERO);
                    this.writeMQMD(jMSMessage);
                    if (bl) {
                        this.writeRFH2(jMSMessage, n);
                    } else {
                        this.setCharacterSet(n);
                    }
                    byte[] byArray = jMSMessage._exportBody(this.getEncoding(), MQJMSMessage.getCharacterSetString(n, this.getEncoding()));
                    if (byArray == null) break block9;
                    this.appendByteArray(byArray);
                }
                catch (IOException iOException) {
                    String string = ConfigEnvironment.getErrorMessage("MQJMS1065");
                    if (Trace.isOn) {
                        Trace.trace(0, (Object)this, "Throwing JMSException " + string);
                    }
                    JMSException jMSException = new JMSException(string);
                    jMSException.setLinkedException((Exception)iOException);
                    throw jMSException;
                }
                catch (MQException mQException) {
                    JMSException jMSException = new JMSException("MQJMS1000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    Trace.trace((Object)this, "write throwing " + (Object)((Object)jMSException));
                    Trace.trace((Object)this, "linked exception " + (Object)((Object)mQException));
                    throw jMSException;
                }
            }
            Object var8_6 = null;
            if (!Trace.isOn) return;
            Trace.exit((Object)this, "write");
            return;
        }
        catch (Throwable throwable) {
            Object var8_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "write");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private int writeFolder(String string) throws IOException, MQException {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry((Object)this, "writeFolder");
            }
            int n2 = this.getMessageDataLength();
            byte[] byArray = string.getBytes(RFH_CHAR_SET_STRING);
            int n3 = byArray.length;
            int n4 = 3 - (n2 + n3 - 1) % 4;
            this.appendInt(n3 += n4, this.getEncoding());
            this.appendByteArray(byArray);
            this.appendByteArray(SPACES, 0, n4);
            n = n3 + 4;
            Object var8_7 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "writeFolder");
            throw throwable;
        }
        Trace.exit((Object)this, "writeFolder");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeMQMD(JMSMessage jMSMessage) throws JMSException {
        try {
            try {
                String string;
                Object object;
                if (Trace.isOn) {
                    Trace.entry((Object)this, "writeMQMD");
                }
                this.setPriority(jMSMessage.getJMSPriority());
                this.setMessageId(MQ_NONE);
                byte[] byArray = jMSMessage.getJMSCorrelationIDAsBytes();
                if (byArray == null) {
                    this.setCorrelationId(MQ_NONE);
                } else {
                    this.setCorrelationId(byArray);
                }
                int n = jMSMessage.getJMSDeliveryMode();
                if (n == 1) {
                    this.setPersistence(0);
                } else if (n == 2) {
                    this.setPersistence(1);
                } else if (n == 2) {
                    this.setPersistence(0);
                } else {
                    String string2 = ConfigEnvironment.getErrorMessage("MQJMS1042");
                    if (!Trace.isOn) throw new JMSException(string2);
                    Trace.trace(0, (Object)this, "Throwing JMSException " + string2);
                    throw new JMSException(string2);
                }
                if (jMSMessage instanceof JMSTextMessage || jMSMessage instanceof JMSStreamMessage || jMSMessage instanceof JMSMapMessage) {
                    this.setFormat("MQSTR   ");
                } else {
                    this.setFormat("        ");
                }
                long l = jMSMessage._getTimeToLive();
                if (l == 0L) {
                    this.setExpiry(-1);
                } else if (l < 214748364700L) {
                    this.setExpiry((int)((l + 100L) / 100L));
                } else {
                    this.setExpiry(-1);
                }
                Destination destination = jMSMessage.getJMSReplyTo();
                this.setReplyToQueueName("");
                this.setReplyToQueueManagerName("");
                if (destination instanceof MQQueue) {
                    object = ((MQQueue)destination).getBaseQueueName();
                    if (object != null) {
                        this.setReplyToQueueName((String)object);
                    }
                    if ((string = ((MQQueue)destination).getBaseQueueManagerName()) != null) {
                        this.setReplyToQueueManagerName(string);
                    }
                    this.setMessageType(1);
                } else {
                    this.setMessageType(8);
                }
                object = jMSMessage.getPropertyNames();
                this.setReport(0);
                this.setFeedback(0);
                this.setGroupId(MQ_NONE);
                this.setMessageSequenceNumber(1);
                this.setOffset(0);
                this.setMessageFlags(0);
                this.setOriginalLength(-1);
                Destination destination2 = jMSMessage.getJMSDestination();
                while (object.hasMoreElements()) {
                    string = (String)object.nextElement();
                    if (!string.startsWith("JMS")) continue;
                    if (Trace.isOn) {
                        Trace.trace(3, (Object)this, "Processing property " + string);
                    }
                    if (string.equals("JMSXGroupID") && destination2 instanceof Queue) {
                        String string3 = jMSMessage.getStringProperty("JMSXGroupID");
                        if (string3.startsWith("ID:")) {
                            this.setGroupId(jMSMessage._stringToId(string3));
                        } else {
                            this.setGroupId(string3.getBytes(RFH_CHAR_SET_STRING));
                        }
                        this.setMessageFlags(this.getMessageFlags() | 8);
                        continue;
                    }
                    if (string.equals("JMSXGroupSeq") && destination2 instanceof Queue) {
                        this.setMessageSequenceNumber(jMSMessage._getJMSXGroupSeqAsInt());
                        this.setMessageFlags(this.getMessageFlags() | 8);
                        continue;
                    }
                    if (!string.startsWith("JMS_IBM_")) continue;
                    if (string.equals("JMS_IBM_Format")) {
                        this.setFormat(jMSMessage.getStringProperty("JMS_IBM_Format"));
                        continue;
                    }
                    if (string.equals("JMS_IBM_MsgType")) {
                        this.setMessageType(jMSMessage._getJMSIBMMsgTypeAsInt());
                        continue;
                    }
                    if (string.equals("JMS_IBM_Feedback")) {
                        this.setFeedback(jMSMessage._getJMSIBMFeedbackAsInt());
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_Exception")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportExceptionAsInt() & 0x7000000);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_Expiration")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportExpirationAsInt() & 0xE00000);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_COA")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportCOAAsInt() & 0x700);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_COD")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportCODAsInt() & 0x3800);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_PAN")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportPANAsInt() & 1);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_NAN")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportNANAsInt() & 2);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_Pass_Msg_ID")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportMsgIDAsInt() & 0x80);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_Pass_Correl_ID")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMPassCorrelIDAsInt() & 0x40);
                        continue;
                    }
                    if (string.equals("JMS_IBM_Report_Discard_Msg")) {
                        this.setReport(this.getReport() | jMSMessage._getJMSIBMReportDiscardAsInt() & 0x8000000);
                        continue;
                    }
                    if (!string.equals("JMS_IBM_Last_Msg_In_Group") || !(destination2 instanceof Queue) || !jMSMessage._getJMSIBMLastMsgInGroupAsBool()) continue;
                    this.setMessageFlags(this.getMessageFlags() | 0x10);
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1059");
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                if (Trace.isOn) {
                    Trace.trace((Object)this, "Write Throwing " + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace((Object)this, "Linked Exception " + unsupportedEncodingException);
                throw jMSException;
            }
            catch (MQException mQException) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace((Object)this, "write Throwing" + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace((Object)this, "Linked Exception " + (Object)((Object)mQException));
                throw jMSException;
            }
            Object var12_15 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var12_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "writeMQMD");
            throw throwable;
        }
        Trace.exit((Object)this, "writeMQMD");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeRFH(String string, JMSMessage jMSMessage, boolean bl, int n) throws JMSException, IOException {
        try {
            try {
                Object var8_5 = null;
                if (Trace.isOn) {
                    Trace.entry((Object)this, "writeRFH");
                }
                String string2 = string + BLANK_STRING15;
                int n2 = string2.length() / 16 * 16;
                String string3 = string2.substring(0, n2);
                this.appendByteArray(MQRFH_STRUC_ID.getBytes());
                this.appendInt(1, this.getEncoding());
                this.appendInt(32 + n2, this.getEncoding());
                this.appendInt(this.getEncoding(), this.getEncoding());
                if (n == 0 || n == -2) {
                    n = this.getCharacterSet();
                }
                if (bl) {
                    this.appendInt(this.getCharacterSet(), this.getEncoding());
                    this.appendByteArray(MQFMT_RF_HEADER_2.getBytes());
                } else {
                    this.appendInt(n, this.getEncoding());
                    this.appendByteArray("        ".getBytes());
                    this.setFormat(MQFMT_RF_HEADER_1);
                }
                this.appendInt(0, this.getEncoding());
                this.appendByteArray(string3.getBytes());
                this.write(jMSMessage, bl, n);
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)((Object)mQException));
                Trace.trace((Object)this, "writeRFH throwing " + (Object)((Object)jMSException));
                Trace.trace((Object)this, "linked exception " + (Object)((Object)mQException));
                throw jMSException;
            }
            Object var10_11 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "writeRFH");
            throw throwable;
        }
        Trace.exit((Object)this, "writeRFH");
    }

    private int reverseInt(int n) {
        int n2 = 0;
        n2 = (n >> 24 & 0xFF) << 0 | (n >> 16 & 0xFF) << 8 | (n >> 8 & 0xFF) << 16 | (n >> 0 & 0xFF) << 24;
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected byte[] buildCacheableRFH(String string, int n, int n2) throws JMSException {
        byte[] byArray;
        if (Trace.isOn) {
            Trace.entry((Object)this, "buildCacheableRFH");
        }
        try {
            try {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                String string2 = string + BLANK_STRING15;
                int n3 = string2.length() / 16 * 16;
                String string3 = string2.substring(0, n3);
                int n4 = 1;
                int n5 = 32 + n3;
                int n6 = this.getEncoding();
                int n7 = this.getCharacterSet();
                int n8 = 0;
                if ((n2 & 0xF) == 2) {
                    n4 = this.reverseInt(n4);
                    n5 = this.reverseInt(n5);
                    n6 = this.reverseInt(n6);
                    n7 = this.reverseInt(n7);
                    n8 = this.reverseInt(n8);
                }
                dataOutputStream.write(MQRFH_STRUC_ID.getBytes());
                dataOutputStream.writeInt(n4);
                dataOutputStream.writeInt(n5);
                dataOutputStream.writeInt(n6);
                if (n == 0 || n == -2) {
                    n = this.getCharacterSet();
                }
                dataOutputStream.writeInt(n7);
                dataOutputStream.write(MQFMT_RF_HEADER_2.getBytes());
                dataOutputStream.writeInt(0);
                dataOutputStream.write(string3.getBytes());
                dataOutputStream.flush();
                byArray = byteArrayOutputStream.toByteArray();
                Object var16_17 = null;
                if (!Trace.isOn) return byArray;
            }
            catch (IOException iOException) {
                JMSException jMSException = new JMSException("MQJMS1000");
                jMSException.setLinkedException((Exception)iOException);
                Trace.trace((Object)this, "buildCacheableRFH throwing " + (Object)((Object)jMSException));
                Trace.trace((Object)this, "linked exception " + iOException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var16_18 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "buildCacheableRFH");
            throw throwable;
        }
        Trace.exit((Object)this, "buildCacheableRFH");
        return byArray;
    }

    private final void insertIntIntoByteArray(int n, byte[] byArray, int n2, int n3) {
        switch (n3 & 0xF) {
            case 0: 
            case 1: {
                byArray[n2 + 0] = (byte)(n >>> 24 & 0xFF);
                byArray[n2 + 1] = (byte)(n >>> 16 & 0xFF);
                byArray[n2 + 2] = (byte)(n >>> 8 & 0xFF);
                byArray[n2 + 3] = (byte)(n >>> 0 & 0xFF);
                break;
            }
            case 2: {
                byArray[n2 + 3] = (byte)(n >>> 24 & 0xFF);
                byArray[n2 + 2] = (byte)(n >>> 16 & 0xFF);
                byArray[n2 + 1] = (byte)(n >>> 8 & 0xFF);
                byArray[n2 + 0] = (byte)(n >>> 0 & 0xFF);
                break;
            }
            default: {
                Trace.trace(1, (Object)this, "Invalid encoding in insertIntIntoByteArray: " + (n3 & 0xF));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeRFH2(JMSMessage jMSMessage, int n) throws JMSException, IOException, MQException {
        if (Trace.isOn) {
            Trace.entry((Object)this, "writeRFH2");
        }
        try {
            int n2;
            int n3;
            byte[] byArray;
            int n4;
            int n5;
            byte[] byArray2;
            byte[] byArray3 = jMSMessage._getMcdFolder().getBytes(RFH_CHAR_SET_STRING);
            int n6 = 3 - (byArray3.length - 1) % 4;
            int n7 = byArray3.length + n6;
            byte[] byArray4 = jMSMessage._getJmsFolder(this.persistenceFromMD).getBytes(RFH_CHAR_SET_STRING);
            int n8 = 3 - (byArray4.length - 1) % 4;
            int n9 = byArray4.length + n8;
            int n10 = 44 + n7 + n9;
            String string = jMSMessage._getUsrFolder();
            if (string.equals("<usr></usr>")) {
                byArray2 = null;
                n5 = 0;
                n4 = 0;
            } else {
                byArray2 = string.getBytes(RFH_CHAR_SET_STRING);
                n5 = 3 - (byArray2.length - 1) % 4;
                n4 = byArray2.length + n5;
                n10 += n4;
                n10 += 4;
            }
            string = jMSMessage._getPscFolder();
            if (string.equals("<psc></psc>")) {
                byArray = null;
                n3 = 0;
                n2 = 0;
            } else {
                byArray = jMSMessage._getPscFolder().getBytes(RFH_CHAR_SET_STRING);
                n3 = 3 - (byArray.length - 1) % 4;
                n2 = byArray.length + n3;
                n10 += n2;
                n10 += 4;
            }
            if (this.cachedFixedRFH2 == null) {
                this.cachedRFH2Length = n10;
                this.cachedRFH2Encoding = this.getEncoding();
                this.cachedRFH2CharSet = n;
                this.cachedRFH2Format = this.getFormat();
                int n11 = 0;
                this.cachedFixedRFH2 = new byte[36];
                this.insertStrIntoByteArray(MQRFH_STRUC_ID, 4, this.cachedFixedRFH2, n11, this.getCharacterSet(), this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(2, this.cachedFixedRFH2, n11 += MQRFH_STRUC_ID.length(), this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(this.cachedRFH2Length, this.cachedFixedRFH2, n11 += 4, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(this.cachedRFH2Encoding, this.cachedFixedRFH2, n11 += 4, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(this.cachedRFH2CharSet, this.cachedFixedRFH2, n11 += 4, this.cachedRFH2Encoding);
                this.insertStrIntoByteArray(this.cachedRFH2Format, 8, this.cachedFixedRFH2, n11 += 4, this.getCharacterSet(), this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(0, this.cachedFixedRFH2, n11 += 8, this.cachedRFH2Encoding);
                this.insertIntIntoByteArray(1208, this.cachedFixedRFH2, n11 += 4, this.cachedRFH2Encoding);
            } else {
                boolean bl = false;
                if (this.cachedRFH2Encoding != this.getEncoding()) {
                    bl = true;
                    this.cachedRFH2Encoding = this.getEncoding();
                    this.insertIntIntoByteArray(this.cachedRFH2Encoding, this.cachedFixedRFH2, 12, this.cachedRFH2Encoding);
                    this.insertIntIntoByteArray(1208, this.cachedFixedRFH2, 32, this.cachedRFH2Encoding);
                    this.insertIntIntoByteArray(2, this.cachedFixedRFH2, 4, this.cachedRFH2Encoding);
                }
                if (bl || this.cachedRFH2Length != n10) {
                    this.cachedRFH2Length = n10;
                    this.insertIntIntoByteArray(this.cachedRFH2Length, this.cachedFixedRFH2, 8, this.cachedRFH2Encoding);
                }
                if (bl || this.cachedRFH2CharSet != n) {
                    this.cachedRFH2CharSet = n;
                    this.insertIntIntoByteArray(this.cachedRFH2CharSet, this.cachedFixedRFH2, 16, this.cachedRFH2Encoding);
                }
                if (!this.cachedRFH2Format.equals(this.getFormat())) {
                    this.cachedRFH2Format = this.getFormat();
                    this.insertStrIntoByteArray(this.cachedRFH2Format, 8, this.cachedFixedRFH2, 20, this.getCharacterSet(), this.cachedRFH2Encoding);
                }
            }
            this.setFormat(MQFMT_RF_HEADER_2);
            this.appendByteArray(this.cachedFixedRFH2);
            if (byArray != null) {
                this.appendInt(n2, this.getEncoding());
                this.appendByteArray(byArray);
                this.appendByteArray(SPACES, 0, n3);
            }
            this.appendInt(n7, this.getEncoding());
            this.appendByteArray(byArray3);
            this.appendByteArray(SPACES, 0, n6);
            this.appendInt(n9, this.getEncoding());
            this.appendByteArray(byArray4);
            this.appendByteArray(SPACES, 0, n8);
            if (byArray2 != null) {
                this.appendInt(n4, this.getEncoding());
                this.appendByteArray(byArray2);
                this.appendByteArray(SPACES, 0, n5);
            }
            Object var19_19 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var19_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "writeRFH2");
            throw throwable;
        }
        Trace.exit((Object)this, "writeRFH2");
    }

    private void insertStrIntoByteArray(String string, int n, byte[] byArray, int n2, int n3, int n4) throws JMSException {
        try {
            String string2 = MQJMSMessage.getCharacterSetString(n3, n4);
            byte[] byArray2 = string.getBytes(string2);
            int n5 = 0;
            while (n5 < n && n5 < byArray2.length) {
                byArray[n2 + n5] = byArray2[n5];
                ++n5;
            }
            if (string.length() < n) {
                byte[] byArray3 = " ".getBytes(string2);
                int n6 = string.length();
                while (n6 < n) {
                    byArray[n2 + n6] = byArray3[0];
                    ++n6;
                }
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (Trace.isOn) {
                Trace.trace((Object)this, "Write Throwing " + (Object)((Object)jMSException));
            }
            if (Trace.isOn) {
                Trace.trace((Object)this, "Linked Exception " + unsupportedEncodingException);
            }
            throw jMSException;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static int getCCSID(String string) {
        int n;
        block12: {
            int n2;
            block11: {
                try {
                    try {
                        int n3;
                        Integer n4;
                        if (Trace.isOn) {
                            Trace.entry(CLASSNAME, "getCCSID");
                        }
                        if ((n4 = (Integer)ccsidTable.get(string)) != null) {
                            n3 = n4;
                        } else {
                            if (string.startsWith("Cp")) {
                                string = string.substring(2);
                            }
                            if ((n3 = Integer.parseInt(string)) < 0) {
                                n2 = 0;
                                Object var5_7 = null;
                                if (!Trace.isOn) return n2;
                                break block11;
                            }
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "Mapped " + string + " -> " + n3);
                        }
                        n = n3;
                        break block12;
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (Trace.isOn) {
                            Trace.trace(CLASSNAME, "got a number format exception, returning 0");
                        }
                        int n5 = 0;
                        Object var5_9 = null;
                        if (!Trace.isOn) return n5;
                        Trace.exit(CLASSNAME, "getCCSID");
                        return n5;
                    }
                }
                catch (Throwable throwable) {
                    Object var5_10 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(CLASSNAME, "getCCSID");
                    throw throwable;
                }
            }
            Trace.exit(CLASSNAME, "getCCSID");
            return n2;
        }
        Object var5_8 = null;
        if (!Trace.isOn) return n;
        Trace.exit(CLASSNAME, "getCCSID");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPersistenceFromMD(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry((Object)this, "setPersistenceFromMD");
            }
            this.persistenceFromMD = bl;
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit((Object)this, "setPersistenceFromMD");
            throw throwable;
        }
        Trace.exit((Object)this, "setPersistenceFromMD");
    }

    static {
        ccsidTable.put("JIS", new Integer(2022));
        ccsidTable.put("EUCJIS", new Integer(954));
        ccsidTable.put("SJIS", new Integer(932));
        ccsidTable.put("KSC5601", new Integer(5601));
        ccsidTable.put(RFH_CHAR_SET_STRING, new Integer(1208));
        ccsidTable.put("UnicodeLittle", new Integer(1200));
        ccsidTable.put("UnicodeBig", new Integer(1200));
        ccsidTable.put("GB18030", new Integer(5844));
    }
}

