/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.jms.JMSDestination;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

public abstract class MQDestination
implements Destination,
JMSDestination,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQDestination.java, jms, j521, j521-L020126 02/01/25 15:22:18 @(#) 1.33.1.1";
    private static final String CLASSNAME = "MQDestination";
    private static final int DEF_EXPIRY = -2;
    private static final int DEF_PRIORITY = -2;
    private static final int DEF_PERSISTENCE = -2;
    private static final int DEF_CCSID = 1208;
    private static final int DEF_TARGET = 0;
    private static final int DEF_ENCODING = 273;
    private static final String DEF_DYNAMICPREFIX = "AMQ.*";
    private int version = 1;
    private String description = null;
    private long expiry = -2L;
    private int priority = -2;
    private int persistence = -2;
    private int CCSID = 1208;
    private int targetClient = 0;
    private int encoding = 273;
    private String dynamicPrefix = "AMQ.*";
    private String cachedNVs = null;
    private long cachedExpiryValue;
    private int cachedPriorityValue;
    private int cachedPersistenceValue;
    private int cachedCCSIDValue;
    private int cachedTargetClientValue;
    private int cachedEncodingValue;
    private String cachedDynamicPrefixValue;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getVersion() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getVersion");
            }
            n = this.version;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getVersion");
            throw throwable;
        }
        Trace.exit(this, "getVersion");
        return n;
    }

    public void setVersion(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setVersion");
                }
                JMSException jMSException = new JMSException("version can't be changed");
                throw jMSException;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                }
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var4_5 = null;
                if (!Trace.isOn) break block6;
                Trace.exit(this, "setVersion");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDescription() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDescription");
            }
            string = this.description;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDescription");
            throw throwable;
        }
        Trace.exit(this, "getDescription");
        return string;
    }

    public void setDescription(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setDescription");
        }
        this.description = string;
        if (Trace.isOn) {
            Trace.exit(this, "setDescription");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDynamicPrefix() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDynamicPrefix");
            }
            string = this.dynamicPrefix;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDynamicPrefix");
            throw throwable;
        }
        Trace.exit(this, "getDynamicPrefix");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setDynamicPrefix(String string) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setDynamicPrefix");
                }
                if (string.equals(null) || string.equals("")) {
                    this.dynamicPrefix = DEF_DYNAMICPREFIX;
                }
                this.dynamicPrefix = string;
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "dynamicPrefix", String.valueOf(this.dynamicPrefix));
                throw jMSException;
            }
            Object var5_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setDynamicPrefix");
            throw throwable;
        }
        Trace.exit(this, "setDynamicPrefix");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getPriority");
            }
            n = this.priority;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getPriority");
            throw throwable;
        }
        Trace.exit(this, "getPriority");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPriority(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setPriority");
                }
                if (n != -2 && n != -1 && (n < 0 || n > 9)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "priority", String.valueOf(n));
                    throw jMSException;
                }
                this.priority = n;
                Object var4_4 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPriority");
            throw throwable;
        }
        Trace.exit(this, "setPriority");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public long getExpiry() {
        long l;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getExpiry");
            }
            l = this.expiry;
            Object var4_2 = null;
            if (!Trace.isOn) return l;
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getExpiry");
            throw throwable;
        }
        Trace.exit(this, "getExpiry");
        return l;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setExpiry(long l) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setExpiry");
                }
                if (l <= 0L && l != -2L && l != 0L) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "expiry", String.valueOf(l));
                    throw jMSException;
                }
                this.expiry = l;
                Object var5_4 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setExpiry");
            throw throwable;
        }
        Trace.exit(this, "setExpiry");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPersistence() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getPersistence");
            }
            n = this.persistence;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getPersistence");
            throw throwable;
        }
        Trace.exit(this, "getPersistence");
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void setPersistence(int var1_1) throws JMSException {
        block11: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setPersistence");
                }
                switch (var1_1) {
                    case -2: 
                    case -1: 
                    case 1: 
                    case 2: {
                        this.persistence = var1_1;
                        break;
                    }
                    default: {
                        var2_2 = ConfigEnvironment.newException("MQJMS1006", "persistence", String.valueOf(var1_1));
                        throw var2_2;
                    }
                }
                var4_4 = null;
                ** if (!Trace.isOn) goto lbl-1000
            }
            catch (Throwable var3_6) {
                var4_5 = null;
                if (Trace.isOn) {
                    Trace.exit(this, "setPersistence");
                }
                throw var3_6;
            }
lbl-1000:
            // 1 sources

            {
                Trace.exit(this, "setPersistence");
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (JMSException var2_3) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)var2_3);
                    }
                    throw var2_3;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTargetClient() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTargetClient");
            }
            n = this.targetClient;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getTargetClient");
            throw throwable;
        }
        Trace.exit(this, "getTargetClient");
        return n;
    }

    /*
     * Unable to fully structure code
     */
    public void setTargetClient(int var1_1) throws JMSException {
        block11: {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setTargetClient");
                }
                switch (var1_1) {
                    case 0: 
                    case 1: {
                        this.targetClient = var1_1;
                        break;
                    }
                    default: {
                        var2_2 = ConfigEnvironment.newException("MQJMS1006", "targetClient", String.valueOf(var1_1));
                        throw var2_2;
                    }
                }
                var4_4 = null;
                ** if (!Trace.isOn) goto lbl-1000
            }
            catch (Throwable var3_6) {
                var4_5 = null;
                if (Trace.isOn) {
                    Trace.exit(this, "setTargetClient");
                }
                throw var3_6;
            }
lbl-1000:
            // 1 sources

            {
                Trace.exit(this, "setTargetClient");
            }
lbl-1000:
            // 2 sources

            {
                break block11;
                catch (JMSException var2_3) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)var2_3);
                    }
                    throw var2_3;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCCSID() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getCCSID");
            }
            n = this.CCSID;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getCCSID");
            throw throwable;
        }
        Trace.exit(this, "getCCSID");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCCSID(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setCCSID");
                }
                if (n < 0) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "CCSID", String.valueOf(n));
                    throw jMSException;
                }
                this.CCSID = n;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setCCSID");
            throw throwable;
        }
        Trace.exit(this, "setCCSID");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getEncoding() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getEncoding");
            }
            n = this.encoding;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getEncoding");
            throw throwable;
        }
        Trace.exit(this, "getEncoding");
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setEncoding(int n) throws JMSException {
        try {
            try {
                int n2;
                if (Trace.isOn) {
                    Trace.entry(this, "setEncoding");
                }
                if ((n & ~(n2 = 819)) != 0) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "encoding", Integer.toHexString(this.encoding));
                    throw jMSException;
                }
                this.encoding = n;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setEncoding");
            throw throwable;
        }
        Trace.exit(this, "setEncoding");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl2 = false;
            } else if (object instanceof MQDestination) {
                MQDestination mQDestination = (MQDestination)object;
                bl2 = this.version == mQDestination.version && this.twoStringsEqual(this.description, mQDestination.description) && this.expiry == mQDestination.expiry && this.priority == mQDestination.priority && this.persistence == mQDestination.persistence && this.CCSID == mQDestination.CCSID && this.targetClient == mQDestination.targetClient && this.encoding == mQDestination.encoding;
            } else {
                bl2 = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl2);
            }
            bl = bl2;
            Object var6_5 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "equals");
            throw throwable;
        }
        Trace.exit(this, "equals");
        return bl;
    }

    public int hashCode() {
        int n = this.version ^ (int)(this.expiry & 0xFFFFFFFFFFFFFFFFL) ^ this.priority << 4 ^ this.persistence << 8 ^ this.CCSID ^ this.targetClient << 12 ^ this.encoding << 16;
        if (this.description != null) {
            n ^= this.description.hashCode();
        }
        return n;
    }

    public String getStringFromDestination() {
        if (Trace.isOn) {
            Trace.entry(this, "getStringFromDestination");
        }
        if (this instanceof MQQueue) {
            if (Trace.isOn) {
                Trace.exit(this, "getStringFromDestination");
            }
            return ((MQQueue)this).getQueueName();
        }
        if (this instanceof MQTopic) {
            if (Trace.isOn) {
                Trace.exit(this, "getStringFromDestination");
            }
            return ((MQTopic)this).getTopicName();
        }
        if (Trace.isOn) {
            Trace.exit(this, "getStringFromDestination");
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Destination createDestination(String string) {
        MQQueue mQQueue;
        try {
            try {
                MQDestination mQDestination = null;
                if (Trace.isOn) {
                    Trace.entry(CLASSNAME, "createDestination");
                }
                if (string != null) {
                    if (string.startsWith("queue:")) {
                        mQDestination = new MQQueue(string);
                    } else if (string.startsWith("topic")) {
                        mQDestination = new MQTopic(string);
                    } else {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1027", string));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        String string2 = ConfigEnvironment.getErrorMessage("MQJMS0003");
                        if (!Trace.isOn) throw new RuntimeException(string2 + ": " + string);
                        Trace.trace(CLASSNAME, "A RuntimeException is about to be thrown with the message: " + string2);
                        Trace.exit(CLASSNAME, "createDestination");
                        throw new RuntimeException(string2 + ": " + string);
                    }
                }
                mQQueue = mQDestination;
                Object var4_7 = null;
                if (!Trace.isOn) return mQQueue;
            }
            catch (JMSException jMSException) {
                RuntimeException runtimeException = new RuntimeException(jMSException.toString());
                if (!Trace.isOn) throw runtimeException;
                Trace.trace(CLASSNAME, "Throwing " + runtimeException);
                throw runtimeException;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLASSNAME, "createDestination");
            throw throwable;
        }
        Trace.exit(CLASSNAME, "createDestination");
        return mQQueue;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean twoStringsEqual(String string, String string2) {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "twoStringsEqual");
            }
            bl = MQConnectionFactory.twoStringsEqual(string, string2);
            Object var5_4 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "twoStringsEqual");
            throw throwable;
        }
        Trace.exit(this, "twoStringsEqual");
        return bl;
    }

    String getNVs() {
        if (this.cachedNVs == null || this.expiry != this.cachedExpiryValue || this.priority != this.cachedPriorityValue || this.persistence != this.cachedPersistenceValue || this.CCSID != this.cachedCCSIDValue || this.targetClient != this.cachedTargetClientValue || this.encoding != this.cachedEncodingValue || this.dynamicPrefix != this.cachedDynamicPrefixValue) {
            boolean bl = true;
            StringBuffer stringBuffer = new StringBuffer();
            if (this.expiry != -2L) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("expiry=" + this.expiry);
            }
            if (this.priority != -2) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("priority=" + this.priority);
            }
            if (this.persistence != -2) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("persistence=" + this.persistence);
            }
            if (this.CCSID != 1208) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("CCSID=" + this.CCSID);
            }
            if (this.targetClient != 0) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("targetClient=" + this.targetClient);
            }
            if (this.encoding != 273) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("encoding=" + this.encoding);
            }
            if (this.dynamicPrefix != DEF_DYNAMICPREFIX) {
                if (bl) {
                    stringBuffer.append("?");
                    bl = false;
                } else {
                    stringBuffer.append("&");
                }
                stringBuffer.append("dynamicPrefix=" + this.dynamicPrefix);
            }
            this.cachedNVs = stringBuffer.toString();
            this.cachedExpiryValue = this.expiry;
            this.cachedPriorityValue = this.priority;
            this.cachedPersistenceValue = this.persistence;
            this.cachedCCSIDValue = this.CCSID;
            this.cachedTargetClientValue = this.targetClient;
            this.cachedEncodingValue = this.encoding;
            this.cachedDynamicPrefixValue = this.dynamicPrefix;
        }
        return this.cachedNVs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Properties getPropertiesFromURI(String string) throws JMSException {
        Properties properties2;
        Properties properties3 = null;
        String string2 = null;
        try {
            try {
                int n;
                if (Trace.isOn) {
                    Trace.entry(this, "getPropertiesFromURI");
                }
                if ((n = string.indexOf(63)) == -1) {
                    string2 = string;
                } else if (string.length() > n + 1) {
                    string2 = string.substring(n + 1);
                }
                while (true) {
                    String string3;
                    if (string2 == null) {
                        properties2 = properties3;
                        Object var14_15 = null;
                        if (!Trace.isOn) return properties2;
                        break;
                    }
                    int n2 = string2.indexOf(38);
                    if (n2 != -1) {
                        string3 = string2.substring(0, n2);
                        string2 = string2.substring(n2 + 1);
                    } else {
                        string3 = string2;
                        string2 = null;
                    }
                    int n3 = string3.indexOf(61);
                    if (n3 == -1) {
                        String string4 = "MQJMS0003";
                        String string5 = ConfigEnvironment.getErrorMessage(string4);
                        InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string5, string4);
                        throw invalidDestinationException;
                    }
                    String string6 = string3.substring(0, n3);
                    String string7 = string3.substring(n3 + 1);
                    if (properties3 == null) {
                        properties3 = new Properties();
                    }
                    ((Hashtable)properties3).put(string6, string7);
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getPropertiesFromURI");
            throw throwable;
        }
        Trace.exit(this, "getPropertiesFromURI");
        return properties2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setFromProperties(Properties properties2) throws JMSException {
        try {
            block12: {
                try {
                    String string;
                    if (Trace.isOn) {
                        Trace.entry(this, "setFromProperties");
                    }
                    if ((string = properties2.getProperty("expiry")) != null) {
                        this.setExpiry(Integer.parseInt(string));
                    }
                    if ((string = properties2.getProperty("priority")) != null) {
                        this.setPriority(Integer.parseInt(string));
                    }
                    if ((string = properties2.getProperty("persistence")) != null) {
                        this.setPersistence(Integer.parseInt(string));
                    }
                    if ((string = properties2.getProperty("CCSID")) != null) {
                        this.setCCSID(Integer.parseInt(string));
                    }
                    if ((string = properties2.getProperty("targetClient")) != null) {
                        this.setTargetClient(Integer.parseInt(string));
                    }
                    if ((string = properties2.getProperty("encoding")) != null) {
                        this.setEncoding(Integer.parseInt(string));
                    }
                    if ((string = properties2.getProperty("dynamicPrefix")) == null) break block12;
                    this.setDynamicPrefix(string);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
                catch (NumberFormatException numberFormatException) {
                    String string = "MQJMS0003";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string2, string);
                    invalidDestinationException.setLinkedException((Exception)numberFormatException);
                    if (!Trace.isOn) throw invalidDestinationException;
                    Trace.trace(this, "Throwing " + invalidDestinationException);
                    throw invalidDestinationException;
                }
            }
            Object var9_3 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "setFromProperties");
            return;
        }
        catch (Throwable throwable) {
            Object var9_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setFromProperties");
            throw throwable;
        }
    }
}

