/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.Serializable;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public abstract class MQConnectionFactory
implements ConnectionFactory,
Serializable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQConnectionFactory.java, jms, j521, j521-L020601 02/05/31 12:02:49 @(#) 1.33.1.4";
    static final long serialVersionUID = 1357803352856448349L;
    private static final String CLASSNAME = "MQConnectionFactory";
    public static final String KEY_VERSION = "VER";
    public static final String KEY_DESCRIPTION = "DESC";
    public static final String KEY_TRANSPORT_TYPE = "TRAN";
    public static final String KEY_CLIENT_ID = "CID";
    public static final String KEY_QUEUE_MANAGER = "QMGR";
    public static final String KEY_HOST_NAME = "HOST";
    public static final String KEY_PORT = "PORT";
    public static final String KEY_CHANNEL = "CHAN";
    public static final String KEY_CCSID = "CCS";
    public static final String KEY_RECEIVE_EXIT = "RCX";
    public static final String KEY_RECEIVE_EXIT_INIT = "RCXI";
    public static final String KEY_SECURITY_EXIT = "SCX";
    public static final String KEY_SECURITY_EXIT_INIT = "SCXI";
    public static final String KEY_SEND_EXIT = "SDX";
    public static final String KEY_SEND_EXIT_INIT = "SDXI";
    public static final String KEY_SYNCPOINT_ALL_GETS = "SPAG";
    public static final String KEY_USE_CONN_POOLING = "UCP";
    public static final String KEY_POLLING_INTERVAL = "PINT";
    public static final String KEY_MSG_BATCH_SIZE = "MBS";
    private int version = 2;
    private String description = null;
    private int transportType = 0;
    private String clientId = null;
    private String queueManager = "";
    private String hostName = "localhost";
    public static final int MQ_DEFAULT_PORT = 1414;
    public static final int DIRECT_DEFAULT_PORT = 1506;
    private int port = 1414;
    private boolean portSet = false;
    private String channel = "SYSTEM.DEF.SVRCONN";
    private int CCSID = 819;
    private String receiveExit = null;
    private String receiveExitInit = null;
    private String securityExit = null;
    private String securityExitInit = null;
    private String sendExit = null;
    private String sendExitInit = null;
    private boolean syncpointAllGets = false;
    private boolean useConnectionPooling = true;
    private int pollingInterval = 5000;
    private int msgBatchSize = 10;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getVersion() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getVersion");
            }
            n = this.version;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getVersion");
            throw throwable;
        }
        Trace.exit(this, "getVersion");
        return n;
    }

    public void setVersion(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setVersion");
            }
            JMSException jMSException = new JMSException("Version can't be changed");
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            }
            throw jMSException;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (!Trace.isOn) break block4;
                Trace.exit(this, "setVersion");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getDescription() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getDescription");
            }
            string = this.description;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getDescription");
            throw throwable;
        }
        Trace.exit(this, "getDescription");
        return string;
    }

    public void setDescription(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setDescription");
        }
        this.description = string;
        if (Trace.isOn) {
            Trace.exit(this, "setDescription");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getTransportType() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getTransportType");
            }
            n = this.transportType;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getTransportType");
            throw throwable;
        }
        Trace.exit(this, "getTransportType");
        return n;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setTransportType(int n) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setTransportType");
            }
            switch (n) {
                case 0: 
                case 1: 
                case 3: {
                    this.transportType = n;
                    if (!this.portSet) {
                        this.port = 1414;
                    }
                    if (this instanceof MQTopicConnectionFactory) {
                        MQTopicConnectionFactory mQTopicConnectionFactory = (MQTopicConnectionFactory)this;
                        mQTopicConnectionFactory.setBrokerVersionDefault(0);
                    }
                    break;
                }
                case 2: {
                    this.transportType = n;
                    if (!this.portSet) {
                        this.port = 1506;
                    }
                    if (this instanceof MQTopicConnectionFactory) {
                        MQTopicConnectionFactory mQTopicConnectionFactory = (MQTopicConnectionFactory)this;
                        mQTopicConnectionFactory.setBrokerVersionDefault(1);
                        break;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "transportType", String.valueOf(n));
                    throw jMSException;
                }
                default: {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "transportType", String.valueOf(n));
                    throw jMSException;
                }
            }
            Object var4_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setTransportType");
            throw throwable;
        }
        Trace.exit(this, "setTransportType");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getClientId() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getClientId");
            }
            string = this.clientId;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getClientId");
            throw throwable;
        }
        Trace.exit(this, "getClientId");
        return string;
    }

    public void setClientId(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "getClientId");
        }
        this.clientId = string;
        if (Trace.isOn) {
            Trace.exit(this, "getClientId");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getQueueManager() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getQueueManager");
            }
            string = this.queueManager;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getQueueManager");
            throw throwable;
        }
        Trace.exit(this, "getQueueManager");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setQueueManager(String string) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setQueueManager");
                }
                if (string == null || string.length() > 48) {
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "<null>";
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "queueManager", string2);
                    throw jMSException;
                }
                this.queueManager = string;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setQueueManager");
            throw throwable;
        }
        Trace.exit(this, "setQueueManager");
    }

    public void setHostName(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setHostName");
        }
        this.hostName = string;
        if (Trace.isOn) {
            Trace.exit(this, "setHostName");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getHostName() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getHostName");
            }
            string = this.hostName;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getHostName");
            throw throwable;
        }
        Trace.exit(this, "getHostName");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPort(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setPort");
                }
                if (n < 0) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "port", String.valueOf(n));
                    throw jMSException;
                }
                this.port = n;
                this.portSet = true;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPort");
            throw throwable;
        }
        Trace.exit(this, "setPort");
    }

    public int getPort() {
        if (Trace.isOn) {
            Trace.entry(this, "getPort");
            Trace.exit(this, "getPort");
        }
        return this.port;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setChannel(String string) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setChannel");
                }
                if (string == null || string.length() > 20) {
                    String string2 = string;
                    if (string2 == null) {
                        string2 = "<null>";
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "channel", string2);
                    throw jMSException;
                }
                this.channel = string;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setChannel");
            throw throwable;
        }
        Trace.exit(this, "setChannel");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getChannel() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getChannel");
            }
            string = this.channel;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getChannel");
            throw throwable;
        }
        Trace.exit(this, "getChannel");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCCSID(int n) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setCCSID");
                }
                if (n < 0) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "CCSID", String.valueOf(n));
                    throw jMSException;
                }
                this.CCSID = n;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var4_4 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setCCSID");
            throw throwable;
        }
        Trace.exit(this, "setCCSID");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getCCSID() {
        int n;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getCCSID");
            }
            n = this.CCSID;
            Object var3_2 = null;
            if (!Trace.isOn) return n;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getCCSID");
            throw throwable;
        }
        Trace.exit(this, "getCCSID");
        return n;
    }

    public void setReceiveExit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setReceiveExit");
        }
        this.receiveExit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setReceiveExit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getReceiveExit() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReceiveExit");
            }
            string = this.receiveExit;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getReceiveExit");
            throw throwable;
        }
        Trace.exit(this, "getReceiveExit");
        return string;
    }

    public void setReceiveExitInit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setReceiveExitInit");
        }
        this.receiveExitInit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setReceiveExitInit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getReceiveExitInit() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getReceiveExitInit");
            }
            string = this.receiveExitInit;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getReceiveExitInit");
            throw throwable;
        }
        Trace.exit(this, "getReceiveExitInit");
        return string;
    }

    public void setSecurityExit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSecurityExit");
        }
        this.securityExit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSecurityExit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSecurityExit() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSecurityExit");
            }
            string = this.securityExit;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getSecurityExit");
            throw throwable;
        }
        Trace.exit(this, "getSecurityExit");
        return string;
    }

    public void setSecurityExitInit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSecurityExitInit");
        }
        this.securityExitInit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSecurityExitInit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSecurityExitInit() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSecurityExitInit");
            }
            string = this.securityExitInit;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getSecurityExitInit");
            throw throwable;
        }
        Trace.exit(this, "getSecurityExitInit");
        return string;
    }

    public void setSendExit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSendExit");
        }
        this.sendExit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSendExit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSendExit() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSendExit");
            }
            string = this.sendExit;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getSendExit");
            throw throwable;
        }
        Trace.exit(this, "getSendExit");
        return string;
    }

    public void setSendExitInit(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setSendExitInit");
        }
        this.sendExitInit = string;
        if (Trace.isOn) {
            Trace.exit(this, "setSendExitInit");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String getSendExitInit() {
        String string;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "getSendExitInit");
            }
            string = this.sendExitInit;
            Object var3_2 = null;
            if (!Trace.isOn) return string;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getSendExitInit");
            throw throwable;
        }
        Trace.exit(this, "getSendExitInit");
        return string;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setSyncpointAllGets(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setSyncpointAllGets");
                Trace.trace(this, "setting to " + bl);
            }
            this.syncpointAllGets = bl;
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setSyncpointAllGets");
            throw throwable;
        }
        Trace.exit(this, "setSyncpointAllGets");
    }

    public boolean getSyncpointAllGets() {
        return this.syncpointAllGets;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setUseConnectionPooling(boolean bl) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setUseConnectionPooling");
                Trace.trace(this, "setting to " + bl);
            }
            this.useConnectionPooling = bl;
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setUseConnectionPooling");
            throw throwable;
        }
        Trace.exit(this, "setUseConnectionPooling");
    }

    public boolean getUseConnectionPooling() {
        return this.useConnectionPooling;
    }

    public void setMsgBatchSize(int n) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setMsgBatchSize");
                Trace.trace(this, "setting to " + n);
            }
            this.msgBatchSize = n;
            Object var3_2 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            Trace.exit(this, "setMsgBatchSize");
            throw throwable;
        }
        Trace.exit(this, "setMsgBatchSize");
    }

    public int getMsgBatchSize() {
        return this.msgBatchSize;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPollingInterval(int n) {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setPollingInterval");
                Trace.trace(this, "setting to " + n);
            }
            this.pollingInterval = n;
            Object var3_2 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setPollingInterval");
            throw throwable;
        }
        Trace.exit(this, "setPollingInterval");
    }

    public int getPollingInterval() {
        return this.pollingInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl;
        try {
            boolean bl2;
            if (Trace.isOn) {
                Trace.entry(this, "equals");
            }
            if (object == null) {
                bl2 = false;
            } else if (object instanceof MQConnectionFactory) {
                MQConnectionFactory mQConnectionFactory = (MQConnectionFactory)object;
                bl2 = this.version == mQConnectionFactory.version && MQConnectionFactory.twoStringsEqual(this.description, mQConnectionFactory.description) && this.transportType == mQConnectionFactory.transportType && MQConnectionFactory.twoStringsEqual(this.clientId, mQConnectionFactory.clientId) && MQConnectionFactory.twoStringsEqual(this.queueManager, mQConnectionFactory.queueManager) && MQConnectionFactory.twoStringsEqual(this.hostName, mQConnectionFactory.hostName) && this.port == mQConnectionFactory.port && MQConnectionFactory.twoStringsEqual(this.channel, mQConnectionFactory.channel) && this.CCSID == mQConnectionFactory.CCSID && MQConnectionFactory.twoStringsEqual(this.receiveExit, mQConnectionFactory.receiveExit) && MQConnectionFactory.twoStringsEqual(this.receiveExitInit, mQConnectionFactory.receiveExitInit) && MQConnectionFactory.twoStringsEqual(this.securityExit, mQConnectionFactory.securityExit) && MQConnectionFactory.twoStringsEqual(this.securityExitInit, mQConnectionFactory.securityExitInit) && MQConnectionFactory.twoStringsEqual(this.sendExit, mQConnectionFactory.sendExit) && MQConnectionFactory.twoStringsEqual(this.sendExitInit, mQConnectionFactory.sendExitInit) && this.syncpointAllGets == mQConnectionFactory.syncpointAllGets && this.useConnectionPooling == mQConnectionFactory.useConnectionPooling && this.msgBatchSize == mQConnectionFactory.msgBatchSize && this.pollingInterval == mQConnectionFactory.pollingInterval;
            } else {
                bl2 = false;
            }
            if (Trace.isOn) {
                Trace.trace(this, "equals - result is " + bl2);
            }
            bl = bl2;
            Object var6_5 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "equals");
            throw throwable;
        }
        Trace.exit(this, "equals");
        return bl;
    }

    public int hashCode() {
        int n = this.version ^ this.transportType << 4 ^ this.port << 8 ^ this.CCSID << 16;
        if (this.description != null) {
            n ^= this.description.hashCode();
        }
        if (this.clientId != null) {
            n ^= this.clientId.hashCode();
        }
        if (this.queueManager != null) {
            n ^= this.queueManager.hashCode();
        }
        if (this.hostName != null) {
            n ^= this.hostName.hashCode();
        }
        if (this.channel != null) {
            n ^= this.channel.hashCode();
        }
        if (this.receiveExit != null) {
            n ^= this.receiveExit.hashCode();
        }
        if (this.receiveExitInit != null) {
            n ^= this.receiveExitInit.hashCode();
        }
        if (this.securityExit != null) {
            n ^= this.securityExit.hashCode();
        }
        if (this.securityExitInit != null) {
            n ^= this.securityExitInit.hashCode();
        }
        if (this.sendExit != null) {
            n ^= this.sendExit.hashCode();
        }
        if (this.sendExitInit != null) {
            n ^= this.sendExitInit.hashCode();
        }
        if (this.syncpointAllGets) {
            n ^= 0xFE00;
        }
        if (this.useConnectionPooling) {
            n ^= 0x30000;
        }
        n ^= this.msgBatchSize << 20;
        return n ^= this.pollingInterval << 7;
    }

    void updateReference(Reference reference) {
        String string = null;
        reference.add(new StringRefAddr(KEY_VERSION, String.valueOf(this.getVersion())));
        string = this.getDescription();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_DESCRIPTION, string));
        }
        reference.add(new StringRefAddr(KEY_TRANSPORT_TYPE, String.valueOf(this.getTransportType())));
        string = this.getClientId();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_CLIENT_ID, string));
        }
        if ((string = this.getQueueManager()) != null) {
            reference.add(new StringRefAddr(KEY_QUEUE_MANAGER, string));
        }
        if ((string = this.getHostName()) != null) {
            reference.add(new StringRefAddr(KEY_HOST_NAME, string));
        }
        reference.add(new StringRefAddr(KEY_PORT, String.valueOf(this.getPort())));
        string = this.getChannel();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_CHANNEL, string));
        }
        reference.add(new StringRefAddr(KEY_CCSID, String.valueOf(this.getCCSID())));
        string = this.getReceiveExit();
        if (string != null) {
            reference.add(new StringRefAddr(KEY_RECEIVE_EXIT, string));
        }
        if ((string = this.getReceiveExitInit()) != null) {
            reference.add(new StringRefAddr(KEY_RECEIVE_EXIT_INIT, string));
        }
        if ((string = this.getSecurityExit()) != null) {
            reference.add(new StringRefAddr(KEY_SECURITY_EXIT, string));
        }
        if ((string = this.getSecurityExitInit()) != null) {
            reference.add(new StringRefAddr(KEY_SECURITY_EXIT_INIT, string));
        }
        if ((string = this.getSendExit()) != null) {
            reference.add(new StringRefAddr(KEY_SEND_EXIT, string));
        }
        if ((string = this.getSendExitInit()) != null) {
            reference.add(new StringRefAddr(KEY_SEND_EXIT_INIT, string));
        }
        reference.add(new StringRefAddr(KEY_SYNCPOINT_ALL_GETS, String.valueOf(this.getSyncpointAllGets())));
        reference.add(new StringRefAddr(KEY_USE_CONN_POOLING, String.valueOf(this.getUseConnectionPooling())));
        reference.add(new StringRefAddr(KEY_POLLING_INTERVAL, String.valueOf(this.getPollingInterval())));
        reference.add(new StringRefAddr(KEY_MSG_BATCH_SIZE, String.valueOf(this.getMsgBatchSize())));
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void setFromReference(Reference reference) throws JMSException {
        try {
            block24: {
                try {
                    RefAddr refAddr;
                    if (Trace.isOn) {
                        Trace.entry(this, "setFromReference");
                    }
                    if ((refAddr = reference.get(KEY_VERSION)) != null) {
                        int n = Integer.parseInt((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_DESCRIPTION)) != null) {
                        this.setDescription((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_TRANSPORT_TYPE)) != null) {
                        this.setTransportType(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_CLIENT_ID)) != null) {
                        this.setClientId((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_QUEUE_MANAGER)) != null) {
                        void var3_6;
                        String string = (String)refAddr.getContent();
                        if (string == null) {
                            String string2 = "";
                        }
                        this.setQueueManager((String)var3_6);
                    }
                    if ((refAddr = reference.get(KEY_HOST_NAME)) != null) {
                        this.setHostName((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_PORT)) != null) {
                        this.setPort(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_CHANNEL)) != null) {
                        this.setChannel((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_CCSID)) != null) {
                        this.setCCSID(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_RECEIVE_EXIT)) != null) {
                        this.setReceiveExit((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_RECEIVE_EXIT_INIT)) != null) {
                        this.setReceiveExitInit((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_SECURITY_EXIT)) != null) {
                        this.setSecurityExit((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_SECURITY_EXIT_INIT)) != null) {
                        this.setSecurityExitInit((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_SEND_EXIT)) != null) {
                        this.setSendExit((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_SEND_EXIT_INIT)) != null) {
                        this.setSendExitInit((String)refAddr.getContent());
                    }
                    if ((refAddr = reference.get(KEY_SYNCPOINT_ALL_GETS)) != null) {
                        boolean bl = Boolean.valueOf((String)refAddr.getContent());
                        this.setSyncpointAllGets(bl);
                    }
                    if ((refAddr = reference.get(KEY_USE_CONN_POOLING)) != null) {
                        boolean bl = Boolean.valueOf((String)refAddr.getContent());
                        this.setUseConnectionPooling(bl);
                    }
                    if ((refAddr = reference.get(KEY_POLLING_INTERVAL)) != null) {
                        this.setPollingInterval(Integer.parseInt((String)refAddr.getContent()));
                    }
                    if ((refAddr = reference.get(KEY_MSG_BATCH_SIZE)) == null) break block24;
                    this.setMsgBatchSize(Integer.parseInt((String)refAddr.getContent()));
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                    Exception exception = jMSException.getLinkedException();
                    if (exception == null) throw jMSException;
                    Trace.trace(this, "linked exception " + exception);
                    throw jMSException;
                }
            }
            Object var6_10 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "setFromReference");
            return;
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setFromReference");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static boolean twoStringsEqual(String string, String string2) {
        boolean bl;
        block7: {
            boolean bl2;
            block6: {
                boolean bl3;
                block5: {
                    try {
                        if (Trace.isOn) {
                            Trace.entry(CLASSNAME, "twoStringsEqual");
                        }
                        if (string == null && string2 == null) {
                            bl3 = true;
                            Object var4_5 = null;
                            if (!Trace.isOn) return bl3;
                            break block5;
                        }
                        if (string == null || string2 == null) {
                            bl2 = false;
                            break block6;
                        }
                        bl = string.equals(string2);
                        break block7;
                    }
                    catch (Throwable throwable) {
                        Object var4_8 = null;
                        if (!Trace.isOn) throw throwable;
                        Trace.exit(CLASSNAME, "twoStringsEqual");
                        throw throwable;
                    }
                }
                Trace.exit(CLASSNAME, "twoStringsEqual");
                return bl3;
            }
            Object var4_6 = null;
            if (!Trace.isOn) return bl2;
            Trace.exit(CLASSNAME, "twoStringsEqual");
            return bl2;
        }
        Object var4_7 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(CLASSNAME, "twoStringsEqual");
        return bl;
    }
}

