/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.matching.SyntaxException;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQDestination;
import com.ibm.mq.jms.MQMessageReference;
import com.ibm.mq.jms.MQMessageSelector;
import com.ibm.mq.jms.MQQueue;
import com.ibm.mq.jms.MQQueueAgent;
import com.ibm.mq.jms.MQQueueConnection;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTemporaryTopic;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.SubscriptionHelper;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import java.util.Vector;
import javax.jms.ConnectionConsumer;
import javax.jms.InvalidSelectorException;
import javax.jms.JMSException;
import javax.jms.ServerSession;
import javax.jms.ServerSessionPool;
import javax.jms.Session;

class MQConnectionConsumer
implements ConnectionConsumer {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2000, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQConnectionConsumer.java, jms, j521, j521-L020126 02/01/25 15:23:51 @(#) 1.30.1.1";
    private MQConnection connection;
    private String mqQueueName;
    private MQMessageSelector msgSelector;
    private ServerSessionPool sessionPool;
    private int maxMessages;
    private Vector messages;
    private MQQueueAgent agent;
    private boolean qAgentActive = false;
    private Object qaLock = new Object();
    boolean receiving;
    private JMSException jmsException;
    private boolean pubSub = false;
    private boolean isDurable = false;
    private byte[] correlId = null;
    private boolean correlIdAsIdentity = true;
    private MQTemporaryTopic tempTopic = null;
    private MQSubscription mqsub = null;

    MQConnectionConsumer(MQConnection mQConnection, MQDestination mQDestination, String string, ServerSessionPool serverSessionPool, int n) throws JMSException {
        this(mQConnection, mQDestination, string, serverSessionPool, n, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    MQConnectionConsumer(MQConnection mQConnection, MQDestination mQDestination, String string, ServerSessionPool serverSessionPool, int n, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        try {
            if (!(mQConnection instanceof MQQueueConnection && mQDestination instanceof MQQueue || mQConnection instanceof MQTopicConnection && mQDestination instanceof MQTopic)) {
                throw ConfigEnvironment.newException("MQJMS1077");
            }
            if (string != null && !string.equals("")) {
                if (Trace.isOn) {
                    Trace.trace(this, "Selector: " + string);
                }
                this.msgSelector = new MQMessageSelector();
                try {
                    this.msgSelector.setSelector(string);
                }
                catch (SyntaxException syntaxException) {
                    String string3 = "MQJMS0004";
                    String string4 = ConfigEnvironment.getErrorMessage(string3);
                    InvalidSelectorException invalidSelectorException = new InvalidSelectorException(string4, string3);
                    invalidSelectorException.setLinkedException((Exception)syntaxException);
                    throw invalidSelectorException;
                }
            }
            if (serverSessionPool == null) {
                throw ConfigEnvironment.newException("MQJMS1084");
            }
            if (n <= 0) {
                throw ConfigEnvironment.newException("MQJMS1083");
            }
        }
        catch (JMSException jMSException) {
            if (!Trace.isOn) throw jMSException;
            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
            Trace.exit(this, "constructor (via exception)");
            throw jMSException;
        }
        try {
            try {
                this.connection = mQConnection;
                this.sessionPool = serverSessionPool;
                this.maxMessages = n;
                this.messages = new Vector(n);
                if (mQDestination instanceof MQTopic) {
                    this.mqQueueName = this.pubSubSetup((MQTopic)mQDestination, string, string2);
                    if (Trace.isOn) {
                        Trace.trace(this, "Topic-based consumer using queue '" + this.mqQueueName + "'");
                    }
                } else {
                    this.mqQueueName = ((MQQueue)mQDestination).getBaseQueueName();
                    this.correlIdAsIdentity = false;
                    if (Trace.isOn) {
                        Trace.trace(this, "Queue-based consumer using queue '" + this.mqQueueName + "'");
                    }
                }
                this.agent = MQQueueAgent.getQueueAgent(this.connection, this.mqQueueName, this.correlIdAsIdentity);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var12_13 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor");
            throw throwable;
        }
        Trace.exit(this, "constructor");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String pubSubSetup(MQTopic mQTopic, String string, String string2) throws JMSException {
        Object object;
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "pubSubSetup");
                }
                this.pubSub = true;
                boolean bl = true;
                String string3 = mQTopic.getBaseTopicName();
                MQTopicConnection mQTopicConnection = (MQTopicConnection)this.connection;
                MQSubscriptionEngine mQSubscriptionEngine = mQTopicConnection.getSubscriptionEngine();
                String string4 = null;
                if (string2 == null) {
                    string4 = SubscriptionHelper.validateQueueName(mQTopicConnection.getBrkCCSubQueue(), 0);
                    if (Trace.isOn) {
                        Trace.trace(this, "Non-durable Consumer on '" + string4 + "'");
                    }
                } else {
                    string4 = SubscriptionHelper.validateQueueName(mQTopic.getBrokerCCDurSubQueue(), 1);
                    if (Trace.isOn) {
                        Trace.trace(this, "Durable Consumer on '" + string4 + "'");
                    }
                }
                if (string4.endsWith("*")) {
                    bl = false;
                    this.correlIdAsIdentity = false;
                } else {
                    bl = true;
                    this.correlIdAsIdentity = true;
                }
                if (mQTopic instanceof MQTemporaryTopic) {
                    this.tempTopic = (MQTemporaryTopic)mQTopic;
                    this.tempTopic.usageUp();
                }
                if (string2 == null) {
                    this.isDurable = false;
                    object = ((MQTopicConnection)this.connection).getCCBrokerSession();
                    this.mqsub = mQSubscriptionEngine.openSubscription((MQTopicSession)object, mQTopic, string, false, bl, string4);
                } else {
                    this.isDurable = true;
                    object = ((MQTopicConnection)this.connection).getCCBrokerSession();
                    this.mqsub = mQSubscriptionEngine.openDurableSubscription((MQTopicSession)object, mQTopic, string, false, bl, string4, string2);
                }
                if (Trace.isOn) {
                    Trace.trace(this, "Topic-based consumer using queue '" + this.mqsub.getQueueName() + "'");
                    Trace.trace(this, "This queue is" + (!bl ? " NOT" : "") + " SHARED");
                    Trace.trace(this, "CorrelId '" + Utils.bytesToHex(this.mqsub.getCorrelationId()) + "'");
                    Trace.trace(this, "The subscription is " + (!this.isDurable ? "NON-" : "") + "DURABLE");
                }
                object = this.mqsub.getQueueName();
                Object var11_12 = null;
                if (!Trace.isOn) return object;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "pubSubSetup throwing: " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "Linked exception: " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "pubSubSetup");
            throw throwable;
        }
        Trace.exit(this, "pubSubSetup");
        return object;
    }

    public ServerSessionPool getServerSessionPool() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getServerSessionPool");
        }
        ServerSessionPool serverSessionPool = this.sessionPool;
        if (Trace.isOn) {
            Trace.exit(this, "getServerSessionPool");
        }
        return serverSessionPool;
    }

    public void close() throws JMSException {
        JMSException jMSException = null;
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        try {
            this.checkException();
            this.deliverNow();
        }
        catch (JMSException jMSException2) {
            Trace.trace(this, "ConnectionConsumer produced exception:");
            Trace.exception(this, "close", (Throwable)jMSException2);
            jMSException = jMSException2;
        }
        this.deactivateQueueAgent();
        this.connection.removeConsumer(this);
        try {
            if (this.agent != null) {
                this.agent.removeConsumer(this);
            }
        }
        catch (JMSException jMSException3) {
            if (Trace.isOn) {
                Trace.trace(this, "MQQueueAgentThread produced exception:");
                Trace.exception(this, "close", (Throwable)jMSException3);
                if (jMSException != null && Trace.isOn) {
                    Trace.trace(this, "Ignoring exception from ConnectionConsumer");
                }
            }
            jMSException = jMSException3;
        }
        if (this.pubSub) {
            this.mqsub.close();
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
        if (jMSException != null) {
            throw jMSException;
        }
    }

    void start() {
        if (Trace.isOn) {
            Trace.entry(this, "start");
        }
        this.jmsException = null;
        if (this.connection instanceof MQQueueConnection && ((MQQueueConnection)this.connection).getMessageRetention() == 1 || this.connection instanceof MQTopicConnection && this.isDurable) {
            this.agent.addConsumer(this, true);
        } else {
            this.agent.addConsumer(this, false);
        }
        if (Trace.isOn) {
            Trace.exit(this, "start");
        }
    }

    void activateQueueAgent() throws JMSException {
        boolean bl = false;
        Object object = this.qaLock;
        synchronized (object) {
            if (!this.qAgentActive) {
                bl = true;
                this.qAgentActive = true;
            }
        }
        if (bl) {
            this.agent.activate(this.connection);
        }
    }

    void deactivateQueueAgent() throws JMSException {
        boolean bl = false;
        Object object = this.qaLock;
        synchronized (object) {
            if (this.qAgentActive) {
                bl = true;
                this.qAgentActive = false;
            }
        }
        if (bl) {
            this.agent.deactivate();
        }
    }

    void stop() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "stop");
        }
        this.agent.removeConsumer(this);
        this.checkException();
        this.deliverNow();
        if (Trace.isOn) {
            Trace.exit(this, "stop");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    boolean deliver(MQMessageReference mQMessageReference) throws JMSException {
        boolean bl = false;
        if (Trace.isOn) {
            Trace.entry(this, "deliver");
        }
        try {
            block7: {
                try {
                    int n;
                    if (this.msgSelector != null && !mQMessageReference.matches(this.msgSelector)) break block7;
                    bl = true;
                    MQConnectionConsumer mQConnectionConsumer = this;
                    synchronized (mQConnectionConsumer) {
                        this.messages.addElement(mQMessageReference);
                        n = this.messages.size();
                    }
                    mQMessageReference.setStatus(1);
                    if (n < this.maxMessages) break block7;
                    this.deliverNow();
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var7_6 = null;
            if (!Trace.isOn) return bl;
            Trace.exit(this, "deliver");
            return bl;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "deliver");
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void deliverNow() throws JMSException {
        try {
            int n;
            if (Trace.isOn) {
                Trace.entry(this, "deliverNow");
            }
            MQConnectionConsumer mQConnectionConsumer = this;
            synchronized (mQConnectionConsumer) {
                n = this.messages.size();
            }
            if (n > 0) {
                ServerSession serverSession = null;
                Session session = null;
                try {
                    serverSession = this.sessionPool.getServerSession();
                    if (serverSession != null) {
                        session = serverSession.getSession();
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
                MQSession mQSession = null;
                if (session == null || !(session instanceof MQSession)) {
                    if (!Trace.isOn) throw ConfigEnvironment.newException("MQJMS1078");
                    Trace.trace(this, "Alien session from pool");
                    throw ConfigEnvironment.newException("MQJMS1078");
                }
                mQSession = (MQSession)session;
                if (serverSession != null && mQSession != null) {
                    Vector vector = null;
                    MQConnectionConsumer mQConnectionConsumer2 = this;
                    synchronized (mQConnectionConsumer2) {
                        vector = this.messages;
                        this.messages = new Vector(this.maxMessages);
                    }
                    try {
                        if (vector.size() > 0) {
                            mQSession.deliver(this.mqQueueName, vector);
                            serverSession.start();
                        }
                    }
                    catch (JMSException jMSException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        }
                        Enumeration enumeration = vector.elements();
                        MQConnectionConsumer mQConnectionConsumer3 = this;
                        synchronized (mQConnectionConsumer3) {
                            while (enumeration.hasMoreElements()) {
                                MQMessageReference mQMessageReference = (MQMessageReference)enumeration.nextElement();
                                mQMessageReference.setStatus(1);
                                this.messages.addElement(mQMessageReference);
                            }
                            throw jMSException;
                        }
                    }
                }
            }
            Object var14_17 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var14_18 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "deliverNow");
            throw throwable;
        }
        Trace.exit(this, "deliverNow");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
    }

    MQConnection getConnection() {
        return this.connection;
    }

    void setException(JMSException jMSException) {
        if (Trace.isOn) {
            Trace.entry(this, "setException");
        }
        this.jmsException = jMSException;
        if (Trace.isOn) {
            Trace.exit(this, "setException");
        }
    }

    JMSException getException() {
        return this.jmsException;
    }

    boolean isPubSub() {
        return this.pubSub;
    }

    byte[] getCorrelId() {
        if (this.mqsub != null) {
            return this.mqsub.getCorrelationId();
        }
        return null;
    }

    private void checkException() throws JMSException {
        if (this.jmsException != null) {
            if (Trace.isOn) {
                Trace.trace(this, "Throwing " + (Object)((Object)this.jmsException));
            }
            throw this.jmsException;
        }
    }
}

