/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.MQException;
import com.ibm.mq.MQPoolToken;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.IntErrorException;
import com.ibm.mq.jms.MQConnectionConsumer;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MQSession;
import com.ibm.mq.jms.SessionClosedException;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Logger;
import com.ibm.mq.jms.services.Trace;
import com.ibm.mq.jms.services.psk.LogException;
import com.ibm.mq.jms.services.psk.LogMessage;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.JMSSecurityException;

public abstract class MQConnection
implements Connection {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQConnection.java, jms, j521, j521-L020516 02/05/15 11:09:36 @(#) 1.50.1.6";
    private static final int STATE_STOPPED = 0;
    private static final int STATE_STARTED = 1;
    private static final int STATE_CLOSED = 2;
    protected static final Object XAGROUP = new Object();
    protected static final Object NON_XAGROUP = new Object();
    protected String qmgrName;
    protected Hashtable mqProperties = new Hashtable();
    private boolean clientIDFixed = false;
    private String clientID = null;
    private int state = 0;
    private Vector sessions = new Vector();
    private Vector consumers = new Vector();
    private ExceptionListener eListener = null;
    private boolean syncpointAllGets;
    private MQPoolToken poolToken = null;
    private int pollingInterval;
    private int msgBatchSize;
    private boolean persistenceFromMD;

    MQConnection(MQConnectionFactory mQConnectionFactory) {
        Trace.checkForTurnTracingOn();
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
            Trace.exit(this, "constructor");
        }
        MQException.log = null;
        if (mQConnectionFactory.getUseConnectionPooling()) {
            this.poolToken = MQEnvironment.addConnectionPoolToken();
        }
        this.syncpointAllGets = mQConnectionFactory.getSyncpointAllGets();
        this.msgBatchSize = mQConnectionFactory.getMsgBatchSize();
        this.pollingInterval = mQConnectionFactory.getPollingInterval();
        this.persistenceFromMD = false;
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.jms.tuning.usePersistenceFromMD");
                }
                catch (AccessControlException accessControlException) {
                    return null;
                }
            }
        });
        if (string != null) {
            if (string.equalsIgnoreCase("ON")) {
                this.persistenceFromMD = true;
            } else if (string.equalsIgnoreCase("OFF")) {
                this.persistenceFromMD = false;
            }
            if (Trace.isOn()) {
                Trace.trace(this, "persistenceFromMD = " + this.persistenceFromMD);
            }
        } else {
            Trace.trace(this, "cannot read tuning parameter system properties");
        }
    }

    public void finalize() throws Throwable {
        if (Trace.isOn) {
            Trace.entry(this, "finalize");
        }
        try {
            this.close();
        }
        catch (JMSException jMSException) {
            // empty catch block
        }
        super.finalize();
        if (Trace.isOn) {
            Trace.exit(this, "finalize");
        }
    }

    public String getClientID() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getClientID");
            Trace.trace(this, "returning clientID='" + this.clientID + "'");
            Trace.exit(this, "getClientID");
        }
        this.checkConnectionOpen();
        return this.clientID;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setClientID(String string) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "setClientID");
                    Trace.trace(this, "Attempting setClientID( " + string + " )");
                }
                if (this.clientIDFixed) {
                    String string2 = ConfigEnvironment.getErrorMessage("MQJMS3031");
                    throw new IllegalStateException(string2);
                }
                if (string == null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS0002");
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "setClientID(null) is not allowed!");
                    throw jMSException;
                }
                if (this.clientID != null) {
                    if (Trace.isOn) {
                        Trace.trace(this, "clientID was already set to '" + this.clientID + "'");
                    }
                    String string3 = ConfigEnvironment.getErrorMessage("MQJMS3032");
                    throw new IllegalStateException(string3);
                }
                this.clientID = string;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setClientID");
            throw throwable;
        }
        Trace.exit(this, "setClientID");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void start() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "start");
                }
                if (this.state == 2) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                if (this.state != 1) {
                    if (this.state == 0) {
                        this.state = 1;
                        this.notifyConsumers();
                        this.notifySessions();
                        this.setClientIDFixed();
                    } else {
                        try {
                            Logger.log(new LogMessage(2, "MQJMS1005", String.valueOf(this.state), "STATE_STARTED"));
                        }
                        catch (LogException logException) {
                            System.err.println("failed to log error because of " + logException);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STARTED");
                        throw jMSException;
                    }
                }
                Object var5_7 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "start throwing" + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "start");
            throw throwable;
        }
        Trace.exit(this, "start");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void stop() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "stop");
                }
                if (this.state == 2) {
                    String string = "MQJMS1004";
                    String string2 = ConfigEnvironment.getErrorMessage(string);
                    throw new IllegalStateException(string2, string);
                }
                if (this.state == 1) {
                    this.state = 0;
                    this.notifyConsumers();
                    this.notifySessions();
                    this.setClientIDFixed();
                } else if (this.state != 0) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1005", String.valueOf(this.state), "STATE_STOPPED"));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_STOPPED");
                    throw jMSException;
                }
                Object var5_7 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "stop throwing " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "stop");
            throw throwable;
        }
        Trace.exit(this, "stop");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized void close() throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "close");
                }
                if (this.state == 1 || this.state == 0) {
                    this.state = 2;
                    if (this.poolToken != null) {
                        MQEnvironment.removeConnectionPoolToken((MQPoolToken)this.poolToken);
                    }
                    this.notifyConsumers();
                    this.notifySessions();
                    this.setClientIDFixed();
                } else if (this.state != 2) {
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1005", String.valueOf(this.state), "STATE_CLOSED"));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1005", String.valueOf(this.state), "STATE_CLOSED");
                    throw jMSException;
                }
                Object var3_4 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var3_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "close");
            throw throwable;
        }
        Trace.exit(this, "close");
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setExceptionListener");
        }
        this.checkConnectionOpen();
        this.eListener = exceptionListener;
        this.setClientIDFixed();
        if (Trace.isOn) {
            Trace.exit(this, "setExceptionListener");
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "getExceptionListener");
            Trace.exit(this, "getExceptionListener");
        }
        this.checkConnectionOpen();
        return this.eListener;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ConnectionMetaData getMetaData() throws JMSException {
        MQConnectionMetaData mQConnectionMetaData;
        try {
            MQConnectionMetaData mQConnectionMetaData2;
            if (Trace.isOn) {
                Trace.entry(this, "getMetaData");
            }
            this.checkConnectionOpen();
            mQConnectionMetaData = mQConnectionMetaData2 = new MQConnectionMetaData(0);
            Object var4_3 = null;
            if (!Trace.isOn) return mQConnectionMetaData;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getMetaData");
            throw throwable;
        }
        Trace.exit(this, "getMetaData");
        return mQConnectionMetaData;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isStarted() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isStarted");
            }
            bl = this.state == 1;
            Object var3_2 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isStarted");
            throw throwable;
        }
        Trace.exit(this, "isStarted");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    boolean isClosed() {
        boolean bl;
        try {
            if (Trace.isOn) {
                Trace.entry(this, "isClosed");
            }
            bl = this.state == 2;
            Object var3_2 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isClosed");
            throw throwable;
        }
        Trace.exit(this, "isClosed");
        return bl;
    }

    void addSession(MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "addSession");
        }
        this.sessions.addElement(mQSession);
        if (Trace.isOn) {
            Trace.exit(this, "addSession");
        }
    }

    void removeSession(MQSession mQSession) {
        if (Trace.isOn) {
            Trace.entry(this, "removeSession");
        }
        boolean bl = this.sessions.removeElement(mQSession);
        if (Trace.isOn) {
            if (bl) {
                Trace.trace(this, "session removed from vector");
            } else {
                Trace.trace(this, "session was not found in vector");
            }
            Trace.exit(this, "removeSession");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void addConsumer(MQConnectionConsumer mQConnectionConsumer) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "addConsumer");
        }
        MQConnection mQConnection = this;
        synchronized (mQConnection) {
            try {
                try {
                    this.consumers.addElement(mQConnectionConsumer);
                    switch (this.state) {
                        case 1: {
                            mQConnectionConsumer.start();
                            mQConnectionConsumer.activateQueueAgent();
                            break;
                        }
                    }
                }
                catch (JMSException jMSException) {
                    this.consumers.removeElement(mQConnectionConsumer);
                    Trace.trace(this, "ConnectionConsumer start failed");
                    Trace.exception(this, "addConsumer", (Throwable)jMSException);
                    throw jMSException;
                }
                {
                }
                Object var5_3 = null;
                if (!Trace.isOn) return;
                Trace.exit(this, "addConsumer");
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                if (!Trace.isOn) throw throwable;
                Trace.exit(this, "addConsumer");
                throw throwable;
            }
            return;
        }
    }

    void removeConsumer(MQConnectionConsumer mQConnectionConsumer) {
        if (Trace.isOn) {
            Trace.entry(this, "removeConsumer");
        }
        boolean bl = this.consumers.removeElement(mQConnectionConsumer);
        if (Trace.isOn) {
            if (bl) {
                Trace.trace(this, "consumer removed from vector");
            } else {
                Trace.trace(this, "consumer was not found in vector");
            }
            Trace.exit(this, "removeConsumer");
        }
    }

    void deliverException(JMSException jMSException) {
        if (Trace.isOn) {
            Trace.entry(this, "deliverException");
        }
        if (this.eListener != null) {
            try {
                this.eListener.onException(jMSException);
            }
            catch (Throwable throwable) {
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "deliverException The following exception was thrown in deliverException: " + throwable.toString());
                    }
                    Logger.log(new LogMessage(2, "MQJMS1026", throwable.toString()));
                }
                catch (LogException logException) {
                    System.err.println("failed to log error because of " + logException);
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "deliverException");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void setClientIDFixed() {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "setClientIDFixed");
            }
            this.clientIDFixed = true;
            Object var2_1 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setClientIDFixed");
            throw throwable;
        }
        Trace.exit(this, "setClientIDFixed");
    }

    boolean getSyncpointAllGets() {
        return this.syncpointAllGets;
    }

    boolean getPersistenceFromMD() {
        return this.persistenceFromMD;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQQueueManager createQMXA() throws JMSException {
        MQQueueManager mQQueueManager;
        try {
            try {
                MQQueueManager mQQueueManager2;
                if (Trace.isOn) {
                    Trace.entry(this, "createQMXA");
                }
                Hashtable hashtable = this.mqProperties;
                synchronized (hashtable) {
                    this.mqProperties.put("Group", XAGROUP);
                    this.mqProperties.put("XAReq", new Boolean(true));
                    this.mqProperties.put("SPI", "SPI_ENABLE");
                    this.mqProperties.put("Use QM CCSID", new Boolean(true));
                    mQQueueManager2 = this.createQM();
                }
                mQQueueManager = mQQueueManager2;
                Object var5_6 = null;
                if (!Trace.isOn) return mQQueueManager;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQMXA");
            throw throwable;
        }
        Trace.exit(this, "createQMXA");
        return mQQueueManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    MQQueueManager createQMNonXA() throws JMSException {
        MQQueueManager mQQueueManager;
        try {
            try {
                MQQueueManager mQQueueManager2;
                if (Trace.isOn) {
                    Trace.entry(this, "createQMNonXA");
                }
                Hashtable hashtable = this.mqProperties;
                synchronized (hashtable) {
                    this.mqProperties.put("Group", NON_XAGROUP);
                    this.mqProperties.put("XAReq", new Boolean(false));
                    this.mqProperties.put("SPI", "SPI_ENABLE");
                    this.mqProperties.put("Use QM CCSID", new Boolean(true));
                    mQQueueManager2 = this.createQM();
                }
                mQQueueManager = mQQueueManager2;
                Object var5_6 = null;
                if (!Trace.isOn) return mQQueueManager;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "caught " + (Object)((Object)jMSException));
                Exception exception = jMSException.getLinkedException();
                if (exception == null) throw jMSException;
                Trace.trace(this, "linked exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQMNonXA");
            throw throwable;
        }
        Trace.exit(this, "createQMNonXA");
        return mQQueueManager;
    }

    int getMsgBatchSize() {
        return this.msgBatchSize;
    }

    int getPollingInterval() {
        return this.pollingInterval;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void notifySessions() throws JMSException, IntErrorException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "notifySessions");
                    Trace.trace(this, "notifying " + this.sessions.size() + " sessions for state " + this.state);
                }
                Vector vector = (Vector)this.sessions.clone();
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    MQSession mQSession = (MQSession)enumeration.nextElement();
                    try {
                        switch (this.state) {
                            case 0: {
                                mQSession.stop();
                                break;
                            }
                            case 1: {
                                mQSession.start();
                                break;
                            }
                            case 2: {
                                mQSession.close();
                                break;
                            }
                            default: {
                                String string = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                                try {
                                    Logger.log(new LogMessage(2, "MQJMS1016", string));
                                }
                                catch (LogException logException) {
                                    System.err.println("failed to log error because of " + logException);
                                }
                                String string2 = "MQJMS1016";
                                String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                                IntErrorException intErrorException = new IntErrorException(string3, string2);
                                throw intErrorException;
                            }
                        }
                    }
                    catch (SessionClosedException sessionClosedException) {
                        this.sessions.removeElement(mQSession);
                    }
                    catch (JMSException jMSException) {
                        throw jMSException;
                    }
                }
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.exception(this, "notifySessions", (Throwable)jMSException);
                }
                Object var9_13 = null;
                if (!Trace.isOn) return;
                Trace.exit(this, "notifySessions");
                return;
            }
            Object var9_12 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "notifySessions");
            return;
        }
        catch (Throwable throwable) {
            Object var9_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "notifySessions");
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void notifyConsumers() throws IntErrorException, JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "notifyConsumers");
                Trace.trace(this, "notifying " + this.consumers.size() + " consumers for state " + this.state);
            }
            switch (this.state) {
                case 0: {
                    MQConnectionConsumer mQConnectionConsumer;
                    Enumeration enumeration = this.consumers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                        try {
                            mQConnectionConsumer.deactivateQueueAgent();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from consumer.deactivateQueueAgent:");
                            Trace.exception(this, "notifyConsumers", (Throwable)jMSException);
                        }
                    }
                    enumeration = this.consumers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                        try {
                            mQConnectionConsumer.stop();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.trace(this, "ignoring following exception from consumer.stop:");
                            Trace.exception(this, "notifyConsumers", (Throwable)jMSException);
                        }
                    }
                    break;
                }
                case 1: {
                    MQConnectionConsumer mQConnectionConsumer;
                    Enumeration enumeration = this.consumers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                        mQConnectionConsumer.start();
                    }
                    enumeration = this.consumers.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                        mQConnectionConsumer.activateQueueAgent();
                    }
                    break;
                }
                case 2: {
                    MQConnectionConsumer mQConnectionConsumer;
                    Vector vector = (Vector)this.consumers.clone();
                    Enumeration enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                        try {
                            mQConnectionConsumer.deactivateQueueAgent();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.exception(this, "notifyConsumers", (Throwable)jMSException);
                        }
                    }
                    enumeration = vector.elements();
                    while (enumeration.hasMoreElements()) {
                        mQConnectionConsumer = (MQConnectionConsumer)enumeration.nextElement();
                        try {
                            mQConnectionConsumer.close();
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) continue;
                            Trace.exception(this, "notifyConsumers", (Throwable)jMSException);
                        }
                    }
                    break;
                }
                default: {
                    String string = ConfigEnvironment.getMessage("MQJMS1006", "state", String.valueOf(this.state));
                    try {
                        Logger.log(new LogMessage(2, "MQJMS1016", string));
                    }
                    catch (LogException logException) {
                        System.err.println("failed to log error because of " + logException);
                    }
                    String string2 = "MQJMS1016";
                    String string3 = ConfigEnvironment.getErrorMessage(string2, string);
                    IntErrorException intErrorException = new IntErrorException(string3, string2);
                    throw intErrorException;
                }
            }
            Object var8_19 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var8_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "notifyConsumers");
            throw throwable;
        }
        Trace.exit(this, "notifyConsumers");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQQueueManager createQM() throws JMSException {
        Object object;
        try {
            try {
                MQSPIQueueManager mQSPIQueueManager;
                Object object2;
                String string;
                String string2;
                if (Trace.isOn) {
                    Trace.entry(this, "createQM");
                    Trace.trace(this, "qmgrName = '" + this.qmgrName + "'");
                    if (this.mqProperties != null) {
                        Trace.trace(this, "mqProperties:");
                        object = this.mqProperties.keys();
                        while (object.hasMoreElements()) {
                            string2 = (String)object.nextElement();
                            string = this.mqProperties.get(string2);
                            object2 = string.toString();
                            Trace.trace(this, string2 + " = '" + (String)object2 + "'");
                        }
                    } else {
                        Trace.trace(this, "mqProperties = null");
                    }
                }
                try {
                    mQSPIQueueManager = new MQSPIQueueManager(this.qmgrName, this.mqProperties);
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "createQM failed because of " + (Object)((Object)mQException));
                    }
                    switch (mQException.reasonCode) {
                        case 2035: {
                            string2 = "MQJMS2013";
                            string = ConfigEnvironment.getErrorMessage(string2);
                            object2 = new JMSSecurityException(string, string2);
                            object2.setLinkedException((Exception)((Object)mQException));
                            throw object2;
                        }
                        case 2063: {
                            String string3 = "MQJMS2013";
                            String string4 = ConfigEnvironment.getErrorMessage(string3);
                            JMSSecurityException jMSSecurityException = new JMSSecurityException(string4, string3);
                            jMSSecurityException.setLinkedException((Exception)((Object)mQException));
                            throw jMSSecurityException;
                        }
                        case 2012: {
                            Object v = this.mqProperties.get("XAReq");
                            boolean bl = false;
                            if (v != null && v instanceof Boolean) {
                                bl = (Boolean)v;
                            }
                            if (!bl) break;
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS2014");
                            jMSException.setLinkedException((Exception)((Object)mQException));
                            throw jMSException;
                        }
                    }
                    String string5 = null;
                    String string6 = (String)this.mqProperties.get("transport");
                    String string7 = (String)this.mqProperties.get("hostname");
                    string5 = string6 != null && string6.equals("MQSeries") ? (string7 != null ? "'" + string7 + ":" + this.qmgrName + "'" : "'<null>:" + this.qmgrName + "'") : "'" + this.qmgrName + "'";
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", string5);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                object = mQSPIQueueManager;
                Object var16_18 = null;
                if (!Trace.isOn) return object;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var16_19 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "createQM");
            throw throwable;
        }
        Trace.exit(this, "createQM");
        return object;
    }

    void checkConnectionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkConnectionOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS1004";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Connection is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkConnectionOpen");
        }
    }

    static {
        try {
            Class.forName("com.ibm.mq.jms.services.ConfigEnvironment");
        }
        catch (ClassNotFoundException classNotFoundException) {
            System.err.println("ERROR: couldn't load ConfigEnvironment class");
        }
    }
}

