/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.services.Trace;
import java.util.Hashtable;
import javax.jms.JMSException;

public class MQBrokerSubscriptionList {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQBrokerSubscriptionList.java, jms, j521, j521-L020202 02/02/01 12:46:44 @(#) 1.1";
    private static String CLSNAME = "MQBrokerSubscriptionList";
    private static Hashtable openSubscriptions;

    public MQBrokerSubscriptionList() {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "constructor");
        }
        if (openSubscriptions == null) {
            if (Trace.isOn) {
                Trace.trace(CLSNAME, "creating new Hashtable");
            }
            openSubscriptions = new Hashtable();
        }
        if (Trace.isOn) {
            Trace.exit(CLSNAME, "constructor");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized boolean getSubscription(String string, MQTopicSession mQTopicSession) throws JMSException {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "getSubscription");
        }
        try {
            try {
                if (openSubscriptions.containsKey(string)) {
                    JMSException jMSException = new JMSException("MQJMS3023");
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(CLSNAME, "subscription " + string + " already in use");
                    Trace.exception(CLSNAME, "getSubscription", (Throwable)jMSException);
                    throw jMSException;
                }
                openSubscriptions.put(string, mQTopicSession);
                bl = true;
                Object var5_6 = null;
                if (!Trace.isOn) return bl;
            }
            catch (Exception exception) {
                if (!Trace.isOn) throw (JMSException)((Object)exception);
                Trace.exception(CLSNAME, "getSubscription", (Throwable)exception);
                throw (JMSException)((Object)exception);
            }
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "getSubscription");
            throw throwable;
        }
        Trace.exit(CLSNAME, "getSubscription");
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized boolean removeSubscription(String string) throws JMSException {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeSubscription");
            Trace.trace(CLSNAME, "removing subscription '" + string + "'");
        }
        try {
            if (!openSubscriptions.containsKey(string)) {
                JMSException jMSException = new JMSException("invalid Subscription name");
                if (!Trace.isOn) throw jMSException;
                Trace.exception(CLSNAME, "removeSubscription", (Throwable)jMSException);
                throw jMSException;
            }
            openSubscriptions.remove(string);
            bl = true;
            Object var4_4 = null;
            if (!Trace.isOn) return bl;
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "removeSubscription");
            throw throwable;
        }
        Trace.exit(CLSNAME, "removeSubscription");
        return bl;
    }
}

