/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMessage;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQSPIQueue;
import com.ibm.mq.MQSPIQueueManager;
import com.ibm.mq.jms.BrokerCommandFailedException;
import com.ibm.mq.jms.BrokerConnectionInfo;
import com.ibm.mq.jms.Cleanup;
import com.ibm.mq.jms.CleanupHandle;
import com.ibm.mq.jms.JMSC;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQBrokerSubscription;
import com.ibm.mq.jms.MQBrokerSubscriptionList;
import com.ibm.mq.jms.MQSubscription;
import com.ibm.mq.jms.MQSubscriptionEngine;
import com.ibm.mq.jms.MQTopic;
import com.ibm.mq.jms.MQTopicConnection;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.MQTopicSession;
import com.ibm.mq.jms.NoBrokerResponseException;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.util.Hashtable;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;

class MQBrokerSubscriptionEngine
extends MQSubscriptionEngine {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQBrokerSubscriptionEngine.java, jms, j521, j521-L020626 02/06/25 13:01:11 @(#) 1.10.1.42";
    private int WSClone = 0;
    private static MQBrokerSubscriptionList localSubscriptions;
    private CleanupHandle cleanupHandle;
    private int SLEEPTIME = 3000;

    public MQBrokerSubscriptionEngine(MQTopicConnection mQTopicConnection, MQTopicConnectionFactory mQTopicConnectionFactory, String string) throws JMSException {
        super(mQTopicConnection);
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
        }
        this.WSClone = mQTopicConnectionFactory.getCloneSupport();
        if (localSubscriptions == null && this.WSClone == 1) {
            localSubscriptions = new MQBrokerSubscriptionList();
        }
        Hashtable hashtable = mQTopicConnection.mqProperties;
        this.cleanupHandle = CleanupHandle.createCleanupHandle(mQTopicConnectionFactory, string, hashtable);
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MQSubscription openSubscription(MQTopicSession mQTopicSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2) throws JMSException {
        MQBrokerSubscription mQBrokerSubscription = null;
        MQQueue mQQueue = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = this.escapeString(this.getMQTopicConnection().getClientID());
        String string4 = this.escapeString(string);
        int n = 65536;
        MQMsg2 mQMsg2 = new MQMsg2();
        MQBrokerMessage mQBrokerMessage = null;
        boolean bl3 = false;
        boolean bl4 = false;
        boolean bl5 = false;
        if (Trace.isOn) {
            Trace.entry(this, "openSubscription");
        }
        try {
            try {
                if (bl2) {
                    n |= 1;
                }
                mQBrokerSubscription = new MQBrokerSubscription(this, mQTopicSession, false, bl2, mQTopicSession.qm.name, string3, null, mQTopic.getBaseTopicName(), string, bl, string2, null, null);
                mQQueue = this.openSubscriberQueue(mQTopicSession, string2, bl2, false);
                mQBrokerSubscription.setSubscriberQueue(mQQueue);
                mQBrokerSubscription.setQueueName(mQQueue.name);
                try {
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions(true);
                    if (bl2) {
                        mQPutMessageOptions.options += 128;
                    }
                    byArray = this.setDeferredMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, mQPutMessageOptions);
                    byArray2 = mQMsg2.getMessageId();
                    if (Trace.isOn) {
                        Trace.trace(this, "Put deferred message, correID = '" + Utils.bytesToHex(byArray) + "'");
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "openSubscription", (Throwable)jMSException);
                    throw jMSException;
                }
                try {
                    mQMsg2 = new MQMsg2();
                    mQBrokerSubscription.setCorrelationId(byArray);
                    if (bl2) {
                        mQMsg2.setCorrelationId(byArray);
                        n |= 1;
                    }
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    this.sendBrokerMessage(mQBrokerSubscription, "RegSub", n, mQMsg2, null);
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.exception(this, "openSubscription", (Throwable)jMSException);
                    }
                    bl3 = false;
                    bl4 = true;
                    throw jMSException;
                }
                try {
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH1 Message from broker");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                        mQBrokerMessage = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH2 Message from broker");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                        mQBrokerMessage = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                    }
                    int n2 = 0;
                    String string5 = null;
                    JMSException jMSException = null;
                    switch (Integer.parseInt(mQBrokerMessage.get("MQPSCompCode"))) {
                        case 1: {
                            bl3 = true;
                            bl4 = true;
                            n2 = Integer.parseInt(mQBrokerMessage.get("MQPSReason"));
                            string5 = mQBrokerMessage.get("MQPSReasonText");
                            jMSException = new BrokerCommandFailedException("Broker command failed: " + string5 + " Reason code " + n2);
                            ((BrokerCommandFailedException)jMSException).setReason(n2);
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "openSubscription", (Throwable)jMSException);
                            throw jMSException;
                        }
                        case 2: {
                            bl3 = false;
                            bl4 = true;
                            n2 = Integer.parseInt(mQBrokerMessage.get("MQPSReason"));
                            string5 = mQBrokerMessage.get("MQPSReasonText");
                            BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string5 + " Reason code " + n2);
                            brokerCommandFailedException.setReason(n2);
                            if (Trace.isOn) {
                                Trace.exception(this, "openSubscription", (Throwable)((Object)brokerCommandFailedException));
                            }
                            if (n2 != 2035) throw brokerCommandFailedException;
                            throw brokerCommandFailedException;
                        }
                        case 0: {
                            if (Trace.isOn) {
                                Trace.trace(this, "non-durable RegSub command processed ok");
                            }
                            bl3 = false;
                            bl4 = false;
                            break;
                        }
                        default: {
                            bl3 = true;
                            bl4 = true;
                            if (Trace.isOn) {
                                Trace.trace(this, "unrecognized completion code: " + mQBrokerMessage.get("MQPSCompCode"));
                            }
                            jMSException = ConfigEnvironment.newException("MQJMS1087", "MQRCCF: " + mQBrokerMessage.get("MQPSCompCode"));
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "openSubscription", (Throwable)jMSException);
                            throw jMSException;
                        }
                    }
                }
                catch (NoBrokerResponseException noBrokerResponseException) {
                    bl3 = true;
                    bl4 = true;
                    throw noBrokerResponseException;
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "openSubscription", (Throwable)jMSException);
                    throw jMSException;
                }
                mQBrokerSubscription.setDeferredMsgId(byArray2);
            }
            catch (JMSException jMSException) {
                if (bl3) {
                    n = 1;
                    mQMsg2.clearMessageData();
                    this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
                }
                if (bl4) {
                    this.cancelDeferredMessage(mQTopicSession, byArray2);
                }
                if (mQQueue == null || !mQQueue.isOpen()) throw jMSException;
                try {
                    if (Trace.isOn) {
                        Trace.trace(this, "deleting subscription queue");
                    }
                    if (!bl2) {
                        mQQueue.closeOptions = 2;
                    }
                    mQQueue.close();
                    throw jMSException;
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "queue delete failed with " + (Object)((Object)mQException));
                    }
                    JMSException jMSException2 = ConfigEnvironment.newException("MQJMS2000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException2;
                }
            }
            Object var24_31 = null;
            if (!Trace.isOn) return mQBrokerSubscription;
        }
        catch (Throwable throwable) {
            Object var24_32 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "openSubscription");
            throw throwable;
        }
        Trace.exit(this, "openSubscription");
        return mQBrokerSubscription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeSubscription(MQSubscription mQSubscription) throws JMSException {
        block22: {
            block21: {
                int n = 0;
                MQMsg2 mQMsg2 = new MQMsg2();
                MQBrokerMessage mQBrokerMessage = null;
                MQQueue mQQueue = null;
                if (Trace.isOn) {
                    Trace.entry(this, "closeSubscription");
                }
                try {
                    try {
                        if (!(mQSubscription instanceof MQBrokerSubscription)) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3049");
                            throw jMSException;
                        }
                        MQBrokerSubscription mQBrokerSubscription = (MQBrokerSubscription)mQSubscription;
                        if (mQBrokerSubscription.isClosed() || mQBrokerSubscription.getMQTopicSession() == null) {
                            if (Trace.isOn) {
                                Trace.trace(this, "null or closed session. Subscription should already be closed. Returning");
                            }
                            Object var10_9 = null;
                            if (!Trace.isOn) return;
                            break block21;
                        }
                        mQQueue = mQBrokerSubscription.getSubscriberQueue();
                        n |= 0x10000;
                        mQMsg2.setMessageType(1);
                        mQMsg2.setReport(0);
                        if (mQBrokerSubscription.isSharedQueue()) {
                            ++n;
                            mQMsg2.setCorrelationId(mQBrokerSubscription.getCorrelationId());
                        }
                        try {
                            this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
                            if (mQBrokerSubscription.getMQTopicSession() == null && Trace.isOn) {
                                Trace.trace(this, "session is null");
                            }
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "Error sending BrokerMessage: ", (Throwable)jMSException);
                            throw jMSException;
                        }
                        try {
                            mQBrokerMessage = this.cleanupUnconsumedMessages(mQSubscription.getMQTopicSession(), mQSubscription.isSharedQueue(), mQSubscription.getQueueName(), mQSubscription.getCorrelationId(), mQMsg2);
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) throw jMSException;
                            Trace.trace(this, "exception thrown dealing with broker response and subscriber queue cleanup");
                            throw jMSException;
                        }
                        if (mQSubscription.isSharedQueue() && mQQueue != null && mQQueue.isOpen()) {
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "closing subscription queue");
                                }
                                mQQueue.close();
                            }
                            catch (MQException mQException) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "subscriber queue close failed with " + (Object)((Object)mQException));
                                }
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS2000");
                                jMSException.setLinkedException((Exception)((Object)mQException));
                                throw jMSException;
                            }
                        }
                        try {
                            this.cancelDeferredMessage(mQBrokerSubscription.getMQTopicSession(), mQBrokerSubscription.getDeferredMsgId());
                            break block22;
                        }
                        catch (JMSException jMSException) {
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "Error cancelling deferred MQPUT: ", (Throwable)jMSException);
                            throw jMSException;
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.exit(this, "closeSubscription - via exception");
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_11 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "closeSubscription");
                    throw throwable;
                }
            }
            Trace.exit(this, "closeSubscription");
            return;
        }
        Object var10_10 = null;
        if (!Trace.isOn) return;
        Trace.exit(this, "closeSubscription");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public MQSubscription openDurableSubscription(MQTopicSession mQTopicSession, MQTopic mQTopic, String string, boolean bl, boolean bl2, String string2, String string3) throws JMSException {
        MQBrokerSubscription mQBrokerSubscription;
        block162: {
            MQBrokerSubscription mQBrokerSubscription2;
            block161: {
                String string4 = null;
                String string5 = null;
                String string6 = null;
                String string7 = null;
                String string8 = null;
                String string9 = null;
                MQBrokerSubscription mQBrokerSubscription3 = null;
                MQBrokerSubscription mQBrokerSubscription4 = null;
                Object var16_16 = null;
                MQBrokerMessage mQBrokerMessage = null;
                MQBrokerMessage mQBrokerMessage2 = null;
                int n = 0;
                MQMsg2 mQMsg2 = null;
                byte[] byArray = null;
                byte[] byArray2 = null;
                byte[] byArray3 = null;
                boolean bl3 = false;
                boolean bl4 = false;
                boolean bl5 = false;
                boolean bl6 = false;
                boolean bl7 = false;
                String string10 = null;
                String string11 = null;
                String string12 = null;
                String string13 = null;
                String string14 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "openDurableSubscription");
                }
                try {
                    try {
                        mQBrokerSubscription3 = new MQBrokerSubscription(this, mQTopicSession, true, bl2, mQTopicSession.qm.name, this.getMQTopicConnection().getClientID(), string3, mQTopic.getBaseTopicName(), string, bl, string2, null, null);
                        string5 = this.escapeString(mQTopicSession.qm.name);
                        string6 = this.escapeString(this.getMQTopicConnection().getClientID());
                        string7 = this.escapeString(string3);
                        string4 = "JMS:" + string5 + ":" + string6 + ":" + string7;
                        if (Trace.isOn) {
                            Trace.trace(this, "Fullname = '" + string4 + "'");
                        }
                        if (string != null && !string.trim().equals("")) {
                            string8 = this.escapeString(string);
                            string9 = "sel=\"" + string8 + "\"";
                        } else {
                            string9 = "";
                        }
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "Setting deferred message");
                            }
                            try {
                                if (this.getMQTopicConnection().getBrkVersion() == 0) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Creating RFH1 Message");
                                    }
                                    mQBrokerMessage = new RFH1BrokerMessageImpl();
                                } else {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Creating RFH2 Message");
                                    }
                                    mQBrokerMessage = new RFH2BrokerMessageImpl();
                                }
                                mQBrokerMessage.set("MQPSCommand", "DeregSub");
                                mQBrokerMessage.set("MQPSTopic", mQTopic.getBaseTopicName());
                                mQBrokerMessage.setOption("MQPSRegOpts", "LeaveOnly");
                                mQBrokerMessage.setOption("MQPSRegOpts", "VariableUserId");
                                mQBrokerMessage.setOption("MQPSRegOpts", "FullResp");
                                if (bl2) {
                                    mQBrokerMessage.setOption("MQPSRegOpts", "CorrelAsId");
                                }
                                mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQTopicSession.getSessionName()));
                                mQBrokerMessage.set("MQPSSubName", string4);
                            }
                            catch (JMSException jMSException) {
                                if (!Trace.isOn) throw jMSException;
                                Trace.exception(this, "openDurableSubscription - setting deferred message", (Throwable)jMSException);
                                throw jMSException;
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "creating put message options");
                            }
                            MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions(true);
                            mQMsg2 = new MQMsg2();
                            mQMsg2.setMessageType(8);
                            if (bl2) {
                                mQPutMessageOptions.options += 128;
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "setting deferred message");
                            }
                            byArray = this.setDeferredMessage(mQTopicSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, true);
                            byArray3 = mQMsg2.getMessageId();
                            if (Trace.isOn) {
                                try {
                                    Trace.trace(this, "got correlID = '" + byArray.toString() + "'");
                                    Trace.dataTrace(1, this, byArray);
                                    Trace.trace(this, "got MessgID  = '" + byArray3.toString() + "'");
                                    Trace.dataTrace(1, this, byArray3);
                                }
                                catch (Exception exception) {}
                            }
                        }
                        catch (JMSException jMSException) {
                            if (Trace.isOn) {
                                Trace.exception(this, "error putting deferred message", (Throwable)jMSException);
                            }
                            bl4 = false;
                            bl5 = false;
                            throw jMSException;
                        }
                        if (this.WSClone == 1) {
                            try {
                                localSubscriptions.getSubscription(string4, mQTopicSession);
                                bl7 = true;
                            }
                            catch (JMSException jMSException) {
                                bl4 = true;
                                bl5 = false;
                                bl6 = true;
                                throw jMSException;
                            }
                        }
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "attempting exclusive register");
                            }
                            n = 360448;
                            if (bl2) {
                                ++n;
                            }
                            mQBrokerSubscription3.setCorrelationId(byArray);
                            mQMsg2 = new MQMsg2();
                            mQMsg2.setCorrelationId(byArray);
                            mQMsg2.setMessageType(1);
                            mQMsg2.setReport(0);
                            if (!bl2) {
                                mQBrokerSubscription3.setQueueName("SYSTEM.JMS.D.SUBSCRIBER.QUEUE");
                                n |= 0x20;
                            }
                            this.sendBrokerMessage(mQBrokerSubscription3, "RegSub", n, mQMsg2, null);
                        }
                        catch (JMSException jMSException) {
                            bl4 = true;
                            bl5 = false;
                            bl6 = true;
                            throw jMSException;
                        }
                        if (!bl2) {
                            if (Trace.isOn) {
                                Trace.trace(this, "using dynamic queues. Checking initial broker response");
                            }
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "getting broker response");
                                }
                                if (this.getMQTopicConnection().getBrkVersion() == 0) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Receiving RFH1 Message from broker");
                                    }
                                    mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                                } else {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Receiving RFH2 Message from broker");
                                    }
                                    mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                                }
                            }
                            catch (JMSException jMSException) {
                                if (jMSException instanceof NoBrokerResponseException) {
                                    bl4 = true;
                                    bl5 = true;
                                    bl6 = true;
                                    throw jMSException;
                                }
                                bl4 = true;
                                bl5 = false;
                                bl6 = false;
                                throw jMSException;
                            }
                            int n2 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                            String string15 = mQBrokerMessage2.get("MQPSReasonText");
                            if (n2 != 0 && (this.WSClone != 1 || n2 != 3155 && n2 != 3156)) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "exclusive register failed");
                                }
                                bl4 = true;
                                bl5 = false;
                                bl6 = false;
                                n2 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                                string15 = mQBrokerMessage2.get("MQPSReasonText");
                                BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string15 + " Reason code " + n2);
                                brokerCommandFailedException.setReason(n2);
                                if (!Trace.isOn) throw brokerCommandFailedException;
                                Trace.exception(this, "openDurableSubscription", (Throwable)((Object)brokerCommandFailedException));
                                throw brokerCommandFailedException;
                            }
                            string12 = mQBrokerMessage2.get("MQPSQName").trim();
                            if (Trace.isOn) {
                                Trace.trace(this, "register succeeded to queue: " + string12);
                            }
                            try {
                                if (Trace.isOn) {
                                    Trace.trace(this, "attempting second exclusive register");
                                }
                                n = 327680;
                                mQMsg2 = new MQMsg2();
                                mQMsg2.setCorrelationId(byArray);
                                mQMsg2.setMessageType(1);
                                mQMsg2.setReport(0);
                                if (string12.equals("SYSTEM.JMS.D.SUBSCRIBER.QUEUE")) {
                                    mQBrokerSubscription3.setSubscriberQueue(this.openSubscriberQueue(mQTopicSession, string2, false, true));
                                    mQBrokerSubscription3.setQueueName(mQBrokerSubscription3.getSubscriberQueue().name.trim());
                                    if (Trace.isOn) {
                                        Trace.trace(this, "poened new dynamic queue: " + mQBrokerSubscription3.getQueueName());
                                    }
                                    string2 = mQBrokerSubscription3.getQueueName();
                                } else {
                                    mQBrokerSubscription3.setQueueName(string12);
                                }
                                this.sendBrokerMessage(mQBrokerSubscription3, "RegSub", n, mQMsg2, null);
                            }
                            catch (JMSException jMSException) {
                                bl4 = true;
                                bl5 = false;
                                bl6 = true;
                                throw jMSException;
                            }
                        }
                        try {
                            if (Trace.isOn) {
                                Trace.trace(this, "getting broker response");
                            }
                            if (this.getMQTopicConnection().getBrkVersion() == 0) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Receiving RFH1 Message from broker");
                                }
                                mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                            } else {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Receiving RFH2 Message from broker");
                                }
                                mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                            }
                        }
                        catch (JMSException jMSException) {
                            if (jMSException instanceof NoBrokerResponseException) {
                                bl4 = true;
                                bl5 = true;
                                bl6 = true;
                                throw jMSException;
                            }
                            bl4 = true;
                            bl5 = false;
                            bl6 = false;
                            throw jMSException;
                        }
                        String string16 = mQBrokerMessage2.get("MQPSCorrelId");
                        if (string16 != null) {
                            byArray2 = Utils.hexToBytes(string16);
                        }
                        int n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                        String string17 = mQBrokerMessage2.get("MQPSReasonText");
                        if (Trace.isOn) {
                            Trace.trace(this, "got response from exclusive register");
                        }
                        switch (Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"))) {
                            case 1: {
                                if (Trace.isOn) {
                                    Trace.trace(this, "broker returned with warning");
                                }
                                bl4 = true;
                                bl5 = true;
                                bl6 = true;
                                if (n3 == 3157) {
                                    bl5 = false;
                                    bl4 = true;
                                } else {
                                    bl5 = true;
                                    bl4 = true;
                                }
                                bl6 = true;
                                BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string17 + " Reason code " + n3);
                                brokerCommandFailedException.setReason(n3);
                                if (!Trace.isOn) throw brokerCommandFailedException;
                                Trace.exception(this, "Broker command returned warning: ", (Throwable)((Object)brokerCommandFailedException));
                                throw brokerCommandFailedException;
                            }
                            case 2: {
                                if (Trace.isOn) {
                                    Trace.trace(this, "broker command failed");
                                }
                                if (this.WSClone == 1 && (n3 == 3155 || n3 == 3156)) {
                                    if (n3 == 3155) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "subscription already shared by another WebSphere clone");
                                        }
                                    } else {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "subscription exclusively locked. Hopefully, this will change soon");
                                        }
                                        try {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Zzzzzzzzz");
                                            }
                                            Thread.sleep(this.SLEEPTIME);
                                        }
                                        catch (InterruptedException interruptedException) {
                                            // empty catch block
                                        }
                                    }
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Subscription in use by another clone.Re-trying with join shared");
                                    }
                                    mQBrokerSubscription3.setCorrelationId(byArray2);
                                    n = 229376;
                                    if (bl2) {
                                        ++n;
                                    }
                                    mQMsg2 = new MQMsg2();
                                    mQMsg2.setCorrelationId(byArray);
                                    mQMsg2.setMessageType(1);
                                    mQMsg2.setReport(0);
                                    this.sendBrokerMessage(mQBrokerSubscription3, "RegSub", n, mQMsg2, null);
                                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Receiving RFH1 Message from broker");
                                        }
                                        mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                                    } else {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Receiving RFH2 Message from broker");
                                        }
                                        mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                                    }
                                    int n4 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
                                    if (n4 != 0) {
                                        JMSException jMSException = ConfigEnvironment.newException(mQBrokerMessage2.get("MQPSReasonText"));
                                        throw jMSException;
                                    }
                                    string10 = mQBrokerMessage2.get("MQPSSubName");
                                    string11 = mQBrokerMessage2.get("MQPSQMgrName").trim();
                                    string12 = mQBrokerMessage2.get("MQPSQName").trim();
                                    string13 = mQBrokerMessage2.get("MQPSSubUserData");
                                    if (string13 == null) {
                                        string13 = "";
                                    }
                                    string13 = string13.trim();
                                    string14 = mQBrokerMessage2.get("MQPSTopic").trim();
                                    byArray2 = Utils.hexToBytes(mQBrokerMessage2.get("MQPSCorrelId"));
                                    mQBrokerSubscription3.setCorrelationId(byArray2);
                                    if (Trace.isOn) {
                                        Trace.trace(this, "subscription we are trying to join is:\n");
                                        Trace.trace(this, string10);
                                        Trace.trace(this, "Topic:    " + string14);
                                        Trace.trace(this, "SubData:  " + string13);
                                        Trace.trace(this, "QMgr:     " + string11);
                                        Trace.trace(this, "Queue:    " + string12);
                                        Trace.trace(this, "CorrelId: " + Utils.bytesToHex(byArray2));
                                    }
                                    if (!(mQTopicSession.qm.name.equals(string11) && string2.equals(string12) && string9.equals(string13) && mQTopic.getBaseTopicName().equals(string14))) {
                                        JMSException jMSException = ConfigEnvironment.newException("Subscription in use");
                                        if (Trace.isOn) {
                                            Trace.trace(this, "subscription already in use by another clone and cannot beupdated");
                                        }
                                        bl4 = true;
                                        bl5 = true;
                                        bl6 = true;
                                        throw jMSException;
                                    }
                                    mQBrokerSubscription4 = mQBrokerSubscription3;
                                    if (mQBrokerSubscription4.getSubscriberQueue() == null) {
                                        mQBrokerSubscription4.setSubscriberQueue(this.openSubscriberQueue(mQTopicSession, string2, bl2, true));
                                    }
                                    mQBrokerSubscription4.setDeferredMsgId(byArray3);
                                    if (Trace.isOn) {
                                        Trace.trace(this, "got subscription with correlID '" + mQBrokerSubscription4.getCorrelationId().toString() + "'");
                                    }
                                    if (Trace.isOn) {
                                        Trace.dataTrace(1, this, mQBrokerSubscription4.getCorrelationId());
                                    }
                                    mQBrokerSubscription2 = mQBrokerSubscription4;
                                    Object var43_76 = null;
                                    if (!Trace.isOn) return mQBrokerSubscription2;
                                    break block161;
                                }
                                bl4 = true;
                                bl5 = false;
                                bl6 = false;
                                n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                                string17 = mQBrokerMessage2.get("MQPSReasonText");
                                BrokerCommandFailedException brokerCommandFailedException = new BrokerCommandFailedException("Broker command failed: " + string17 + " Reason code " + n3);
                                brokerCommandFailedException.setReason(n3);
                                if (!Trace.isOn) throw brokerCommandFailedException;
                                Trace.exception(this, "openDurableSubscription", (Throwable)((Object)brokerCommandFailedException));
                                throw brokerCommandFailedException;
                            }
                            case 0: {
                                if (!Trace.isOn) break;
                                Trace.trace(this, "got exclusive lock");
                                break;
                            }
                            default: {
                                bl4 = true;
                                bl5 = true;
                                bl6 = true;
                                if (Trace.isOn) {
                                    Trace.trace(this, "unrecognized completion code: " + mQBrokerMessage2.get("MQPSCompCode"));
                                }
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1087", "MQRCCF: " + mQBrokerMessage2.get("MQPSCompCode"));
                                if (!Trace.isOn) throw jMSException;
                                Trace.exception(this, "unrecognized response", (Throwable)jMSException);
                                throw jMSException;
                            }
                        }
                        mQBrokerSubscription3.setCorrelationId(byArray2);
                        if (Trace.isOn) {
                            try {
                                string10 = mQBrokerMessage2.get("MQPSSubName");
                            }
                            catch (Exception exception) {
                                Trace.trace(this, "Couldn't get subName: " + exception);
                            }
                            if (string10 == null) {
                                Trace.trace(this, "received null subName");
                            } else {
                                string10 = string10.trim();
                                Trace.trace(this, "got subName         = '" + string10 + "'");
                            }
                            Trace.trace(this, "wanted subName      = '" + string4 + "'");
                        }
                        string11 = mQBrokerMessage2.get("MQPSQMgrName").trim();
                        if (Trace.isOn) {
                            Trace.trace(this, "got QueueManager    = '" + string11 + "'");
                            Trace.trace(this, "wanted QueueManager = '" + string5 + "'");
                        }
                        string12 = mQBrokerMessage2.get("MQPSQName").trim();
                        if (Trace.isOn) {
                            Trace.trace(this, "got Queue           = '" + string12 + "'");
                            Trace.trace(this, "wanted Queue        = '" + string2 + "'");
                        }
                        if ((string13 = mQBrokerMessage2.get("MQPSSubUserData")) == null) {
                            string13 = "";
                        }
                        string13 = string13.trim();
                        if (Trace.isOn) {
                            Trace.trace(this, "got UserSubData      = '" + string13 + "'");
                            Trace.trace(this, "wanted UserSubData   = '" + string9 + "'");
                        }
                        string14 = mQBrokerMessage2.get("MQPSTopic").trim();
                        if (Trace.isOn) {
                            Trace.trace(this, "got Topic            = '" + string14 + "'");
                            Trace.trace(this, "wanted Topic         = '" + mQTopic.getBaseTopicName() + "'");
                        }
                        if (!mQTopicSession.qm.name.equals(string11) || !string2.equals(string12)) {
                            bl4 = true;
                            bl5 = true;
                            bl6 = true;
                            String string18 = new String(mQTopicSession.qm.name + ":" + string2);
                            String string19 = new String(string11 + ":" + string12);
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3022", string18, string19);
                            if (!Trace.isOn) throw jMSException;
                            Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                            throw jMSException;
                        }
                        if (!string9.equals(string13) || !mQTopic.getBaseTopicName().equals(string14)) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Subscription exists, but requires updating");
                            }
                            try {
                                mQBrokerSubscription4 = this.updateDurableSubscription(mQBrokerSubscription3, mQTopic.getBaseTopicName(), string, false);
                            }
                            catch (JMSException jMSException) {
                                bl4 = true;
                                bl5 = true;
                                bl6 = true;
                                throw jMSException;
                            }
                        } else if (mQBrokerMessage2.isOptionSet("MQPSRegOpts", 32)) {
                            if (Trace.isOn) {
                                Trace.trace(this, "subscription needs to recover from previous update error");
                            }
                            try {
                                mQBrokerSubscription4 = this.updateDurableSubscription(mQBrokerSubscription3, mQTopic.getBaseTopicName(), string, true);
                            }
                            catch (JMSException jMSException) {
                                bl4 = true;
                                bl5 = true;
                                bl6 = true;
                                throw jMSException;
                            }
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "subscription exists as requested.");
                            }
                            mQBrokerSubscription4 = mQBrokerSubscription3;
                        }
                        if (this.WSClone == 1) {
                            try {
                                n = 196608;
                                if (bl2) {
                                    ++n;
                                }
                                mQMsg2 = new MQMsg2();
                                mQMsg2.setCorrelationId(mQBrokerSubscription4.getCorrelationId());
                                mQMsg2.setMessageType(1);
                                mQMsg2.setReport(0);
                            }
                            catch (Exception exception) {
                                JMSException jMSException;
                                if (exception instanceof JMSException) {
                                    jMSException = (JMSException)((Object)exception);
                                } else {
                                    jMSException = ConfigEnvironment.newException(exception.getMessage());
                                    jMSException.setLinkedException(exception);
                                }
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "error building  MQMsg2");
                                Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                                throw jMSException;
                            }
                            try {
                                this.sendBrokerMessage(mQBrokerSubscription4, "RegSub", n, mQMsg2, null);
                            }
                            catch (JMSException jMSException) {
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "error sending migrate to shared subscription message to broker");
                                throw jMSException;
                            }
                            mQBrokerMessage2 = this.getMQTopicConnection().getBrkVersion() == 0 ? (RFH1BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true) : (RFH2BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, true);
                            int n5 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
                            if (n5 != 0) {
                                JMSException jMSException = ConfigEnvironment.newException(mQBrokerMessage2.get("MQPSReasonText"));
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "migrate to shared broker command failed" + mQBrokerMessage2.get("MQPSReasonText"));
                                throw jMSException;
                            }
                        }
                        if (mQBrokerSubscription4.getSubscriberQueue() == null) {
                            mQBrokerSubscription4.setSubscriberQueue(this.openSubscriberQueue(mQTopicSession, string2, bl2, true));
                        }
                        mQBrokerSubscription4.setDeferredMsgId(byArray3);
                        if (Trace.isOn) {
                            if (bl2) {
                                Trace.trace(this, "got subscription with correlID '" + mQBrokerSubscription4.getCorrelationId().toString() + "'");
                                Trace.dataTrace(1, this, mQBrokerSubscription4.getCorrelationId());
                            } else {
                                Trace.trace(this, "got dynamic queue subscrpition");
                            }
                        }
                        mQBrokerSubscription = mQBrokerSubscription4;
                        break block162;
                    }
                    catch (JMSException jMSException) {
                        block164: {
                            block163: {
                                if (Trace.isOn) {
                                    Trace.trace(this, "cleaning up after exception");
                                    Trace.exception(this, "openDurableSubscription", (Throwable)jMSException);
                                    if (bl4) {
                                        Trace.trace(this, "must cancel deferred message");
                                    }
                                    if (bl5) {
                                        Trace.trace(this, "must cancel register broker command");
                                    }
                                    if (!bl6) {
                                        Trace.trace(this, "closing subscriber queue");
                                    }
                                }
                                boolean bl8 = false;
                                if (bl5) {
                                    try {
                                        n = 524288;
                                        mQMsg2.clearMessageData();
                                        mQMsg2.setMessageType(8);
                                        this.sendBrokerMessage(mQBrokerSubscription3, "DeregSub", n, mQMsg2, null);
                                    }
                                    catch (JMSException jMSException2) {
                                        if (Trace.isOn) {
                                            Trace.exception(this, "openDurableSubscription - canceling register command", (Throwable)jMSException2);
                                        }
                                        bl8 = true;
                                    }
                                }
                                if (bl4) {
                                    try {
                                        this.cancelDeferredMessage(mQTopicSession, byArray3);
                                    }
                                    catch (JMSException jMSException3) {
                                        if (Trace.isOn) {
                                            Trace.exception(this, "openDurableSubscription - cancelling deferred message", (Throwable)jMSException3);
                                        }
                                        bl8 = true;
                                    }
                                }
                                if (var16_16 != null && var16_16.isOpen() && !bl6) {
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "deleting subscription queue");
                                        }
                                        if (!bl2) {
                                            var16_16.closeOptions = 2;
                                        }
                                        var16_16.close();
                                    }
                                    catch (MQException mQException) {
                                        if (!Trace.isOn) break block163;
                                        Trace.exception(this, "queue delete failed with ", (Throwable)mQException);
                                    }
                                }
                            }
                            if (this.WSClone == 1 && bl7) {
                                try {
                                    localSubscriptions.removeSubscription(string4);
                                }
                                catch (Exception exception) {
                                    if (!Trace.isOn) break block164;
                                    Trace.trace(this, "error encountered while removing subscription entry from localSubscriptions table");
                                    Trace.exception(this, "openDurableSubscription", (Throwable)exception);
                                }
                            }
                        }
                        if (!Trace.isOn) throw jMSException;
                        Trace.exit(this, "openDurableSubscription - from exception");
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var43_78 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "openDurableSubscription");
                    throw throwable;
                }
            }
            Trace.exit(this, "openDurableSubscription");
            return mQBrokerSubscription2;
        }
        Object var43_77 = null;
        if (!Trace.isOn) return mQBrokerSubscription;
        Trace.exit(this, "openDurableSubscription");
        return mQBrokerSubscription;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDurableSubscription(MQSubscription mQSubscription) throws JMSException {
        int n = 0;
        MQMsg2 mQMsg2 = new MQMsg2();
        MQQueue mQQueue = null;
        if (Trace.isOn) {
            Trace.entry(this, "closeDurableSubscription");
        }
        try {
            try {
                block21: {
                    block22: {
                        try {
                            try {
                                if (!(mQSubscription instanceof MQBrokerSubscription)) {
                                    JMSException jMSException = new JMSException("MQJMS3049");
                                    throw jMSException;
                                }
                                MQBrokerSubscription mQBrokerSubscription = (MQBrokerSubscription)mQSubscription;
                                n += 524288;
                                mQMsg2.setMessageType(8);
                                try {
                                    this.sendBrokerMessage(mQBrokerSubscription, "DeregSub", n, mQMsg2, null);
                                }
                                catch (JMSException jMSException) {
                                    if (!Trace.isOn) throw jMSException;
                                    Trace.trace(this, "Error sending BrokerMessage: ");
                                    throw jMSException;
                                }
                                try {
                                    this.cancelDeferredMessage(mQBrokerSubscription.getMQTopicSession(), mQBrokerSubscription.getDeferredMsgId());
                                }
                                catch (JMSException jMSException) {
                                    if (!Trace.isOn) throw jMSException;
                                    Trace.trace(this, "Error cancelling deferred MQPUT: ");
                                    throw jMSException;
                                }
                                mQQueue = mQBrokerSubscription.getSubscriberQueue();
                                if (mQQueue != null && mQQueue.isOpen()) {
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "closing subscription queue");
                                        }
                                        mQQueue.close();
                                    }
                                    catch (MQException mQException) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "queue close failed with " + (Object)((Object)mQException));
                                        }
                                        jMSException = ConfigEnvironment.newException("MQJMS2000");
                                        jMSException.setLinkedException((Exception)((Object)mQException));
                                        throw jMSException;
                                    }
                                }
                                Object var9_13 = null;
                                if (this.WSClone != 1) break block21;
                                if (!Trace.isOn) break block22;
                            }
                            catch (JMSException jMSException) {
                                if (!Trace.isOn) throw jMSException;
                                Trace.trace(this, "exception thrown while attempting to close durable subscription");
                                throw jMSException;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_14 = null;
                            if (this.WSClone != 1) throw throwable;
                            if (Trace.isOn) {
                                Trace.trace(this, "attempting to remove localSubscription entry");
                            }
                            localSubscriptions.removeSubscription(((MQBrokerSubscription)mQSubscription).getEscapedFullName());
                            throw throwable;
                        }
                        Trace.trace(this, "attempting to remove localSubscription entry");
                    }
                    localSubscriptions.removeSubscription(((MQBrokerSubscription)mQSubscription).getEscapedFullName());
                }
                Object var11_16 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "closeDurableSubscription", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_17 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "closeDurableSubscription");
            throw throwable;
        }
        Trace.exit(this, "closeDurableSubscription");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void durableUnsubscribe(MQTopicSession mQTopicSession, String string) throws JMSException {
        int n = 0;
        MQMsg2 mQMsg2 = new MQMsg2();
        BrokerConnectionInfo brokerConnectionInfo = mQTopicSession.getBrk();
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string2 = null;
        String string3 = null;
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        boolean bl = false;
        byte[] byArray3 = null;
        String string4 = null;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        String string5 = new String("JMS:SYS:Unknown");
        Object var19_19 = null;
        if (Trace.isOn) {
            Trace.entry(this, "durableUnsubscribe");
        }
        try {
            block51: {
                String string6;
                try {
                    try {
                        if (this.getMQTopicConnection().getBrkVersion() == 0) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Creating new RFH1 Message");
                            }
                            mQBrokerMessage = new RFH1BrokerMessageImpl();
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "Creating new RFH2 Message");
                            }
                            mQBrokerMessage = new RFH2BrokerMessageImpl();
                        }
                        string2 = "JMS:" + this.escapeString(mQTopicSession.qm.name) + ":" + this.escapeString(this.getMQTopicConnection().getClientID()) + ":" + this.escapeString(string);
                        mQBrokerMessage.set("MQPSCommand", "DeregSub");
                        mQBrokerMessage.set("MQPSSubName", string2);
                        mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQTopicSession.getSessionName()));
                        n = 589824;
                        mQBrokerMessage.setOption("MQPSRegOpts", n);
                        mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                        if (mQTopicSession.qm.name != null) {
                            mQBrokerMessage.set("MQPSQMgrName", mQTopicSession.qm.name);
                        }
                        mQMsg2.setMessageType(8);
                        mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                    }
                    catch (Exception exception) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Couldn't construct brokerMessage:");
                        }
                        if (exception instanceof JMSException) {
                            throw (JMSException)((Object)exception);
                        }
                        JMSException jMSException = new JMSException("MQJMS3008");
                        jMSException.setLinkedException(exception);
                        throw jMSException;
                    }
                    try {
                        byArray = this.setDeferredMessage(mQTopicSession, mQBrokerMessage, mQMsg2, null, true);
                        byArray2 = mQMsg2.getMessageId();
                        if (byArray == null && Trace.isOn) {
                            Trace.trace(this, "Queue manager does not support deferred messages");
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Could not send brokerMessage with deferred MQPUT");
                        throw jMSException;
                    }
                }
                catch (JMSException jMSException) {
                    bl2 = false;
                    bl3 = false;
                    throw jMSException;
                }
                try {
                    mQBrokerMessage.clear();
                    mQBrokerMessage.set("MQPSCommand", "RegSub");
                    mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQTopicSession.getSessionName()));
                    mQBrokerMessage.set("MQPSSubName", string2);
                    mQBrokerMessage.set("MQPSTopic", string5);
                    n = 360448;
                    mQBrokerMessage.setOption("MQPSRegOpts", n);
                    mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                    if (mQTopicSession.qm.name != null) {
                        mQBrokerMessage.set("MQPSQMgrName", mQTopicSession.qm.name);
                    }
                    mQMsg2 = new MQMsg2();
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                    this.sendBrokerMessage(mQTopicSession, mQBrokerMessage, mQMsg2, null, true);
                    try {
                        if (this.getMQTopicConnection().getBrkVersion() == 0) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Receiving RFH1 Message from broker");
                            }
                            mQBrokerMessage2 = new RFH1BrokerMessageImpl();
                            mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, false);
                        } else {
                            if (Trace.isOn) {
                                Trace.trace(this, "Receiving RFH2 Message from broker");
                            }
                            mQBrokerMessage2 = new RFH2BrokerMessageImpl();
                            mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQTopicSession, mQMsg2, false);
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!(jMSException instanceof NoBrokerResponseException)) {
                            bl2 = false;
                            bl3 = false;
                            throw jMSException;
                        }
                        mQBrokerMessage2 = null;
                    }
                    string6 = "Broker did not respond";
                    switch (Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"))) {
                        case 1: {
                            string6 = mQBrokerMessage2.get("MQPSReasonText");
                            bl2 = true;
                            bl3 = true;
                            throw new JMSException("Broker Command warning: " + string6);
                        }
                        case 2: {
                            bl3 = true;
                            bl2 = false;
                            string6 = mQBrokerMessage2.get("MQPSReasonText");
                            throw new JMSException("Broker Command failed: " + string6);
                        }
                        case 0: {
                            string3 = mQBrokerMessage2.get("MQPSTopic");
                            break;
                        }
                        default: {
                            string6 = mQBrokerMessage2.get("MQPSReasonText");
                            throw ConfigEnvironment.newException("MQJMS3040", string6);
                        }
                    }
                }
                catch (Exception exception) {
                    if (exception instanceof JMSException) {
                        throw (JMSException)((Object)exception);
                    }
                    jMSException = new JMSException(exception.getMessage());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                try {
                    if (string3.equals(string5)) {
                        bl4 = true;
                    }
                    bl = mQBrokerMessage2.isOptionSet("MQPSRegOpts", 1);
                    string4 = mQBrokerMessage2.get("MQPSQName");
                    string6 = mQBrokerMessage2.get("MQPSCorrelId");
                    if (string6 != null) {
                        byArray3 = Utils.hexToBytes(string6);
                    }
                    mQBrokerMessage.clear();
                    mQBrokerMessage.set("MQPSCommand", "DeregSub");
                    mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(mQTopicSession.getSessionName()));
                    mQBrokerMessage.set("MQPSSubName", string2);
                    mQBrokerMessage.set("MQPSTopic", string3);
                    n = 65536;
                    mQBrokerMessage.setOption("MQPSRegOpts", n);
                    mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                    if (mQTopicSession.qm.name != null) {
                        mQBrokerMessage.set("MQPSQMgrName", mQTopicSession.qm.name);
                    }
                    mQMsg2 = new MQMsg2();
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                    this.sendBrokerMessage(mQTopicSession, mQBrokerMessage, mQMsg2, null, true);
                }
                catch (Exception exception) {
                    if (exception instanceof JMSException) {
                        throw (JMSException)((Object)exception);
                    }
                    jMSException = new JMSException(exception.getMessage());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                if (bl4) {
                    if (Trace.isOn) {
                        Trace.trace(this, "No record found for '" + string + "'");
                    }
                    string6 = "MQJMS3018";
                    String string7 = ConfigEnvironment.getErrorMessage(string6, string);
                    InvalidDestinationException invalidDestinationException = new InvalidDestinationException(string7, string6);
                    throw invalidDestinationException;
                }
                if (Trace.isOn) {
                    Trace.trace(this, "About to call cleanup to remove unconsumed messages");
                }
                try {
                    mQBrokerMessage2 = this.cleanupUnconsumedMessages(mQTopicSession, bl, string4, byArray3, mQMsg2);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "exception thrown while attempting to cleanup subscriber queue");
                    throw jMSException;
                }
                try {
                    this.cancelDeferredMessage(mQTopicSession, byArray2);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) break block51;
                    Trace.trace(this, "Exception thrown cancelling deferred deregister message. Ignoring");
                    Trace.exception(this, "durableUnsubscribe", (Throwable)jMSException);
                }
            }
            Object var24_35 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var24_36 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "durableUnsubscribe");
            throw throwable;
        }
        Trace.exit(this, "durableUnsubscribe");
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.cleanupHandle != null) {
            this.cleanupHandle.close();
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQBrokerSubscription updateDurableSubscription(MQBrokerSubscription mQBrokerSubscription, String string, String string2, boolean bl) throws JMSException {
        MQBrokerSubscription mQBrokerSubscription2;
        Object var5_5 = null;
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        int n = 0;
        MQMsg2 mQMsg2 = null;
        byte[] byArray = null;
        if (Trace.isOn) {
            Trace.entry(this, "updateDurableSubscription");
            if (bl) {
                Trace.trace(this, "Recovering broken subscription");
            }
        }
        try {
            try {
                byArray = mQBrokerSubscription.getMQTopicSession().getSessionName();
                if (!bl) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Setting subscription to PubOnReqOnly");
                    }
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH1 Message");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH2 Message");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                    }
                    mQBrokerMessage.set("MQPSCommand", "RegSub");
                    mQBrokerMessage.set("MQPSSubName", mQBrokerSubscription.getEscapedFullName());
                    mQBrokerMessage.set("MQPSTopic", mQBrokerSubscription.getTopic());
                    mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(byArray));
                    n = 65568;
                    if (mQBrokerSubscription.isSharedQueue()) {
                        ++n;
                    }
                    mQBrokerMessage.setOption("MQPSRegOpts", n);
                    mQMsg2 = new MQMsg2();
                    mQMsg2.setCorrelationId(mQBrokerSubscription.getCorrelationId());
                    mQMsg2.setMessageType(1);
                    mQMsg2.setReport(0);
                    this.sendBrokerMessage(mQBrokerSubscription.getMQTopicSession(), mQBrokerMessage, mQMsg2, null, true);
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH1 Message from broker");
                        }
                        mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQTopicSession(), mQMsg2, true);
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Receiving RFH2 Message from broker");
                        }
                        mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQTopicSession(), mQMsg2, true);
                    }
                    if (Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode")) != 0) {
                        throw new JMSException(mQBrokerMessage2.get("MQPSReasonText"));
                    }
                }
                mQBrokerMessage.clear();
                if (string2 == null) {
                    string2 = "";
                }
                mQBrokerMessage.unset("MQPSRegOpts");
                n = 327680;
                if (mQBrokerSubscription.isSharedQueue()) {
                    ++n;
                }
                mQBrokerMessage.setOption("MQPSRegOpts", n);
                mQBrokerMessage.set("MQPSCommand", "RegSub");
                mQBrokerMessage.set("MQPSSubName", mQBrokerSubscription.getEscapedFullName());
                mQBrokerMessage.set("MQPSQName", mQBrokerSubscription.getQueueName());
                mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(byArray));
                mQBrokerMessage.set("MQPSSubUserData", string2);
                mQBrokerMessage.set("MQPSTopic", string);
                mQMsg2 = new MQMsg2();
                mQMsg2.setCorrelationId(mQBrokerSubscription.getCorrelationId());
                mQMsg2.setMessageType(1);
                mQMsg2.setReport(0);
                this.sendBrokerMessage(mQBrokerSubscription.getMQTopicSession(), mQBrokerMessage, mQMsg2, null, true);
                if (this.getMQTopicConnection().getBrkVersion() == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Receiving RFH1 Message from broker");
                    }
                    mQBrokerMessage2 = (RFH1BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQTopicSession(), mQMsg2, true);
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Receiving RFH2 Message from broker");
                    }
                    mQBrokerMessage2 = (RFH2BrokerMessageImpl)this.getBrokerResponse(mQBrokerSubscription.getMQTopicSession(), mQMsg2, true);
                }
                int n2 = Integer.parseInt(mQBrokerMessage2.get("MQPSCompCode"));
                int n3 = Integer.parseInt(mQBrokerMessage2.get("MQPSReason"));
                if (n2 != 0) {
                    if (n2 != 1) throw new JMSException(mQBrokerMessage2.get("MQPSReasonText"));
                    if (n3 != 3157) {
                        throw new JMSException(mQBrokerMessage2.get("MQPSReasonText"));
                    }
                }
                mQBrokerSubscription.setTopic(string);
                mQBrokerSubscription.setSelector(string2);
                mQBrokerSubscription2 = mQBrokerSubscription;
                Object var15_19 = null;
                if (!Trace.isOn) return mQBrokerSubscription2;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "updateDurableSubscription", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var15_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "updateDurableSubscription");
            throw throwable;
        }
        Trace.exit(this, "updateDurableSubscription");
        return mQBrokerSubscription2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] sendBrokerMessageInternal(MQTopicSession mQTopicSession, MQBrokerMessage mQBrokerMessage, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl, boolean bl2) throws JMSException {
        MQQueue mQQueue = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessageInternal(mqts, brkMsg, MQMsg2, pmo, deferred)");
        }
        try {
            try {
                BrokerConnectionInfo brokerConnectionInfo = mQTopicSession.getBrk();
                try {
                    MQTopicConnection mQTopicConnection = this.getMQTopicConnection();
                    if (mQBrokerMessage.get("MQPSCommand") == "RegSub" && mQTopicConnection.getBrkOptLevel() > 0) {
                        if (!mQTopicSession.persistenceFromMD && !bl2) {
                            mQBrokerMessage.setOption("MQPSRegOpts", "NonPers");
                        }
                        if (mQTopicSession.acknowledgeMode == 3) {
                            mQBrokerMessage.setOption("MQPSRegOpts", "DupsOK");
                        }
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Exception thrown attempting to set nonPersistent and DupsOk options");
                    Trace.exception(this, "sendBrokerMessageInternal", (Throwable)jMSException);
                    throw jMSException;
                }
                try {
                    Object object;
                    try {
                        if (bl2) {
                            byArray = mQTopicSession.getSessionName();
                            mQBrokerMessage.set("MQPSSubIdentity", Utils.bytesToHex(byArray));
                            mQBrokerMessage.setOption("MQPSRegOpts", "VariableUserId");
                        }
                        mQBrokerMessage.writeToMessage(mQMsg2);
                        mQMsg2.setReplyToQueueManagerName("");
                        mQMsg2.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                        mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.exception(this, "sendBrokerMessageInternal", (Throwable)mQException);
                        }
                        JMSException jMSException = new JMSException("MQJMS1000");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                    try {
                        int n = 16;
                        object = mQTopicSession.qm;
                        if (mQPutMessageOptions == null) {
                            mQPutMessageOptions = new MQPutMessageOptions();
                        }
                        if (bl) {
                            MQSPIQueueManager mQSPIQueueManager = (MQSPIQueueManager)object;
                            if (!mQSPIQueueManager.spiSupportsDeferred()) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS3047");
                                throw jMSException;
                            }
                            mQQueue = mQSPIQueueManager.accessQueue(brokerConnectionInfo.controlQ, n, brokerConnectionInfo.qmName, null, null);
                            ((MQSPIQueue)mQQueue).spiDeferredPut(mQMsg2, mQPutMessageOptions);
                        } else {
                            mQQueue = mQTopicSession.qm.accessQueue(brokerConnectionInfo.controlQ, n, brokerConnectionInfo.qmName, null, null);
                            mQQueue.putMsg2(mQMsg2, mQPutMessageOptions);
                        }
                    }
                    catch (MQException mQException) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2008");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Failed to MQPUT broker command due to: " + (Object)((Object)mQException));
                        throw jMSException;
                    }
                    byArray2 = mQMsg2.getCorrelationId();
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        object = ConfigEnvironment.newException("MQJMS2000");
                        object.setLinkedException((Exception)((Object)mQException));
                        if (!Trace.isOn) throw object;
                        Trace.trace(this, "Failed to close broker queue");
                        throw object;
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Failed to put message to broker queue");
                    throw jMSException;
                }
                Object var16_24 = null;
                if (!Trace.isOn) return byArray2;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2)", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var16_25 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "sendBrokerMessageInternal(mqts, brkMsg, MQMsg2)");
            throw throwable;
        }
        Trace.exit(this, "sendBrokerMessageInternal(mqts, brkMsg, MQMsg2)");
        return byArray2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] sendBrokerMessageInternal(MQSubscription mQSubscription, String string, int n, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl) throws JMSException {
        byte[] byArray;
        MQTopicSession mQTopicSession = null;
        String string2 = null;
        String string3 = null;
        byte[] byArray2 = null;
        MQBrokerMessage mQBrokerMessage = null;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessageInternal");
        }
        try {
            try {
                mQTopicSession = mQSubscription.getMQTopicSession();
                BrokerConnectionInfo brokerConnectionInfo = mQTopicSession.getBrk();
                string2 = mQSubscription.getSelector();
                string3 = string2 != null && !string2.trim().equals("") ? "sel=\"" + this.escapeString(string2) + "\"" : "";
                try {
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH1 Message");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH2 Message");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                    }
                    mQBrokerMessage.set("MQPSCommand", string);
                    mQBrokerMessage.setOption("MQPSRegOpts", n);
                    mQBrokerMessage.set("MQPSStreamName", brokerConnectionInfo.streamQ);
                    mQBrokerMessage.set("MQPSTopic", mQSubscription.getTopic());
                    if (mQTopicSession.qm.name != null) {
                        mQBrokerMessage.set("MQPSQMgrName", mQTopicSession.qm.name);
                    }
                    mQBrokerMessage.set("MQPSQName", mQSubscription.getQueueName());
                    if (mQSubscription.isDurable()) {
                        mQBrokerMessage.set("MQPSSubName", ((MQBrokerSubscription)mQSubscription).getEscapedFullName());
                    }
                    if (!string.equals("DeregSub")) {
                        mQBrokerMessage.set("MQPSSubUserData", string3);
                    } else {
                        mQBrokerMessage.unset("MQPSSubUserData");
                    }
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Error constructing MQBrokerMessage");
                    throw jMSException;
                }
                try {
                    if (mQMsg2 == null) {
                        mQMsg2 = new MQMsg2();
                    }
                    mQMsg2.setReplyToQueueManagerName("");
                    mQMsg2.setReplyToQueueName("SYSTEM.JMS.REPORT.QUEUE");
                    mQMsg2.setFormat(mQBrokerMessage.getHeaderFormat());
                }
                catch (MQException mQException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Error detailing jmsMessage");
                    }
                    JMSException jMSException = new JMSException("MQJMS1000");
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                byArray2 = this.sendBrokerMessageInternal(mQTopicSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, bl, mQSubscription.isDurable());
                byArray = byArray2;
                Object var16_19 = null;
                if (!Trace.isOn) return byArray;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "sendBrokerMessageInternal", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var16_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "sendBrokerMessageInternal");
            throw throwable;
        }
        Trace.exit(this, "sendBrokerMessageInternal");
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] sendBrokerMessage(MQSubscription mQSubscription, String string, int n, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws JMSException {
        byte[] byArray;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessage(sub, cmd, regOpts, Msg, pmo)");
        }
        try {
            byArray = this.sendBrokerMessageInternal(mQSubscription, string, n, mQMsg2, mQPutMessageOptions, false);
            Object var8_7 = null;
            if (!Trace.isOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "sendBrokerMessage(sub, cmd, regOpts, Msg, pmo)");
            throw throwable;
        }
        Trace.exit(this, "sendBrokerMessage(sub, cmd, regOpts, Msg, pmo)");
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] sendBrokerMessage(MQTopicSession mQTopicSession, MQBrokerMessage mQBrokerMessage, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl) throws JMSException {
        byte[] byArray;
        if (Trace.isOn) {
            Trace.entry(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2, pmo, durable)");
        }
        try {
            byArray = this.sendBrokerMessageInternal(mQTopicSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, false, bl);
            Object var8_7 = null;
            if (!Trace.isOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2, pmo, durable)");
            throw throwable;
        }
        Trace.exit(this, "sendBrokerMessage(mqts, brkMsg, MQMsg2, pmo, durable)");
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] setDeferredMessage(MQSubscription mQSubscription, String string, int n, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions) throws JMSException {
        byte[] byArray;
        if (Trace.isOn) {
            Trace.entry(this, "setDeferredMessage(sub, cmd, regOpts, msg, pmo)");
        }
        try {
            byte[] byArray2 = null;
            byArray = byArray2 = this.sendBrokerMessageInternal(mQSubscription, string, n, mQMsg2, mQPutMessageOptions, true);
            Object var9_8 = null;
            if (!Trace.isOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setDeferredMessage(sub, cmd, regOpts, msg, pmo)");
            throw throwable;
        }
        Trace.exit(this, "setDeferredMessage(sub, cmd, regOpts, msg, pmo)");
        return byArray;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private byte[] setDeferredMessage(MQTopicSession mQTopicSession, MQBrokerMessage mQBrokerMessage, MQMsg2 mQMsg2, MQPutMessageOptions mQPutMessageOptions, boolean bl) throws JMSException {
        byte[] byArray;
        if (Trace.isOn) {
            Trace.entry(this, "setDeferredMessage(mqts, brokermsg, jmsMsg, pmo");
        }
        try {
            byte[] byArray2 = null;
            byArray = byArray2 = this.sendBrokerMessageInternal(mQTopicSession, mQBrokerMessage, mQMsg2, mQPutMessageOptions, true, bl);
            Object var9_8 = null;
            if (!Trace.isOn) return byArray;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setDeferredMessage(mqts, brokermsg, jmsMsg, pmo");
            throw throwable;
        }
        Trace.exit(this, "setDeferredMessage(mqts, brokermsg, jmsMsg, pmo");
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cancelDeferredMessage(MQTopicSession mQTopicSession, byte[] byArray) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "cancelDeferredMessage");
        }
        try {
            try {
                MQQueueManager mQQueueManager = mQTopicSession.qm;
                if (!(mQQueueManager instanceof MQSPIQueueManager)) {
                    JMSException jMSException = new JMSException("MQJMS3047");
                    throw jMSException;
                }
                MQSPIQueueManager mQSPIQueueManager = (MQSPIQueueManager)mQQueueManager;
                if (!mQSPIQueueManager.spiSupportsDeferred()) {
                    JMSException jMSException = new JMSException("MQJMS3047");
                    throw jMSException;
                }
                mQSPIQueueManager.spiCancelDeferred(byArray);
                Object var7_10 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                throw jMSException;
            }
            catch (MQException mQException) {
                JMSException jMSException = new JMSException(mQException.getMessage());
                jMSException.setLinkedException((Exception)((Object)mQException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var7_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "cancelDeferredMessage");
            throw throwable;
        }
        Trace.exit(this, "cancelDeferredMessage");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQBrokerMessage getBrokerResponse(MQTopicSession mQTopicSession, MQMsg2 mQMsg2, boolean bl) throws JMSException {
        MQMsg2 mQMsg22 = null;
        MQQueue mQQueue = null;
        MQGetMessageOptions mQGetMessageOptions = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        if (Trace.isOn) {
            Trace.entry(this, "getBrokerResponse");
        }
        try {
            MQBrokerMessage mQBrokerMessage;
            block15: {
                try {
                    mQMsg22 = new MQMsg2();
                    mQMsg22.setCorrelationId(mQMsg2.getMessageId());
                    try {
                        mQQueue = mQTopicSession.getResponseQueue();
                        mQGetMessageOptions = new MQGetMessageOptions();
                        mQGetMessageOptions.options = 1;
                        mQGetMessageOptions.waitInterval = mQTopicSession.getBrokerTimeout();
                        if (Trace.isOn) {
                            Trace.trace(this, "setting broker timeout to " + mQTopicSession.getBrokerTimeout());
                        }
                        mQQueue.getMsg2(mQMsg22, mQGetMessageOptions);
                    }
                    catch (MQException mQException) {
                        String string = "MQJMS5053";
                        String string2 = ConfigEnvironment.getErrorMessage(string);
                        NoBrokerResponseException noBrokerResponseException = new NoBrokerResponseException(string2);
                        noBrokerResponseException.setLinkedException((Exception)((Object)mQException));
                        if (!Trace.isOn) throw noBrokerResponseException;
                        Trace.exception(this, "error getting broker response: ", (Throwable)((Object)noBrokerResponseException));
                        throw noBrokerResponseException;
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "got broker response");
                    }
                    if (this.getMQTopicConnection().getBrkVersion() == 0) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH1 Message");
                        }
                        mQBrokerMessage = new RFH1BrokerMessageImpl();
                    } else {
                        if (Trace.isOn) {
                            Trace.trace(this, "Creating RFH2 Message");
                        }
                        mQBrokerMessage = new RFH2BrokerMessageImpl();
                    }
                    mQBrokerMessage.initializeFromMessage(mQMsg22);
                    if (!bl || mQBrokerMessage.get("MQPSTopic") != null && !mQBrokerMessage.get("MQPSTopic").equals("") || Integer.parseInt(mQBrokerMessage.get("MQPSCompCode")) == 2) break block15;
                    mQBrokerMessage2 = MQBrokerMessage.fromMessage(mQMsg2);
                    if (mQBrokerMessage2.get("MQPSCommand").equals("RegSub")) {
                        boolean bl2 = mQBrokerMessage2.isOptionSet("MQPSRegOpts", "CorrelAsId");
                        this.cleanupUnwantedSubscription(mQTopicSession, mQMsg2, bl2);
                    }
                    if (Trace.isOn) {
                        Trace.trace(this, "Full response didn't work, using workaround and setting fail");
                    }
                    mQBrokerMessage.set("MQPSCompCode", Integer.toString(2));
                    mQBrokerMessage.set("MQPSReason", Integer.toString(2337));
                    mQBrokerMessage.set("MQPSReasonText", "MQRC_RFH_PARM_ERROR");
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "exception thrown getting broker response", (Throwable)jMSException);
                    throw jMSException;
                }
            }
            Object var14_15 = null;
            if (!Trace.isOn) return mQBrokerMessage;
            Trace.exit(this, "getBrokerResponse");
            return mQBrokerMessage;
        }
        catch (Throwable throwable) {
            Object var14_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "getBrokerResponse");
            throw throwable;
        }
    }

    /*
     * Loose catch block
     */
    byte[] createSessionName(MQTopicSession mQTopicSession) throws JMSException {
        byte[] byArray;
        block18: {
            MQQueue mQQueue;
            block17: {
                block16: {
                    byArray = null;
                    Object var3_3 = null;
                    MQQueueManager mQQueueManager = mQTopicSession.qm;
                    mQQueue = null;
                    if (Trace.isOn) {
                        Trace.entry(this, "createSessionName");
                    }
                    mQQueue = mQQueueManager.accessQueue("SYSTEM.JMS.REPORT.QUEUE", 18);
                    MQMessage mQMessage = new MQMessage();
                    MQPutMessageOptions mQPutMessageOptions = new MQPutMessageOptions();
                    try {
                        mQMessage.writeString("sessGen");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    mQMessage.expiry = 1;
                    mQMessage.correlationId = JMSC.PS_IDGEN_CORRELID;
                    mQMessage.persistence = 0;
                    mQQueue.put(mQMessage, mQPutMessageOptions);
                    byArray = mQMessage.messageId;
                    try {
                        mQQueue.get(mQMessage);
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2033) break block16;
                        throw mQException;
                    }
                }
                Object var10_12 = null;
                if (mQQueue == null) break block17;
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    // empty catch block
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "createSessionName");
            }
            break block18;
            {
                catch (MQException mQException) {
                    JMSException jMSException = mQException.reasonCode == 2085 ? ConfigEnvironment.newException("MQJMS3014", "SYSTEM.JMS.PS.STATUS.QUEUE") : ConfigEnvironment.newException("MQJMS3005", mQException.toString());
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    if (Trace.isOn) {
                        Trace.exception(this, "createSessionName", (Throwable)jMSException);
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                Object var10_13 = null;
                if (mQQueue != null) {
                    try {
                        mQQueue.close();
                    }
                    catch (MQException mQException) {
                        // empty catch block
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "createSessionName");
                }
                throw throwable;
            }
        }
        return byArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String escapeString(String string) {
        String string2;
        StringBuffer stringBuffer;
        block11: {
            String string3;
            block10: {
                stringBuffer = new StringBuffer();
                boolean bl = false;
                char c = '\u0000';
                String string4 = null;
                if (Trace.isOn) {
                    Trace.entry(this, "escapeString: " + string);
                }
                try {
                    if (string == null) {
                        string3 = "";
                        Object var10_7 = null;
                        if (!Trace.isOn) return string3;
                        break block10;
                    }
                    int n = 0;
                    while (true) {
                        if (n >= string.length()) {
                            string2 = stringBuffer.toString();
                            break block11;
                        }
                        c = string.charAt(n);
                        switch (c) {
                            case '\"': 
                            case ':': 
                            case ';': 
                            case '\\': {
                                string4 = "0000" + Integer.toString(c, 16);
                                stringBuffer.append("\\u" + string4.substring(string4.length() - 4, string4.length()));
                                break;
                            }
                            default: {
                                if (c < ' ' || c > '~') {
                                    string4 = "0000" + Integer.toString(c, 16);
                                    stringBuffer.append("\\u" + string4.substring(string4.length() - 4, string4.length()));
                                    break;
                                }
                                stringBuffer.append(c);
                            }
                        }
                        ++n;
                    }
                }
                catch (Throwable throwable) {
                    Object var10_9 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.trace(this, "Returning string: " + stringBuffer.toString());
                    Trace.exit(this, "escapeString");
                    throw throwable;
                }
            }
            Trace.trace(this, "Returning string: " + stringBuffer.toString());
            Trace.exit(this, "escapeString");
            return string3;
        }
        Object var10_8 = null;
        if (!Trace.isOn) return string2;
        Trace.trace(this, "Returning string: " + stringBuffer.toString());
        Trace.exit(this, "escapeString");
        return string2;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQBrokerMessage cleanupUnconsumedMessages(MQTopicSession var1_1, boolean var2_2, String var3_3, byte[] var4_4, MQMsg2 var5_5) throws JMSException {
        block45: {
            block42: {
                block44: {
                    block39: {
                        var6_6 = new String("cleanupUnconsumedMessages");
                        var7_7 = this.cleanupHandle.getCleanupLevel();
                        var8_8 = 0;
                        var9_9 = null;
                        var10_10 = null;
                        var11_11 = null;
                        var12_12 = null;
                        try {
                            try {
                                block41: {
                                    if (Trace.isOn) {
                                        Trace.entry(this, var6_6);
                                    }
                                    if (var7_7 == 0) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Cleanup level is NONE; skipping cleanup");
                                        }
                                        var13_13 = null;
                                        var18_19 = null;
                                        break block39;
                                    }
                                    var8_8 = 10;
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "opening report queue");
                                        }
                                        var9_9 = var1_1.qm.accessQueue("SYSTEM.JMS.REPORT.QUEUE", var8_8);
                                    }
                                    catch (MQException var13_14) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "exception thrown opening report queue");
                                        }
                                        if (var13_14.reasonCode != 2042) {
                                            var14_27 = ConfigEnvironment.newException("MQJMS2008");
                                            var14_27.setLinkedException((Exception)var13_14);
                                            throw var14_27;
                                        }
                                        if ((var8_8 & 2) == 2) {
                                            var14_25 = ConfigEnvironment.newException("MQJMS3045", "SYSTEM.JMS.REPORT.QUEUE");
                                            var14_25.setLinkedException((Exception)var13_14);
                                            throw var14_25;
                                        }
                                        var14_26 = ConfigEnvironment.newException("MQJMS3046", "SYSTEM.JMS.REPORT.QUEUE");
                                        var14_26.setLinkedException((Exception)var13_14);
                                        throw var14_26;
                                    }
                                    try {
                                        var10_10 = new MQGetMessageOptions();
                                        var10_10.options = 545;
                                        var10_10.waitInterval = var1_1.getBrokerTimeout();
                                        if (Trace.isOn) {
                                            Trace.trace(this, "setting broker timeout to " + var1_1.getBrokerTimeout());
                                        }
                                        var11_11 = new MQMsg2();
                                        var11_11.setCorrelationId(var5_5.getMessageId());
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Setting reponse correlationId = " + Utils.bytesToHex(var5_5.getMessageId()));
                                        }
                                        var9_9.getMsg2(var11_11, var10_10);
                                    }
                                    catch (MQException var13_15) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "exception thrown getting response message from report queue");
                                        }
                                        var14_28 = "MQJMS5053";
                                        var15_33 = ConfigEnvironment.getErrorMessage(var14_28);
                                        var16_36 = new NoBrokerResponseException(var15_33);
                                        var16_36.setLinkedException((Exception)var13_15);
                                        throw var16_36;
                                    }
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "got MQ response message, converting to MQBrokerMessage");
                                        }
                                        var12_12 = MQBrokerMessage.fromMessage(var11_11);
                                    }
                                    catch (JMSException var13_16) {
                                        if (Trace.isOn == false) throw var13_16;
                                        Trace.trace(this, "exception thrown while creating MQBrokerMessage");
                                        throw var13_16;
                                    }
                                    var13_17 = Integer.parseInt(var12_12.get("MQPSCompCode"));
                                    if (var13_17 != 0) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "The broker deregister command failed. Abort cleanup and throw exception");
                                        }
                                        var14_29 = var12_12.get("MQPSCompCode");
                                        var15_34 = ConfigEnvironment.newException(var14_29);
                                        throw var15_34;
                                    }
                                    try {
                                        if (var2_2) {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "shared queue, calling removeMessages");
                                            }
                                            Cleanup.removeMessages(var1_1.qm, var3_3, var4_4);
                                        } else {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "dynamic queue, calling removeDynamicQueue");
                                            }
                                            Cleanup.removeDynamicQueue(var1_1.qm, var3_3);
                                        }
                                    }
                                    catch (JMSException var14_30) {
                                        if (Trace.isOn == false) throw var14_30;
                                        Trace.trace(this, "exception thrown while attempting to clean subscriber queue");
                                        throw var14_30;
                                    }
                                    try {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Removing message");
                                        }
                                        var10_10.options = 320;
                                        var9_9.getMsg2(var11_11, var10_10, 1);
                                    }
                                    catch (MQException var14_31) {
                                        if (var14_31.reasonCode == 2079) break block41;
                                        var16_37 = "Couldn't get locked message from queue (" + (Object)var14_31 + ")";
                                        var15_35 = ConfigEnvironment.newException("MQJMS1016", var16_37);
                                        var15_35.setLinkedException((Exception)var14_31);
                                        throw var15_35;
                                    }
                                }
                                var14_32 = var12_12;
                                break block42;
                            }
                            catch (JMSException var13_18) {
                                if (Trace.isOn == false) throw var13_18;
                                Trace.exception(this, var6_6, (Throwable)var13_18);
                                throw var13_18;
                            }
                        }
                        catch (Throwable var17_38) {
                            block43: {
                                var18_21 = null;
                                try {
                                    if (var9_9 != null && var9_9.isOpen()) {
                                        var9_9.close();
                                    }
                                }
                                catch (MQException var19_24) {
                                    if (!Trace.isOn) break block43;
                                    Trace.trace(this, "exception thrown closing reportQueue. Not much we can do about this though.");
                                    Trace.exception(this, var6_6, (Throwable)var19_24);
                                }
                            }
                            if (Trace.isOn == false) throw var17_38;
                            Trace.exit(this, var6_6);
                            throw var17_38;
                        }
                    }
                    ** try [egrp 7[TRYBLOCK] [7 : 675->696)] { 
lbl127:
                    // 1 sources

                    if (var9_9 != null && var9_9.isOpen()) {
                        var9_9.close();
                    }
                    break block44;
lbl130:
                    // 1 sources

                    catch (MQException var19_22) {
                        if (!Trace.isOn) break block44;
                        Trace.trace(this, "exception thrown closing reportQueue. Not much we can do about this though.");
                        Trace.exception(this, var6_6, (Throwable)var19_22);
                    }
                }
                if (Trace.isOn == false) return var13_13;
                Trace.exit(this, var6_6);
                return var13_13;
            }
            var18_20 = null;
            ** try [egrp 7[TRYBLOCK] [7 : 675->696)] { 
lbl141:
            // 1 sources

            if (var9_9 != null && var9_9.isOpen()) {
                var9_9.close();
            }
            break block45;
lbl144:
            // 1 sources

            catch (MQException var19_23) {
                if (!Trace.isOn) break block45;
                Trace.trace(this, "exception thrown closing reportQueue. Not much we can do about this though.");
                Trace.exception(this, var6_6, (Throwable)var19_23);
            }
        }
        if (Trace.isOn == false) return var14_32;
        Trace.exit(this, var6_6);
        return var14_32;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void cleanupUnwantedSubscription(MQTopicSession mQTopicSession, MQMsg2 mQMsg2, boolean bl) {
        String string = "cleanupUnwantedException";
        boolean bl2 = false;
        MQMsg2 mQMsg22 = new MQMsg2();
        MQBrokerMessage mQBrokerMessage = null;
        MQBrokerMessage mQBrokerMessage2 = null;
        MQBrokerMessage mQBrokerMessage3 = null;
        Object var10_10 = null;
        if (Trace.isOn) {
            Trace.entry(this, string);
        }
        Trace.entry(this, string, "sentMessage=" + mQMsg2.toString() + ", sharedQueue=" + bl);
        try {
            try {
                mQBrokerMessage = MQBrokerMessage.fromMessage(mQMsg2);
                if (this.getMQTopicConnection().getBrkVersion() == 0) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Composing new RFH1 message to deregister");
                    }
                    mQBrokerMessage2 = new RFH1BrokerMessageImpl();
                } else {
                    if (Trace.isOn) {
                        Trace.trace(this, "Composing new RFH2 message to deregister");
                    }
                    mQBrokerMessage2 = new RFH2BrokerMessageImpl();
                }
                mQBrokerMessage2.set("MQPSCommand", "DeregSub");
                mQBrokerMessage2.set("MQPSStreamName", mQBrokerMessage.get("MQPSStreamName"));
                mQBrokerMessage2.set("MQPSQMgrName", mQBrokerMessage.get("MQPSQMgrName"));
                mQBrokerMessage2.set("MQPSQName", mQBrokerMessage.get("MQPSQName"));
                if (bl) {
                    mQBrokerMessage2.setOption("MQPSRegOpts", 1);
                }
                mQBrokerMessage2.writeToMessage(mQMsg22);
                mQMsg22.setMessageType(1);
                mQMsg22.setReport(0);
                if (bl) {
                    mQMsg22.setCorrelationId(mQMsg2.getCorrelationId());
                }
                try {
                    this.sendBrokerMessage(mQTopicSession, mQBrokerMessage2, mQMsg22, null, false);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.exception(this, "Error sending deregister unwanted subscription message: ", (Throwable)jMSException);
                    throw jMSException;
                }
                try {
                    mQBrokerMessage3 = this.cleanupUnconsumedMessages(mQTopicSession, bl, mQBrokerMessage.get("MQPSQName"), mQMsg2.getCorrelationId(), mQMsg22);
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "exception thrown dealing with broker response and subscriber queue cleanup");
                    throw jMSException;
                }
                Object var13_14 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (Trace.isOn) {
                    Trace.trace(this, "Problems encountered attempting to deal with an erroneously created subscription.");
                    Trace.trace(this, "Subscription could still exist causing unwanted messages to be delivered");
                }
                Object var13_15 = null;
                if (!Trace.isOn) return;
                Trace.exit(this, string);
                return;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, string);
            throw throwable;
        }
        Trace.exit(this, string);
    }
}

