/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMsg2;
import com.ibm.mq.jms.RFH1BrokerMessageImpl;
import com.ibm.mq.jms.RFH2BrokerMessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.jms.JMSException;

abstract class MQBrokerMessage {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/MQBrokerMessage.java, jms, j521, j521-L020425 02/04/24 11:07:51 @(#) 1.7.1.4";
    private static final String clsName = "MQBrokerMessage";
    public static final String MQPS_COMMAND = "MQPSCommand";
    public static final String MQPS_COMP_CODE = "MQPSCompCode";
    public static final String MQPS_DELETE_OPTIONS = "MQPSDelOpts";
    public static final String MQPS_ERROR_ID = "MQPSErrorId";
    public static final String MQPS_ERROR_POS = "MQPSErrorPos";
    public static final String MQPS_INTEGER_DATA = "MQPSIntData";
    public static final String MQPS_PARAMETER_ID = "MQPSParmId";
    public static final String MQPS_PUBLICATION_OPTIONS = "MQPSPubOpts";
    public static final String MQPS_PUBLISH_TIMESTAMP = "MQPSPubTime";
    public static final String MQPS_Q_MGR_NAME = "MQPSQMgrName";
    public static final String MQPS_Q_NAME = "MQPSQName";
    public static final String MQPS_REASON = "MQPSReason";
    public static final String MQPS_REASON_TEXT = "MQPSReasonText";
    public static final String MQPS_REGISTRATION_OPTIONS = "MQPSRegOpts";
    public static final String MQPS_SEQUENCE_NUMBER = "MQPSSeqNum";
    public static final String MQPS_STREAM_NAME = "MQPSStreamName";
    public static final String MQPS_STRING_DATA = "MQPSStringData";
    public static final String MQPS_TOPIC = "MQPSTopic";
    public static final String MQPS_USER_ID = "MQPSUserId";
    public static final String MQPS_SUBSCRIPTION_IDENTITY = "MQPSSubIdentity";
    public static final String MQPS_SUBSCRIPTION_NAME = "MQPSSubName";
    public static final String MQPS_SUBSCRIPTION_USER_DATA = "MQPSSubUserData";
    public static final String MQPS_CORREL_ID = "MQPSCorrelId";
    public static final String MQPS_DELETE_PUBLICATION = "DeletePub";
    public static final String MQPS_DEREGISTER_PUBLISHER = "DeregPub";
    public static final String MQPS_DEREGISTER_SUBSCRIBER = "DeregSub";
    public static final String MQPS_PUBLISH = "Publish";
    public static final String MQPS_REGISTER_PUBLISHER = "RegPub";
    public static final String MQPS_REGISTER_SUBSCRIBER = "RegSub";
    public static final String MQPS_REQUEST_UPDATE = "ReqUpdate";
    public static final String MQPS_ANONYMOUS = "Anon";
    public static final String MQPS_CORREL_ID_AS_IDENTITY = "CorrelAsId";
    public static final String MQPS_DEREGISTER_ALL = "DeregAll";
    public static final String MQPS_DIRECT_REQUESTS = "DirectReq";
    public static final String MQPS_INCLUDE_STREAM_NAME = "InclStreamName";
    public static final String MQPS_INFORM_IF_RETAINED = "InformIfRet";
    public static final String MQPS_IS_RETAINED_PUBLICATION = "IsRetainedPub";
    public static final String MQPS_LOCAL = "Local";
    public static final String MQPS_NEW_PUBLICATIONS_ONLY = "NewPubsOnly";
    public static final String MQPS_NO_REGISTRATION = "NoReg";
    public static final String MQPS_NONE = "None";
    public static final String MQPS_OTHER_SUBSCRIBERS_ONLY = "OtherSubsOnly";
    public static final String MQPS_PUBLISH_ON_REQUEST_ONLY = "PubOnReqOnly";
    public static final String MQPS_RETAIN_PUBLICATION = "RetainPub";
    public static final String MQPS_DUPLICATES_OK = "DupsOK";
    public static final String MQPS_NON_PERSISTENT = "NonPers";
    public static final String MQPS_PERSISTENT = "Pers";
    public static final String MQPS_PERSISTENT_AS_PUBLISH = "PersAsPub";
    public static final String MQPS_PERSISTENT_AS_Q = "PersAsQueue";
    public static final String MQPS_ADD_NAME = "AddName";
    public static final String MQPS_NO_ALTERATION = "NoAlter";
    public static final String MQPS_FULL_RESPONSE = "FullResp";
    public static final String MQPS_JOIN_SHARED = "JoinShared";
    public static final String MQPS_JOIN_EXCLUSIVE = "JoinExcl";
    public static final String MQPS_LEAVE_ONLY = "LeaveOnly";
    public static final String MQPS_VARIABLE_USER_ID = "VariableUserId";
    public static final String MQPS_LOCKED = "Locked";
    public static final int MQDELO_NONE = 0;
    public static final int MQDELO_LOCAL = 4;
    public static final int MQPUBO_NONE = 0;
    public static final int MQPUBO_CORREL_ID_AS_IDENTITY = 1;
    public static final int MQPUBO_RETAIN_PUBLICATION = 2;
    public static final int MQPUBO_OTHER_SUBSCRIBERS_ONLY = 4;
    public static final int MQPUBO_NO_REGISTRATION = 8;
    public static final int MQPUBO_IS_RETAINED_PUBLICATION = 16;
    public static final int MQREGO_NONE = 0;
    public static final int MQREGO_CORREL_ID_AS_IDENTITY = 1;
    public static final int MQREGO_ANONYMOUS = 2;
    public static final int MQREGO_LOCAL = 4;
    public static final int MQREGO_DIRECT_REQUESTS = 8;
    public static final int MQREGO_NEW_PUBLICATIONS_ONLY = 16;
    public static final int MQREGO_PUBLISH_ON_REQUEST_ONLY = 32;
    public static final int MQREGO_DEREGISTER_ALL = 64;
    public static final int MQREGO_INCLUDE_STREAM_NAME = 128;
    public static final int MQREGO_INFORM_IF_RETAINED = 256;
    public static final int MQREGO_DUPLICATES_OK = 512;
    public static final int MQREGO_NON_PERSISTENT = 1024;
    public static final int MQREGO_PERSISTENT = 2048;
    public static final int MQREGO_PERSISTENT_AS_PUBLISH = 4096;
    public static final int MQREGO_PERSISTENT_AS_Q = 8192;
    public static final int MQREGO_ADD_NAME = 16384;
    public static final int MQREGO_NO_ALTERATION = 32768;
    public static final int MQREGO_FULL_RESPONSE = 65536;
    public static final int MQREGO_JOIN_SHARED = 131072;
    public static final int MQREGO_JOIN_EXCLUSIVE = 262144;
    public static final int MQREGO_LEAVE_ONLY = 524288;
    public static final int MQREGO_VARIABLE_USER_ID = 0x100000;
    public static final int MQREGO_LOCKED = 0x200000;
    private static Hashtable optionFields = new Hashtable();
    private Hashtable nameValuePairs = new Hashtable();
    private int encoding = 273;
    private int codedCharSetId = 1208;
    private String format = "        ";
    private static final int MQRFH_ASCII_STRUCID_INT = 1380337696;
    private static final int MQRFH_EBCDIC_STRUCID_INT = -641284032;

    public static boolean isOptionField(String string) {
        if (Trace.isOn) {
            Trace.entry(clsName, "isOptionField");
            Trace.exit(clsName, "isOptionField");
        }
        return optionFields.containsKey(string);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int optionToFlag(String string, String string2) throws JMSException {
        int n;
        if (Trace.isOn) {
            Trace.entry(clsName, "optionToFlag");
        }
        int n2 = 0;
        try {
            try {
                boolean bl = false;
                Hashtable hashtable = (Hashtable)optionFields.get(string);
                if (hashtable != null) {
                    Integer n3 = (Integer)hashtable.get(string2);
                    if (n3 != null) {
                        n2 = n3;
                    } else {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                if (bl) {
                    try {
                        n2 = Integer.parseInt(string2);
                    }
                    catch (NumberFormatException numberFormatException) {
                        if (Trace.isOn) {
                            Trace.trace(clsName, "caught " + numberFormatException);
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string2);
                        jMSException.setLinkedException((Exception)numberFormatException);
                        throw jMSException;
                    }
                }
                n = n2;
                Object var8_10 = null;
                if (!Trace.isOn) return n;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(clsName, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(clsName, "optionToFlag");
            throw throwable;
        }
        Trace.exit(clsName, "optionToFlag");
        return n;
    }

    MQBrokerMessage() {
        if (Trace.isOn) {
            Trace.entry(this, "constructor");
            Trace.trace(this, sccsid);
        }
        if (Trace.isOn) {
            Trace.exit(this, "constructor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void set(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "set(String, String)");
        }
        try {
            try {
                if (MQBrokerMessage.isOptionField(string)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                    throw jMSException;
                }
                this.nameValuePairs.put(string, string2);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "set(String, String)");
            throw throwable;
        }
        Trace.exit(this, "set(String, String)");
    }

    public void set(String string, int n) {
        if (Trace.isOn) {
            Trace.entry(this, "set(String, int)");
        }
        this.nameValuePairs.put(string, new Integer(n));
        if (Trace.isOn) {
            Trace.exit(this, "set(String, int)");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setOption(String, String");
        }
        try {
            try {
                int n = MQBrokerMessage.optionToFlag(string, string2);
                this.setOption(string, n);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setOption(String, String)");
            throw throwable;
        }
        Trace.exit(this, "setOption(String, String)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setOption(String string, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setOption(String, int)");
        }
        try {
            try {
                Object v = this.nameValuePairs.get(string);
                int n2 = 0;
                if (v != null) {
                    if (!(v instanceof Integer)) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                        throw jMSException;
                    }
                    n2 = (Integer)v;
                }
                this.nameValuePairs.put(string, new Integer(n2 |= n));
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var7_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setOption(String, int)");
            throw throwable;
        }
        Trace.exit(this, "setOption(String, int)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void update(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "update(String, String)");
            Trace.trace(this, "Updating name = '" + string + "', value = '" + string2 + "'");
        }
        try {
            try {
                string2 = string2.trim();
                Object v = this.nameValuePairs.get(string);
                boolean bl = MQBrokerMessage.isOptionField(string);
                if (bl) {
                    int n = MQBrokerMessage.optionToFlag(string, string2);
                    int n2 = 0;
                    if (v != null) {
                        if (!(v instanceof Integer)) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                            throw jMSException;
                        }
                        n2 = (Integer)v;
                    }
                    this.nameValuePairs.put(string, new Integer(n2 |= n));
                }
                if (v != null) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3041", string);
                    throw jMSException;
                }
                this.nameValuePairs.put(string, string2);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var9_10 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "update(String, String)");
            throw throwable;
        }
        Trace.exit(this, "update(String, String)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(String string, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "update(String, int)");
        }
        try {
            try {
                Object v = this.nameValuePairs.get(string);
                if (v != null && !(v instanceof Integer)) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                    throw jMSException;
                }
                int n2 = 0;
                if (v != null) {
                    n2 = (Integer)v;
                }
                this.nameValuePairs.put(string, new Integer(n2 |= n));
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var6_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "update(String, int)");
            throw throwable;
        }
        Trace.exit(this, "update(String, int)");
    }

    public void clear() {
        if (Trace.isOn) {
            Trace.entry(this, "clear");
        }
        this.nameValuePairs.clear();
        if (Trace.isOn) {
            Trace.exit(this, "clear");
        }
    }

    public void unset(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "unset");
        }
        this.nameValuePairs.remove(string);
        if (Trace.isOn) {
            Trace.exit(this, "unset");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void unsetOption(String string, String string2) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "unsetOption(String, String)");
        }
        try {
            try {
                int n = MQBrokerMessage.optionToFlag(string, string2);
                this.unsetOption(string, n);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_5 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "unsetOption(String, String)");
            throw throwable;
        }
        Trace.exit(this, "unsetOption(String, String)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unsetOption(String string, int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "unsetOption(String, int)");
        }
        try {
            block6: {
                try {
                    Object v = this.nameValuePairs.get(string);
                    if (v != null && !(v instanceof Integer)) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                        throw jMSException;
                    }
                    if (v == null) break block6;
                    int n2 = 0;
                    n2 = (Integer)v;
                    this.nameValuePairs.put(string, new Integer(n2 &= ~n));
                }
                catch (JMSException jMSException) {
                    if (!Trace.isOn) throw jMSException;
                    Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    throw jMSException;
                }
            }
            Object var6_7 = null;
            if (!Trace.isOn) return;
            Trace.exit(this, "unsetOption(String, int)");
            return;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "unsetOption(String, int)");
            throw throwable;
        }
    }

    public Enumeration getFields() {
        if (Trace.isOn) {
            Trace.entry(this, "getFields");
        }
        Enumeration enumeration = this.nameValuePairs.keys();
        if (Trace.isOn) {
            Trace.exit(this, "getFields");
        }
        return enumeration;
    }

    public String get(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "get");
        }
        Object v = this.nameValuePairs.get(string);
        if (Trace.isOn) {
            Trace.exit(this, "get");
        }
        if (v == null) {
            return null;
        }
        return v.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int getOptions(String string) throws JMSException {
        int n;
        block8: {
            int n2;
            block7: {
                if (Trace.isOn) {
                    Trace.entry(this, "getOptions");
                }
                try {
                    try {
                        Object v = this.nameValuePairs.get(string);
                        if (v == null) {
                            n2 = 0;
                            Object var7_5 = null;
                            if (!Trace.isOn) return n2;
                            break block7;
                        }
                        if (!(v instanceof Integer)) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                            throw jMSException;
                        }
                        n = (Integer)v;
                        break block8;
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var7_7 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "getOptions");
                    throw throwable;
                }
            }
            Trace.exit(this, "getOptions");
            return n2;
        }
        Object var7_6 = null;
        if (!Trace.isOn) return n;
        Trace.exit(this, "getOptions");
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOptionSet(String string, String string2) throws JMSException {
        boolean bl;
        if (Trace.isOn) {
            Trace.entry(this, "isOptionSet(String, String)");
        }
        try {
            try {
                int n = MQBrokerMessage.optionToFlag(string, string2);
                bl = this.isOptionSet(string, n);
                Object var6_6 = null;
                if (!Trace.isOn) return bl;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "isOptionSet(String, String)");
            throw throwable;
        }
        Trace.exit(this, "isOptionSet(String, String)");
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isOptionSet(String string, int n) throws JMSException {
        boolean bl;
        block8: {
            boolean bl2;
            block7: {
                if (Trace.isOn) {
                    Trace.entry(this, "isOptionSet(String, int)");
                }
                try {
                    try {
                        Object v = this.nameValuePairs.get(string);
                        if (v == null) {
                            bl2 = false;
                            Object var8_6 = null;
                            if (!Trace.isOn) return bl2;
                            break block7;
                        }
                        if (!(v instanceof Integer)) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS3040", string);
                            throw jMSException;
                        }
                        int n2 = (Integer)v;
                        bl = (n2 & n) == n;
                        break block8;
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) throw jMSException;
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                        throw jMSException;
                    }
                }
                catch (Throwable throwable) {
                    Object var8_8 = null;
                    if (!Trace.isOn) throw throwable;
                    Trace.exit(this, "isOptionSet(String, int)");
                    throw throwable;
                }
            }
            Trace.exit(this, "isOptionSet(String, int)");
            return bl2;
        }
        Object var8_7 = null;
        if (!Trace.isOn) return bl;
        Trace.exit(this, "isOptionSet(String, int)");
        return bl;
    }

    public void setEncoding(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setEncoding");
            Trace.exit(this, "setEncoding");
        }
        this.encoding = n;
    }

    public int getEncoding() {
        if (Trace.isOn) {
            Trace.entry(this, "getEncoding");
            Trace.exit(this, "getEncoding");
        }
        return this.encoding;
    }

    public void setCodedCharSetId(int n) {
        if (Trace.isOn) {
            Trace.entry(this, "setCodedCharSetId");
            Trace.exit(this, "setCodedCharSetId");
        }
        this.codedCharSetId = n;
    }

    public int getCodedCharSetId() {
        if (Trace.isOn) {
            Trace.entry(this, "getCodedCharSetId");
            Trace.exit(this, "getCodedCharSetId");
        }
        return this.codedCharSetId;
    }

    public void setFormat(String string) {
        if (Trace.isOn) {
            Trace.entry(this, "setFormat");
            Trace.exit(this, "setFormat");
        }
        this.format = string;
    }

    public String getFormat() {
        if (Trace.isOn) {
            Trace.entry(this, "getFormat");
            Trace.exit(this, "getFormat");
        }
        return this.format;
    }

    public abstract void writeToMessage(MQMsg2 var1) throws JMSException;

    public abstract void initializeFromMessage(MQMsg2 var1) throws JMSException;

    public abstract String getHeaderFormat();

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MQBrokerMessage fromMessage(MQMsg2 mQMsg2) throws JMSException {
        MQBrokerMessage mQBrokerMessage;
        if (Trace.isOn) {
            Trace.entry(clsName, "fromMessage");
        }
        try {
            try {
                int n;
                int n2;
                try {
                    n2 = mQMsg2.readInt(1);
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(clsName, "Caught " + exception);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1089", exception.toString());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                try {
                    n = mQMsg2.readInt(mQMsg2.getEncoding());
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(clsName, "caught " + exception);
                    }
                    try {
                        mQMsg2.skipReadingBytes(-4);
                    }
                    catch (Exception exception2) {
                        // empty catch block
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1089", exception.toString());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                try {
                    mQMsg2.skipReadingBytes(-8);
                }
                catch (Exception exception) {
                    if (Trace.isOn) {
                        Trace.trace(clsName, "caught " + exception);
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1089", exception.toString());
                    jMSException.setLinkedException(exception);
                    throw jMSException;
                }
                MQBrokerMessage mQBrokerMessage2 = n2 == 1380337696 || n2 == -641284032 ? (n == 1 ? new RFH1BrokerMessageImpl() : (n == 2 ? new RFH2BrokerMessageImpl() : null)) : null;
                if (mQBrokerMessage2 == null) {
                    if (Trace.isOn) {
                        Trace.trace(clsName, "Message header not understood");
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3042");
                    throw jMSException;
                }
                ((MQBrokerMessage)mQBrokerMessage2).initializeFromMessage(mQMsg2);
                mQBrokerMessage = mQBrokerMessage2;
                Object var6_14 = null;
                if (!Trace.isOn) return mQBrokerMessage;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(clsName, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(clsName, "fromMessage");
            throw throwable;
        }
        Trace.exit(clsName, "fromMessage");
        return mQBrokerMessage;
    }

    static {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        hashtable.put(MQPS_LOCAL, new Integer(4));
        optionFields.put(MQPS_DELETE_OPTIONS, hashtable);
        hashtable = new Hashtable();
        hashtable.put(MQPS_CORREL_ID_AS_IDENTITY, new Integer(1));
        hashtable.put(MQPS_ANONYMOUS, new Integer(2));
        hashtable.put(MQPS_LOCAL, new Integer(4));
        hashtable.put(MQPS_DIRECT_REQUESTS, new Integer(8));
        hashtable.put(MQPS_NEW_PUBLICATIONS_ONLY, new Integer(16));
        hashtable.put(MQPS_PUBLISH_ON_REQUEST_ONLY, new Integer(32));
        hashtable.put(MQPS_DEREGISTER_ALL, new Integer(64));
        hashtable.put(MQPS_INCLUDE_STREAM_NAME, new Integer(128));
        hashtable.put(MQPS_INFORM_IF_RETAINED, new Integer(256));
        hashtable.put(MQPS_DUPLICATES_OK, new Integer(512));
        hashtable.put(MQPS_NON_PERSISTENT, new Integer(1024));
        hashtable.put(MQPS_PERSISTENT, new Integer(2048));
        hashtable.put(MQPS_PERSISTENT_AS_PUBLISH, new Integer(4096));
        hashtable.put(MQPS_PERSISTENT_AS_Q, new Integer(8192));
        hashtable.put(MQPS_ADD_NAME, new Integer(16384));
        hashtable.put(MQPS_NO_ALTERATION, new Integer(32768));
        hashtable.put(MQPS_FULL_RESPONSE, new Integer(65536));
        hashtable.put(MQPS_JOIN_SHARED, new Integer(131072));
        hashtable.put(MQPS_JOIN_EXCLUSIVE, new Integer(262144));
        hashtable.put(MQPS_LEAVE_ONLY, new Integer(524288));
        hashtable.put(MQPS_VARIABLE_USER_ID, new Integer(0x100000));
        hashtable.put(MQPS_LOCKED, new Integer(0x200000));
        optionFields.put(MQPS_REGISTRATION_OPTIONS, hashtable);
        hashtable = new Hashtable();
        hashtable.put(MQPS_CORREL_ID_AS_IDENTITY, new Integer(1));
        hashtable.put(MQPS_RETAIN_PUBLICATION, new Integer(2));
        hashtable.put(MQPS_OTHER_SUBSCRIBERS_ONLY, new Integer(4));
        hashtable.put(MQPS_NO_REGISTRATION, new Integer(8));
        hashtable.put(MQPS_IS_RETAINED_PUBLICATION, new Integer(16));
        optionFields.put(MQPS_PUBLICATION_OPTIONS, hashtable);
    }
}

