/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.util.RealDispatcher;
import com.ibm.disthubmq.impl.util.SafeDispatchQueue;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.JMSWrappedException;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;

public class ExceptionDispatchThread
implements RealDispatcher,
ClientLogConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/ExceptionDispatchThread.java, jms, j521, j521-L020126 02/01/25 15:16:26 @(#) 1.6.1.1";
    private static final DebugObject debug = new DebugObject("ExceptionDispatchThread");
    static ExceptionDispatchThread xThread = new ExceptionDispatchThread();
    private SafeDispatchQueue q;

    public ExceptionDispatchThread() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ExceptionDispatchThread");
        }
        this.q = new SafeDispatchQueue(this);
        ConnectionImpl.threadProvider.schedule(this.q);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ExceptionDispatchThread");
        }
    }

    public void enqueue(ExceptionListener exceptionListener, Exception exception) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "enqueue", exceptionListener, exception);
        }
        QueueElement queueElement = new QueueElement(exceptionListener, exception);
        this.q.enqueue(queueElement);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "enqueue");
        }
    }

    public void close() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.q.close();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    public void dispatch(Object object) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "dispatch", object);
        }
        QueueElement queueElement = (QueueElement)object;
        try {
            if (queueElement.el != null) {
                JMSException jMSException = queueElement.e instanceof JMSException ? (JMSException)((Object)queueElement.e) : new JMSWrappedException(queueElement.e);
                queueElement.el.onException(jMSException);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "dispatch");
        }
    }

    class QueueElement {
        ExceptionListener el;
        Exception e;

        QueueElement(ExceptionListener exceptionListener, Exception exception) {
            this.el = exceptionListener;
            this.e = exception;
        }
    }
}

