/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQMessage;
import com.ibm.mq.jms.MQJMSMessage;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;

class DLH {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/DLH.java, jms, j521, j521-L020126 02/01/25 15:21:55 @(#) 1.5.1.1";
    private static final String MQDLH_STRUC_ID = "DLH ";
    private static final int MQDLH_VERSION_1 = 1;
    private String strucId;
    private int version;
    int reason;
    String destQName;
    String destQMgrName;
    private int encoding;
    private int codedCharSetId;
    private String format;
    int putApplType;
    String putApplName;
    String putDate;
    String putTime;
    private int msgCharSet;
    private int msgEncoding;

    DLH() {
        this.strucId = MQDLH_STRUC_ID;
        this.version = 1;
        this.reason = 0;
        this.destQName = Utils.padString(null, 48);
        this.destQMgrName = Utils.padString(null, 48);
        this.encoding = 273;
        this.codedCharSetId = 0;
        this.format = "        ";
        this.putApplType = 0;
        this.putApplName = Utils.padString(null, 28);
        this.putDate = Utils.padString(null, 8);
        this.putTime = Utils.padString(null, 8);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DLH(MQMessage mQMessage) throws JMSException {
        try {
            if (Trace.isOn) {
                Trace.entry(this, "constructor(message)");
            }
            if (mQMessage == null) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1074");
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            this.msgCharSet = mQMessage.characterSet;
            this.msgEncoding = mQMessage.encoding;
            try {
                byte[] byArray = new byte[4];
                mQMessage.readFully(byArray, 0, 4);
                this.strucId = this.getString(byArray);
                if (!this.strucId.equals(MQDLH_STRUC_ID)) {
                    throw new Exception("strucId");
                }
                this.version = mQMessage.readInt();
                if (this.version != 1) {
                    throw new Exception("version");
                }
                this.reason = mQMessage.readInt();
                byArray = new byte[48];
                mQMessage.readFully(byArray, 0, 48);
                this.destQName = this.getString(byArray);
                mQMessage.readFully(byArray, 0, 48);
                this.destQMgrName = this.getString(byArray);
                this.encoding = mQMessage.readInt();
                this.codedCharSetId = mQMessage.readInt();
                byArray = new byte[4];
                mQMessage.readFully(byArray, 0, 4);
                this.format = this.getString(byArray);
                this.putApplType = mQMessage.readInt();
                byArray = new byte[28];
                mQMessage.readFully(byArray, 0, 28);
                this.putApplName = this.getString(byArray);
                byArray = new byte[8];
                mQMessage.readFully(byArray, 0, 8);
                this.putDate = this.getString(byArray);
                mQMessage.readFully(byArray, 0, 8);
                this.putTime = this.getString(byArray);
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1076");
                jMSException.setLinkedException(exception);
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "constructor(message)");
            throw throwable;
        }
        Trace.exit(this, "constructor(message)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void write(MQMessage mQMessage) throws JMSException {
        try {
            try {
                if (Trace.isOn) {
                    Trace.entry(this, "write");
                }
                this.encoding = mQMessage.encoding;
                this.codedCharSetId = mQMessage.characterSet;
                this.format = mQMessage.format;
                mQMessage.encoding = 273;
                mQMessage.characterSet = 0;
                mQMessage.format = "MQDEAD  ";
                int n = mQMessage.getMessageLength();
                byte[] byArray = new byte[n];
                mQMessage.seek(0);
                mQMessage.readFully(byArray);
                mQMessage.seek(0);
                this.writeDLHFields(mQMessage);
                mQMessage.write(byArray);
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1075");
                jMSException.setLinkedException(exception);
                throw jMSException;
            }
            Object var5_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "write");
            throw throwable;
        }
        Trace.exit(this, "write");
    }

    private void writeDLHFields(MQMessage mQMessage) throws IOException {
        mQMessage.writeString(this.strucId);
        mQMessage.writeInt(this.version);
        mQMessage.writeInt(this.reason);
        mQMessage.writeString(Utils.padString(this.destQName, 48));
        mQMessage.writeString(Utils.padString(this.destQMgrName, 48));
        mQMessage.writeInt(this.encoding);
        mQMessage.writeInt(this.codedCharSetId);
        mQMessage.writeString(this.format);
        mQMessage.writeInt(this.putApplType);
        mQMessage.writeString(Utils.padString(this.putApplName, 28));
        mQMessage.writeString(Utils.padString(this.putDate, 8));
        mQMessage.writeString(Utils.padString(this.putTime, 8));
    }

    private String getString(byte[] byArray) throws UnsupportedEncodingException {
        return new String(byArray, MQJMSMessage.getCharacterSetString(this.msgCharSet, this.msgEncoding));
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("StrucId='" + this.strucId + "'\n");
        stringBuffer.append("Version=" + this.version + "\n");
        stringBuffer.append("Reason=" + this.reason + "\n");
        stringBuffer.append("DestQName='" + this.destQName + "'\n");
        stringBuffer.append("DestQMgrName='" + this.destQMgrName + "'\n");
        stringBuffer.append("Encoding=" + this.encoding + "\n");
        stringBuffer.append("CodedCharSetId=" + this.codedCharSetId + "\n");
        stringBuffer.append("Format='" + this.format + "'\n");
        stringBuffer.append("PutApplType=" + this.putApplType + "\n");
        stringBuffer.append("PutApplName='" + this.putApplName + "'\n");
        stringBuffer.append("PutDate='" + this.putDate + "'\n");
        stringBuffer.append("PutTime='" + this.putTime + "'");
        return stringBuffer.toString();
    }
}

