/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.SchemaRegistry;
import com.ibm.disthubmq.impl.util.FastVector;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionImpl;
import com.ibm.mq.jms.SessionConfig;
import javax.jms.JMSException;

public final class ConnectionMonitor
implements Runnable,
ClientExceptionConstants,
ClientLogConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/ConnectionMonitor.java, jms, j000 02/04/05 14:57:10 @(#) 1.8";
    private static final DebugObject debug = new DebugObject("ConnectionMonitor");
    private static volatile FastVector aFVConns = new FastVector();
    private static volatile ConnectionMonitor act = null;
    boolean die = false;
    private static final int PING_PRIORITY = 11;

    public static void addConnection(ConnectionImpl connectionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "addConnection", connectionImpl);
        }
        connectionImpl.lastMRTime = ConnectionImpl.pingClock;
        ConnectionMonitor connectionMonitor = null;
        FastVector fastVector = aFVConns;
        synchronized (fastVector) {
            if (connectionImpl.ixFVConns == -1) {
                connectionImpl.ixFVConns = aFVConns.addElementI(connectionImpl);
                if (ConnectionMonitor.aFVConns.m_count == 1) {
                    act = connectionMonitor = new ConnectionMonitor();
                }
            }
        }
        if (connectionMonitor != null) {
            ConnectionImpl.threadProvider.schedule(connectionMonitor);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "addConnection");
        }
    }

    public static void removeConnection(ConnectionImpl connectionImpl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "removeConnection", connectionImpl);
        }
        ConnectionMonitor connectionMonitor = null;
        FastVector fastVector = aFVConns;
        synchronized (fastVector) {
            int n = connectionImpl.ixFVConns;
            if (n != -1) {
                ConnectionImpl connectionImpl2 = (ConnectionImpl)aFVConns.dropElementAt(n);
                if (connectionImpl2 != null) {
                    connectionImpl2.ixFVConns = n;
                }
                if (ConnectionMonitor.aFVConns.m_count == 0) {
                    connectionMonitor = act;
                    act = null;
                }
            }
            connectionImpl.ixFVConns = -1;
        }
        if (connectionMonitor != null) {
            ConnectionMonitor connectionMonitor2 = connectionMonitor;
            synchronized (connectionMonitor2) {
                connectionMonitor.die = true;
                connectionMonitor.notify();
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "removeConnection");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        if (ConnectionMonitor.debug.debugIt(32)) {
            ConnectionMonitor.debug.debug(-175921860444055L, "run");
        }
        var1_1 = SchemaRegistry.getSchemaCursor((short)0, -8843998126721588213L);
        var2_2 = var1_1.getContents();
        var2_2.setByteArray(0, new byte[0]);
        var2_2.setBoolean(1, false);
        var2_2.setChoice(2, 0);
        var2_2.setByte(3, (byte)11);
        var2_2.setBoolean(4, false);
        var2_2.setString(5, "");
        var2_2.setChoice(6, 0);
        var2_2.setChoice(7, 2);
        var3_3 = 0L;
        var5_4 = 0L;
        var7_5 = 0L;
        var9_6 = 0L;
        var11_7 = 0L;
        var13_8 = 0L;
        var15_9 = 0;
        var16_10 = 0;
        var17_11 = 0;
        while (true) lbl-1000:
        // 6 sources

        {
            var18_12 = SessionConfig.CLIENT_PING_INTERVAL;
            var19_13 = SessionConfig.PING_MIN;
            var20_14 = SessionConfig.PING_TIMEOUT_MULTIPLE;
            if (var18_12 <= 0) ** break;
            try {
                var21_15 = ConnectionMonitor.aFVConns.m_count;
                var22_17 = ConnectionMonitor.aFVConns.m_data;
                var11_7 = System.currentTimeMillis();
                var13_8 = var11_7 + (long)var18_12;
                ConnectionImpl.pingClock = var11_7;
                if (var21_15 > 0) {
                    var7_5 = (long)var18_12 - var9_6;
                    if (var7_5 < 1L) {
                        var7_5 = 1L;
                    }
                    var16_10 = 1;
                    var15_9 = (int)(var7_5 / (long)var21_15);
                    if (var15_9 < var19_13) {
                        var15_9 = var19_13;
                        var23_19 = (int)(var7_5 / (long)var19_13);
                        if (var23_19 <= 0) {
                            var23_19 = 1;
                        }
                        var16_10 = (var21_15 + var23_19 - 1) / var23_19;
                    }
                    if (ConnectionMonitor.debug.debugIt(16)) {
                        ConnectionMonitor.debug.debug(-175921860444056L, "beg sweep: i=" + var21_15 + " ibn=" + var16_10 + " ibt=" + var15_9 + " ag=" + var7_5 + " x=" + var3_3);
                    }
                    while (var21_15 > 0) {
                        var17_11 = var16_10;
                        while (var21_15 > 0 && var17_11 > 0) {
                            if ((var23_20 = (ConnectionImpl)var22_17[--var21_15]) != null && var23_20.isActive() && (var3_3 = var11_7 - var23_20.lastMRTime) > (long)var18_12) {
                                if (++var23_20.pingCnt <= var20_14) {
                                    if (ConnectionMonitor.debug.debugIt(16)) {
                                        ConnectionMonitor.debug.debug(-175921860444056L, "pinging " + var23_20.hostandportString());
                                    }
                                    var23_20.send(var1_1);
                                } else {
                                    if (ConnectionMonitor.debug.debugIt(16)) {
                                        ConnectionMonitor.debug.debug(-175921860444056L, "reaping " + var23_20.hostandportString());
                                    }
                                    var23_20.connectionDropped((Exception)new JMSException("ConnectionMonitor timeout"), false);
                                }
                            }
                            --var17_11;
                        }
                        if (var21_15 <= 0) continue;
                        this.xwait(var15_9);
                        ConnectionImpl.pingClock = var11_7 += (long)var15_9;
                    }
                    var5_4 = System.currentTimeMillis();
                    var9_6 = var5_4 - var11_7;
                    var3_3 = var13_8 - var5_4;
                    ConnectionImpl.pingClock = var5_4;
                    if (var3_3 < (long)var19_13) ** GOTO lbl-1000
                    this.xwait(var3_3);
                }
                this.xwait(var18_12);
            }
            catch (KillMon var21_16) {
                if (ConnectionMonitor.debug.debugIt(16)) {
                    ConnectionMonitor.debug.debug(-175921860444056L, "decommissioned");
                }
                if (ConnectionMonitor.debug.debugIt(64)) {
                    ConnectionMonitor.debug.debug(-175921860444054L, "run");
                }
                return;
            }
            catch (Throwable var22_18) {
                if (!ConnectionMonitor.debug.debugIt(16)) ** GOTO lbl-1000
                ConnectionMonitor.debug.debug(-175921860444056L, "caught: " + var22_18);
                continue;
            }
            break;
        }
        ** GOTO lbl-1000
        if (ConnectionMonitor.debug.debugIt(64)) {
            ConnectionMonitor.debug.debug(-175921860444054L, "run");
        }
    }

    private final synchronized void xwait(long l) throws KillMon {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "xwait", new Long(l));
        }
        if (!this.die) {
            try {
                this.wait(l);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.die) {
            throw new KillMon(ExceptionBuilder.buildReasonString(1088, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "xwait");
        }
    }

    private class KillMon
    extends Exception {
        protected KillMon(String string) {
            super(string);
        }
    }
}

