/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.client.ThreadProvider;
import com.ibm.disthubmq.impl.client.ConnectorImpl;
import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.matching.BadMessageFormatMatchingException;
import com.ibm.disthubmq.impl.matching.CursorWrapper;
import com.ibm.disthubmq.impl.matching.EvalCache;
import com.ibm.disthubmq.impl.matching.MatchSpace;
import com.ibm.disthubmq.impl.matching.MatchingException;
import com.ibm.disthubmq.impl.util.FastVector;
import com.ibm.disthubmq.impl.util.SocketThreadPool;
import com.ibm.disthubmq.impl.util.SocketThreadPoolClient;
import com.ibm.disthubmq.impl.util.SocketThreadPoolClientHndl;
import com.ibm.disthubmq.impl.util.SocketThreadPoolException;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.ConnectionMonitor;
import com.ibm.mq.jms.ExceptionDispatchThread;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MessageConsumerImpl;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.SearchResults;
import com.ibm.mq.jms.SessionConfig;
import com.ibm.mq.jms.SessionImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.psk.Trace;
import java.io.IOException;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.jms.Connection;
import javax.jms.ConnectionMetaData;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;

public abstract class ConnectionImpl
extends ConnectorImpl
implements Connection,
SocketThreadPoolClient,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/ConnectionImpl.java, jms, j521, j521-L020523 02/05/22 18:33:26 @(#) 1.10.1.8";
    private static final DebugObject debug = new DebugObject("ConnectionImpl");
    private String clientID = null;
    private boolean clientIDFixed = false;
    public static ThreadProvider threadProvider = new ThreadProvider(){

        public void schedule(Runnable runnable) {
            Runnable runnable2 = runnable;
            Thread thread = (Thread)AccessController.doPrivileged(new PrivilegedAction(this, runnable2){
                private final /* synthetic */ Runnable val$fr;
                private final /* synthetic */ 1 this$0;
                {
                    this.this$0 = var1_1;
                    this.val$fr = runnable;
                }

                public Object run() {
                    try {
                        Thread thread = new Thread(this.val$fr, this.val$fr.toString());
                        thread.setDaemon(true);
                        thread.start();
                        return thread;
                    }
                    catch (AccessControlException accessControlException) {
                        return null;
                    }
                }
            });
        }
    };
    private SocketThreadPoolClientHndl m_threadPoolHandle;
    private static SocketThreadPool s_clientSocketThreadPool;
    private ExceptionListener exceptionListener;
    private boolean active = true;
    protected boolean appConnectionClosed = true;
    protected Exception eConnectionClosed = null;
    public static volatile long pingClock;
    public volatile long lastMRTime;
    public int pingCnt = 0;
    int ixFVConns = -1;
    private String userName;
    MatchSpace matchSpace = new MatchSpace();
    private SearchResults matches = new SearchResults();
    private EvalCache cache = new EvalCache();
    protected boolean stopped = true;
    private static boolean threadPoolChecked;
    private static long midMask;
    static /* synthetic */ Class class$com$ibm$mq$jms$SessionConfig;

    private static synchronized boolean isThreadPooled() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isThreadPooled");
        }
        boolean bl = true;
        if (threadPoolChecked) {
            bl = s_clientSocketThreadPool != null;
        } else {
            int n = SessionConfig.MAX_CLIENT_READ_THREADS;
            if (n == 0) {
                threadPoolChecked = true;
                bl = false;
            } else {
                System.err.println("Threadpooling active with " + n + " threads.");
                int n2 = SessionConfig.CLIENT_THREAD_POLLING_INTERVAL;
                try {
                    Class<?> clazz = Class.forName("com.ibm.disthubmq.impl.util.ASocketThreadPool");
                    s_clientSocketThreadPool = (SocketThreadPool)clazz.newInstance();
                }
                catch (Exception exception) {
                    throw new RuntimeException(ExceptionBuilder.buildReasonString(1079, new Object[]{exception}));
                }
                s_clientSocketThreadPool.setMaxThreads(n, 0);
                s_clientSocketThreadPool.setPollingInterval(n2);
                s_clientSocketThreadPool.start();
                threadPoolChecked = true;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isThreadPooled", new Boolean(bl));
        }
        return bl;
    }

    protected Class configClass() {
        return class$com$ibm$mq$jms$SessionConfig == null ? (class$com$ibm$mq$jms$SessionConfig = ConnectionImpl.class$("com.ibm.mq.jms.SessionConfig")) : class$com$ibm$mq$jms$SessionConfig;
    }

    protected ConnectionImpl(String string, String string2, int n, String string3, String string4) throws IOException {
        super(string, string2, n, string3, string4, null, false);
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "ConnectionImpl", string, string2, new Integer(n), string3, "********");
        }
        if (ConnectionImpl.isThreadPooled()) {
            try {
                this.m_threadPoolHandle = s_clientSocketThreadPool.registerClient(this.socket.getSocket(), this);
                this.m_threadPoolHandle.readyToRead();
            }
            catch (SocketThreadPoolException socketThreadPoolException) {
                throw new IOException(ExceptionBuilder.buildReasonString(1083, new Object[]{socketThreadPoolException}));
            }
        } else {
            threadProvider.schedule(this);
        }
        this.userName = string3;
        ConnectionMonitor.addConnection(this);
        this.startDelivery();
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "ConnectionImpl");
        }
    }

    public void close() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "close");
        }
        this.active = false;
        this.exceptionListener = null;
        super.close(!this.appConnectionClosed);
        if (this.m_threadPoolHandle != null) {
            try {
                this.m_threadPoolHandle.deregisterClient();
            }
            catch (SocketThreadPoolException socketThreadPoolException) {
                // empty catch block
            }
        }
        ConnectionMonitor.removeConnection(this);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "close");
        }
    }

    public void connectionDropped() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "connectionDropped");
        }
        this.connectionDropped(this.getException(), false);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "connectionDropped");
        }
    }

    public void newJMSMessage(SchemaCursor schemaCursor) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "newJMSMessage", schemaCursor);
        }
        MessageImpl messageImpl = MessageImpl.construct(schemaCursor);
        this.matches.reset();
        try {
            this.matchSpace.get(messageImpl.getJMSDestinationString(), new CursorWrapper(schemaCursor), this.matches, this.cache);
        }
        catch (MatchingException matchingException) {
        }
        catch (BadMessageFormatMatchingException badMessageFormatMatchingException) {
            // empty catch block
        }
        if (this.matches.m_receivers.m_count > 0) {
            FastVector fastVector = this.matches.m_receivers;
            int n = 0;
            while (n < fastVector.m_count) {
                MessageConsumerImpl messageConsumerImpl = (MessageConsumerImpl)fastVector.m_data[n];
                messageConsumerImpl.newMessage(messageImpl);
                ++n;
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "newJMSMessage");
        }
    }

    protected void handleMessage(byte[] byArray) throws IOException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "handleMessage", byArray);
        }
        this.lastMRTime = pingClock;
        this.pingCnt = 0;
        super.handleMessage(byArray);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "handleMessage");
        }
    }

    public void connectionDropped(Exception exception, boolean bl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "connectionDropped", exception, new Boolean(bl));
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            ExceptionListener exceptionListener = this.exceptionListener;
            this.appConnectionClosed = bl;
            this.eConnectionClosed = exception;
            try {
                this.close();
            }
            catch (JMSException jMSException) {
                // empty catch block
            }
            if (exceptionListener != null) {
                ExceptionDispatchThread.xThread.enqueue(exceptionListener, exception);
            }
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "connectionDropped");
        }
    }

    String getTemporaryTopicString(String string) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getTemporaryTopicString", string);
        }
        String string2 = this.createTemporaryTopicString(string);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getTermporaryTopicString", string2);
        }
        return string2;
    }

    public String getClientID() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getClientID");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getClientID", this.clientID);
        }
        if (this.clientID == null || this.clientID.equals("")) {
            return this.userName;
        }
        return this.clientID;
    }

    public void setClientID(String string) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setClientID", this.clientID);
        }
        if (this.clientIDFixed) {
            String string2 = ConfigEnvironment.getErrorMessage("MQJMS3031");
            throw new IllegalStateException(string2);
        }
        if (string == null) {
            String string3 = "MQJMS0002";
            String string4 = ConfigEnvironment.getErrorMessage(string3);
            throw new IllegalStateException(string4, string3);
        }
        if (this.clientID != null) {
            String string5 = "MQJMS3032";
            String string6 = ConfigEnvironment.getErrorMessage(string5);
            throw new IllegalStateException(string6, string5);
        }
        this.clientID = string;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setClientID", this.clientID);
        }
    }

    void setClientIDFixed() {
        this.clientIDFixed = true;
    }

    public ConnectionMetaData getMetaData() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getMetaData");
        }
        this.checkConnectionOpen();
        MQConnectionMetaData mQConnectionMetaData = new MQConnectionMetaData(2);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getMetaData", mQConnectionMetaData);
        }
        return mQConnectionMetaData;
    }

    public void setExceptionListener(ExceptionListener exceptionListener) throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "setExceptionListener", exceptionListener);
        }
        ConnectionImpl connectionImpl = this;
        synchronized (connectionImpl) {
            this.exceptionListener = exceptionListener;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "setExceptionListener");
        }
    }

    public ExceptionListener getExceptionListener() throws JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "getExceptionListener");
        }
        if (this.exceptionListener == null) {
            throw new IllegalStateException(ExceptionBuilder.buildReasonString(1085, null));
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "getExceptionListener", this.exceptionListener);
        }
        return this.exceptionListener;
    }

    protected boolean isActive() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isActive");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isClosed", new Boolean(this.active));
        }
        return this.active;
    }

    protected boolean isClosed() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isClosed");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isClosed", new Boolean(!this.active));
        }
        return !this.active;
    }

    protected void deactivate() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "deactivate");
        }
        this.active = false;
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "deactivate");
        }
    }

    abstract void closed(SessionImpl var1);

    boolean isLocalMid(long l) {
        boolean bl;
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isLocalMid", new Long(l));
        }
        boolean bl2 = bl = (l & midMask) == (this.messageId & midMask);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isLocalMid", new Boolean(bl));
        }
        return bl;
    }

    public boolean doRead() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "doRead");
        }
        boolean bl = false;
        try {
            this.m_threadPoolHandle.beginRead();
            byte[] byArray = this.receive();
            this.m_threadPoolHandle.endRead();
            this.handleMessage(byArray);
            bl = true;
        }
        catch (IOException iOException) {
            this.setException(iOException);
            bl = false;
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "doRead", new Boolean(bl));
        }
        return bl;
    }

    public boolean doWrite() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "doWrite");
        }
        throw new RuntimeException(ExceptionBuilder.buildReasonString(1086, null));
    }

    public void culled(SocketThreadPoolClientHndl socketThreadPoolClientHndl) {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "culled", socketThreadPoolClientHndl);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "culled");
        }
    }

    boolean isStopped() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isStopped");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isStopped", new Boolean(this.stopped));
        }
        return this.stopped;
    }

    boolean isStarted() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "isStarted");
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "isStarted", new Boolean(!this.stopped));
        }
        return !this.stopped;
    }

    void checkConnectionOpen() throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "checkConnectionOpen");
        }
        if (this.isClosed()) {
            String string = "MQJMS1004";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            IllegalStateException illegalStateException = new IllegalStateException(string2, string);
            if (Trace.isOn) {
                Trace.trace(this, "Connection is closed. Throwing IllegalStateException.");
            }
            throw illegalStateException;
        }
        if (Trace.isOn) {
            Trace.exit(this, "checkConnectionOpen");
        }
    }

    public abstract void stop() throws JMSException;

    public abstract void start() throws JMSException;

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        pingClock = System.currentTimeMillis();
        midMask = -4294967296L;
    }
}

