/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQEnvironment;
import com.ibm.mq.jms.Cleanup;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Vector;
import javax.jms.JMSException;

class CleanupHandle {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/CleanupHandle.java, jms, j521, j521-L020613 02/06/12 10:40:57 @(#) 1.4.1.5";
    private static final String CLSNAME = "CleanupHandle";
    private static final int CLEANUP_PROPERTY_NOT_SET = -1;
    private static final int CLEANUP_PROPERTY_ERROR = -2;
    String qmgrKey;
    int cleanupLevel;
    long cleanupInterval;
    Cleanup cleanupInstance;
    static int cleanupProperty = -1;
    static String invalidCleanupValue = null;
    static Object updateLock = new Object();
    static Hashtable cleanups = new Hashtable();
    static Hashtable handles = new Hashtable();

    private CleanupHandle(String string, int n, long l) {
        if (Trace.isOn) {
            Trace.entry(this, "CleanupHandle (constructor)");
        }
        this.qmgrKey = string;
        this.cleanupLevel = n;
        this.cleanupInterval = l;
        if (Trace.isOn) {
            Trace.trace(this, "Instantiated with following parameters:");
            Trace.trace(this, "qmgrKey         = " + string);
            Trace.trace(this, "cleanupLevel    = " + this.cleanupLevel);
            Trace.trace(this, "cleanupInterval = " + this.cleanupInterval);
        }
        if (Trace.isOn) {
            Trace.exit(this, "CleanupHandle (constructor)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CleanupHandle createCleanupHandle(MQTopicConnectionFactory mQTopicConnectionFactory, String string) throws JMSException {
        CleanupHandle cleanupHandle;
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "createCleanupHandle");
        }
        try {
            try {
                if (string == null) {
                    string = mQTopicConnectionFactory.getQueueManager();
                }
                String string2 = null;
                int n = mQTopicConnectionFactory.getTransportType();
                switch (n) {
                    case 0: 
                    case 3: {
                        string2 = string;
                        break;
                    }
                    case 1: {
                        string2 = string + ":" + mQTopicConnectionFactory.getHostName() + ":" + mQTopicConnectionFactory.getPort();
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                        throw jMSException;
                    }
                }
                int n2 = mQTopicConnectionFactory.getCleanupLevel();
                if (n2 == -1) {
                    if (cleanupProperty == -2) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", invalidCleanupValue);
                        throw jMSException;
                    }
                    n2 = cleanupProperty;
                }
                CleanupHandle cleanupHandle2 = new CleanupHandle(string2, n2, mQTopicConnectionFactory.getCleanupInterval());
                if (n2 != 0) {
                    cleanupHandle2.cleanupInstance = CleanupHandle.obtainCleanupInstance(string2, mQTopicConnectionFactory);
                    CleanupHandle.addCleanupHandle(cleanupHandle2);
                }
                cleanupHandle = cleanupHandle2;
                Object var9_10 = null;
                if (!Trace.isOn) return cleanupHandle;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "createCleanupHandle");
            throw throwable;
        }
        Trace.exit(CLSNAME, "createCleanupHandle");
        return cleanupHandle;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CleanupHandle createCleanupHandle(MQTopicConnectionFactory mQTopicConnectionFactory, String string, Hashtable hashtable) throws JMSException {
        CleanupHandle cleanupHandle;
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "createCleanupHandle");
        }
        try {
            try {
                if (string == null) {
                    string = mQTopicConnectionFactory.getQueueManager();
                }
                String string2 = null;
                int n = mQTopicConnectionFactory.getTransportType();
                switch (n) {
                    case 0: 
                    case 3: {
                        string2 = string;
                        break;
                    }
                    case 1: {
                        string2 = string + ":" + mQTopicConnectionFactory.getHostName() + ":" + mQTopicConnectionFactory.getPort();
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(n));
                        throw jMSException;
                    }
                }
                int n2 = mQTopicConnectionFactory.getCleanupLevel();
                if (n2 == -1) {
                    if (cleanupProperty == -2) {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", invalidCleanupValue);
                        throw jMSException;
                    }
                    n2 = cleanupProperty;
                }
                CleanupHandle cleanupHandle2 = new CleanupHandle(string2, n2, mQTopicConnectionFactory.getCleanupInterval());
                if (n2 != 0) {
                    cleanupHandle2.cleanupInstance = CleanupHandle.obtainCleanupInstance(string2, mQTopicConnectionFactory, hashtable);
                    CleanupHandle.addCleanupHandle(cleanupHandle2);
                }
                cleanupHandle = cleanupHandle2;
                Object var10_11 = null;
                if (!Trace.isOn) return cleanupHandle;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_12 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "createCleanupHandle");
            throw throwable;
        }
        Trace.exit(CLSNAME, "createCleanupHandle");
        return cleanupHandle;
    }

    public void close() {
        if (Trace.isOn) {
            Trace.entry(this, "close");
        }
        if (this.cleanupLevel != 0) {
            this.removeCleanupHandle(this);
        }
        if (Trace.isOn) {
            Trace.exit(this, "close");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Cleanup obtainCleanupInstance(String string, MQTopicConnectionFactory mQTopicConnectionFactory) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "obtainCleanupInstance");
        }
        try {
            try {
                Cleanup cleanup = null;
                Object object = updateLock;
                // MONITORENTER : object
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "got updateLock");
                }
                if ((cleanup = (Cleanup)cleanups.get(string)) == null) {
                    cleanup = new Cleanup(mQTopicConnectionFactory);
                    cleanups.put(string, cleanup);
                }
                // MONITOREXIT : object
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "released updateLock");
                }
                Cleanup cleanup2 = cleanup;
                Object var6_6 = null;
                if (!Trace.isOn) return cleanup2;
                Trace.exit(CLSNAME, "obtainCleanupInstance");
                return cleanup2;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "obtainCleanupInstance");
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static Cleanup obtainCleanupInstance(String string, MQTopicConnectionFactory mQTopicConnectionFactory, Hashtable hashtable) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "obtainCleanupInstance");
        }
        try {
            try {
                Cleanup cleanup = null;
                Object object = updateLock;
                // MONITORENTER : object
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "got updateLock");
                }
                if ((cleanup = (Cleanup)cleanups.get(string)) == null) {
                    cleanup = new Cleanup(mQTopicConnectionFactory);
                    cleanups.put(string, cleanup);
                }
                // MONITOREXIT : object
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "released updateLock");
                }
                Cleanup cleanup2 = cleanup;
                Object var7_7 = null;
                if (!Trace.isOn) return cleanup2;
                Trace.exit(CLSNAME, "obtainCleanupInstance");
                return cleanup2;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "obtainCleanupInstance");
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void addCleanupHandle(CleanupHandle cleanupHandle) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "addCleanupHandle");
        }
        try {
            block17: {
                Object object;
                boolean bl = false;
                Object object2 = updateLock;
                synchronized (object2) {
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "got updateLock");
                    }
                    if ((object = (Vector[])handles.get(cleanupHandle.qmgrKey)) == null) {
                        object = new Vector[]{new Vector(), new Vector()};
                        handles.put(cleanupHandle.qmgrKey, object);
                    }
                    Vector vector = object[0];
                    Vector vector2 = object[1];
                    int n = 0;
                    int n2 = vector.size();
                    while (n < n2 && cleanupHandle.cleanupLevel < ((CleanupHandle)vector.elementAt((int)n)).cleanupLevel) {
                        ++n;
                    }
                    vector.insertElementAt(cleanupHandle, n);
                    n = 0;
                    n2 = vector2.size();
                    while (n < n2 && cleanupHandle.cleanupInterval > ((CleanupHandle)vector2.elementAt((int)n)).cleanupInterval) {
                        ++n;
                    }
                    vector2.insertElementAt(cleanupHandle, n);
                    int n3 = ((CleanupHandle)vector.elementAt((int)0)).cleanupLevel;
                    long l = ((CleanupHandle)vector2.elementAt((int)0)).cleanupInterval;
                    cleanupHandle.cleanupInstance.setCleanupLevel(n3);
                    cleanupHandle.cleanupInstance.setCleanupInterval(l);
                    int n4 = n2 + 1;
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Now " + n4 + " users with key " + cleanupHandle.qmgrKey);
                    }
                    if (n4 == 1) {
                        bl = true;
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "released updateLock");
                }
                if (!bl) break block17;
                if (Trace.isOn) {
                    Trace.trace(CLSNAME, "starting Cleanup");
                }
                object = MQEnvironment.createThread((Runnable)cleanupHandle.cleanupInstance, (String)("Cleanup(" + cleanupHandle.qmgrKey + ")"), (boolean)true);
                ((Thread)object).start();
            }
            Object var14_14 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "addCleanupHandle");
            throw throwable;
        }
        Trace.exit(CLSNAME, "addCleanupHandle");
        {
            return;
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            catch (SecurityException securityException) {
                if (!Trace.isOn) throw securityException;
                Trace.trace(CLSNAME, "Throwing " + securityException);
                throw securityException;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void removeCleanupHandle(CleanupHandle cleanupHandle) {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeCleanupHandle");
        }
        try {
            block15: {
                try {
                    Vector[] vectorArray;
                    boolean bl = false;
                    Object object = updateLock;
                    // MONITORENTER : object
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "got updateLock");
                    }
                    if ((vectorArray = (Vector[])handles.get(cleanupHandle.qmgrKey)) != null) {
                        Vector vector = vectorArray[0];
                        Vector vector2 = vectorArray[1];
                        vector.removeElement(cleanupHandle);
                        vector2.removeElement(cleanupHandle);
                        int n = vector.size();
                        if (n > 0) {
                            int n2 = ((CleanupHandle)vector.elementAt((int)0)).cleanupLevel;
                            long l = ((CleanupHandle)vector2.elementAt((int)0)).cleanupInterval;
                            cleanupHandle.cleanupInstance.setCleanupLevel(n2);
                            cleanupHandle.cleanupInstance.setCleanupInterval(l);
                        } else {
                            cleanups.remove(cleanupHandle.qmgrKey);
                            bl = true;
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Now " + n + " users with key " + cleanupHandle.qmgrKey);
                        }
                    }
                    // MONITOREXIT : object
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "released updateLock");
                    }
                    if (!bl) break block15;
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "stopping Cleanup");
                    }
                    cleanupHandle.cleanupInstance.stop();
                }
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Ignoring exception on removeCleanupHandle:");
                        Trace.exception(CLSNAME, "removeCleanupHandle", (Throwable)jMSException);
                    }
                    Object var13_12 = null;
                    if (!Trace.isOn) return;
                    Trace.exit(CLSNAME, "removeCleanupHandle");
                    return;
                }
            }
            Object var13_11 = null;
            if (!Trace.isOn) return;
            Trace.exit(CLSNAME, "removeCleanupHandle");
            return;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "removeCleanupHandle");
            throw throwable;
        }
    }

    public int getCleanupLevel() {
        if (Trace.isOn) {
            Trace.trace(CLSNAME, "current cleanup level: " + this.cleanupLevel);
        }
        return this.cleanupLevel;
    }

    static {
        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("com.ibm.mq.jms.cleanup");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        if (string != null) {
            if ((string = string.toUpperCase()).equals("NONE")) {
                cleanupProperty = 0;
            } else if (string.equals("SAFE")) {
                cleanupProperty = 1;
            } else if (string.equals("STRONG")) {
                cleanupProperty = 2;
            } else {
                cleanupProperty = -2;
                invalidCleanupValue = string;
            }
        }
        if (cleanupProperty == -1) {
            cleanupProperty = 1;
        }
    }
}

