/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.mq.MQException;
import com.ibm.mq.MQGetMessageOptions;
import com.ibm.mq.MQMsg2;
import com.ibm.mq.MQPutMessageOptions;
import com.ibm.mq.MQQueue;
import com.ibm.mq.MQQueueManager;
import com.ibm.mq.MQReceiveExit;
import com.ibm.mq.MQSecurityExit;
import com.ibm.mq.MQSendExit;
import com.ibm.mq.jms.MQBrokerMessage;
import com.ibm.mq.jms.MQConnection;
import com.ibm.mq.jms.MQConnectionFactory;
import com.ibm.mq.jms.MQConnectionMetaData;
import com.ibm.mq.jms.MQTopicConnectionFactory;
import com.ibm.mq.jms.Utils;
import com.ibm.mq.jms.services.ConfigEnvironment;
import com.ibm.mq.jms.services.Trace;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Hashtable;
import java.util.Locale;
import javax.jms.ExceptionListener;
import javax.jms.IllegalStateException;
import javax.jms.JMSException;
import javax.jms.TransactionInProgressException;

public class Cleanup
extends MQConnectionFactory
implements Runnable {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 2001, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/Cleanup.java, jms, j521, j521-L020613 02/06/12 10:39:56 @(#) 1.7.1.11";
    private static final String CLSNAME = "Cleanup";
    private static final String reportQueueName = "SYSTEM.JMS.REPORT.QUEUE";
    private static long assumeOld = 60000L;
    private static final int CAT_SUCC_DEREG = 1;
    private static final int CAT_SUCC_STOP = 2;
    private static final int CAT_SUCCESS = 3;
    private static final int CAT_UNSUCCESS = 4;
    private static final int CAT_PCF_RESPONSE = 5;
    private static final int CAT_UNRECOGNISED = 99;
    private static final int RESP_DONE = 0;
    private static final int RESP_TRY_LATER = 1;
    private static final int RESP_FAILED = 2;
    private static final byte[] dummyMessageText = new byte[]{77, 81, 32, 74, 77, 83, 32, 67, 108, 101, 97, 110, 117, 112, 32, 84, 101, 109, 112, 111, 114, 97, 114, 121, 32, 77, 101, 115, 115, 97, 103, 101};
    private static final String[] defaultNDQueues = new String[]{"SYSTEM.JMS.ND.SUBSCRIBER.QUEUE", "SYSTEM.JMS.ND.CC.SUBSCRIBER.QUEUE"};
    private static final byte[] blankMessageId = new byte[24];
    private boolean endCleanup = false;
    private ExceptionListener exceptionListener = null;
    private Object runLock = new Object();
    private boolean isRunning = false;
    private String userID = "";
    private String password = "";
    private long cleanupInterval = 3600000L;
    private int cleanupLevel = 1;

    public Cleanup() {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor)");
        }
        if (Trace.isOn) {
            Trace.exit(this, "Cleanup (constructor)");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cleanup(MQTopicConnectionFactory mQTopicConnectionFactory) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor - MQTopicConnectionFactory)");
        }
        try {
            try {
                int n;
                block11: {
                    block12: {
                        this.setQueueManager(mQTopicConnectionFactory.getQueueManager());
                        this.setTransportType(mQTopicConnectionFactory.getTransportType());
                        this.setHostName(mQTopicConnectionFactory.getHostName());
                        this.setPort(mQTopicConnectionFactory.getPort());
                        this.setChannel(mQTopicConnectionFactory.getChannel());
                        this.setCCSID(mQTopicConnectionFactory.getCCSID());
                        this.setReceiveExit(mQTopicConnectionFactory.getReceiveExit());
                        this.setReceiveExitInit(mQTopicConnectionFactory.getReceiveExitInit());
                        this.setSecurityExit(mQTopicConnectionFactory.getSecurityExit());
                        this.setSecurityExitInit(mQTopicConnectionFactory.getSecurityExitInit());
                        this.setSendExit(mQTopicConnectionFactory.getSendExit());
                        this.setSendExitInit(mQTopicConnectionFactory.getSendExitInit());
                        this.setCleanupInterval(mQTopicConnectionFactory.getCleanupInterval());
                        n = mQTopicConnectionFactory.getCleanupLevel();
                        if (n != -1) break block11;
                        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return System.getProperty("com.ibm.mq.jms.cleanup");
                                }
                                catch (AccessControlException accessControlException) {
                                    return "";
                                }
                            }
                        });
                        if (string == null) break block12;
                        if ((string = string.trim().toUpperCase()).equals("NONE")) {
                            n = 0;
                            break block11;
                        } else if (string.equals("SAFE")) {
                            n = 1;
                            break block11;
                        } else {
                            if (!string.equals("STRONG")) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", String.valueOf(n));
                                throw jMSException;
                            }
                            n = 2;
                        }
                        break block11;
                    }
                    n = 1;
                }
                this.setCleanupLevel(n);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "Cleanup (constructor - MQTopicConnectionFactory)", (Throwable)jMSException);
                throw jMSException;
            }
            Object var6_6 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "Cleanup (constructor - MQTopicConnectionFactory)");
            throw throwable;
        }
        Trace.exit(this, "Cleanup (constructor - MQTopicConnectionFactory)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Cleanup(MQTopicConnectionFactory mQTopicConnectionFactory, Hashtable hashtable) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "Cleanup (constructor - MQTopicConnectionFactory)");
        }
        try {
            try {
                int n;
                block11: {
                    block12: {
                        this.setQueueManager(mQTopicConnectionFactory.getQueueManager());
                        this.setTransportType(mQTopicConnectionFactory.getTransportType());
                        this.setHostName(mQTopicConnectionFactory.getHostName());
                        this.setPort(mQTopicConnectionFactory.getPort());
                        this.setChannel(mQTopicConnectionFactory.getChannel());
                        this.setCCSID(mQTopicConnectionFactory.getCCSID());
                        this.setReceiveExit(mQTopicConnectionFactory.getReceiveExit());
                        this.setReceiveExitInit(mQTopicConnectionFactory.getReceiveExitInit());
                        this.setSecurityExit(mQTopicConnectionFactory.getSecurityExit());
                        this.setSecurityExitInit(mQTopicConnectionFactory.getSecurityExitInit());
                        this.setSendExit(mQTopicConnectionFactory.getSendExit());
                        this.setSendExitInit(mQTopicConnectionFactory.getSendExitInit());
                        this.setCleanupInterval(mQTopicConnectionFactory.getCleanupInterval());
                        this.setUserID((String)hashtable.get("userID"));
                        this.setPassword((String)hashtable.get("password"));
                        n = mQTopicConnectionFactory.getCleanupLevel();
                        if (n != -1) break block11;
                        String string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                try {
                                    return System.getProperty("com.ibm.mq.jms.cleanup");
                                }
                                catch (AccessControlException accessControlException) {
                                    return "";
                                }
                            }
                        });
                        if (string == null) break block12;
                        if ((string = string.trim().toUpperCase()).equals("NONE")) {
                            n = 0;
                            break block11;
                        } else if (string.equals("SAFE")) {
                            n = 1;
                            break block11;
                        } else {
                            if (!string.equals("STRONG")) {
                                JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "com.ibm.mq.jms.cleanup", String.valueOf(n));
                                throw jMSException;
                            }
                            n = 2;
                        }
                        break block11;
                    }
                    n = 1;
                }
                this.setCleanupLevel(n);
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "Cleanup (constructor - MQTopicConnectionFactory)", (Throwable)jMSException);
                throw jMSException;
            }
            Object var7_7 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "Cleanup (constructor - MQTopicConnectionFactory)");
            throw throwable;
        }
        Trace.exit(this, "Cleanup (constructor - MQTopicConnectionFactory)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCleanupInterval(long l) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setCleanupInterval");
        }
        try {
            try {
                if (l < 0L) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupInterval", String.valueOf(l));
                    throw jMSException;
                }
                Object object = this.runLock;
                synchronized (object) {
                    if (this.isRunning && (this.getCleanupLevel() == 3 || this.getCleanupLevel() == 4)) {
                        String string = ConfigEnvironment.getMessage("MQJMS3043");
                        IllegalStateException illegalStateException = new IllegalStateException(string);
                        throw illegalStateException;
                    }
                    this.cleanupInterval = l;
                    if (this.isRunning) {
                        this.runLock.notifyAll();
                    }
                }
                Object var8_8 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "setCleanupInterval", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setCleanupInterval");
            throw throwable;
        }
        Trace.exit(this, "setCleanupInterval");
    }

    public long getCleanupInterval() {
        if (Trace.isOn) {
            Trace.entry(this, "getCleanupInterval");
            Trace.exit(this, "getCleanupInterval");
        }
        return this.cleanupInterval;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setCleanupLevel(int n) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(this, "setCleanupLevel");
        }
        try {
            try {
                switch (n) {
                    case 0: 
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: {
                        break;
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1006", "cleanupLevel", String.valueOf(n));
                        throw jMSException;
                    }
                }
                Object object = this.runLock;
                synchronized (object) {
                    if (this.isRunning && (n == 3 || n == 4) && this.getCleanupInterval() > 0L) {
                        String string = ConfigEnvironment.getMessage("MQJMS3043");
                        IllegalStateException illegalStateException = new IllegalStateException(string);
                        throw illegalStateException;
                    }
                    this.cleanupLevel = n;
                    if (this.isRunning) {
                        this.runLock.notifyAll();
                    }
                }
                Object var8_8 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.exception(this, "setCleanupLevel", (Throwable)jMSException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "setCleanupLevel");
            throw throwable;
        }
        Trace.exit(this, "setCleanupLevel");
    }

    public int getCleanupLevel() {
        if (Trace.isOn) {
            Trace.entry(this, "getCleanupLevel");
            Trace.exit(this, "getCleanupLevel");
        }
        return this.cleanupLevel;
    }

    public void setPassword(String string) {
        this.password = string;
    }

    private String getPassword() {
        return this.password;
    }

    public void setUserID(String string) {
        this.userID = string;
    }

    private String getUserID() {
        return this.userID;
    }

    public static void main(String[] stringArray) throws UnsupportedEncodingException {
        Object object;
        boolean bl = false;
        String string = "";
        int n = 0;
        int n2 = 0;
        boolean bl2 = false;
        String string2 = null;
        int n3 = 0;
        String string3 = null;
        String string4 = null;
        Locale locale = Locale.getDefault();
        String string5 = locale.getLanguage();
        String string6 = (String)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return System.getProperty("os.name");
                }
                catch (AccessControlException accessControlException) {
                    return "";
                }
            }
        });
        PrintWriter printWriter = !(!string6.equals("Windows NT") && !string6.equals("OS/2") || !string5.equals("en") && !string5.equals("fr") && !string5.equals("de") && !string5.equals("es") && !string5.equals("it") && !string5.equals("pt")) ? new PrintWriter(new OutputStreamWriter((OutputStream)System.out, "Cp850")) : new PrintWriter(new OutputStreamWriter(System.out));
        final PrintWriter printWriter2 = printWriter;
        MQConnectionMetaData mQConnectionMetaData = new MQConnectionMetaData();
        String string7 = mQConnectionMetaData.getProviderVersion();
        printWriter2.println();
        printWriter2.println(ConfigEnvironment.getMessage("MQJMS1003"));
        printWriter2.println(ConfigEnvironment.getMessage("MQJMS1002") + " " + string7);
        printWriter2.println(ConfigEnvironment.getMessage("MQJMS5079"));
        printWriter2.println();
        printWriter2.flush();
        int n4 = 0;
        try {
            while (n4 < stringArray.length) {
                object = stringArray[n4].toLowerCase();
                string4 = stringArray[n4];
                if (((String)object).equals("-client")) {
                    bl = true;
                } else if (((String)object).equals("safe")) {
                    n2 = 1;
                } else if (((String)object).equals("strong")) {
                    n2 = 2;
                } else if (((String)object).equals("force")) {
                    n2 = 3;
                } else if (((String)object).equals("nondur")) {
                    n2 = 4;
                } else if (((String)object).equals("-m")) {
                    string = stringArray[++n4];
                } else if (((String)object).equals("-r")) {
                    n = Integer.parseInt(stringArray[++n4]);
                } else if (((String)object).equals("-host")) {
                    string2 = stringArray[++n4];
                } else if (((String)object).equals("-port")) {
                    n3 = Integer.parseInt(stringArray[++n4]);
                } else if (((String)object).equals("-channel")) {
                    string3 = stringArray[++n4];
                } else if (((String)object).equals("-t")) {
                    bl2 = true;
                } else {
                    throw new IllegalArgumentException();
                }
                ++n4;
            }
        }
        catch (NumberFormatException numberFormatException) {
            String string8 = ConfigEnvironment.getMessage("MQJMS5073", string4);
            printWriter2.println(string8);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            String string9 = ConfigEnvironment.getMessage("MQJMS5074", string4);
            printWriter2.println(string9);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            String string10 = ConfigEnvironment.getMessage("MQJMS5075", string4);
            printWriter2.println(string10);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (n2 == 0) {
            object = ConfigEnvironment.getMessage("MQJMS5076");
            printWriter2.println((String)object);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (bl && string2 == null) {
            object = ConfigEnvironment.getMessage("MQJMS5077");
            printWriter2.println((String)object);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (!(bl || string2 == null && n3 == 0 && string3 == null)) {
            object = ConfigEnvironment.getMessage("MQJMS5078");
            printWriter2.println((String)object);
            Cleanup.displayUsage(printWriter2);
            printWriter2.flush();
            return;
        }
        if (n3 < 0) {
            object = ConfigEnvironment.getMessage("MQJMS1006", "-port", String.valueOf(n3));
            printWriter2.println((String)object);
            printWriter2.println();
            printWriter2.flush();
            return;
        }
        if (n < 0) {
            object = ConfigEnvironment.getMessage("MQJMS1006", "-r", String.valueOf(n));
            printWriter2.println((String)object);
            printWriter2.println();
            printWriter2.flush();
            return;
        }
        if (bl) {
            if (n3 == 0) {
                n3 = 1414;
            }
            if (string3 == null) {
                string3 = "SYSTEM.DEF.SVRCONN";
            }
        }
        MQException.log = null;
        if (bl2) {
            ConfigEnvironment.start();
            Trace.entry(CLSNAME, "main");
            Trace.trace(CLSNAME, "Trace started from main by -t flag");
        }
        object = new Cleanup();
        try {
            ((MQConnectionFactory)object).setQueueManager(string);
            if (bl) {
                ((MQConnectionFactory)object).setTransportType(1);
                ((MQConnectionFactory)object).setHostName(string2);
                ((MQConnectionFactory)object).setChannel(string3);
                ((MQConnectionFactory)object).setPort(n3);
            } else {
                ((MQConnectionFactory)object).setTransportType(0);
            }
            ((Cleanup)object).setCleanupInterval(n * 60000);
            ((Cleanup)object).setCleanupLevel(n2);
        }
        catch (JMSException jMSException) {
            printWriter2.println(jMSException.getMessage());
            Cleanup.displayUsage(printWriter2);
        }
        if (n > 0) {
            ((Cleanup)object).setExceptionListener(new ExceptionListener(){

                public void onException(JMSException jMSException) {
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5085"));
                    printWriter2.println((Object)jMSException);
                    if (jMSException.getLinkedException() != null) {
                        printWriter2.println(ConfigEnvironment.getMessage("MQJMS5086"));
                        printWriter2.println(jMSException.getLinkedException());
                        printWriter2.flush();
                    }
                }
            });
            ((Cleanup)object).run();
        } else {
            block44: {
                try {
                    ((Cleanup)object).cleanup();
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5084"));
                }
                catch (JMSException jMSException) {
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5085"));
                    printWriter2.println((Object)jMSException);
                    if (jMSException.getLinkedException() == null) break block44;
                    printWriter2.println(ConfigEnvironment.getMessage("MQJMS5086"));
                    printWriter2.println(jMSException.getLinkedException());
                }
            }
            printWriter2.println();
            printWriter2.flush();
        }
    }

    private static void displayUsage(PrintWriter printWriter) {
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5080"));
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5081"));
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5082"));
        printWriter.println(ConfigEnvironment.getMessage("MQJMS5083"));
        printWriter.println();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        block51: {
            if (Trace.isOn) {
                Trace.entry(this, "run");
            }
            var1_1 = null;
            MQException.log = null;
            try {
                try {
                    var6_2 = this.runLock;
                    synchronized (var6_2) {
                        this.isRunning = true;
                        var2_3 = this.getCleanupLevel();
                        var3_5 = this.getCleanupInterval();
                        if (var2_3 == 0) {
                            var7_7 = ConfigEnvironment.getMessage("MQJMS3044");
                            throw new IllegalStateException(var7_7);
                        }
                        if ((var2_3 == 3 || var2_3 == 4) && var3_5 > 0L) {
                            var7_8 = ConfigEnvironment.getMessage("MQJMS3043");
                            throw new IllegalStateException(var7_8);
                        }
                        this.endCleanup = false;
                        var5_10 = false;
                    }
                    block26: while (!var5_10) {
                        block48: {
                            var7_9 = System.currentTimeMillis();
                            if (Trace.isOn) {
                                Trace.trace(this, "Cleanup started at " + var7_9);
                            }
                            try {
                                var1_1 = this.connect();
                                this.performCleanup(var1_1, var2_3);
                            }
                            catch (JMSException var9_12) {
                                if (Trace.isOn) {
                                    Trace.exception(this, "run - informing ExceptionListener", (Throwable)var9_12);
                                }
                                if ((var10_13 /* !! */  = this.exceptionListener) != null) {
                                    var10_13 /* !! */ .onException(var9_12);
                                }
                                var12_16 = null;
                                if (var1_1 != null) {
                                    try {
                                        var1_1.disconnect();
                                        var1_1 = null;
                                    }
                                    catch (MQException var13_17) {
                                        Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                                        Trace.exception(this, "run", (Throwable)var13_17);
                                    }
                                }
                                break block48;
                            }
                            var12_16 = null;
                            if (var1_1 == null) break block48;
                            {
                                catch (Throwable var11_15) {
                                    var12_16 = null;
                                    if (var1_1 == null) throw var11_15;
                                    ** try [egrp 5[TRYBLOCK] [3 : 226->235)] { 
lbl53:
                                    // 1 sources

                                    var1_1.disconnect();
                                    var1_1 = null;
                                    throw var11_15;
lbl56:
                                    // 1 sources

                                    catch (MQException var13_17) {
                                        Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                                        Trace.exception(this, "run", (Throwable)var13_17);
                                    }
                                    throw var11_15;
                                }
                                ** try [egrp 5[TRYBLOCK] [3 : 226->235)] { 
lbl61:
                                // 1 sources

                                var1_1.disconnect();
                                var1_1 = null;
lbl64:
                                // 1 sources

                                catch (MQException var13_17) {}
                                Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                                Trace.exception(this, "run", (Throwable)var13_17);
                            }
                        }
                        var9_11 = false;
                        var10_13 /* !! */  = this.runLock;
                        synchronized (var10_13 /* !! */ ) {
                            while (true) {
                                if (var9_11) {
                                    continue block26;
                                }
                                var3_5 = this.getCleanupInterval();
                                var2_3 = this.getCleanupLevel();
                                if (this.endCleanup || var3_5 == 0L) {
                                    var9_11 = true;
                                    var5_10 = true;
                                    continue;
                                }
                                var11_14 = var7_9 + var3_5 - System.currentTimeMillis();
                                if (var11_14 > 0L) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Sleeping for " + var11_14);
                                    }
                                    try {
                                        this.runLock.wait(var11_14);
                                    }
                                    catch (InterruptedException var13_18) {}
                                    continue;
                                }
                                var9_11 = true;
                            }
                        }
                    }
                }
                catch (JMSException var2_4) {
                    block49: {
                        if (Trace.isOn) {
                            Trace.exception(this, "run - informing ExceptionListener", (Throwable)var2_4);
                        }
                        if ((var3_6 = this.exceptionListener) != null) {
                            var3_6.onException(var2_4);
                        }
                        var16_20 = null;
                        try {
                            if (var1_1 != null) {
                                var1_1.disconnect();
                            }
                            var1_1 = null;
                            if (Trace.isOn) {
                                Trace.trace(this, "Disconnected");
                            }
                        }
                        catch (MQException var17_23 /* !! */ ) {
                            if (!Trace.isOn) break block49;
                            Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                            Trace.exception(this, "run", (Throwable)var17_23 /* !! */ );
                        }
                    }
                    var17_23 /* !! */  = this.runLock;
                    synchronized (var17_23 /* !! */ ) {
                        this.isRunning = false;
                        this.runLock.notifyAll();
                    }
                    if (Trace.isOn == false) return;
                    Trace.exit(this, "run");
                    return;
                }
                var16_19 = null;
            }
            catch (Throwable var15_25) {
                block50: {
                    var16_21 = null;
                    ** try [egrp 8[TRYBLOCK] [8 : 443->468)] { 
lbl124:
                    // 1 sources

                    if (var1_1 != null) {
                        var1_1.disconnect();
                    }
                    var1_1 = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "Disconnected");
                    }
                    break block50;
lbl130:
                    // 1 sources

                    catch (MQException var17_24 /* !! */ ) {
                        if (!Trace.isOn) break block50;
                        Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                        Trace.exception(this, "run", (Throwable)var17_24 /* !! */ );
                    }
                }
                var17_24 /* !! */  = this.runLock;
                synchronized (var17_24 /* !! */ ) {
                    this.isRunning = false;
                    this.runLock.notifyAll();
                }
                if (Trace.isOn == false) throw var15_25;
                Trace.exit(this, "run");
                throw var15_25;
            }
            ** try [egrp 8[TRYBLOCK] [8 : 443->468)] { 
lbl143:
            // 1 sources

            if (var1_1 != null) {
                var1_1.disconnect();
            }
            var1_1 = null;
            if (Trace.isOn) {
                Trace.trace(this, "Disconnected");
            }
            break block51;
lbl149:
            // 1 sources

            catch (MQException var17_22 /* !! */ ) {
                if (!Trace.isOn) break block51;
                Trace.trace(this, "Ignoring exception from qmgr.disconnect()");
                Trace.exception(this, "run", (Throwable)var17_22 /* !! */ );
            }
        }
        var17_22 /* !! */  = this.runLock;
        synchronized (var17_22 /* !! */ ) {
            this.isRunning = false;
            this.runLock.notifyAll();
        }
        if (Trace.isOn == false) return;
        Trace.exit(this, "run");
    }

    public void stop() {
        if (Trace.isOn) {
            Trace.entry(this, "stop");
        }
        Object object = this.runLock;
        synchronized (object) {
            if (this.isRunning && !this.endCleanup) {
                this.endCleanup = true;
                this.runLock.notifyAll();
            }
            while (this.isRunning) {
                if (Trace.isOn) {
                    Trace.trace(this, "Cleanup still running: wait");
                }
                try {
                    this.runLock.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (Trace.isOn) {
            Trace.exit(this, "stop");
        }
    }

    public void setExceptionListener(ExceptionListener exceptionListener) {
        if (Trace.isOn) {
            Trace.entry(this, "setExceptionListener");
        }
        this.exceptionListener = exceptionListener;
        if (Trace.isOn) {
            Trace.exit(this, "setExceptionListener");
        }
    }

    public ExceptionListener getExceptionListener() {
        if (Trace.isOn) {
            Trace.entry(this, "getExceptionListener");
            Trace.exit(this, "getExceptionListener");
        }
        return this.exceptionListener;
    }

    public boolean isRunning() {
        if (Trace.isOn) {
            Trace.entry(this, "isRunning");
            Trace.exit(this, "isRunning");
        }
        return this.isRunning;
    }

    /*
     * Loose catch block
     */
    public void cleanup() throws JMSException {
        block16: {
            MQQueueManager mQQueueManager;
            block14: {
                if (Trace.isOn) {
                    Trace.entry(this, "cleanup");
                }
                MQException.log = null;
                mQQueueManager = null;
                int n = this.getCleanupLevel();
                if (n == 0) {
                    String string = ConfigEnvironment.getMessage("MQJMS3044");
                    throw new IllegalStateException(string);
                }
                mQQueueManager = this.connect();
                this.performCleanup(mQQueueManager, n);
                Object var5_5 = null;
                try {
                    if (mQQueueManager != null) {
                        mQQueueManager.disconnect();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block14;
                    Trace.trace(this, "Ignoring exception from qmgr.disconnect");
                    Trace.exception(this, "cleanup", (Throwable)mQException);
                }
            }
            if (Trace.isOn) {
                Trace.exit(this, "cleanup");
            }
            break block16;
            {
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block15: {
                    Object var5_6 = null;
                    try {
                        if (mQQueueManager != null) {
                            mQQueueManager.disconnect();
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block15;
                        Trace.trace(this, "Ignoring exception from qmgr.disconnect");
                        Trace.exception(this, "cleanup", (Throwable)mQException);
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(this, "cleanup");
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MQQueueManager connect() throws JMSException {
        MQQueueManager mQQueueManager;
        Trace.entry(this, "connect");
        try {
            try {
                MQQueueManager mQQueueManager2;
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                switch (this.getTransportType()) {
                    case 0: {
                        hashtable.put("transport", "MQSeries Bindings");
                        break;
                    }
                    case 3: {
                        hashtable.put("transport", "MQJD");
                        break;
                    }
                    case 1: {
                        hashtable.put("transport", "MQSeries");
                        hashtable.put("CCSID", new Integer(this.getCCSID()));
                        hashtable.put("channel", this.getChannel());
                        hashtable.put("hostname", this.getHostName());
                        hashtable.put("port", new Integer(this.getPort()));
                        hashtable.put("userID", this.getUserID());
                        hashtable.put("password", this.getPassword());
                        String string = "<unset>";
                        try {
                            String string2;
                            string = this.getReceiveExit();
                            if (string != null) {
                                string2 = this.getReceiveExitInit();
                                mQQueueManager = (MQReceiveExit)this.newExitInstance(string, string2);
                                hashtable.put("receiveExit", mQQueueManager);
                            }
                            if ((string = this.getSecurityExit()) != null) {
                                string2 = this.getSecurityExitInit();
                                mQQueueManager = (MQSecurityExit)this.newExitInstance(string, string2);
                                hashtable.put("securityExit", mQQueueManager);
                            }
                            if ((string = this.getSendExit()) == null) break;
                            string2 = this.getSendExitInit();
                            mQQueueManager = (MQSendExit)this.newExitInstance(string, string2);
                            hashtable.put("sendExit", mQQueueManager);
                            break;
                        }
                        catch (JMSException jMSException) {
                            throw jMSException;
                        }
                        catch (Exception exception) {
                            JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
                            jMSException.setLinkedException(exception);
                            throw jMSException;
                        }
                    }
                    default: {
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1008", String.valueOf(this.getTransportType()));
                        throw jMSException;
                    }
                }
                hashtable.put("Group", MQConnection.NON_XAGROUP);
                hashtable.put("SPI", "SPI_ENABLE");
                hashtable.put("Use QM CCSID", new Boolean(true));
                mQQueueManager = mQQueueManager2 = new MQQueueManager(this.getQueueManager(), hashtable);
                Object var8_13 = null;
                if (!Trace.isOn) return mQQueueManager;
            }
            catch (MQException mQException) {
                Object var3_4 = null;
                JMSException jMSException = ConfigEnvironment.newException("MQJMS2005", this.getQueueManager());
                jMSException.setLinkedException((Exception)((Object)mQException));
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Linked Exception " + (Object)((Object)mQException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var8_14 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "connect");
            throw throwable;
        }
        Trace.exit(this, "connect");
        return mQQueueManager;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object newExitInstance(String string, String string2) throws JMSException {
        Object obj;
        try {
            try {
                Object obj2;
                Constructor<?> constructor;
                Object[] objectArray;
                if (Trace.isOn) {
                    Trace.entry(this, "newExitInstance");
                }
                Class<?> clazz = Class.forName(string);
                Class<?> clazz2 = Class.forName("java.lang.String");
                try {
                    objectArray = new Class[]{clazz2};
                    constructor = clazz.getConstructor((Class<?>[])objectArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS1009");
                    jMSException.setLinkedException((Exception)noSuchMethodException);
                    throw jMSException;
                }
                objectArray = new Object[]{string2};
                obj = obj2 = constructor.newInstance(objectArray);
                Object var10_14 = null;
                if (!Trace.isOn) return obj;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            catch (Exception exception) {
                JMSException jMSException = ConfigEnvironment.newException("MQJMS1007", string);
                jMSException.setLinkedException(exception);
                if (Trace.isOn) {
                    Trace.trace(this, "Create and Throwing " + (Object)((Object)jMSException));
                }
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Linked Exception " + exception);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var10_15 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "newExitInstance");
            throw throwable;
        }
        Trace.exit(this, "newExitInstance");
        return obj;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void performCleanup(MQQueueManager var1_1, int var2_2) throws JMSException {
        block82: {
            block78: {
                block81: {
                    block77: {
                        if (Trace.isOn) {
                            Trace.entry(this, "performCleanup");
                        }
                        var3_3 = null;
                        var4_4 = 0L;
                        try {
                            try {
                                if (var2_2 == 0) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Cleanup level is NONE; skipping cleanup");
                                    }
                                    var26_5 = null;
                                    break block77;
                                }
                                var6_11 = 24;
                                switch (var2_2) {
                                    case 1: 
                                    case 2: {
                                        var6_11 |= 2;
                                        break;
                                    }
                                    case 3: 
                                    case 4: {
                                        var6_11 |= 4;
                                        break;
                                    }
                                    default: {
                                        var7_13 = ConfigEnvironment.newException("MQJMS1016", "Bad level " + var2_2 + " encountered in Cleanup");
                                        throw var7_13;
                                    }
                                }
                                try {
                                    var3_3 = var1_1.accessQueue("SYSTEM.JMS.REPORT.QUEUE", var6_11);
                                }
                                catch (MQException var8_14) {
                                    if (var8_14.reasonCode != 2042) {
                                        var9_20 = ConfigEnvironment.newException("MQJMS2008");
                                        var9_20.setLinkedException((Exception)var8_14);
                                        throw var9_20;
                                    }
                                    if ((var6_11 & 2) == 2) {
                                        var9_18 = ConfigEnvironment.newException("MQJMS3045", "SYSTEM.JMS.REPORT.QUEUE");
                                        var9_18.setLinkedException((Exception)var8_14);
                                        throw var9_18;
                                    }
                                    var9_19 = ConfigEnvironment.newException("MQJMS3046", "SYSTEM.JMS.REPORT.QUEUE");
                                    var9_19.setLinkedException((Exception)var8_14);
                                    throw var9_19;
                                }
                                try {
                                    var8_15 = new MQMsg2();
                                    var8_15.setMessageData(Cleanup.dummyMessageText);
                                    var8_15.setCharacterSet(1208);
                                    var8_15.setPersistence(0);
                                    var9_21 = new MQPutMessageOptions();
                                    var9_21.options = 2;
                                    var3_3.putMsg2(var8_15, var9_21);
                                    var4_4 = var8_15.getPutTimeMillis();
                                    var1_1.backout();
                                }
                                catch (MQException var8_16) {
                                    var9_22 = ConfigEnvironment.newException("MQJMS2007");
                                    var9_22.setLinkedException((Exception)var8_16);
                                    throw var9_22;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "Current MQ clock is " + var4_4);
                                }
                                var8_17 = false;
                                var9_21 = new MQMsg2();
                                var10_23 = new MQGetMessageOptions();
                                var11_24 = true;
                                while (true) {
                                    block79: {
                                        if (var8_17) {
                                            if (var2_2 == 4) {
                                                this.cleanupNonDur(var1_1, var3_3);
                                            }
                                            break block78;
                                        }
                                        var12_25 = false;
                                        var13_26 = 0;
                                        var10_23.options = 512;
                                        var10_23.options = var11_24 ? (var10_23.options |= 16) : (var10_23.options |= 32);
                                        var10_23.matchOptions = 0;
                                        try {
                                            var3_3.getMsg2((MQMsg2)var9_21, var10_23);
                                            var12_25 = true;
                                        }
                                        catch (MQException var14_27) {
                                            if (var14_27.reasonCode != 2033) {
                                                var15_49 = ConfigEnvironment.newException("MQJMS2002");
                                                var15_49.setLinkedException((Exception)var14_27);
                                                throw var15_49;
                                            }
                                            var8_17 = true;
                                        }
                                        if (var8_17) continue;
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Found message on report queue");
                                        }
                                        var14_28 = 0L;
                                        try {
                                            var14_28 = var4_4 - var9_21.getPutTimeMillis();
                                        }
                                        catch (MQException var16_30) {
                                            var17_32 = "Unexpected error from getPutTimeMillis (" + (Object)var16_30 + ")";
                                            var18_38 = ConfigEnvironment.newException("MQJMS1016", var17_32);
                                            var18_38.setLinkedException((Exception)var16_30);
                                            throw var18_38;
                                        }
                                        var16_29 = null;
                                        try {
                                            var16_29 = MQBrokerMessage.fromMessage((MQMsg2)var9_21);
                                        }
                                        catch (JMSException var17_33) {
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Message is not a broker message");
                                            }
                                            var13_26 = 99;
                                        }
                                        try {
                                            if (var16_29 == null) break block79;
                                            var17_34 = var16_29.get("MQPSCommand");
                                            var18_39 = var16_29.get("MQPSCompCode");
                                            if (Trace.isOn) {
                                                Trace.trace(this, "Message has command '" + var17_34 + "'");
                                                Trace.trace(this, "Message has completion code '" + var18_39 + "'");
                                            }
                                            if ("DeregSub".equals(var17_34)) {
                                                if (var18_39 != null && var18_39.equals("0")) {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "Message is reponse to dereg sub w. full data");
                                                    }
                                                    var13_26 = 1;
                                                    break block79;
                                                } else {
                                                    if (Trace.isOn) {
                                                        Trace.trace(this, "Message is response to unsuccessful dereg sub");
                                                    }
                                                    var13_26 = 4;
                                                }
                                                break block79;
                                            }
                                            if ("RegSub".equals(var17_34)) {
                                                if (var18_39 != null && var18_39.equals("0")) {
                                                    var19_42 = var16_29.isOptionSet("MQPSRegOpts", "PubOnReqOnly");
                                                    if (var19_42) {
                                                        if (Trace.isOn) {
                                                            Trace.trace(this, "Message is response to reg sub w. poro");
                                                        }
                                                        var13_26 = 2;
                                                        break block79;
                                                    } else {
                                                        if (Trace.isOn) {
                                                            Trace.trace(this, "Message appears to be response to reg sub");
                                                        }
                                                        var13_26 = 99;
                                                    }
                                                    break block79;
                                                }
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Message is response to unsuccessful reg sub");
                                                }
                                                var13_26 = 4;
                                                break block79;
                                            }
                                            if (var17_34 == null) {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Message has no command field");
                                                }
                                                var13_26 = var18_39 == null ? 99 : (var18_39.equals("0") ? 3 : 4);
                                            } else {
                                                if (Trace.isOn) {
                                                    Trace.trace(this, "Message has unrecognised command field");
                                                }
                                                var13_26 = 99;
                                            }
                                        }
                                        catch (JMSException var17_35) {
                                            var19_43 = "Error dealing with MQBrokerMessage (" + var17_35.toString() + ")";
                                            var18_40 = ConfigEnvironment.newException("MQJMS1016", var19_43);
                                            var18_40.setLinkedException((Exception)var17_35);
                                            throw var18_40;
                                        }
                                    }
                                    try {
                                        if (var13_26 == 99 && var9_21.getFormat().equals("MQADMIN ") && var9_21.getMessageType() == 2) {
                                            var13_26 = 5;
                                        }
                                    }
                                    catch (MQException var17_36) {
                                        var19_44 = "Could not fetch header data from MQMsg2 (" + (Object)var17_36 + ")";
                                        var18_41 = ConfigEnvironment.newException("MQJMS1016", var19_44);
                                        var18_41.setLinkedException((Exception)var17_36);
                                        throw var18_41;
                                    }
                                    v0 = var17_31 = var14_28 >= Cleanup.assumeOld;
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Message is of category " + var13_26);
                                        if (var17_31) {
                                            Trace.trace(this, "Message is sufficiently old");
                                        } else {
                                            Trace.trace(this, "Message is not sufficiently old");
                                        }
                                    }
                                    var18_37 = false;
                                    switch (var2_2) {
                                        case 1: {
                                            if (var17_31 && (var13_26 == 1 || var13_26 == 2 || var13_26 == 3 || var13_26 == 5)) {
                                                var18_37 = true;
                                                break;
                                            }
                                            var18_37 = false;
                                            break;
                                        }
                                        case 2: {
                                            if (var17_31) {
                                                var18_37 = true;
                                                break;
                                            }
                                            var18_37 = false;
                                            break;
                                        }
                                        case 3: 
                                        case 4: {
                                            var18_37 = true;
                                            break;
                                        }
                                        default: {
                                            var19_45 = ConfigEnvironment.newException("MQJMS1016", "Bad level " + var2_2 + " encountered in Cleanup");
                                            throw var19_45;
                                        }
                                    }
                                    var20_46 = false;
                                    var21_47 = 1;
                                    if (var18_37) {
                                        var21_47 = this.processMessage(var1_1, (MQMsg2)var9_21, var16_29, var13_26);
                                    }
                                    if (var20_46 = var2_2 == 4 ? true : var21_47 == 0) {
                                        if (Trace.isOn) {
                                            Trace.trace(this, "Removing message");
                                        }
                                        try {
                                            var10_23.options = 320;
                                            var3_3.getMsg2((MQMsg2)var9_21, var10_23, 1);
                                        }
                                        catch (MQException var22_48) {
                                            if (var22_48.reasonCode == 2079) ** GOTO lbl203
                                            var24_50 = "Couldn't get locked message from queue (" + (Object)var22_48 + ")";
                                            var23_51 = ConfigEnvironment.newException("MQJMS1016");
                                            var23_51.setLinkedException((Exception)var22_48);
                                            throw var23_51;
                                        }
                                    } else if (Trace.isOn) {
                                        Trace.trace(this, "Leaving message on queue");
                                    }
lbl203:
                                    // 5 sources

                                    var11_24 = false;
                                }
                            }
                            catch (JMSException var6_12) {
                                if (Trace.isOn == false) throw var6_12;
                                Trace.trace(this, "Throwing " + (Object)var6_12);
                                throw var6_12;
                            }
                        }
                        catch (Throwable var25_52) {
                            block80: {
                                var26_7 = null;
                                try {
                                    if (var3_3 != null) {
                                        var3_3.close();
                                    }
                                }
                                catch (MQException var27_10) {
                                    if (!Trace.isOn) break block80;
                                    Trace.exception(this, "performCleanup (during tidy up - ignoring)", (Throwable)var27_10);
                                }
                            }
                            Trace.exit(this, "performCleanup");
                            throw var25_52;
                        }
                    }
                    ** try [egrp 10[TRYBLOCK] [10 : 1483->1494)] { 
lbl224:
                    // 1 sources

                    if (var3_3 != null) {
                        var3_3.close();
                    }
                    break block81;
lbl227:
                    // 1 sources

                    catch (MQException var27_8) {
                        if (!Trace.isOn) break block81;
                        Trace.exception(this, "performCleanup (during tidy up - ignoring)", (Throwable)var27_8);
                    }
                }
                Trace.exit(this, "performCleanup");
                return;
            }
            var26_6 = null;
            ** try [egrp 10[TRYBLOCK] [10 : 1483->1494)] { 
lbl236:
            // 1 sources

            if (var3_3 != null) {
                var3_3.close();
            }
            break block82;
lbl239:
            // 1 sources

            catch (MQException var27_9) {
                if (!Trace.isOn) break block82;
                Trace.exception(this, "performCleanup (during tidy up - ignoring)", (Throwable)var27_9);
            }
        }
        Trace.exit(this, "performCleanup");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int processMessage(MQQueueManager mQQueueManager, MQMsg2 mQMsg2, MQBrokerMessage mQBrokerMessage, int n) throws JMSException {
        int n2;
        if (Trace.isOn) {
            Trace.entry(this, "processMessage");
        }
        int n3 = 2;
        try {
            try {
                if (Trace.isOn) {
                    Trace.trace(this, "Category " + n + " message");
                }
                switch (n) {
                    case 1: 
                    case 2: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Cleaning up any orphaned message");
                        }
                        if (mQBrokerMessage.isOptionSet("MQPSRegOpts", "CorrelAsId")) {
                            try {
                                String string = mQBrokerMessage.get("MQPSQMgrName");
                                String string2 = mQBrokerMessage.get("MQPSQName");
                                String string3 = mQBrokerMessage.get("MQPSCorrelId");
                                byte[] byArray = Utils.hexToBytes(string3);
                                if (string != null && string.equals(mQQueueManager.name) && string2 != null && string3 != null && byArray != null && byArray.length == 24) {
                                    if (Trace.isOn) {
                                        Trace.trace(this, "Removing messages with correlId " + string3 + " from " + string2);
                                    }
                                    Cleanup.removeMessages(mQQueueManager, string2, byArray);
                                    n3 = 0;
                                    break;
                                }
                                if (Trace.isOn) {
                                    Trace.trace(this, "Response message has surprising information - ignoring");
                                }
                                n3 = 2;
                            }
                            catch (JMSException jMSException) {
                                if (Trace.isOn) {
                                    Trace.exception(this, "processMessage", (Throwable)jMSException);
                                }
                                n3 = 2;
                            }
                            break;
                        }
                        try {
                            String string = mQBrokerMessage.get("MQPSQMgrName");
                            String string4 = mQBrokerMessage.get("MQPSQName");
                            if (string != null && string.trim().equals(mQQueueManager.name.trim()) && string4 != null) {
                                if (Trace.isOn) {
                                    Trace.trace(this, "Removing dynamic queue " + string4);
                                }
                                Cleanup.removeDynamicQueue(mQQueueManager, string4);
                                n3 = 0;
                                break;
                            }
                            if (Trace.isOn) {
                                Trace.trace(this, "Reponse message has surprising information - ignoring");
                            }
                            n3 = 2;
                        }
                        catch (TransactionInProgressException transactionInProgressException) {
                            if (Trace.isOn) {
                                Trace.exception(this, "processMessage", (Throwable)transactionInProgressException);
                                Trace.trace(this, "Will retry this cleanup later");
                            }
                            n3 = 1;
                        }
                        catch (JMSException jMSException) {
                            if (Trace.isOn) {
                                Trace.exception(this, "processMessage", (Throwable)jMSException);
                            }
                            n3 = 2;
                        }
                        break;
                    }
                    case 3: 
                    case 4: 
                    case 5: 
                    case 99: {
                        if (Trace.isOn) {
                            Trace.trace(this, "Nothing to do");
                        }
                        n3 = 0;
                        break;
                    }
                    default: {
                        String string = "Bad category " + n + " encountered in Cleanup";
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS1016");
                        throw jMSException;
                    }
                }
                if (Trace.isOn) {
                    Trace.trace(this, "processMessage returning " + n3);
                }
                n2 = n3;
                Object var11_19 = null;
                if (!Trace.isOn) return n2;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(this, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var11_20 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(this, "processMessage");
            throw throwable;
        }
        Trace.exit(this, "processMessage");
        return n2;
    }

    /*
     * Loose catch block
     */
    static void removeMessages(MQQueueManager mQQueueManager, String string, byte[] byArray) throws JMSException {
        block23: {
            MQQueue mQQueue;
            block21: {
                if (Trace.isOn) {
                    Trace.entry(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
                }
                mQQueue = null;
                try {
                    mQQueue = mQQueueManager.accessQueue(string, 1);
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2085) {
                        block20: {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Queue doesn't exist. No messages to remove.");
                            }
                            Object var7_6 = null;
                            try {
                                if (mQQueue != null) {
                                    mQQueue.close();
                                }
                            }
                            catch (MQException mQException2) {
                                if (!Trace.isOn) break block20;
                                Trace.exception(CLSNAME, "removeMessages(MQQueueManager, String, byte[])", (Throwable)mQException2);
                                Trace.trace(CLSNAME, "Ignoring exception from queue.close()");
                            }
                        }
                        if (Trace.isOn) {
                            Trace.exit(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
                        }
                        return;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3014", string);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Cleanup.removeMessages(mQQueue, byArray);
                Object var7_7 = null;
                try {
                    if (mQQueue != null) {
                        mQQueue.close();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block21;
                    Trace.exception(CLSNAME, "removeMessages(MQQueueManager, String, byte[])", (Throwable)mQException);
                    Trace.trace(CLSNAME, "Ignoring exception from queue.close()");
                }
            }
            if (Trace.isOn) {
                Trace.exit(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
            }
            break block23;
            {
                catch (JMSException jMSException) {
                    if (Trace.isOn) {
                        Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                    }
                    throw jMSException;
                }
            }
            catch (Throwable throwable) {
                block22: {
                    Object var7_8 = null;
                    try {
                        if (mQQueue != null) {
                            mQQueue.close();
                        }
                    }
                    catch (MQException mQException) {
                        if (!Trace.isOn) break block22;
                        Trace.exception(CLSNAME, "removeMessages(MQQueueManager, String, byte[])", (Throwable)mQException);
                        Trace.trace(CLSNAME, "Ignoring exception from queue.close()");
                    }
                }
                if (Trace.isOn) {
                    Trace.exit(CLSNAME, "removeMessages(MQQueueManager, String, byte[])");
                }
                throw throwable;
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeMessages(MQQueue mQQueue, byte[] byArray) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeMessages(MQQueue, byte[])");
        }
        try {
            try {
                MQMsg2 mQMsg2 = new MQMsg2();
                mQMsg2.setCorrelationId(byArray);
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 68;
                mQGetMessageOptions.matchOptions = 2;
                int n = 0;
                boolean bl = false;
                while (!bl) {
                    try {
                        mQQueue.getMsg2(mQMsg2, mQGetMessageOptions, 1);
                        ++n;
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2079) {
                            ++n;
                            continue;
                        }
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Removed " + n + " messages");
                            }
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Got 2033 - no more messages");
                            }
                            bl = true;
                            continue;
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Removed " + n + " messages");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var9_9 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "removeMessages(MQQueue, byte[])");
            throw throwable;
        }
        Trace.exit(CLSNAME, "removeMessages(MQQueue, byte[])");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeMessages(MQQueue mQQueue) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeMessages(MQQueue)");
        }
        try {
            try {
                MQMsg2 mQMsg2 = new MQMsg2();
                MQGetMessageOptions mQGetMessageOptions = new MQGetMessageOptions();
                mQGetMessageOptions.options = 68;
                int n = 0;
                boolean bl = false;
                while (!bl) {
                    try {
                        mQMsg2.setMessageId(blankMessageId);
                        mQMsg2.setCorrelationId(blankMessageId);
                        mQQueue.getMsg2(mQMsg2, mQGetMessageOptions, 1);
                        ++n;
                    }
                    catch (MQException mQException) {
                        if (mQException.reasonCode == 2079) {
                            ++n;
                            continue;
                        }
                        if (mQException.reasonCode == 2033) {
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Removed " + n + " messages");
                            }
                            if (Trace.isOn) {
                                Trace.trace(CLSNAME, "Got 2033 - no more messages");
                            }
                            bl = true;
                            continue;
                        }
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Removed " + n + " messages");
                        }
                        JMSException jMSException = ConfigEnvironment.newException("MQJMS2002");
                        jMSException.setLinkedException((Exception)((Object)mQException));
                        throw jMSException;
                    }
                }
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
            Object var8_8 = null;
            if (!Trace.isOn) return;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "removeMessages(MQQueue)");
            throw throwable;
        }
        Trace.exit(CLSNAME, "removeMessages(MQQueue)");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void removeDynamicQueue(MQQueueManager mQQueueManager, String string) throws JMSException {
        if (Trace.isOn) {
            Trace.entry(CLSNAME, "removeDynamicQueue");
        }
        try {
            try {
                MQQueue mQQueue = null;
                try {
                    mQQueue = mQQueueManager.accessQueue(string, 4);
                }
                catch (MQException mQException) {
                    if (mQException.reasonCode == 2085 || mQException.reasonCode == 2052) {
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "Queue doesn't exist.");
                        }
                        Object var7_6 = null;
                        if (!Trace.isOn) return;
                        Trace.exit(CLSNAME, "removeDynamicQueue");
                        return;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3014", string);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                mQQueue.closeOptions = 2;
                try {
                    mQQueue.close();
                }
                catch (MQException mQException) {
                    block15: {
                        if (Trace.isOn) {
                            Trace.trace(CLSNAME, "DELETE_PURGE failed");
                        }
                        mQQueue.closeOptions = 0;
                        try {
                            mQQueue.close();
                        }
                        catch (MQException mQException2) {
                            if (!Trace.isOn) break block15;
                            Trace.trace(CLSNAME, "Ignoring following exception on close");
                            Trace.exception(CLSNAME, "removeDynamicQueue", (Throwable)mQException2);
                        }
                    }
                    if (mQException.reasonCode == 2045) {
                        String string2 = ConfigEnvironment.getMessage("MQJMS0010");
                        TransactionInProgressException transactionInProgressException = new TransactionInProgressException(string2);
                        transactionInProgressException.setLinkedException((Exception)((Object)mQException));
                        throw transactionInProgressException;
                    }
                    JMSException jMSException = ConfigEnvironment.newException("MQJMS3017", string);
                    jMSException.setLinkedException((Exception)((Object)mQException));
                    throw jMSException;
                }
                Object var7_7 = null;
                if (!Trace.isOn) return;
            }
            catch (JMSException jMSException) {
                if (!Trace.isOn) throw jMSException;
                Trace.trace(CLSNAME, "Throwing " + (Object)((Object)jMSException));
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            if (!Trace.isOn) throw throwable;
            Trace.exit(CLSNAME, "removeDynamicQueue");
            throw throwable;
        }
        Trace.exit(CLSNAME, "removeDynamicQueue");
    }

    private void cleanupNonDur(MQQueueManager mQQueueManager, MQQueue mQQueue) {
        String[] stringArray;
        if (Trace.isOn) {
            Trace.entry(this, "cleanupNonDur");
        }
        if ((stringArray = Utils.listMatchingQueues(mQQueueManager, mQQueue, "SYSTEM.JMS.ND.*")) == null) {
            if (Trace.isOn) {
                Trace.trace(this, "listMatchingQueues failed; only clearing out known SYSTEM.JMS.ND.* queues");
            }
            stringArray = defaultNDQueues;
        }
        int n = 0;
        while (n < stringArray.length) {
            MQQueue mQQueue2;
            block28: {
                block27: {
                    String string = stringArray[n];
                    mQQueue2 = null;
                    if (Trace.isOn) {
                        Trace.trace(this, "Dealing with queue " + string);
                    }
                    try {
                        mQQueue2 = mQQueueManager.accessQueue(string, 36);
                        if (Trace.isOn) {
                            Trace.trace(this, "Opened queue for input and inquire");
                        }
                        int n2 = mQQueue2.getDefinitionType();
                        if (Trace.isOn) {
                            Trace.trace(this, "Definition type is " + n2);
                        }
                        boolean bl = false;
                        boolean bl2 = false;
                        switch (n2) {
                            case 1: 
                            case 3: {
                                bl = false;
                                break;
                            }
                            case 2: {
                                String string2 = string.trim();
                                int n3 = string2.length() - 16;
                                if (n3 < 0) {
                                    bl = false;
                                    break;
                                }
                                String string3 = string2.substring(n3);
                                char[] cArray = string3.toCharArray();
                                bl = true;
                                int n4 = 0;
                                while (n4 < 16 && bl) {
                                    if (!(cArray[n4] >= '0' && cArray[n4] <= '9' || cArray[n4] >= 'a' && cArray[n4] <= 'z' || cArray[n4] >= 'A' && cArray[n4] <= 'Z')) {
                                        bl = false;
                                    }
                                    ++n4;
                                }
                                break;
                            }
                            default: {
                                if (Trace.isOn) {
                                    Trace.trace(this, "WARNING: Unrecognised definition type");
                                }
                                bl2 = true;
                                bl = false;
                            }
                        }
                        if (!bl2 && !bl) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Removing messages from queue");
                            }
                            Cleanup.removeMessages(mQQueue2);
                        } else if (!bl2 && bl) {
                            if (Trace.isOn) {
                                Trace.trace(this, "Setting queue.closeOptions to DELETE_PURGE");
                            }
                            mQQueue2.closeOptions = 2;
                        }
                    }
                    catch (MQException mQException) {
                        if (Trace.isOn) {
                            Trace.trace(this, "Ignoring exception while performing NONDUR cleanup:");
                            Trace.exception(this, "cleanupNonDur", (Throwable)mQException);
                        }
                    }
                    catch (JMSException jMSException) {
                        if (!Trace.isOn) break block27;
                        Trace.trace(this, "Ignoring exception while performing NONDUR cleanup:");
                        Trace.exception(this, "cleanupNonDur", (Throwable)jMSException);
                    }
                }
                try {
                    if (mQQueue2 != null) {
                        mQQueue2.close();
                    }
                }
                catch (MQException mQException) {
                    if (!Trace.isOn) break block28;
                    Trace.trace(this, "Ignoring exception on queue.close");
                    Trace.exception(this, "cleanupNonDur", (Throwable)mQException);
                }
            }
            mQQueue2 = null;
            ++n;
        }
    }
}

