/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.mq.jms;

import com.ibm.disthubmq.impl.client.DebugObject;
import com.ibm.disthubmq.impl.formats.SchemaCursor;
import com.ibm.disthubmq.impl.formats.TupleCursor;
import com.ibm.disthubmq.impl.util.Assert;
import com.ibm.disthubmq.spi.ClientExceptionConstants;
import com.ibm.disthubmq.spi.ClientLogConstants;
import com.ibm.disthubmq.spi.ExceptionBuilder;
import com.ibm.mq.jms.MessageImpl;
import com.ibm.mq.jms.services.ConfigEnvironment;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.MessageEOFException;
import javax.jms.MessageFormatException;
import javax.jms.MessageNotReadableException;
import javax.jms.MessageNotWriteableException;

public class BytesMessageImpl
extends MessageImpl
implements BytesMessage,
ClientLogConstants,
ClientExceptionConstants {
    private static final String copyrightNotice = "Licensed Materials - Property of IBM 5648-C60(c) Copyright IBM Corp. 1999, 2002. All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/mq/jms/BytesMessageImpl.java, jms, j521, j521-L020523 02/05/22 11:22:39 @(#) 1.12.1.2";
    private static final DebugObject debug = new DebugObject("BytesMessageImpl");
    private static final int BYTE_OUTPUT_STREAM_SIZE = 1024;
    ByteArrayInputStream bais;
    DataInputStream dis;
    byte[] body;
    private boolean bodyNeeded = false;
    ByteArrayOutputStream baos;
    DataOutputStream dos;
    public static final String ENCODING_PROPERTY = "JMS_IBM_Encoding";
    public static final int ENC_INTEGER_MASK = 15;
    public static final int ENC_FLOAT_MASK = 3840;
    public static final int ENC_INTEGER_UNDEFINED = 0;
    public static final int ENC_INTEGER_NORMAL = 1;
    public static final int ENC_INTEGER_REVERSED = 2;
    public static final int ENC_FLOAT_UNDEFINED = 0;
    public static final int ENC_FLOAT_IEEE_NORMAL = 256;
    public static final int ENC_FLOAT_IEEE_REVERSED = 512;
    public static final int ENC_FLOAT_S390 = 768;
    private int integerEncoding = 1;
    private int floatEncoding = 256;
    private boolean markInUse = false;

    public BytesMessageImpl(SchemaCursor schemaCursor, TupleCursor tupleCursor, TupleCursor tupleCursor2) {
        super(schemaCursor, tupleCursor, tupleCursor2);
        this.messageClass = "jms_bytes";
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "BytesMessageImpl", schemaCursor, tupleCursor, tupleCursor2);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "BytesMessageImpl");
        }
    }

    public BytesMessageImpl() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "BytesMessageImpl");
        }
        this.messageClass = "jms_bytes";
        this.baos = new ByteArrayOutputStream(1024);
        this.dos = new DataOutputStream(this.baos);
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "BytesMessageImpl");
        }
    }

    private void obtainBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "obtainBody");
        }
        try {
            this.body = this.getBytesBody();
            this.bais = new ByteArrayInputStream(this.body);
            this.dis = new DataInputStream(this.bais);
        }
        catch (Exception exception) {
            Assert.failure(exception);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "obtainBody");
        }
    }

    void prepareMessage() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "prepareMessage");
        }
        if (!this.readOnly) {
            this.setBytesBody(this.baos.toByteArray());
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "prepareMessage");
        }
    }

    public void clearBody() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "clearBody");
        }
        if (this.readOnly) {
            this.readOnly = false;
            if (this.body == null) {
                this.obtainBody();
            }
            this.bais.reset();
            if (this.baos == null) {
                this.baos = new ByteArrayOutputStream(1024);
                this.dos = new DataOutputStream(this.baos);
            } else {
                this.baos.reset();
            }
        } else {
            this.baos.reset();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "clearBody");
        }
    }

    public boolean readBoolean() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readBoolean");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        boolean bl = false;
        try {
            bl = this.dis.readBoolean();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readBoolean", new Boolean(bl));
        }
        return bl;
    }

    public byte readByte() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readByte");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        byte by = 0;
        try {
            by = this.dis.readByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readByte", new Byte(by));
        }
        return by;
    }

    public int readUnsignedByte() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readUnsignedByte");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.readUnsignedByte();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readUnsignedByte", new Integer(n));
        }
        return n;
    }

    public short readShort() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readShort");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        short s = 0;
        try {
            s = this.dis.readShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readShort", new Short(s));
        }
        return s;
    }

    public int readUnsignedShort() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readUnsignedShort");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.readUnsignedShort();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readUnsignedShort", new Integer(n));
        }
        return n;
    }

    public char readChar() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readChar");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        char c = '\u0000';
        try {
            c = this.dis.readChar();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readChar", new Character(c));
        }
        return c;
    }

    public int readInt() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readInt");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.readInt();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readInt", new Integer(n));
        }
        return n;
    }

    public long readLong() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readLong");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        long l = 0L;
        try {
            l = this.dis.readLong();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readLong", new Long(l));
        }
        return l;
    }

    public float readFloat() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readFloat");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        float f = 0.0f;
        try {
            f = this.dis.readFloat();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readFloat", new Double(f));
        }
        return f;
    }

    public double readDouble() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readDouble");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        double d = 0.0;
        try {
            d = this.dis.readDouble();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readDouble", new Double(d));
        }
        return d;
    }

    public String readUTF() throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readUTF");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        int n = this.integerEncoding;
        if (this.body == null) {
            this.obtainBody();
        }
        String string = null;
        try {
            string = this.dis.readUTF();
        }
        catch (EOFException eOFException) {
            throw new MessageEOFException(ExceptionBuilder.buildReasonString(1077, null));
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readUTF", string);
        }
        return string;
    }

    public int readBytes(byte[] byArray) throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "readBytes");
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n = 0;
        try {
            n = this.dis.read(byArray);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readBytes", new Integer(n));
        }
        return n;
    }

    public int readBytes(byte[] byArray, int n) throws MessageNotReadableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "BytesMessageImpl.readBytes", new Integer(n));
        }
        if (!this.readOnly) {
            throw new MessageNotReadableException(ExceptionBuilder.buildReasonString(1075, null));
        }
        if (this.body == null) {
            this.obtainBody();
        }
        int n2 = 0;
        try {
            n2 = this.dis.read(byArray, 0, n);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "readBytes", new Integer(n2));
        }
        return n2;
    }

    public void writeBoolean(boolean bl) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeBoolean", new Boolean(bl));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeBoolean(bl);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeBoolean");
        }
    }

    public void writeByte(byte by) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeByte", new Byte(by));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeByte(by);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeByte");
        }
    }

    public void writeShort(short s) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeShort", new Short(s));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeShort(s);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeShort");
        }
    }

    public void writeChar(char c) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeChar", new Character(c));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeChar(c);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeChar");
        }
    }

    public void writeInt(int n) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeInt", new Integer(n));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeInt(n);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeInt");
        }
    }

    public void writeLong(long l) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeLong", new Long(l));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeLong(l);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeLong");
        }
    }

    public void writeFloat(float f) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeFloat", new Float(f));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeFloat(f);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeFloat");
        }
    }

    public void writeDouble(double d) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeDouble", new Double(d));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeDouble(d);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeDouble");
        }
    }

    public void writeUTF(String string) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeUTF", string);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.writeUTF(string);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeUTF");
        }
    }

    public void writeBytes(byte[] byArray) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeBytes");
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.write(byArray, 0, byArray.length);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeBytes");
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeBytes", new Integer(n), new Integer(n2));
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        try {
            this.dos.write(byArray, n, n2);
        }
        catch (IOException iOException) {
            throw Assert.failureError(iOException);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeBytes");
        }
    }

    public void writeObject(Object object) throws MessageNotWriteableException, JMSException {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "writeObject", object);
        }
        if (this.readOnly) {
            throw new MessageNotWriteableException(ExceptionBuilder.buildReasonString(1076, null));
        }
        if (object instanceof Boolean) {
            this.writeBoolean((Boolean)object);
        } else if (object instanceof Byte) {
            this.writeByte((Byte)object);
        } else if (object instanceof Character) {
            this.writeChar(((Character)object).charValue());
        } else if (object instanceof Double) {
            this.writeDouble((Double)object);
        } else if (object instanceof Float) {
            this.writeFloat(((Float)object).floatValue());
        } else if (object instanceof Integer) {
            this.writeInt((Integer)object);
        } else if (object instanceof Long) {
            this.writeLong((Long)object);
        } else if (object instanceof Short) {
            this.writeShort((Short)object);
        } else if (object instanceof String) {
            this.writeUTF((String)object);
        } else if (object instanceof byte[]) {
            this.writeBytes((byte[])object);
        } else {
            String string = "MQJMS0006";
            String string2 = ConfigEnvironment.getErrorMessage(string);
            throw new MessageFormatException(string2, string);
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "writeObject");
        }
    }

    public void reset() {
        if (debug.debugIt(32)) {
            debug.debug(-175921860444055L, "reset");
        }
        if (!this.readOnly) {
            this.prepareMessage();
            this.readOnly = true;
            this.body = this.baos.toByteArray();
            this.bais = new ByteArrayInputStream(this.body);
            this.dis = new DataInputStream(this.bais);
        } else if (this.bais != null) {
            this.bais.reset();
        }
        if (debug.debugIt(64)) {
            debug.debug(-175921860444054L, "reset");
        }
    }
}

