/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.UnsupportedEncodingException;
import javax.jms.JMSException;
import javax.jms.TextMessage;

public class JMSTextMessage
extends JMSMessage
implements TextMessage {
    static final long serialVersionUID = -7013263043146565366L;
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2001     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/jms/JMSTextMessage.java, jms, j521, j521-L020320 02/03/19 17:10:18 @(#) 1.10.2.2";
    String messageText = null;
    byte[] messageBytes = null;
    String characterSet;
    int dataStart;
    boolean readOnly = false;

    public JMSTextMessage(JMSStringResources jMSStringResources) {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "constructor");
            JMSMessage.trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_text";
        this.jmsStrings = jMSStringResources;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "constructor");
        }
    }

    public JMSTextMessage(JMSStringResources jMSStringResources, String string) throws JMSException {
        this(jMSStringResources);
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "MQTextMessage constructor with String");
        }
        this.messageClass = "jms_text";
        this.setText(string);
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "MQTextMessage constructor with StringBuffer");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_exportBody");
        }
        try {
            if (this.messageBytes == null) {
                if (this.messageText == null) {
                    if (JMSMessage.trace != null) {
                        JMSMessage.trace.exit(this, "_exportBody - no body");
                    }
                    return null;
                }
                this.messageBytes = this.messageText.getBytes(string);
                this.characterSet = string;
            } else {
                if (this.characterSet.equals(string)) {
                    if (this.dataStart != 0) {
                        byte[] byArray = new byte[this.messageBytes.length - this.dataStart];
                        System.arraycopy(this.messageBytes, this.dataStart, byArray, 0, this.messageBytes.length - this.dataStart);
                        return byArray;
                    }
                    return this.messageBytes;
                }
                this.messageText = new String(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart, this.characterSet);
                this.messageBytes = this.messageText.getBytes(string);
                this.characterSet = string;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = this.newJMSException(1008, string);
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_exportBody, via Exception");
            }
            throw jMSException;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "_exportBody");
        }
        return this.messageBytes;
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_importBody");
        }
        this.messageBytes = byArray;
        this.messageText = null;
        this.dataStart = n;
        this.characterSet = string;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "_importBody");
        }
    }

    public void clearBody() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.messageText = null;
        this.messageBytes = null;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "clearBody");
        }
    }

    public String getText() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "getText");
        }
        try {
            if (this.messageText == null && this.messageBytes != null) {
                if (this.characterSet.equals("1051") || this.characterSet.equalsIgnoreCase("Cp1051")) {
                    this.messageText = this.unicodeFrom1051(this.messageBytes, this.dataStart);
                    this.characterSet = new String("UTF8");
                } else {
                    this.messageText = new String(this.messageBytes, this.dataStart, this.messageBytes.length - this.dataStart, this.characterSet);
                }
                this.messageBytes = null;
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            JMSException jMSException = this.newMessageFormatException(1008, this.characterSet);
            jMSException.setLinkedException((Exception)unsupportedEncodingException);
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "getText, via Exception");
            }
            throw jMSException;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "getText");
        }
        return this.messageText;
    }

    public void setText(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "setText");
        }
        if (this.readOnly) {
            throw this.newMessageNotWriteableException();
        }
        this.messageText = string;
        this.messageBytes = null;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "setText");
        }
    }

    public String toString() {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "toString");
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        try {
            if (this.messageText == null) {
                this.getText();
            }
        }
        catch (JMSException jMSException) {
            stringBuffer.append(this.jmsStrings.getMessage(1025, (Object)jMSException));
            stringBuffer.append(">");
        }
        if (this.messageText == null) {
            stringBuffer.append("<null>");
        } else if (this.messageText.length() > 100) {
            stringBuffer.append(this.messageText.substring(0, 100));
            stringBuffer.append("\n" + this.jmsStrings.getMessage(1026, new Integer(this.messageText.length() - 100)));
        } else {
            stringBuffer.append(this.messageText);
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "toString");
        }
        return stringBuffer.toString();
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }

    public String unicodeFrom1051(byte[] byArray, int n) {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "unicodeFrom1051");
        }
        int n2 = byArray.length - n;
        char[] cArray = new char[n2];
        char[] cArray2 = this.get1051codepage();
        int n3 = n;
        int n4 = 0;
        while (n4 < n2) {
            cArray[n4] = cArray2[byArray[n3]];
            ++n3;
            ++n4;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "unicodeFrom1051");
        }
        return new String(cArray);
    }

    private char[] get1051codepage() {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "get1051codepage");
        }
        char[] cArray = new char[255];
        char[] cArray2 = new char[]{'\u00c0', '\u00c2', '\u00c8', '\u00ca', '\u00cb', '\u00ce', '\u00cf', '\u02ca', '\u02cb', '\u02c6', '\u00a8', '\u02dc', '\u00d9', '\u00db', '\u20a4', '\u00af', '\u00dd', '\u00fd', '\u00b0', '\u00c7', '\u00e7', '\u00d1', '\u00f1', '\u00a1', '\u00bf', '\u00a4', '\u00a3', '\u00a5', '\u00a7', '\u0192', '\u00a2', '\u00e2', '\u00ea', '\u00f4', '\u00fb', '\u00e1', '\u00e9', '\u00f3', '\u00fa', '\u00e0', '\u00e8', '\u00f2', '\u00f9', '\u00e4', '\u00eb', '\u00f6', '\u00fc', '\u00c5', '\u00ee', '\u00d8', '\u00c6', '\u00e5', '\u00ed', '\u00f8', '\u00e6', '\u00c4', '\u00ec', '\u00d6', '\u00dc', '\u00c9', '\u00ef', '\u00df', '\u00d4', '\u00c1', '\u00c3', '\u00e3', '\u00d0', '\u00f0', '\u00cd', '\u00cc', '\u00d3', '\u00d2', '\u00d5', '\u00f5', '\u0160', '\u0161', '\u00da', '\u0178', '\u00ff', '\u00de', '\u00fe', '\u00b7', '\u00b5', '\u00b6', '\u00be', '\u00ad', '\u00bc', '\u00bd', '\u00aa', '\u00ba', '\u00ab', '\u25a0', '\u00bb', '\u00b1'};
        int n = 0;
        while (n < 161) {
            cArray[n] = (char)n;
            ++n;
        }
        int n2 = 161;
        while (n2 <= 254) {
            cArray[n2] = cArray2[n2 - 161];
            ++n2;
        }
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "get1051codepage");
        }
        return cArray;
    }
}

