/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jms;

import com.ibm.jms.JMSMessage;
import com.ibm.jms.JMSStringResources;
import java.io.UnsupportedEncodingException;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.jms.JMSException;
import javax.jms.StreamMessage;

public class JMSStreamMessage
extends JMSMessage
implements StreamMessage {
    static final long serialVersionUID = -3015681339377486635L;
    private static final String copyrightNotice = "Licensed Materials - Property of IBM (c) Copyright IBM Corp. 1999, 2001     All Rights Reserved. US Government Users Restricted Rights - Use, duplication or disclosure restricted by GSA ADP Schedule Contract with IBM Corp.";
    private static final String sccsid = "common/jms/com/ibm/jms/JMSStreamMessage.java, jms, j521, j521-L020126 02/01/25 15:38:24 @(#) 1.16.1.1";
    private static final String STREAM_BODY_NAME = "stream";
    private static final String STREAM_ELT_NAME = "elt";
    private StringBuffer dataWritten;
    private String streamBody;
    private StringTokenizer dataToBeRead;
    private Object currentField;
    private boolean retrying = false;
    private int readPos = 0;
    boolean readOnly = false;

    public JMSStreamMessage(JMSStringResources jMSStringResources) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "constructor");
            JMSMessage.trace.trace(2, this, sccsid);
        }
        this.messageClass = "jms_stream";
        this.jmsStrings = jMSStringResources;
        this.clearBody();
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "constructor");
        }
    }

    public byte[] _exportBody(int n, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_exportBody");
        }
        try {
            try {
                this.reset();
                byte[] byArray = this.streamBody.getBytes(string);
                Object var6_5 = null;
                if (JMSMessage.trace != null) {
                    JMSMessage.trace.exit(this, "_exportBody");
                }
                return byArray;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
        }
        catch (Throwable throwable) {
            block6: {
                Object var6_6 = null;
                if (JMSMessage.trace == null) break block6;
                JMSMessage.trace.exit(this, "_exportBody");
            }
            throw throwable;
        }
    }

    public void _importBody(byte[] byArray, int n, int n2, String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "_importBody");
        }
        try {
            try {
                this.streamBody = new String(byArray, n, byArray.length - n, string);
                this.readOnly = true;
                this.reset();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                JMSException jMSException = this.newJMSException(1008, string);
                jMSException.setLinkedException((Exception)unsupportedEncodingException);
                throw jMSException;
            }
            Object var8_5 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_importBody");
            }
        }
        catch (Throwable throwable) {
            Object var8_6 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "_importBody");
            }
            throw throwable;
        }
    }

    public void clearBody() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "clearBody");
        }
        this.readOnly = false;
        this.dataToBeRead = null;
        this.streamBody = null;
        this.dataWritten = new StringBuffer("<stream>");
        if (JMSMessage.trace != null) {
            JMSMessage.trace.exit(this, "clearBody");
        }
    }

    public boolean readBoolean() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readBoolean");
        }
        try {
            boolean bl = this.toBoolean(this.readField());
            this.retrying = false;
            boolean bl2 = bl;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readBoolean");
            }
            return bl2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readBoolean");
            }
            throw throwable;
        }
    }

    public byte readByte() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readByte");
        }
        try {
            byte by = this.toByte(this.readField());
            this.retrying = false;
            byte by2 = by;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readByte");
            }
            return by2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readByte");
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int readBytes(byte[] byArray) throws JMSException {
        int n;
        block11: {
            int n2;
            block10: {
                int n3;
                block9: {
                    int n4;
                    block8: {
                        byte[] byArray2 = null;
                        if (JMSMessage.trace != null) {
                            JMSMessage.trace.entry(this, "readBytes");
                        }
                        try {
                            byArray2 = this.toBytes(this.readField());
                            if (byArray2 == null) {
                                this.retrying = false;
                                int n5 = -1;
                                Object var6_6 = null;
                                if (JMSMessage.trace == null) return n5;
                                JMSMessage.trace.exit(this, "readBytes");
                                return n5;
                            }
                            if (byArray2.length == 0) {
                                if (byArray.length > 0) {
                                    this.retrying = false;
                                }
                                n4 = 0;
                                break block8;
                            }
                            int n6 = byArray2.length - this.readPos;
                            if (n6 == 0) {
                                this.retrying = false;
                                n3 = -1;
                                break block9;
                            }
                            if (byArray.length > n6) {
                                System.arraycopy(byArray2, this.readPos, byArray, 0, n6);
                                this.retrying = false;
                                this.readPos = 0;
                                n2 = n6;
                                break block10;
                            }
                            System.arraycopy(byArray2, this.readPos, byArray, 0, byArray.length);
                            this.readPos += byArray.length;
                            n = byArray.length;
                            break block11;
                        }
                        catch (Throwable throwable) {
                            Object var6_11 = null;
                            if (JMSMessage.trace == null) throw throwable;
                            JMSMessage.trace.exit(this, "readBytes");
                            throw throwable;
                        }
                    }
                    Object var6_7 = null;
                    if (JMSMessage.trace == null) return n4;
                    JMSMessage.trace.exit(this, "readBytes");
                    return n4;
                }
                Object var6_8 = null;
                if (JMSMessage.trace == null) return n3;
                JMSMessage.trace.exit(this, "readBytes");
                return n3;
            }
            Object var6_9 = null;
            if (JMSMessage.trace == null) return n2;
            JMSMessage.trace.exit(this, "readBytes");
            return n2;
        }
        Object var6_10 = null;
        if (JMSMessage.trace == null) return n;
        JMSMessage.trace.exit(this, "readBytes");
        return n;
    }

    public char readChar() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readChar");
        }
        try {
            char c = this.toChar(this.readField());
            this.retrying = false;
            char c2 = c;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readChar");
            }
            return c2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readChar");
            }
            throw throwable;
        }
    }

    public double readDouble() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readDouble");
        }
        try {
            double d = this.toDouble(this.readField());
            this.retrying = false;
            double d2 = d;
            Object var6_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readDouble");
            }
            return d2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readDouble");
            }
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Object readField() throws JMSException {
        Object object;
        block22: {
            Object object2;
            block21: {
                Object object3;
                block20: {
                    Object var11_19;
                    block19: {
                        if (JMSMessage.trace != null) {
                            JMSMessage.trace.entry(this, "readField");
                        }
                        try {
                            Object object4;
                            block18: {
                                try {
                                    String string;
                                    if (!this.readOnly) {
                                        throw this.newMessageNotReadableException();
                                    }
                                    if (this.retrying) {
                                        object4 = this.currentField;
                                        Object var13_3 = null;
                                        if (JMSMessage.trace == null) return object4;
                                        break block18;
                                    }
                                    String string2 = this.dataToBeRead.nextToken();
                                    if (string2.equals("/stream")) {
                                        throw this.newMessageEOFException();
                                    }
                                    this.currentField = null;
                                    this.retrying = true;
                                    int n = 0;
                                    boolean bl = false;
                                    boolean bl2 = false;
                                    if (string2.charAt(string2.length() - 1) == '/') {
                                        bl2 = true;
                                    }
                                    if ((n = string2.indexOf(" xsi:nil")) != -1) {
                                        int n2 = 0;
                                        n2 = string2.indexOf(" ");
                                        string2 = string2.substring(0, n2);
                                        if (!bl2) {
                                            String string3 = this.dataToBeRead.nextToken();
                                            if (string3.charAt(0) != '/') {
                                                string3 = this.dataToBeRead.nextToken();
                                            }
                                            if (string3.charAt(0) != '/') {
                                                throw this.newMessageFormatException(1012);
                                            }
                                        }
                                        var11_19 = null;
                                        break block19;
                                    }
                                    int n3 = string2.indexOf(" dt=");
                                    if (n3 != -1) {
                                        string = string2.substring(n3 + 4);
                                        string2 = string2.substring(0, n3);
                                    } else {
                                        string = "'string'";
                                    }
                                    if (bl2) {
                                        object3 = this.currentField = this.deformatElement(string, "");
                                        break block20;
                                    }
                                    String string4 = this.dataToBeRead.nextToken();
                                    if (string4.charAt(0) == '/') {
                                        object2 = this.currentField = this.deformatElement(string, "");
                                        break block21;
                                    }
                                    String string5 = this.dataToBeRead.nextToken();
                                    if (string5.charAt(0) != '/') {
                                        throw this.newMessageFormatException(1010);
                                    }
                                    object = this.currentField = this.deformatElement(string, string4);
                                    break block22;
                                }
                                catch (NoSuchElementException noSuchElementException) {
                                    throw this.newMessageEOFException();
                                }
                            }
                            JMSMessage.trace.exit(this, "readField");
                            return object4;
                        }
                        catch (Throwable throwable) {
                            Object var13_8 = null;
                            if (JMSMessage.trace == null) throw throwable;
                            JMSMessage.trace.exit(this, "readField");
                            throw throwable;
                        }
                    }
                    Object var13_4 = null;
                    if (JMSMessage.trace == null) return var11_19;
                    JMSMessage.trace.exit(this, "readField");
                    return var11_19;
                }
                Object var13_5 = null;
                if (JMSMessage.trace == null) return object3;
                JMSMessage.trace.exit(this, "readField");
                return object3;
            }
            Object var13_6 = null;
            if (JMSMessage.trace == null) return object2;
            JMSMessage.trace.exit(this, "readField");
            return object2;
        }
        Object var13_7 = null;
        if (JMSMessage.trace == null) return object;
        JMSMessage.trace.exit(this, "readField");
        return object;
    }

    public float readFloat() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readFloat");
        }
        try {
            float f = this.toFloat(this.readField());
            this.retrying = false;
            float f2 = f;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readFloat");
            }
            return f2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readFloat");
            }
            throw throwable;
        }
    }

    public int readInt() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readInt");
        }
        try {
            int n = this.toInt(this.readField());
            this.retrying = false;
            int n2 = n;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readInt");
            }
            return n2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readInt");
            }
            throw throwable;
        }
    }

    public long readLong() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readLong");
        }
        try {
            long l = this.toLong(this.readField());
            this.retrying = false;
            long l2 = l;
            Object var6_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readLong");
            }
            return l2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var6_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readLong");
            }
            throw throwable;
        }
    }

    public Object readObject() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readObject");
        }
        try {
            Object object = this.readField();
            this.retrying = false;
            Object object2 = object;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readObject");
            }
            return object2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readObject");
            }
            throw throwable;
        }
    }

    public short readShort() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readShort");
        }
        try {
            short s = this.toShort(this.readField());
            this.retrying = false;
            short s2 = s;
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "readShort");
            }
            return s2;
        }
        catch (Throwable throwable) {
            block4: {
                Object var4_4 = null;
                if (JMSMessage.trace == null) break block4;
                JMSMessage.trace.exit(this, "readShort");
            }
            throw throwable;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String readString() throws JMSException {
        String string;
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "readString");
        }
        try {
            Object object = this.readField();
            if (object instanceof byte[]) {
                throw this.newMessageFormatException(1011);
            }
            this.retrying = false;
            if (object == null) {
                String string2 = null;
                Object var5_3 = null;
                if (JMSMessage.trace == null) return string2;
                JMSMessage.trace.exit(this, "readString");
                return string2;
            }
            string = object.toString();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (JMSMessage.trace == null) throw throwable;
            JMSMessage.trace.exit(this, "readString");
            throw throwable;
        }
        Object var5_4 = null;
        if (JMSMessage.trace == null) return string;
        JMSMessage.trace.exit(this, "readString");
        return string;
    }

    public void reset() throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "reset");
        }
        try {
            if (!this.readOnly) {
                this.dataWritten.append("</stream>");
                this.streamBody = this.dataWritten.toString();
                this.dataWritten = null;
                this.readOnly = true;
            }
            this.dataToBeRead = new StringTokenizer(this.streamBody, "<>");
            this.retrying = false;
            if (!this.dataToBeRead.nextToken().equals(STREAM_BODY_NAME)) {
                throw this.newMessageFormatException(1010);
            }
            Object var2_1 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "reset");
            }
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "reset");
            }
            throw throwable;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(super.toString());
        stringBuffer.append("\n");
        if (this.readOnly) {
            stringBuffer.append(this.streamBody);
        } else {
            stringBuffer.append((Object)this.dataWritten);
        }
        return stringBuffer.toString();
    }

    public void writeBoolean(boolean bl) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeBoolean");
        }
        try {
            this.writeObject(new Boolean(bl));
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBoolean");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBoolean");
            }
            throw throwable;
        }
    }

    public void writeByte(byte by) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeByte");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i1'", String.valueOf(by), this.dataWritten);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeByte");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeByte");
            }
            throw throwable;
        }
    }

    public void writeBytes(byte[] byArray) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeBytes");
        }
        try {
            this.writeObject(byArray);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBytes");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBytes");
            }
            throw throwable;
        }
    }

    public void writeBytes(byte[] byArray, int n, int n2) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeBytes");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.dataWritten.append("<elt dt='bin.hex'>");
            JMSMessage.binToHex(byArray, n, n2, this.dataWritten);
            this.dataWritten.append("</elt>");
            Object var5_4 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBytes");
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeBytes");
            }
            throw throwable;
        }
    }

    public void writeChar(char c) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeChar");
        }
        try {
            this.writeObject(new Character(c));
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeChar");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeChar");
            }
            throw throwable;
        }
    }

    public void writeDouble(double d) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeDouble");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'r8'", String.valueOf(d), this.dataWritten);
            Object var4_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeDouble");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeDouble");
            }
            throw throwable;
        }
    }

    public void writeFloat(float f) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeFloat");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'r4'", String.valueOf(f), this.dataWritten);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeFloat");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeFloat");
            }
            throw throwable;
        }
    }

    public void writeInt(int n) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeInt");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i4'", String.valueOf(n), this.dataWritten);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeInt");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeInt");
            }
            throw throwable;
        }
    }

    public void writeLong(long l) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeLong");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i8'", String.valueOf(l), this.dataWritten);
            Object var4_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeLong");
            }
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeLong");
            }
            throw throwable;
        }
    }

    public void writeObject(Object object) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeObject");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            if (!(object == null || object instanceof String || object instanceof Number || object instanceof Boolean || object instanceof Character || object instanceof byte[])) {
                throw this.newMessageFormatException(1018, object.getClass());
            }
            this.formatElement(STREAM_ELT_NAME, object, this.dataWritten);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeObject");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeObject");
            }
            throw throwable;
        }
    }

    public void writeShort(short s) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeShort");
        }
        try {
            if (this.readOnly) {
                throw this.newMessageNotWriteableException();
            }
            this.formatElement(STREAM_ELT_NAME, "'i2'", String.valueOf(s), this.dataWritten);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeShort");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeShort");
            }
            throw throwable;
        }
    }

    public void writeString(String string) throws JMSException {
        if (JMSMessage.trace != null) {
            JMSMessage.trace.entry(this, "writeString");
        }
        try {
            this.writeObject(string);
            Object var3_2 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeString");
            }
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            if (JMSMessage.trace != null) {
                JMSMessage.trace.exit(this, "writeString");
            }
            throw throwable;
        }
    }

    void _setBodyReadOnly() {
        this.readOnly = true;
    }
}

